
#ifndef __SRC_CONFIGSTORE_H__
#define __SRC_CONFIGSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include "src/DeviceGroup.h"
#include "src/Device.h"

G_BEGIN_DECLS


#define DVB_TYPE_CONFIG_STORE (dvb_config_store_get_type ())
#define DVB_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStore))
#define DVB_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CONFIG_STORE))
#define DVB_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStoreIface))

typedef struct _DVBConfigStore DVBConfigStore;
typedef struct _DVBConfigStoreIface DVBConfigStoreIface;

struct _DVBConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBConfigStore* self);
	void (*add_device_group) (DVBConfigStore* self, DVBDeviceGroup* dev_group);
	void (*remove_device_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
	void (*add_device_to_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	void (*remove_device_from_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
};


GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self);
void dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group);
void dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup);
void dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
void dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
GType dvb_config_store_get_type (void);


G_END_DECLS

#endif
