/* SqliteConfigTimersStore.c generated by valac 0.9.7, the Vala compiler
 * generated from SqliteConfigTimersStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE (dvb_database_sqlite_sqlite_config_timers_store_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStore))
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStoreClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStoreClass))

typedef struct _DVBdatabasesqliteSqliteConfigTimersStore DVBdatabasesqliteSqliteConfigTimersStore;
typedef struct _DVBdatabasesqliteSqliteConfigTimersStoreClass DVBdatabasesqliteSqliteConfigTimersStoreClass;
typedef struct _DVBdatabasesqliteSqliteConfigTimersStorePrivate DVBdatabasesqliteSqliteConfigTimersStorePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

struct _DVBdatabasesqliteSqliteConfigTimersStore {
	DVBdatabasesqliteSqliteDatabase parent_instance;
	DVBdatabasesqliteSqliteConfigTimersStorePrivate * priv;
};

struct _DVBdatabasesqliteSqliteConfigTimersStoreClass {
	DVBdatabasesqliteSqliteDatabaseClass parent_class;
};

struct _DVBdatabasesqliteSqliteConfigTimersStorePrivate {
	sqlite3_stmt* select_devices_statement;
	sqlite3_stmt* delete_group_statement;
	sqlite3_stmt* insert_group_statement;
	sqlite3_stmt* update_group_statement;
	sqlite3_stmt* delete_device_statement;
	sqlite3_stmt* delete_group_devices_statement;
	sqlite3_stmt* insert_device_statement;
	sqlite3_stmt* select_group_of_device_statement;
	sqlite3_stmt* select_timers_statement;
	sqlite3_stmt* delete_timer_statement;
	sqlite3_stmt* delete_group_timers_statement;
	sqlite3_stmt* insert_timer_statement;
	sqlite3_stmt* contains_group_statement;
	sqlite3_stmt* contains_timer_statement;
	sqlite3_stmt* insert_channel_group_statement;
	sqlite3_stmt* delete_channel_group_statement;
	sqlite3_stmt* remove_all_channel_group_statement;
	sqlite3_stmt* select_channel_groups_statement;
	sqlite3_stmt* add_channel_group_statement;
	sqlite3_stmt* remove_channel_group_statement;
	sqlite3_stmt* select_channels_statement;
};

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;


static gpointer dvb_database_sqlite_sqlite_config_timers_store_parent_class = NULL;
static DVBdatabaseConfigStoreIface* dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_parent_iface = NULL;
static DVBdatabaseTimersStoreIface* dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_parent_iface = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
GType dvb_database_sqlite_sqlite_config_timers_store_get_type (void) G_GNUC_CONST;
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStorePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DUMMY_PROPERTY
};
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_VERSION 1
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICE_GROUPS "CREATE TABLE device_groups (\n" \
"        group_id INTEGER,\n" \
"        adapter_type INTEGER(1),\n" \
"        channels_file VARCHAR(255),\n" \
"        recordings_dir VARCHAR(255),\n" \
"        name VARCHAR(255),\n" \
"        PRIMARY KEY(group_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICES "CREATE TABLE devices (\n" \
"        group_id INTEGER,\n" \
"        adapter INTEGER,\n" \
"        frontend INTEGER,\n" \
"        PRIMARY KEY(adapter, frontend))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_TIMERS "CREATE TABLE timers (\n" \
"        timer_id INTEGER,\n" \
"        group_id INTEGER,\n" \
"        channel_sid INTEGER,\n" \
"        year INTEGER,\n" \
"        month INTEGER,\n" \
"        day INTEGER,\n" \
"        hour INTEGER,\n" \
"        minute INTEGER,\n" \
"        duration INTEGER,\n" \
"        event_id INTEGER,\n" \
"        PRIMARY KEY(timer_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_GROUPS "CREATE TABLE channel_groups (\n" \
"        channel_group_id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"        name VARCHAR(255))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_CHANNELS "CREATE TABLE channels (\n" \
"        sid INTEGER,\n" \
"        group_id INTEGER,\n" \
"        channel_group_id INTEGER,\n" \
"        PRIMARY KEY(sid, group_id, channel_group_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_ALL_GROUPS "SELECT * FROM device_groups"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_DEVICES "SELECT * FROM devices WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP "DELETE FROM device_groups WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_GROUP "INSERT INTO device_groups VALUES (?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_GROUP "SELECT 1 FROM device_groups WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_UPDATE_GROUP "UPDATE device_groups SET adapter_type=?, channels_file=?, recordings_d" \
"ir=?, name=? WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_DEVICE "DELETE FROM devices WHERE adapter=? AND frontend=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_DEVICES "DELETE FROM devices WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_DEVICE "INSERT INTO devices VALUES (?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_GROUP_OF_DEVICE "SELECT group_id FROM devices WHERE adapter=? AND frontend=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_TIMERS "SELECT * FROM timers WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_TIMER "DELETE FROM timers WHERE timer_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_TIMERS "DELETE FROM timers WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_TIMER "INSERT INTO timers VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_TIMER "SELECT 1 FROM timers WHERE timer_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_CHANNEL_GROUP "INSERT INTO channel_groups (name) VALUES (?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_CHANNEL_GROUP "DELETE FROM channel_groups WHERE channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_ALL_CHANNEL_GROUP "DELETE FROM channels WHERE channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNEL_GROUPS "SELECT * FROM channel_groups"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_ADD_CHANNEL_GROUP "INSERT INTO channels VALUES (?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_CHANNEL_GROUP "DELETE FROM channels WHERE sid=? AND group_id=? AND channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNELS "SELECT sid FROM channels WHERE group_id=? AND channel_group_id=?"
DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_new (void);
DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_construct (GType object_type);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
static void dvb_database_sqlite_sqlite_config_timers_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups (DVBdatabaseConfigStore* base, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const char* errmsg, GError** error);
GQuark dvb_device_error_quark (void);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
gboolean main_get_disable_epg_scanner (void);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const char* value);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* dev_group, GError** error);
gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_group (DVBdatabasesqliteSqliteConfigTimersStore* self, guint group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
const char* dvb_device_group_get_Name (DVBDeviceGroup* self);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
gboolean dvb_database_config_store_add_device_to_group (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group (DVBdatabaseConfigStore* base, guint adapter, guint frontend, guint* group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group (DVBdatabaseTimersStore* base, DVBDeviceGroup* dev, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_timer_set_EventID (DVBTimer* self, guint value);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group (DVBdatabaseTimersStore* base, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_timer (DVBdatabasesqliteSqliteConfigTimersStore* self, guint timer_id, GError** error);
guint32 dvb_timer_get_Id (DVBTimer* self);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_timer_get_Duration (DVBTimer* self);
guint dvb_timer_get_EventID (DVBTimer* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group (DVBdatabaseTimersStore* base, guint timer_id, DVBDeviceGroup* dev, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group (DVBdatabaseTimersStore* base, guint group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group (DVBdatabaseConfigStore* base, const char* name, gint* channel_group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group (DVBdatabaseConfigStore* base, gint group_id, GError** error);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups (DVBdatabaseConfigStore* base, GError** error);
DVBChannelGroup* dvb_channel_group_new (gint id, const char* name);
DVBChannelGroup* dvb_channel_group_construct (GType object_type, gint id, const char* name);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group (DVBdatabaseConfigStore* base, guint dev_group_id, gint channel_group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error);
guint dvb_channel_get_GroupId (DVBChannel* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_finalize (GObject* obj);



DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_construct (GType object_type) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GFile* config_dir;
	GFile* config_cache;
	GFile* dbfile;
	config_dir = g_file_new_for_path (g_get_user_config_dir ());
	config_cache = g_file_get_child (config_dir, "gnome-dvb-daemon");
	dbfile = g_file_get_child (config_cache, "configtimers.sqlite3");
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) dvb_database_sqlite_sqlite_database_construct (object_type, dbfile, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_VERSION);
	_g_object_unref0 (dbfile);
	_g_object_unref0 (config_cache);
	_g_object_unref0 (config_dir);
	return self;
}


DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_new (void) {
	return dvb_database_sqlite_sqlite_config_timers_store_construct (DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE);
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICE_GROUPS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICES, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_TIMERS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_GROUPS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_CHANNELS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	sqlite3_stmt* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_;
	sqlite3_stmt* _tmp16_ = NULL;
	sqlite3_stmt* _tmp17_;
	sqlite3_stmt* _tmp18_ = NULL;
	sqlite3_stmt* _tmp19_;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_;
	sqlite3_stmt* _tmp22_ = NULL;
	sqlite3_stmt* _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	sqlite3_stmt* _tmp25_;
	sqlite3_stmt* _tmp26_ = NULL;
	sqlite3_stmt* _tmp27_;
	sqlite3_stmt* _tmp28_ = NULL;
	sqlite3_stmt* _tmp29_;
	sqlite3_stmt* _tmp30_ = NULL;
	sqlite3_stmt* _tmp31_;
	sqlite3_stmt* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_;
	sqlite3_stmt* _tmp34_ = NULL;
	sqlite3_stmt* _tmp35_;
	sqlite3_stmt* _tmp36_ = NULL;
	sqlite3_stmt* _tmp37_;
	sqlite3_stmt* _tmp38_ = NULL;
	sqlite3_stmt* _tmp39_;
	sqlite3_stmt* _tmp40_ = NULL;
	sqlite3_stmt* _tmp41_;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_DEVICES, -1, &_tmp0_, NULL);
	self->priv->select_devices_statement = (_tmp1_ = _tmp0_, _sqlite3_finalize0 (self->priv->select_devices_statement), _tmp1_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP, -1, &_tmp2_, NULL);
	self->priv->delete_group_statement = (_tmp3_ = _tmp2_, _sqlite3_finalize0 (self->priv->delete_group_statement), _tmp3_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_GROUP, -1, &_tmp4_, NULL);
	self->priv->insert_group_statement = (_tmp5_ = _tmp4_, _sqlite3_finalize0 (self->priv->insert_group_statement), _tmp5_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_UPDATE_GROUP, -1, &_tmp6_, NULL);
	self->priv->update_group_statement = (_tmp7_ = _tmp6_, _sqlite3_finalize0 (self->priv->update_group_statement), _tmp7_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_DEVICE, -1, &_tmp8_, NULL);
	self->priv->delete_device_statement = (_tmp9_ = _tmp8_, _sqlite3_finalize0 (self->priv->delete_device_statement), _tmp9_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_DEVICES, -1, &_tmp10_, NULL);
	self->priv->delete_group_devices_statement = (_tmp11_ = _tmp10_, _sqlite3_finalize0 (self->priv->delete_group_devices_statement), _tmp11_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_DEVICE, -1, &_tmp12_, NULL);
	self->priv->insert_device_statement = (_tmp13_ = _tmp12_, _sqlite3_finalize0 (self->priv->insert_device_statement), _tmp13_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_GROUP_OF_DEVICE, -1, &_tmp14_, NULL);
	self->priv->select_group_of_device_statement = (_tmp15_ = _tmp14_, _sqlite3_finalize0 (self->priv->select_group_of_device_statement), _tmp15_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_TIMERS, -1, &_tmp16_, NULL);
	self->priv->select_timers_statement = (_tmp17_ = _tmp16_, _sqlite3_finalize0 (self->priv->select_timers_statement), _tmp17_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_TIMER, -1, &_tmp18_, NULL);
	self->priv->delete_timer_statement = (_tmp19_ = _tmp18_, _sqlite3_finalize0 (self->priv->delete_timer_statement), _tmp19_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_TIMERS, -1, &_tmp20_, NULL);
	self->priv->delete_group_timers_statement = (_tmp21_ = _tmp20_, _sqlite3_finalize0 (self->priv->delete_group_timers_statement), _tmp21_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_TIMER, -1, &_tmp22_, NULL);
	self->priv->insert_timer_statement = (_tmp23_ = _tmp22_, _sqlite3_finalize0 (self->priv->insert_timer_statement), _tmp23_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_GROUP, -1, &_tmp24_, NULL);
	self->priv->contains_group_statement = (_tmp25_ = _tmp24_, _sqlite3_finalize0 (self->priv->contains_group_statement), _tmp25_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_TIMER, -1, &_tmp26_, NULL);
	self->priv->contains_timer_statement = (_tmp27_ = _tmp26_, _sqlite3_finalize0 (self->priv->contains_timer_statement), _tmp27_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_CHANNEL_GROUP, -1, &_tmp28_, NULL);
	self->priv->insert_channel_group_statement = (_tmp29_ = _tmp28_, _sqlite3_finalize0 (self->priv->insert_channel_group_statement), _tmp29_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_CHANNEL_GROUP, -1, &_tmp30_, NULL);
	self->priv->delete_channel_group_statement = (_tmp31_ = _tmp30_, _sqlite3_finalize0 (self->priv->delete_channel_group_statement), _tmp31_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_ALL_CHANNEL_GROUP, -1, &_tmp32_, NULL);
	self->priv->remove_all_channel_group_statement = (_tmp33_ = _tmp32_, _sqlite3_finalize0 (self->priv->remove_all_channel_group_statement), _tmp33_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNEL_GROUPS, -1, &_tmp34_, NULL);
	self->priv->select_channel_groups_statement = (_tmp35_ = _tmp34_, _sqlite3_finalize0 (self->priv->select_channel_groups_statement), _tmp35_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_ADD_CHANNEL_GROUP, -1, &_tmp36_, NULL);
	self->priv->add_channel_group_statement = (_tmp37_ = _tmp36_, _sqlite3_finalize0 (self->priv->add_channel_group_statement), _tmp37_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_CHANNEL_GROUP, -1, &_tmp38_, NULL);
	self->priv->remove_channel_group_statement = (_tmp39_ = _tmp38_, _sqlite3_finalize0 (self->priv->remove_channel_group_statement), _tmp39_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNELS, -1, &_tmp40_, NULL);
	self->priv->select_channels_statement = (_tmp41_ = _tmp40_, _sqlite3_finalize0 (self->priv->select_channels_statement), _tmp41_);
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups (DVBdatabaseConfigStore* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeList* groups;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	groups = (GeeList*) gee_array_list_new (DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	statement = NULL;
	if ((_tmp1_ = sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_ALL_GROUPS, -1, &_tmp0_, NULL), statement = (_tmp2_ = _tmp0_, _sqlite3_finalize0 (statement), _tmp2_), _tmp1_) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				_g_object_unref0 (groups);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				_g_object_unref0 (groups);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = groups;
		_sqlite3_finalize0 (statement);
		return result;
	}
	while (TRUE) {
		gint group_id;
		GFile* channels_file;
		GFile* rec_dir;
		GeeList* devs;
		DVBDevice* ref_dev;
		DVBDeviceGroup* group;
		if (!(sqlite3_step (statement) == SQLITE_ROW)) {
			break;
		}
		group_id = sqlite3_column_int (statement, 0);
		sqlite3_reset (self->priv->select_devices_statement);
		if (sqlite3_bind_int (self->priv->select_devices_statement, 1, group_id) != SQLITE_OK) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_sqlite3_finalize0 (statement);
					_g_object_unref0 (groups);
					return NULL;
				} else {
					_sqlite3_finalize0 (statement);
					_g_object_unref0 (groups);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			continue;
		}
		channels_file = g_file_new_for_path (sqlite3_column_text (statement, 2));
		rec_dir = g_file_new_for_path (sqlite3_column_text (statement, 3));
		devs = (GeeList*) gee_array_list_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		ref_dev = NULL;
		while (TRUE) {
			guint adapter;
			guint frontend;
			if (!(sqlite3_step (self->priv->select_devices_statement) == SQLITE_ROW)) {
				break;
			}
			adapter = (guint) sqlite3_column_int (self->priv->select_devices_statement, 1);
			frontend = (guint) sqlite3_column_int (self->priv->select_devices_statement, 2);
			if (ref_dev == NULL) {
				{
					DVBDevice* _tmp3_;
					DVBDevice* _tmp4_;
					_tmp3_ = dvb_device_new_full (adapter, frontend, channels_file, rec_dir, (guint) group_id, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DEVICE_ERROR) {
							goto __catch8_dvb_device_error;
						}
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					ref_dev = (_tmp4_ = _tmp3_, _g_object_unref0 (ref_dev), _tmp4_);
				}
				goto __finally8;
				__catch8_dvb_device_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("SqliteConfigTimersStore.vala:266: Could not create device: %s", e->message);
						_g_error_free0 (e);
					}
				}
				__finally8:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						return NULL;
					} else {
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			} else {
				DVBDevice* _tmp5_;
				gee_collection_add ((GeeCollection*) devs, _tmp5_ = dvb_device_new_with_type (adapter, frontend));
				_g_object_unref0 (_tmp5_);
			}
		}
		if (ref_dev == NULL) {
			g_debug ("SqliteConfigTimersStore.vala:275: Group %d has no devices", group_id);
			_g_object_unref0 (ref_dev);
			_g_object_unref0 (devs);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (channels_file);
			continue;
		}
		group = dvb_device_group_new ((guint) group_id, ref_dev, !main_get_disable_epg_scanner ());
		dvb_device_group_set_Name (group, sqlite3_column_text (statement, 4));
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					DVBDevice* _tmp7_;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < gee_collection_get_size ((GeeCollection*) devs))) {
						break;
					}
					dvb_device_group_add (group, _tmp7_ = (DVBDevice*) gee_list_get (devs, i));
					_g_object_unref0 (_tmp7_);
				}
			}
		}
		gee_collection_add ((GeeCollection*) groups, group);
		_g_object_unref0 (group);
		_g_object_unref0 (ref_dev);
		_g_object_unref0 (devs);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (channels_file);
	}
	result = groups;
	_sqlite3_finalize0 (statement);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* dev_group, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	char* channels;
	char* recdir;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev_group != NULL, FALSE);
	_tmp0_ = dvb_database_sqlite_sqlite_config_timers_store_contains_group (self, dvb_device_group_get_Id (dev_group), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	channels = g_file_get_path (dvb_channel_list_get_channels_file (dvb_device_group_get_Channels (dev_group)));
	recdir = g_file_get_path (dvb_device_group_get_RecordingsDirectory (dev_group));
	sqlite3_reset (self->priv->insert_group_statement);
	if (sqlite3_bind_int (self->priv->insert_group_statement, 1, (gint) dvb_device_group_get_Id (dev_group)) != SQLITE_OK) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = sqlite3_bind_int (self->priv->insert_group_statement, 2, (gint) dvb_device_group_get_Type (dev_group)) != SQLITE_OK;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = sqlite3_bind_text (self->priv->insert_group_statement, 3, g_strdup (channels), -1, g_free) != SQLITE_OK;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = sqlite3_bind_text (self->priv->insert_group_statement, 4, g_strdup (recdir), -1, g_free) != SQLITE_OK;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_text (self->priv->insert_group_statement, 5, g_strdup (dvb_device_group_get_Name (dev_group)), -1, g_free) != SQLITE_OK;
	}
	if (_tmp1_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (recdir);
				_g_free0 (channels);
				return FALSE;
			} else {
				_g_free0 (recdir);
				_g_free0 (channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		_g_free0 (recdir);
		_g_free0 (channels);
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (recdir);
			_g_free0 (channels);
			return FALSE;
		} else {
			_g_free0 (recdir);
			_g_free0 (channels);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (sqlite3_step (self->priv->insert_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (recdir);
				_g_free0 (channels);
				return FALSE;
			} else {
				_g_free0 (recdir);
				_g_free0 (channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		_g_free0 (recdir);
		_g_free0 (channels);
		return result;
	}
	{
		GeeIterator* _dev_it;
		_dev_it = gee_iterable_iterator ((GeeIterable*) dev_group);
		while (TRUE) {
			DVBDevice* dev;
			if (!gee_iterator_next (_dev_it)) {
				break;
			}
			dev = (DVBDevice*) gee_iterator_get (_dev_it);
			dvb_database_config_store_add_device_to_group ((DVBdatabaseConfigStore*) self, dev, dev_group, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dev);
					_g_object_unref0 (_dev_it);
					_g_free0 (recdir);
					_g_free0 (channels);
					return FALSE;
				} else {
					_g_object_unref0 (dev);
					_g_object_unref0 (_dev_it);
					_g_free0 (recdir);
					_g_free0 (channels);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_it);
	}
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (recdir);
			_g_free0 (channels);
			return FALSE;
		} else {
			_g_free0 (recdir);
			_g_free0 (channels);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (recdir);
	_g_free0 (channels);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (devgroup != NULL, FALSE);
	sqlite3_reset (self->priv->delete_group_statement);
	if (sqlite3_bind_int (self->priv->delete_group_statement, 1, (gint) dvb_device_group_get_Id (devgroup)) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_group_devices_statement);
	if (sqlite3_bind_int (self->priv->delete_group_devices_statement, 1, (gint) dvb_device_group_get_Id (devgroup)) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (sqlite3_step (self->priv->delete_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_group_devices_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group (DVBdatabaseConfigStore* base, guint adapter, guint frontend, guint* group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_reset (self->priv->select_group_of_device_statement);
	if (sqlite3_bind_int (self->priv->select_group_of_device_statement, 1, (gint) adapter) != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->select_group_of_device_statement, 2, (gint) frontend) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	ret = FALSE;
	while (TRUE) {
		if (!(sqlite3_step (self->priv->select_group_of_device_statement) == SQLITE_ROW)) {
			break;
		}
		*group_id = (guint) sqlite3_column_int (self->priv->select_group_of_device_statement, 0);
		ret = TRUE;
	}
	result = ret;
	return result;
}


gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_group (DVBdatabasesqliteSqliteConfigTimersStore* self, guint group_id, GError** error) {
	gboolean result = FALSE;
	gint c;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	sqlite3_reset (self->priv->contains_group_statement);
	if (sqlite3_bind_int (self->priv->contains_group_statement, 1, (gint) group_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		if (!(sqlite3_step (self->priv->contains_group_statement) == SQLITE_ROW)) {
			break;
		}
		c = sqlite3_column_int (self->priv->contains_group_statement, 0);
	}
	result = c > 0;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	sqlite3_reset (self->priv->insert_device_statement);
	if (sqlite3_bind_int (self->priv->insert_device_statement, 1, (gint) dvb_device_group_get_Id (devgroup)) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->insert_device_statement, 2, (gint) dvb_device_get_Adapter (dev)) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->insert_device_statement, 3, (gint) dvb_device_get_Frontend (dev)) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->insert_device_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	sqlite3_reset (self->priv->delete_device_statement);
	if (sqlite3_bind_int (self->priv->delete_device_statement, 1, (gint) dvb_device_get_Adapter (dev)) != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->delete_device_statement, 2, (gint) dvb_device_get_Frontend (dev)) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_device_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group (DVBdatabaseTimersStore* base, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeList* timers;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, NULL);
	timers = (GeeList*) gee_array_list_new (DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	sqlite3_reset (self->priv->select_timers_statement);
	if (sqlite3_bind_int (self->priv->select_timers_statement, 1, (gint) dvb_device_group_get_Id (dev)) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (timers);
				return NULL;
			} else {
				_g_object_unref0 (timers);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = timers;
		return result;
	}
	while (TRUE) {
		guint tid = 0U;
		guint sid = 0U;
		guint duration = 0U;
		guint event_id = 0U;
		gint year = 0;
		gint month = 0;
		gint day = 0;
		gint hour = 0;
		gint minute = 0;
		DVBChannel* channel;
		DVBTimer* timer;
		if (!(sqlite3_step (self->priv->select_timers_statement) == SQLITE_ROW)) {
			break;
		}
		tid = (guint) sqlite3_column_int (self->priv->select_timers_statement, 0);
		sid = (guint) sqlite3_column_int (self->priv->select_timers_statement, 2);
		year = sqlite3_column_int (self->priv->select_timers_statement, 3);
		month = sqlite3_column_int (self->priv->select_timers_statement, 4);
		day = sqlite3_column_int (self->priv->select_timers_statement, 5);
		hour = sqlite3_column_int (self->priv->select_timers_statement, 6);
		minute = sqlite3_column_int (self->priv->select_timers_statement, 7);
		duration = (guint) sqlite3_column_int (self->priv->select_timers_statement, 8);
		event_id = (guint) sqlite3_column_int (self->priv->select_timers_statement, 9);
		channel = dvb_channel_list_get_channel (dvb_device_group_get_Channels (dev), sid);
		timer = dvb_timer_new ((guint32) tid, channel, year, month, day, hour, minute, duration);
		dvb_timer_set_EventID (timer, event_id);
		gee_collection_add ((GeeCollection*) timers, timer);
		_g_object_unref0 (timer);
		_g_object_unref0 (channel);
	}
	result = timers;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group (DVBdatabaseTimersStore* base, DVBTimer* timer, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint start_length1;
	gint _start_size_;
	guint* _tmp2_;
	gint _tmp1_;
	guint* start;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (timer != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	_tmp0_ = dvb_database_sqlite_sqlite_config_timers_store_contains_timer (self, (guint) dvb_timer_get_Id (timer), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->insert_timer_statement);
	start = (_tmp2_ = dvb_timer_get_start_time (timer, &_tmp1_), start_length1 = _tmp1_, _start_size_ = start_length1, _tmp2_);
	if (sqlite3_bind_int (self->priv->insert_timer_statement, 1, (gint) dvb_timer_get_Id (timer)) != SQLITE_OK) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = sqlite3_bind_int (self->priv->insert_timer_statement, 2, (gint) dvb_device_group_get_Id (dev)) != SQLITE_OK;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = sqlite3_bind_int (self->priv->insert_timer_statement, 3, (gint) dvb_channel_get_Sid (dvb_timer_get_Channel (timer))) != SQLITE_OK;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = sqlite3_bind_int (self->priv->insert_timer_statement, 4, (gint) start[0]) != SQLITE_OK;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = sqlite3_bind_int (self->priv->insert_timer_statement, 5, (gint) start[1]) != SQLITE_OK;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = sqlite3_bind_int (self->priv->insert_timer_statement, 6, (gint) start[2]) != SQLITE_OK;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = sqlite3_bind_int (self->priv->insert_timer_statement, 7, (gint) start[3]) != SQLITE_OK;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = sqlite3_bind_int (self->priv->insert_timer_statement, 8, (gint) start[4]) != SQLITE_OK;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = sqlite3_bind_int (self->priv->insert_timer_statement, 9, (gint) dvb_timer_get_Duration (timer)) != SQLITE_OK;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = sqlite3_bind_int (self->priv->insert_timer_statement, 10, (gint) dvb_timer_get_EventID (timer)) != SQLITE_OK;
	}
	if (_tmp3_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				start = (g_free (start), NULL);
				return FALSE;
			} else {
				start = (g_free (start), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		start = (g_free (start), NULL);
		return result;
	}
	if (sqlite3_step (self->priv->insert_timer_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				start = (g_free (start), NULL);
				return FALSE;
			} else {
				start = (g_free (start), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		start = (g_free (start), NULL);
		return result;
	}
	result = TRUE;
	start = (g_free (start), NULL);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group (DVBdatabaseTimersStore* base, guint timer_id, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	sqlite3_reset (self->priv->delete_timer_statement);
	if (sqlite3_bind_int (self->priv->delete_timer_statement, 1, (gint) timer_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_timer_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group (DVBdatabaseTimersStore* base, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_reset (self->priv->delete_group_timers_statement);
	if (sqlite3_bind_int (self->priv->delete_group_timers_statement, 1, (gint) group_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_group_timers_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_timer (DVBdatabasesqliteSqliteConfigTimersStore* self, guint timer_id, GError** error) {
	gboolean result = FALSE;
	gint c;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	sqlite3_reset (self->priv->contains_timer_statement);
	if (sqlite3_bind_int (self->priv->contains_timer_statement, 1, (gint) timer_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		if (!(sqlite3_step (self->priv->contains_timer_statement) == SQLITE_ROW)) {
			break;
		}
		c = sqlite3_column_int (self->priv->contains_timer_statement, 0);
	}
	result = c > 0;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (devgroup != NULL, FALSE);
	sqlite3_reset (self->priv->update_group_statement);
	if (sqlite3_bind_int (self->priv->update_group_statement, 1, (gint) dvb_device_group_get_Type (devgroup)) != SQLITE_OK) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = sqlite3_bind_text (self->priv->update_group_statement, 2, g_file_get_path (dvb_channel_list_get_channels_file (dvb_device_group_get_Channels (devgroup))), -1, g_free) != SQLITE_OK;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = sqlite3_bind_text (self->priv->update_group_statement, 3, g_file_get_path (dvb_device_group_get_RecordingsDirectory (devgroup)), -1, g_free) != SQLITE_OK;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_text (self->priv->update_group_statement, 4, g_strdup (dvb_device_group_get_Name (devgroup)), -1, g_free) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->update_group_statement, 5, (gint) dvb_device_group_get_Id (devgroup)) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->update_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group (DVBdatabaseConfigStore* base, const char* name, gint* channel_group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	sqlite3_reset (self->priv->insert_channel_group_statement);
	if (sqlite3_bind_text (self->priv->insert_channel_group_statement, 1, g_strdup (name), -1, g_free) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->insert_channel_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	*channel_group_id = (gint) sqlite3_last_insert_rowid (((DVBdatabasesqliteSqliteDatabase*) self)->db);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group (DVBdatabaseConfigStore* base, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_reset (self->priv->delete_channel_group_statement);
	sqlite3_reset (self->priv->remove_all_channel_group_statement);
	if (sqlite3_bind_int (self->priv->delete_channel_group_statement, 1, group_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_bind_int (self->priv->remove_all_channel_group_statement, 1, group_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (sqlite3_step (self->priv->delete_channel_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->remove_all_channel_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups (DVBdatabaseConfigStore* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeArrayList* groups;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_reset (self->priv->select_channel_groups_statement);
	groups = gee_array_list_new (DVB_TYPE_CHANNEL_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	while (TRUE) {
		gint group_id;
		char* group_name;
		DVBChannelGroup* group;
		if (!(sqlite3_step (self->priv->select_channel_groups_statement) == SQLITE_ROW)) {
			break;
		}
		group_id = sqlite3_column_int (self->priv->select_channel_groups_statement, 0);
		group_name = g_strdup (sqlite3_column_text (self->priv->select_channel_groups_statement, 1));
		group = dvb_channel_group_new (group_id, group_name);
		gee_abstract_collection_add ((GeeAbstractCollection*) groups, group);
		_g_object_unref0 (group);
		_g_free0 (group_name);
	}
	result = (GeeList*) groups;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group (DVBdatabaseConfigStore* base, guint dev_group_id, gint channel_group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* channels;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	sqlite3_reset (self->priv->select_channels_statement);
	if (sqlite3_bind_int (self->priv->select_channels_statement, 1, (gint) dev_group_id) != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->select_channels_statement, 2, channel_group_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	channels = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	while (TRUE) {
		if (!(sqlite3_step (self->priv->select_channels_statement) == SQLITE_ROW)) {
			break;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) channels, GUINT_TO_POINTER ((guint) sqlite3_column_int (self->priv->select_channels_statement, 0)));
	}
	result = (GeeList*) channels;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (channel != NULL, FALSE);
	sqlite3_reset (self->priv->add_channel_group_statement);
	if (sqlite3_bind_int (self->priv->add_channel_group_statement, 1, (gint) dvb_channel_get_Sid (channel)) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->add_channel_group_statement, 2, (gint) dvb_channel_get_GroupId (channel)) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->add_channel_group_statement, 3, group_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->add_channel_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (channel != NULL, FALSE);
	sqlite3_reset (self->priv->remove_channel_group_statement);
	if (sqlite3_bind_int (self->priv->remove_channel_group_statement, 1, (gint) dvb_channel_get_Sid (channel)) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->remove_channel_group_statement, 2, (gint) dvb_channel_get_GroupId (channel)) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->remove_channel_group_statement, 3, group_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->remove_channel_group_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void dvb_database_sqlite_sqlite_config_timers_store_class_init (DVBdatabasesqliteSqliteConfigTimersStoreClass * klass) {
	dvb_database_sqlite_sqlite_config_timers_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteConfigTimersStorePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_config_timers_store_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_config_timers_store_real_upgrade;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_config_timers_store_real_on_open;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_config_timers_store_finalize;
}


static void dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_interface_init (DVBdatabaseConfigStoreIface * iface) {
	dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_all_device_groups = dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups;
	iface->add_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group;
	iface->remove_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group;
	iface->get_parent_group = dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group;
	iface->add_device_to_group = dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group;
	iface->remove_device_from_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group;
	iface->update_from_group = dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group;
	iface->add_channel_group = dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group;
	iface->remove_channel_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group;
	iface->get_channel_groups = dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups;
	iface->get_channels_of_group = dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group;
	iface->add_channel_to_group = dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group;
	iface->remove_channel_from_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group;
}


static void dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_interface_init (DVBdatabaseTimersStoreIface * iface) {
	dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_all_timers_of_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group;
	iface->add_timer_to_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group;
	iface->remove_timer_from_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group;
	iface->remove_all_timers_from_device_group = dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group;
}


static void dvb_database_sqlite_sqlite_config_timers_store_instance_init (DVBdatabasesqliteSqliteConfigTimersStore * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_config_timers_store_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	self = DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE (obj);
	_sqlite3_finalize0 (self->priv->select_devices_statement);
	_sqlite3_finalize0 (self->priv->delete_group_statement);
	_sqlite3_finalize0 (self->priv->insert_group_statement);
	_sqlite3_finalize0 (self->priv->update_group_statement);
	_sqlite3_finalize0 (self->priv->delete_device_statement);
	_sqlite3_finalize0 (self->priv->delete_group_devices_statement);
	_sqlite3_finalize0 (self->priv->insert_device_statement);
	_sqlite3_finalize0 (self->priv->select_group_of_device_statement);
	_sqlite3_finalize0 (self->priv->select_timers_statement);
	_sqlite3_finalize0 (self->priv->delete_timer_statement);
	_sqlite3_finalize0 (self->priv->delete_group_timers_statement);
	_sqlite3_finalize0 (self->priv->insert_timer_statement);
	_sqlite3_finalize0 (self->priv->contains_group_statement);
	_sqlite3_finalize0 (self->priv->contains_timer_statement);
	_sqlite3_finalize0 (self->priv->insert_channel_group_statement);
	_sqlite3_finalize0 (self->priv->delete_channel_group_statement);
	_sqlite3_finalize0 (self->priv->remove_all_channel_group_statement);
	_sqlite3_finalize0 (self->priv->select_channel_groups_statement);
	_sqlite3_finalize0 (self->priv->add_channel_group_statement);
	_sqlite3_finalize0 (self->priv->remove_channel_group_statement);
	_sqlite3_finalize0 (self->priv->select_channels_statement);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_config_timers_store_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_config_timers_store_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteConfigTimersStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_config_timers_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteConfigTimersStore), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_instance_init, NULL };
		static const GInterfaceInfo dvb_database_config_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_database_timers_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_database_sqlite_sqlite_config_timers_store_type_id;
		dvb_database_sqlite_sqlite_config_timers_store_type_id = g_type_register_static (DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, "DVBdatabasesqliteSqliteConfigTimersStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_config_timers_store_type_id, DVB_DATABASE_TYPE_CONFIG_STORE, &dvb_database_config_store_info);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_config_timers_store_type_id, DVB_DATABASE_TYPE_TIMERS_STORE, &dvb_database_timers_store_info);
		g_once_init_leave (&dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile, dvb_database_sqlite_sqlite_config_timers_store_type_id);
	}
	return dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile;
}




