/* Channel.c generated by valac 0.9.7, the Vala compiler
 * generated from Channel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	char* (*to_string) (DVBChannel* self);
};

struct _DVBChannelPrivate {
	guint _GroupId;
	char* _Name;
	guint _TransportStreamId;
	char* _Network;
	guint* _LogicalChannelNumber;
	guint _VideoPID;
	GeeList* _AudioPIDs;
	guint _Frequency;
	gboolean _Scrambled;
	DVBSchedule* schedule;
	guint sid;
	gboolean has_schedule;
};


static gpointer dvb_channel_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_schedule_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL, DVBChannelPrivate))
enum  {
	DVB_CHANNEL_DUMMY_PROPERTY,
	DVB_CHANNEL_SID,
	DVB_CHANNEL_GROUP_ID,
	DVB_CHANNEL_NAME,
	DVB_CHANNEL_TRANSPORT_STREAM_ID,
	DVB_CHANNEL_NETWORK,
	DVB_CHANNEL_VIDEO_PID,
	DVB_CHANNEL_AUDIO_PI_DS,
	DVB_CHANNEL_FREQUENCY,
	DVB_CHANNEL_SCRAMBLED,
	DVB_CHANNEL_SCHEDULE,
	DVB_CHANNEL_URL
};
DVBChannel* dvb_channel_construct (GType object_type);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
char* dvb_channel_get_audio_pids_string (DVBChannel* self);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
static gboolean dvb_channel_real_is_valid (DVBChannel* self);
const char* dvb_channel_get_Name (DVBChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
gboolean dvb_channel_equals (DVBChannel* self, DVBChannel* channel);
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source);
char* dvb_channel_to_string (DVBChannel* self);
static char* dvb_channel_real_to_string (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
guint dvb_channel_get_GroupId (DVBChannel* self);
void dvb_channel_set_GroupId (DVBChannel* self, guint value);
void dvb_channel_set_Name (DVBChannel* self, const char* value);
guint dvb_channel_get_TransportStreamId (DVBChannel* self);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
const char* dvb_channel_get_Network (DVBChannel* self);
void dvb_channel_set_Network (DVBChannel* self, const char* value);
guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
static guint* _uint_dup (guint* self);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
void dvb_channel_set_AudioPIDs (DVBChannel* self, GeeList* value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
char* dvb_channel_get_URL (DVBChannel* self);
char* dvb_utils_remove_nonalphanums (const char* text);
static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_channel_finalize (GObject* obj);
static void dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DVBChannel* dvb_channel_construct (GType object_type) {
	DVBChannel * self;
	self = (DVBChannel*) g_object_new (object_type, NULL);
	self->priv->has_schedule = TRUE;
	return self;
}


DVBChannel* dvb_channel_construct_without_schedule (GType object_type) {
	DVBChannel * self;
	self = (DVBChannel*) g_object_new (object_type, NULL);
	self->priv->has_schedule = FALSE;
	return self;
}


char* dvb_channel_get_audio_pids_string (DVBChannel* self) {
	char* result = NULL;
	GString* apids;
	gint i;
	g_return_val_if_fail (self != NULL, NULL);
	apids = g_string_new ("");
	i = 1;
	{
		GeeIterator* _pid_it;
		_pid_it = gee_iterable_iterator ((GeeIterable*) self->priv->_AudioPIDs);
		while (TRUE) {
			guint pid;
			if (!gee_iterator_next (_pid_it)) {
				break;
			}
			pid = GPOINTER_TO_UINT (gee_iterator_get (_pid_it));
			if (i == gee_collection_get_size ((GeeCollection*) self->priv->_AudioPIDs)) {
				char* _tmp0_;
				g_string_append (apids, _tmp0_ = g_strdup_printf ("%u", pid));
				_g_free0 (_tmp0_);
			} else {
				char* _tmp1_;
				g_string_append (apids, _tmp1_ = g_strdup_printf ("%u,", pid));
				_g_free0 (_tmp1_);
			}
			i++;
		}
		_g_object_unref0 (_pid_it);
	}
	result = g_strdup (apids->str);
	_g_string_free0 (apids);
	return result;
}


gboolean dvb_channel_is_radio (DVBChannel* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_VideoPID == 0;
	return result;
}


static gboolean dvb_channel_real_is_valid (DVBChannel* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_Name != NULL) {
		_tmp2_ = self->priv->_Frequency != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = dvb_channel_get_Sid (self) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp3_ = FALSE;
		if (self->priv->_VideoPID != 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = gee_collection_get_size ((GeeCollection*) self->priv->_AudioPIDs) != 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean dvb_channel_is_valid (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->is_valid (self);
}


/**
         * @returns: TRUE if both channels are part of the same
         * transport stream (TS).
         *
         * Channels that are part of the same TS can be viewed/recorded
         * at the same time with a single device.
         */
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	result = self->priv->_Frequency == channel->priv->_Frequency;
	return result;
}


gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	return DVB_CHANNEL_GET_CLASS (self)->on_same_transport_stream (self, channel);
}


/**
         * @returns: TRUE of both channels are identical
         */
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	result = self->priv->sid == dvb_channel_get_Sid (channel);
	return result;
}


gboolean dvb_channel_equals (DVBChannel* self, DVBChannel* channel) {
	return DVB_CHANNEL_GET_CLASS (self)->equals (self, channel);
}


/**
         * @source: Either dvbbasebin or dvbsrc
         *
         * Set properties of source so that the channel can be watched
         */
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_setup_dvb_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source) {
	DVB_CHANNEL_GET_CLASS (self)->setup_dvb_source (self, source);
}


static char* dvb_channel_real_to_string (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* dvb_channel_to_string (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->to_string (self);
}


guint dvb_channel_get_Sid (DVBChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->sid;
	return result;
}


void dvb_channel_set_Sid (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->sid = value;
	if (self->priv->has_schedule) {
		DVBSchedule* _tmp0_;
		self->priv->schedule = (_tmp0_ = dvb_schedule_new (self), _g_object_unref0 (self->priv->schedule), _tmp0_);
	}
	g_object_notify ((GObject *) self, "Sid");
}


guint dvb_channel_get_GroupId (DVBChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_GroupId;
	return result;
}


void dvb_channel_set_GroupId (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_GroupId = value;
	g_object_notify ((GObject *) self, "GroupId");
}


const char* dvb_channel_get_Name (DVBChannel* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Name;
	return result;
}


void dvb_channel_set_Name (DVBChannel* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Name), _tmp0_);
	g_object_notify ((GObject *) self, "Name");
}


guint dvb_channel_get_TransportStreamId (DVBChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_TransportStreamId;
	return result;
}


void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_TransportStreamId = value;
	g_object_notify ((GObject *) self, "TransportStreamId");
}


const char* dvb_channel_get_Network (DVBChannel* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Network;
	return result;
}


void dvb_channel_set_Network (DVBChannel* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Network = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Network), _tmp0_);
	g_object_notify ((GObject *) self, "Network");
}


guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self) {
	guint* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_LogicalChannelNumber;
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value) {
	guint* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_LogicalChannelNumber = (_tmp0_ = __uint_dup0 (value), _g_free0 (self->priv->_LogicalChannelNumber), _tmp0_);
}


guint dvb_channel_get_VideoPID (DVBChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_VideoPID;
	return result;
}


void dvb_channel_set_VideoPID (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_VideoPID = value;
	g_object_notify ((GObject *) self, "VideoPID");
}


GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_AudioPIDs;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_channel_set_AudioPIDs (DVBChannel* self, GeeList* value) {
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_AudioPIDs = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_AudioPIDs), _tmp0_);
	g_object_notify ((GObject *) self, "AudioPIDs");
}


guint dvb_channel_get_Frequency (DVBChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Frequency;
	return result;
}


void dvb_channel_set_Frequency (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frequency = value;
	g_object_notify ((GObject *) self, "Frequency");
}


gboolean dvb_channel_get_Scrambled (DVBChannel* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_Scrambled;
	return result;
}


void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_Scrambled = value;
	g_object_notify ((GObject *) self, "Scrambled");
}


DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self) {
	DVBSchedule* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->schedule;
	return result;
}


char* dvb_channel_get_URL (DVBChannel* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf ("rtsp://%s:8554/%u/%u/%s", g_get_host_name (), self->priv->_GroupId, dvb_channel_get_Sid (self), _tmp0_ = dvb_utils_remove_nonalphanums (self->priv->_Name)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBChannel * self;
	parent_class = G_OBJECT_CLASS (dvb_channel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL (obj);
	{
		GeeArrayList* _tmp0_;
		dvb_channel_set_AudioPIDs (self, (GeeList*) (_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL)));
		_g_object_unref0 (_tmp0_);
	}
	return obj;
}


static void dvb_channel_class_init (DVBChannelClass * klass) {
	dvb_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->on_same_transport_stream = dvb_channel_real_on_same_transport_stream;
	DVB_CHANNEL_CLASS (klass)->equals = dvb_channel_real_equals;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SID, g_param_spec_uint ("Sid", "Sid", "Sid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_TRANSPORT_STREAM_ID, g_param_spec_uint ("TransportStreamId", "TransportStreamId", "TransportStreamId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NETWORK, g_param_spec_string ("Network", "Network", "Network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_VIDEO_PID, g_param_spec_uint ("VideoPID", "VideoPID", "VideoPID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_AUDIO_PI_DS, g_param_spec_object ("AudioPIDs", "AudioPIDs", "AudioPIDs", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCRAMBLED, g_param_spec_boolean ("Scrambled", "Scrambled", "Scrambled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCHEDULE, g_param_spec_object ("Schedule", "Schedule", "Schedule", DVB_TYPE_SCHEDULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_URL, g_param_spec_string ("URL", "URL", "URL", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dvb_channel_instance_init (DVBChannel * self) {
	self->priv = DVB_CHANNEL_GET_PRIVATE (self);
}


static void dvb_channel_finalize (GObject* obj) {
	DVBChannel * self;
	self = DVB_CHANNEL (obj);
	_g_free0 (self->priv->_Name);
	_g_free0 (self->priv->_Network);
	_g_free0 (self->priv->_LogicalChannelNumber);
	_g_object_unref0 (self->priv->_AudioPIDs);
	_g_object_unref0 (self->priv->schedule);
	G_OBJECT_CLASS (dvb_channel_parent_class)->finalize (obj);
}


GType dvb_channel_get_type (void) {
	static volatile gsize dvb_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannel), 0, (GInstanceInitFunc) dvb_channel_instance_init, NULL };
		GType dvb_channel_type_id;
		dvb_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_channel_type_id__volatile, dvb_channel_type_id);
	}
	return dvb_channel_type_id__volatile;
}


static void dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		g_value_set_uint (value, dvb_channel_get_Sid (self));
		break;
		case DVB_CHANNEL_GROUP_ID:
		g_value_set_uint (value, dvb_channel_get_GroupId (self));
		break;
		case DVB_CHANNEL_NAME:
		g_value_set_string (value, dvb_channel_get_Name (self));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		g_value_set_uint (value, dvb_channel_get_TransportStreamId (self));
		break;
		case DVB_CHANNEL_NETWORK:
		g_value_set_string (value, dvb_channel_get_Network (self));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		g_value_set_uint (value, dvb_channel_get_VideoPID (self));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		g_value_set_object (value, dvb_channel_get_AudioPIDs (self));
		break;
		case DVB_CHANNEL_FREQUENCY:
		g_value_set_uint (value, dvb_channel_get_Frequency (self));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		g_value_set_boolean (value, dvb_channel_get_Scrambled (self));
		break;
		case DVB_CHANNEL_SCHEDULE:
		g_value_set_object (value, dvb_channel_get_Schedule (self));
		break;
		case DVB_CHANNEL_URL:
		g_value_take_string (value, dvb_channel_get_URL (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		dvb_channel_set_Sid (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_GROUP_ID:
		dvb_channel_set_GroupId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NAME:
		dvb_channel_set_Name (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		dvb_channel_set_TransportStreamId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NETWORK:
		dvb_channel_set_Network (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		dvb_channel_set_VideoPID (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		dvb_channel_set_AudioPIDs (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_FREQUENCY:
		dvb_channel_set_Frequency (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		dvb_channel_set_Scrambled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




