/* Interfaces2.c generated by valac 0.10.0, the Vala compiler
 * generated from Interfaces2.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define TYPE_MEDIA_OBJECT2 (media_object2_get_type ())
#define MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT2, MediaObject2))
#define IS_MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT2))
#define MEDIA_OBJECT2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT2, MediaObject2Iface))

typedef struct _MediaObject2 MediaObject2;
typedef struct _MediaObject2Iface MediaObject2Iface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObject2DBusProxy MediaObject2DBusProxy;
typedef DBusGProxyClass MediaObject2DBusProxyClass;

#define TYPE_MEDIA_CONTAINER2 (media_container2_get_type ())
#define MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2))
#define IS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER2))
#define MEDIA_CONTAINER2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2Iface))

typedef struct _MediaContainer2 MediaContainer2;
typedef struct _MediaContainer2Iface MediaContainer2Iface;
typedef struct _MediaContainer2DBusProxy MediaContainer2DBusProxy;
typedef DBusGProxyClass MediaContainer2DBusProxyClass;

#define TYPE_MEDIA_ITEM2 (media_item2_get_type ())
#define MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM2, MediaItem2))
#define IS_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM2))
#define MEDIA_ITEM2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM2, MediaItem2Iface))

typedef struct _MediaItem2 MediaItem2;
typedef struct _MediaItem2Iface MediaItem2Iface;
typedef struct _MediaItem2DBusProxy MediaItem2DBusProxy;
typedef DBusGProxyClass MediaItem2DBusProxyClass;

struct _MediaObject2Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject2* self);
	char* (*get_DisplayName) (MediaObject2* self);
	char* (*get_Type) (MediaObject2* self);
	char* (*get_Path) (MediaObject2* self);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _MediaObject2DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaContainer2Iface {
	GTypeInterface parent_iface;
	GHashTable** (*ListChildren) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListContainers) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListItems) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	guint (*get_ChildCount) (MediaContainer2* self);
	guint (*get_ItemCount) (MediaContainer2* self);
	guint (*get_ContainerCount) (MediaContainer2* self);
	gboolean (*get_Searchable) (MediaContainer2* self);
};

struct _MediaContainer2DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaItem2Iface {
	GTypeInterface parent_iface;
	char** (*get_URLs) (MediaItem2* self, int* result_length1);
	char* (*get_MIMEType) (MediaItem2* self);
};

struct _MediaItem2DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};



GType media_object2_get_type (void) G_GNUC_CONST;
MediaObject2* media_object2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char* media_object2_get_Parent (MediaObject2* self);
char* media_object2_get_DisplayName (MediaObject2* self);
char* media_object2_get_Type (MediaObject2* self);
char* media_object2_get_Path (MediaObject2* self);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void media_object2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_object2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_object2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_object2_introspect (MediaObject2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object2_property_get (MediaObject2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object2_property_get_all (MediaObject2* self, DBusConnection* connection, DBusMessage* message);
GType media_object2_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult media_object2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_OBJECT2_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_OBJECT2_DBUS_PROXY_PARENT,
	MEDIA_OBJECT2_DBUS_PROXY_DISPLAY_NAME,
	MEDIA_OBJECT2_DBUS_PROXY_TYPE,
	MEDIA_OBJECT2_DBUS_PROXY_PATH
};
static char* media_object2_dbus_proxy_get_Parent (MediaObject2* self);
static char* media_object2_dbus_proxy_get_DisplayName (MediaObject2* self);
static char* media_object2_dbus_proxy_get_Type (MediaObject2* self);
static char* media_object2_dbus_proxy_get_Path (MediaObject2* self);
static void media_object2_dbus_proxy_media_object2__interface_init (MediaObject2Iface* iface);
static void media_object2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_object2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
MediaContainer2* media_container2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType media_container2_get_type (void) G_GNUC_CONST;
GHashTable** media_container2_ListChildren (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListContainers (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListItems (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
guint media_container2_get_ChildCount (MediaContainer2* self);
guint media_container2_get_ItemCount (MediaContainer2* self);
guint media_container2_get_ContainerCount (MediaContainer2* self);
gboolean media_container2_get_Searchable (MediaContainer2* self);
void media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_container2_introspect (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container2_property_get (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container2_property_get_all (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container2_ListChildren (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container2_ListContainers (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container2_ListItems (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_media_container2_updated (GObject* _sender, DBusConnection* _connection);
GType media_container2_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_media_container2_updated (MediaContainer2* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult media_container2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_CONTAINER2_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_CONTAINER2_DBUS_PROXY_CHILD_COUNT,
	MEDIA_CONTAINER2_DBUS_PROXY_ITEM_COUNT,
	MEDIA_CONTAINER2_DBUS_PROXY_CONTAINER_COUNT,
	MEDIA_CONTAINER2_DBUS_PROXY_SEARCHABLE
};
static GHashTable** media_container2_dbus_proxy_ListChildren (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** media_container2_dbus_proxy_ListContainers (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** media_container2_dbus_proxy_ListItems (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static guint media_container2_dbus_proxy_get_ChildCount (MediaContainer2* self);
static guint media_container2_dbus_proxy_get_ItemCount (MediaContainer2* self);
static guint media_container2_dbus_proxy_get_ContainerCount (MediaContainer2* self);
static gboolean media_container2_dbus_proxy_get_Searchable (MediaContainer2* self);
static void media_container2_dbus_proxy_media_container2__interface_init (MediaContainer2Iface* iface);
static void media_container2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_container2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_item2_get_type (void) G_GNUC_CONST;
MediaItem2* media_item2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char** media_item2_get_URLs (MediaItem2* self, int* result_length1);
char* media_item2_get_MIMEType (MediaItem2* self);
void media_item2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_item2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_item2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_item2_introspect (MediaItem2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item2_property_get (MediaItem2* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item2_property_get_all (MediaItem2* self, DBusConnection* connection, DBusMessage* message);
GType media_item2_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult media_item2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_ITEM2_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_ITEM2_DBUS_PROXY_UR_LS,
	MEDIA_ITEM2_DBUS_PROXY_MIME_TYPE
};
static char** media_item2_dbus_proxy_get_URLs (MediaItem2* self, int* result_length1);
static char* media_item2_dbus_proxy_get_MIMEType (MediaItem2* self);
static void media_item2_dbus_proxy_media_item2__interface_init (MediaItem2Iface* iface);
static void media_item2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_item2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _media_object2_dbus_path_vtable = {_media_object2_dbus_unregister, media_object2_dbus_message};
static const _DBusObjectVTable _media_object2_dbus_vtable = {media_object2_dbus_register_object};
static const DBusObjectPathVTable _media_container2_dbus_path_vtable = {_media_container2_dbus_unregister, media_container2_dbus_message};
static const _DBusObjectVTable _media_container2_dbus_vtable = {media_container2_dbus_register_object};
static const DBusObjectPathVTable _media_item2_dbus_path_vtable = {_media_item2_dbus_unregister, media_item2_dbus_message};
static const _DBusObjectVTable _media_item2_dbus_vtable = {media_item2_dbus_register_object};


char* media_object2_get_Parent (MediaObject2* self) {
	return MEDIA_OBJECT2_GET_INTERFACE (self)->get_Parent (self);
}


char* media_object2_get_DisplayName (MediaObject2* self) {
	return MEDIA_OBJECT2_GET_INTERFACE (self)->get_DisplayName (self);
}


char* media_object2_get_Type (MediaObject2* self) {
	return MEDIA_OBJECT2_GET_INTERFACE (self)->get_Type (self);
}


char* media_object2_get_Path (MediaObject2* self) {
	return MEDIA_OBJECT2_GET_INTERFACE (self)->get_Path (self);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _media_object2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_object2_introspect (MediaObject2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject2\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n  <property name=\"Path\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object2_property_get (MediaObject2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject2") == 0) && (strcmp (property_name, "Parent") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = media_object2_get_Parent (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject2") == 0) && (strcmp (property_name, "DisplayName") == 0)) {
		char* result;
		const char* _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_object2_get_DisplayName (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp3_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject2") == 0) && (strcmp (property_name, "Type") == 0)) {
		char* result;
		const char* _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_object2_get_Type (self);
		_tmp4_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp4_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject2") == 0) && (strcmp (property_name, "Path") == 0)) {
		char* result;
		const char* _tmp5_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_object2_get_Path (self);
		_tmp5_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp5_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object2_property_get_all (MediaObject2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp6_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp6_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaObject2") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp7_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Parent";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = media_object2_get_Parent (self);
			_tmp7_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp7_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp8_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DisplayName";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_object2_get_DisplayName (self);
			_tmp8_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp8_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp9_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Type";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_object2_get_Type (self);
			_tmp9_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp9_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp10_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Path";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_object2_get_Path (self);
			_tmp10_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp10_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_object2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_object2_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_object2_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_object2_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_object2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_object2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_object2_base_init (MediaObject2Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("Parent", "Parent", "Parent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("DisplayName", "DisplayName", "DisplayName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("Type", "Type", "Type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("Path", "Path", "Path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_OBJECT2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_object2_dbus_vtable));
	}
}


GType media_object2_get_type (void) {
	static volatile gsize media_object2_type_id__volatile = 0;
	if (g_once_init_enter (&media_object2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObject2Iface), (GBaseInitFunc) media_object2_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_object2_type_id;
		media_object2_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaObject2", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_object2_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_object2_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_object2_dbus_proxy_get_type);
		g_once_init_leave (&media_object2_type_id__volatile, media_object2_type_id);
	}
	return media_object2_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaObject2DBusProxy, media_object2_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_OBJECT2, media_object2_dbus_proxy_media_object2__interface_init) );
MediaObject2* media_object2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaObject2* self;
	self = g_object_new (media_object2_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaObject2", NULL);
	return self;
}


static GObject* media_object2_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_object2_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_object2_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_object2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_object2_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaObject2DBusProxy*) self)->disposed) {
		return;
	}
	((MediaObject2DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_object2_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_object2_dbus_proxy_parent_class)->dispose (self);
}


static void media_object2_dbus_proxy_class_init (MediaObject2DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_object2_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_object2_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_object2_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_object2_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT2_DBUS_PROXY_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT2_DBUS_PROXY_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT2_DBUS_PROXY_TYPE, "Type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT2_DBUS_PROXY_PATH, "Path");
}


static void media_object2_dbus_proxy_init (MediaObject2DBusProxy* self) {
}


static char* media_object2_dbus_proxy_get_Parent (MediaObject2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp481_;
	const char* _tmp482_;
	char* _result;
	const char* _tmp483_;
	if (((MediaObject2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp481_ = "org.gnome.UPnP.MediaObject2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp481_);
	_tmp482_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp482_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp483_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp483_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_object2_dbus_proxy_get_DisplayName (MediaObject2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp484_;
	const char* _tmp485_;
	char* _result;
	const char* _tmp486_;
	if (((MediaObject2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp484_ = "org.gnome.UPnP.MediaObject2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp484_);
	_tmp485_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp485_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp486_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp486_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_object2_dbus_proxy_get_Type (MediaObject2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp487_;
	const char* _tmp488_;
	char* _result;
	const char* _tmp489_;
	if (((MediaObject2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp487_ = "org.gnome.UPnP.MediaObject2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp487_);
	_tmp488_ = "Type";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp488_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp489_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp489_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_object2_dbus_proxy_get_Path (MediaObject2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp490_;
	const char* _tmp491_;
	char* _result;
	const char* _tmp492_;
	if (((MediaObject2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp490_ = "org.gnome.UPnP.MediaObject2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp490_);
	_tmp491_ = "Path";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp491_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp492_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp492_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_object2_dbus_proxy_media_object2__interface_init (MediaObject2Iface* iface) {
	iface->get_Parent = media_object2_dbus_proxy_get_Parent;
	iface->get_DisplayName = media_object2_dbus_proxy_get_DisplayName;
	iface->get_Type = media_object2_dbus_proxy_get_Type;
	iface->get_Path = media_object2_dbus_proxy_get_Path;
}


static void media_object2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_object2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GHashTable** media_container2_ListChildren (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->ListChildren (self, offset, max, filter, filter_length1, result_length1, error);
}


GHashTable** media_container2_ListContainers (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->ListContainers (self, offset, max, filter, filter_length1, result_length1, error);
}


GHashTable** media_container2_ListItems (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->ListItems (self, offset, max, filter, filter_length1, result_length1, error);
}


guint media_container2_get_ChildCount (MediaContainer2* self) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->get_ChildCount (self);
}


guint media_container2_get_ItemCount (MediaContainer2* self) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->get_ItemCount (self);
}


guint media_container2_get_ContainerCount (MediaContainer2* self) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->get_ContainerCount (self);
}


gboolean media_container2_get_Searchable (MediaContainer2* self) {
	return MEDIA_CONTAINER2_GET_INTERFACE (self)->get_Searchable (self);
}


void _media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_container2_introspect (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer2\">\n  <method name=\"ListChildren\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListContainers\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListItems\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <property name=\"ChildCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Searchable\" type=\"b\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container2_property_get (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer2") == 0) && (strcmp (property_name, "ChildCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container2_get_ChildCount (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp2_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer2") == 0) && (strcmp (property_name, "ItemCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container2_get_ItemCount (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp3_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer2") == 0) && (strcmp (property_name, "ContainerCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container2_get_ContainerCount (self);
		_tmp4_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp4_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer2") == 0) && (strcmp (property_name, "Searchable") == 0)) {
		gboolean result;
		dbus_bool_t _tmp5_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = media_container2_get_Searchable (self);
		_tmp5_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp5_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container2_property_get_all (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp6_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp6_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaContainer2") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			guint result;
			dbus_uint32_t _tmp7_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ChildCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container2_get_ChildCount (self);
			_tmp7_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp7_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp8_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ItemCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container2_get_ItemCount (self);
			_tmp8_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp8_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp9_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ContainerCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container2_get_ContainerCount (self);
			_tmp9_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp9_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp10_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Searchable";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = media_container2_get_Searchable (self);
			_tmp10_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp10_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container2_ListChildren (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint offset = 0U;
	dbus_uint32_t _tmp11_;
	guint max = 0U;
	dbus_uint32_t _tmp12_;
	char** filter = NULL;
	int filter_length1;
	char** _tmp13_;
	int _tmp13__length;
	int _tmp13__size;
	int _tmp13__length1;
	DBusMessageIter _tmp14_;
	GHashTable** result;
	int result_length1;
	DBusMessage* reply;
	GHashTable** _tmp16_;
	DBusMessageIter _tmp17_;
	int _tmp18_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuas")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	offset = _tmp11_;
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	max = _tmp12_;
	filter_length1 = 0;
	_tmp13_ = g_new (char*, 5);
	_tmp13__length = 0;
	_tmp13__size = 4;
	_tmp13__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp14_);
	for (; dbus_message_iter_get_arg_type (&_tmp14_); _tmp13__length1++) {
		const char* _tmp15_;
		if (_tmp13__size == _tmp13__length) {
			_tmp13__size = 2 * _tmp13__size;
			_tmp13_ = g_renew (char*, _tmp13_, _tmp13__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp14_, &_tmp15_);
		dbus_message_iter_next (&_tmp14_);
		_tmp13_[_tmp13__length++] = g_strdup (_tmp15_);
	}
	filter_length1 = _tmp13__length1;
	_tmp13_[_tmp13__length] = NULL;
	dbus_message_iter_next (&iter);
	filter = _tmp13_;
	result_length1 = 0;
	result = media_container2_ListChildren (self, offset, max, filter, filter_length1, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	filter = (_vala_array_free (filter, filter_length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "a{sv}", &_tmp17_);
	for (_tmp18_ = 0; _tmp18_ < result_length1; _tmp18_++) {
		DBusMessageIter _tmp19_, _tmp20_;
		GHashTableIter _tmp21_;
		gpointer _tmp22_, _tmp23_;
		dbus_message_iter_open_container (&_tmp17_, DBUS_TYPE_ARRAY, "{sv}", &_tmp19_);
		g_hash_table_iter_init (&_tmp21_, *_tmp16_);
		while (g_hash_table_iter_next (&_tmp21_, &_tmp22_, &_tmp23_)) {
			char* _key;
			GValue* _value;
			const char* _tmp24_;
			DBusMessageIter _tmp25_;
			dbus_message_iter_open_container (&_tmp19_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp20_);
			_key = (char*) _tmp22_;
			_value = (GValue*) _tmp23_;
			_tmp24_ = _key;
			dbus_message_iter_append_basic (&_tmp20_, DBUS_TYPE_STRING, &_tmp24_);
			if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
				guint8 _tmp26_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "y", &_tmp25_);
				_tmp26_ = g_value_get_uchar (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_BYTE, &_tmp26_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
				dbus_bool_t _tmp27_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "b", &_tmp25_);
				_tmp27_ = g_value_get_boolean (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_BOOLEAN, &_tmp27_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
				dbus_int32_t _tmp28_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "i", &_tmp25_);
				_tmp28_ = g_value_get_int (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_INT32, &_tmp28_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
				dbus_uint32_t _tmp29_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "u", &_tmp25_);
				_tmp29_ = g_value_get_uint (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_UINT32, &_tmp29_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
				dbus_int64_t _tmp30_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "x", &_tmp25_);
				_tmp30_ = g_value_get_int64 (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_INT64, &_tmp30_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
				dbus_uint64_t _tmp31_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "t", &_tmp25_);
				_tmp31_ = g_value_get_uint64 (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_UINT64, &_tmp31_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
				double _tmp32_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "d", &_tmp25_);
				_tmp32_ = g_value_get_double (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_DOUBLE, &_tmp32_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
				const char* _tmp33_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "s", &_tmp25_);
				_tmp33_ = g_value_get_string (_value);
				dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_STRING, &_tmp33_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
				const char** _tmp34_;
				DBusMessageIter _tmp35_;
				int _tmp36_;
				dbus_message_iter_open_container (&_tmp20_, DBUS_TYPE_VARIANT, "as", &_tmp25_);
				_tmp34_ = g_value_get_boxed (_value);
				dbus_message_iter_open_container (&_tmp25_, DBUS_TYPE_ARRAY, "s", &_tmp35_);
				for (_tmp36_ = 0; _tmp36_ < g_strv_length (g_value_get_boxed (_value)); _tmp36_++) {
					const char* _tmp37_;
					_tmp37_ = *_tmp34_;
					dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_STRING, &_tmp37_);
					_tmp34_++;
				}
				dbus_message_iter_close_container (&_tmp25_, &_tmp35_);
				dbus_message_iter_close_container (&_tmp20_, &_tmp25_);
			}
			dbus_message_iter_close_container (&_tmp19_, &_tmp20_);
		}
		dbus_message_iter_close_container (&_tmp17_, &_tmp19_);
		_tmp16_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp17_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container2_ListContainers (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint offset = 0U;
	dbus_uint32_t _tmp38_;
	guint max = 0U;
	dbus_uint32_t _tmp39_;
	char** filter = NULL;
	int filter_length1;
	char** _tmp40_;
	int _tmp40__length;
	int _tmp40__size;
	int _tmp40__length1;
	DBusMessageIter _tmp41_;
	GHashTable** result;
	int result_length1;
	DBusMessage* reply;
	GHashTable** _tmp43_;
	DBusMessageIter _tmp44_;
	int _tmp45_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuas")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp38_);
	dbus_message_iter_next (&iter);
	offset = _tmp38_;
	dbus_message_iter_get_basic (&iter, &_tmp39_);
	dbus_message_iter_next (&iter);
	max = _tmp39_;
	filter_length1 = 0;
	_tmp40_ = g_new (char*, 5);
	_tmp40__length = 0;
	_tmp40__size = 4;
	_tmp40__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp41_);
	for (; dbus_message_iter_get_arg_type (&_tmp41_); _tmp40__length1++) {
		const char* _tmp42_;
		if (_tmp40__size == _tmp40__length) {
			_tmp40__size = 2 * _tmp40__size;
			_tmp40_ = g_renew (char*, _tmp40_, _tmp40__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp41_, &_tmp42_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_[_tmp40__length++] = g_strdup (_tmp42_);
	}
	filter_length1 = _tmp40__length1;
	_tmp40_[_tmp40__length] = NULL;
	dbus_message_iter_next (&iter);
	filter = _tmp40_;
	result_length1 = 0;
	result = media_container2_ListContainers (self, offset, max, filter, filter_length1, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	filter = (_vala_array_free (filter, filter_length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "a{sv}", &_tmp44_);
	for (_tmp45_ = 0; _tmp45_ < result_length1; _tmp45_++) {
		DBusMessageIter _tmp46_, _tmp47_;
		GHashTableIter _tmp48_;
		gpointer _tmp49_, _tmp50_;
		dbus_message_iter_open_container (&_tmp44_, DBUS_TYPE_ARRAY, "{sv}", &_tmp46_);
		g_hash_table_iter_init (&_tmp48_, *_tmp43_);
		while (g_hash_table_iter_next (&_tmp48_, &_tmp49_, &_tmp50_)) {
			char* _key;
			GValue* _value;
			const char* _tmp51_;
			DBusMessageIter _tmp52_;
			dbus_message_iter_open_container (&_tmp46_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp47_);
			_key = (char*) _tmp49_;
			_value = (GValue*) _tmp50_;
			_tmp51_ = _key;
			dbus_message_iter_append_basic (&_tmp47_, DBUS_TYPE_STRING, &_tmp51_);
			if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
				guint8 _tmp53_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "y", &_tmp52_);
				_tmp53_ = g_value_get_uchar (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_BYTE, &_tmp53_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
				dbus_bool_t _tmp54_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "b", &_tmp52_);
				_tmp54_ = g_value_get_boolean (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_BOOLEAN, &_tmp54_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
				dbus_int32_t _tmp55_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "i", &_tmp52_);
				_tmp55_ = g_value_get_int (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_INT32, &_tmp55_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
				dbus_uint32_t _tmp56_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "u", &_tmp52_);
				_tmp56_ = g_value_get_uint (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_UINT32, &_tmp56_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
				dbus_int64_t _tmp57_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "x", &_tmp52_);
				_tmp57_ = g_value_get_int64 (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_INT64, &_tmp57_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
				dbus_uint64_t _tmp58_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "t", &_tmp52_);
				_tmp58_ = g_value_get_uint64 (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_UINT64, &_tmp58_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
				double _tmp59_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "d", &_tmp52_);
				_tmp59_ = g_value_get_double (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_DOUBLE, &_tmp59_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
				const char* _tmp60_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "s", &_tmp52_);
				_tmp60_ = g_value_get_string (_value);
				dbus_message_iter_append_basic (&_tmp52_, DBUS_TYPE_STRING, &_tmp60_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
				const char** _tmp61_;
				DBusMessageIter _tmp62_;
				int _tmp63_;
				dbus_message_iter_open_container (&_tmp47_, DBUS_TYPE_VARIANT, "as", &_tmp52_);
				_tmp61_ = g_value_get_boxed (_value);
				dbus_message_iter_open_container (&_tmp52_, DBUS_TYPE_ARRAY, "s", &_tmp62_);
				for (_tmp63_ = 0; _tmp63_ < g_strv_length (g_value_get_boxed (_value)); _tmp63_++) {
					const char* _tmp64_;
					_tmp64_ = *_tmp61_;
					dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp64_);
					_tmp61_++;
				}
				dbus_message_iter_close_container (&_tmp52_, &_tmp62_);
				dbus_message_iter_close_container (&_tmp47_, &_tmp52_);
			}
			dbus_message_iter_close_container (&_tmp46_, &_tmp47_);
		}
		dbus_message_iter_close_container (&_tmp44_, &_tmp46_);
		_tmp43_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp44_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container2_ListItems (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint offset = 0U;
	dbus_uint32_t _tmp65_;
	guint max = 0U;
	dbus_uint32_t _tmp66_;
	char** filter = NULL;
	int filter_length1;
	char** _tmp67_;
	int _tmp67__length;
	int _tmp67__size;
	int _tmp67__length1;
	DBusMessageIter _tmp68_;
	GHashTable** result;
	int result_length1;
	DBusMessage* reply;
	GHashTable** _tmp70_;
	DBusMessageIter _tmp71_;
	int _tmp72_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuas")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp65_);
	dbus_message_iter_next (&iter);
	offset = _tmp65_;
	dbus_message_iter_get_basic (&iter, &_tmp66_);
	dbus_message_iter_next (&iter);
	max = _tmp66_;
	filter_length1 = 0;
	_tmp67_ = g_new (char*, 5);
	_tmp67__length = 0;
	_tmp67__size = 4;
	_tmp67__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp68_);
	for (; dbus_message_iter_get_arg_type (&_tmp68_); _tmp67__length1++) {
		const char* _tmp69_;
		if (_tmp67__size == _tmp67__length) {
			_tmp67__size = 2 * _tmp67__size;
			_tmp67_ = g_renew (char*, _tmp67_, _tmp67__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp68_, &_tmp69_);
		dbus_message_iter_next (&_tmp68_);
		_tmp67_[_tmp67__length++] = g_strdup (_tmp69_);
	}
	filter_length1 = _tmp67__length1;
	_tmp67_[_tmp67__length] = NULL;
	dbus_message_iter_next (&iter);
	filter = _tmp67_;
	result_length1 = 0;
	result = media_container2_ListItems (self, offset, max, filter, filter_length1, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	filter = (_vala_array_free (filter, filter_length1, (GDestroyNotify) g_free), NULL);
	_tmp70_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "a{sv}", &_tmp71_);
	for (_tmp72_ = 0; _tmp72_ < result_length1; _tmp72_++) {
		DBusMessageIter _tmp73_, _tmp74_;
		GHashTableIter _tmp75_;
		gpointer _tmp76_, _tmp77_;
		dbus_message_iter_open_container (&_tmp71_, DBUS_TYPE_ARRAY, "{sv}", &_tmp73_);
		g_hash_table_iter_init (&_tmp75_, *_tmp70_);
		while (g_hash_table_iter_next (&_tmp75_, &_tmp76_, &_tmp77_)) {
			char* _key;
			GValue* _value;
			const char* _tmp78_;
			DBusMessageIter _tmp79_;
			dbus_message_iter_open_container (&_tmp73_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp74_);
			_key = (char*) _tmp76_;
			_value = (GValue*) _tmp77_;
			_tmp78_ = _key;
			dbus_message_iter_append_basic (&_tmp74_, DBUS_TYPE_STRING, &_tmp78_);
			if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
				guint8 _tmp80_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "y", &_tmp79_);
				_tmp80_ = g_value_get_uchar (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_BYTE, &_tmp80_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
				dbus_bool_t _tmp81_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "b", &_tmp79_);
				_tmp81_ = g_value_get_boolean (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_BOOLEAN, &_tmp81_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
				dbus_int32_t _tmp82_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "i", &_tmp79_);
				_tmp82_ = g_value_get_int (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_INT32, &_tmp82_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
				dbus_uint32_t _tmp83_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "u", &_tmp79_);
				_tmp83_ = g_value_get_uint (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_UINT32, &_tmp83_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
				dbus_int64_t _tmp84_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "x", &_tmp79_);
				_tmp84_ = g_value_get_int64 (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_INT64, &_tmp84_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
				dbus_uint64_t _tmp85_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "t", &_tmp79_);
				_tmp85_ = g_value_get_uint64 (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_UINT64, &_tmp85_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
				double _tmp86_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "d", &_tmp79_);
				_tmp86_ = g_value_get_double (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_DOUBLE, &_tmp86_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
				const char* _tmp87_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "s", &_tmp79_);
				_tmp87_ = g_value_get_string (_value);
				dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_STRING, &_tmp87_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
				const char** _tmp88_;
				DBusMessageIter _tmp89_;
				int _tmp90_;
				dbus_message_iter_open_container (&_tmp74_, DBUS_TYPE_VARIANT, "as", &_tmp79_);
				_tmp88_ = g_value_get_boxed (_value);
				dbus_message_iter_open_container (&_tmp79_, DBUS_TYPE_ARRAY, "s", &_tmp89_);
				for (_tmp90_ = 0; _tmp90_ < g_strv_length (g_value_get_boxed (_value)); _tmp90_++) {
					const char* _tmp91_;
					_tmp91_ = *_tmp88_;
					dbus_message_iter_append_basic (&_tmp89_, DBUS_TYPE_STRING, &_tmp91_);
					_tmp88_++;
				}
				dbus_message_iter_close_container (&_tmp79_, &_tmp89_);
				dbus_message_iter_close_container (&_tmp74_, &_tmp79_);
			}
			dbus_message_iter_close_container (&_tmp73_, &_tmp74_);
		}
		dbus_message_iter_close_container (&_tmp71_, &_tmp73_);
		_tmp70_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp71_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_container2_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_container2_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_container2_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.UPnP.MediaContainer2", "ListChildren")) {
		result = _dbus_media_container2_ListChildren (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.UPnP.MediaContainer2", "ListContainers")) {
		result = _dbus_media_container2_ListContainers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.UPnP.MediaContainer2", "ListItems")) {
		result = _dbus_media_container2_ListItems (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_media_container2_updated (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.UPnP.MediaContainer2", "Updated");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_container2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_media_container2_updated, connection);
}


static void media_container2_base_init (MediaContainer2Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("ChildCount", "ChildCount", "ChildCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint ("ItemCount", "ItemCount", "ItemCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint ("ContainerCount", "ContainerCount", "ContainerCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("Searchable", "Searchable", "Searchable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("updated", TYPE_MEDIA_CONTAINER2, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (TYPE_MEDIA_CONTAINER2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_container2_dbus_vtable));
	}
}


GType media_container2_get_type (void) {
	static volatile gsize media_container2_type_id__volatile = 0;
	if (g_once_init_enter (&media_container2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainer2Iface), (GBaseInitFunc) media_container2_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_container2_type_id;
		media_container2_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaContainer2", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_container2_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_container2_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_container2_dbus_proxy_get_type);
		g_once_init_leave (&media_container2_type_id__volatile, media_container2_type_id);
	}
	return media_container2_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaContainer2DBusProxy, media_container2_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_CONTAINER2, media_container2_dbus_proxy_media_container2__interface_init) );
MediaContainer2* media_container2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaContainer2* self;
	self = g_object_new (media_container2_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaContainer2", NULL);
	return self;
}


static GObject* media_container2_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_container2_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_container2_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_media_container2_updated (MediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "updated");
}


DBusHandlerResult media_container2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.UPnP.MediaContainer2", "Updated")) {
			_dbus_handle_media_container2_updated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_container2_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		return;
	}
	((MediaContainer2DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_container2_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_container2_dbus_proxy_parent_class)->dispose (self);
}


static void media_container2_dbus_proxy_class_init (MediaContainer2DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_container2_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_container2_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_container2_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_container2_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER2_DBUS_PROXY_CHILD_COUNT, "ChildCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER2_DBUS_PROXY_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER2_DBUS_PROXY_CONTAINER_COUNT, "ContainerCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER2_DBUS_PROXY_SEARCHABLE, "Searchable");
}


static void media_container2_dbus_proxy_init (MediaContainer2DBusProxy* self) {
}


static GHashTable** media_container2_dbus_proxy_ListChildren (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp493_;
	dbus_uint32_t _tmp494_;
	char** _tmp495_;
	DBusMessageIter _tmp496_;
	int _tmp497_;
	GHashTable** _result;
	int _result_length1;
	GHashTable** _tmp499_;
	int _tmp499__length;
	int _tmp499__size;
	int _tmp499__length1;
	DBusMessageIter _tmp500_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.UPnP.MediaContainer2", "ListChildren");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp493_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp493_);
	_tmp494_ = max;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp494_);
	_tmp495_ = filter;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp496_);
	for (_tmp497_ = 0; _tmp497_ < filter_length1; _tmp497_++) {
		const char* _tmp498_;
		_tmp498_ = *_tmp495_;
		dbus_message_iter_append_basic (&_tmp496_, DBUS_TYPE_STRING, &_tmp498_);
		_tmp495_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp496_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp522_;
			_edomain = DBUS_GERROR;
			_tmp522_ = _dbus_error.name + 27;
			if (strcmp (_tmp522_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp522_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp522_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp522_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp522_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp522_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp522_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp522_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp522_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp522_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp522_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp522_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp522_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp522_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp522_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp522_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp522_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp522_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp522_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp522_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp522_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp522_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp522_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp522_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp522_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp522_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp522_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp522_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp522_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp522_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp522_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp522_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp522_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aa{sv}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aa{sv}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp499_ = g_new (GHashTable*, 5);
	_tmp499__length = 0;
	_tmp499__size = 4;
	_tmp499__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp500_);
	for (; dbus_message_iter_get_arg_type (&_tmp500_); _tmp499__length1++) {
		GHashTable* _tmp501_;
		DBusMessageIter _tmp502_;
		DBusMessageIter _tmp503_;
		if (_tmp499__size == _tmp499__length) {
			_tmp499__size = 2 * _tmp499__size;
			_tmp499_ = g_renew (GHashTable*, _tmp499_, _tmp499__size + 1);
		}
		_tmp501_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
		dbus_message_iter_recurse (&_tmp500_, &_tmp502_);
		while (dbus_message_iter_get_arg_type (&_tmp502_)) {
			char* _key;
			GValue* _value;
			const char* _tmp504_;
			GValue _tmp505_ = {0};
			DBusMessageIter _tmp506_;
			dbus_message_iter_recurse (&_tmp502_, &_tmp503_);
			dbus_message_iter_get_basic (&_tmp503_, &_tmp504_);
			dbus_message_iter_next (&_tmp503_);
			_key = g_strdup (_tmp504_);
			dbus_message_iter_recurse (&_tmp503_, &_tmp506_);
			if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_BYTE) {
				guint8 _tmp507_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp507_);
				g_value_init (&_tmp505_, G_TYPE_UCHAR);
				g_value_set_uchar (&_tmp505_, _tmp507_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_BOOLEAN) {
				dbus_bool_t _tmp508_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp508_);
				g_value_init (&_tmp505_, G_TYPE_BOOLEAN);
				g_value_set_boolean (&_tmp505_, _tmp508_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_INT16) {
				dbus_int16_t _tmp509_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp509_);
				g_value_init (&_tmp505_, G_TYPE_INT);
				g_value_set_int (&_tmp505_, _tmp509_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_UINT16) {
				dbus_uint16_t _tmp510_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp510_);
				g_value_init (&_tmp505_, G_TYPE_UINT);
				g_value_set_uint (&_tmp505_, _tmp510_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_INT32) {
				dbus_int32_t _tmp511_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp511_);
				g_value_init (&_tmp505_, G_TYPE_INT);
				g_value_set_int (&_tmp505_, _tmp511_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_UINT32) {
				dbus_uint32_t _tmp512_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp512_);
				g_value_init (&_tmp505_, G_TYPE_UINT);
				g_value_set_uint (&_tmp505_, _tmp512_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_INT64) {
				dbus_int64_t _tmp513_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp513_);
				g_value_init (&_tmp505_, G_TYPE_INT64);
				g_value_set_int64 (&_tmp505_, _tmp513_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_UINT64) {
				dbus_uint64_t _tmp514_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp514_);
				g_value_init (&_tmp505_, G_TYPE_UINT64);
				g_value_set_uint64 (&_tmp505_, _tmp514_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_DOUBLE) {
				double _tmp515_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp515_);
				g_value_init (&_tmp505_, G_TYPE_DOUBLE);
				g_value_set_double (&_tmp505_, _tmp515_);
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_STRING) {
				const char* _tmp516_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp516_);
				g_value_init (&_tmp505_, G_TYPE_STRING);
				g_value_take_string (&_tmp505_, g_strdup (_tmp516_));
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_OBJECT_PATH) {
				const char* _tmp517_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp517_);
				g_value_init (&_tmp505_, G_TYPE_STRING);
				g_value_take_string (&_tmp505_, g_strdup (_tmp517_));
			} else if (dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_SIGNATURE) {
				const char* _tmp518_;
				dbus_message_iter_get_basic (&_tmp506_, &_tmp518_);
				g_value_init (&_tmp505_, G_TYPE_STRING);
				g_value_take_string (&_tmp505_, g_strdup (_tmp518_));
			} else if ((dbus_message_iter_get_arg_type (&_tmp506_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp506_) == DBUS_TYPE_STRING)) {
				const char** _tmp519_;
				int _tmp519__length;
				int _tmp519__size;
				int _tmp519__length1;
				DBusMessageIter _tmp520_;
				_tmp519_ = g_new (const char*, 5);
				_tmp519__length = 0;
				_tmp519__size = 4;
				_tmp519__length1 = 0;
				dbus_message_iter_recurse (&_tmp506_, &_tmp520_);
				for (; dbus_message_iter_get_arg_type (&_tmp520_); _tmp519__length1++) {
					const char* _tmp521_;
					if (_tmp519__size == _tmp519__length) {
						_tmp519__size = 2 * _tmp519__size;
						_tmp519_ = g_renew (const char*, _tmp519_, _tmp519__size + 1);
					}
					dbus_message_iter_get_basic (&_tmp520_, &_tmp521_);
					dbus_message_iter_next (&_tmp520_);
					_tmp519_[_tmp519__length++] = g_strdup (_tmp521_);
				}
				_tmp519_[_tmp519__length] = NULL;
				g_value_init (&_tmp505_, G_TYPE_STRV);
				g_value_take_boxed (&_tmp505_, _tmp519_);
			}
			dbus_message_iter_next (&_tmp503_);
			_value = g_memdup (&_tmp505_, sizeof (GValue));
			g_hash_table_insert (_tmp501_, _key, _value);
			dbus_message_iter_next (&_tmp502_);
		}
		dbus_message_iter_next (&_tmp500_);
		_tmp499_[_tmp499__length++] = _tmp501_;
	}
	_result_length1 = _tmp499__length1;
	_tmp499_[_tmp499__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp499_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static GHashTable** media_container2_dbus_proxy_ListContainers (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp523_;
	dbus_uint32_t _tmp524_;
	char** _tmp525_;
	DBusMessageIter _tmp526_;
	int _tmp527_;
	GHashTable** _result;
	int _result_length1;
	GHashTable** _tmp529_;
	int _tmp529__length;
	int _tmp529__size;
	int _tmp529__length1;
	DBusMessageIter _tmp530_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.UPnP.MediaContainer2", "ListContainers");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp523_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp523_);
	_tmp524_ = max;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp524_);
	_tmp525_ = filter;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp526_);
	for (_tmp527_ = 0; _tmp527_ < filter_length1; _tmp527_++) {
		const char* _tmp528_;
		_tmp528_ = *_tmp525_;
		dbus_message_iter_append_basic (&_tmp526_, DBUS_TYPE_STRING, &_tmp528_);
		_tmp525_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp526_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp552_;
			_edomain = DBUS_GERROR;
			_tmp552_ = _dbus_error.name + 27;
			if (strcmp (_tmp552_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp552_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp552_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp552_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp552_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp552_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp552_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp552_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp552_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp552_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp552_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp552_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp552_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp552_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp552_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp552_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp552_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp552_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp552_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp552_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp552_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp552_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp552_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp552_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp552_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp552_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp552_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp552_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp552_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp552_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp552_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp552_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp552_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aa{sv}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aa{sv}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp529_ = g_new (GHashTable*, 5);
	_tmp529__length = 0;
	_tmp529__size = 4;
	_tmp529__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp530_);
	for (; dbus_message_iter_get_arg_type (&_tmp530_); _tmp529__length1++) {
		GHashTable* _tmp531_;
		DBusMessageIter _tmp532_;
		DBusMessageIter _tmp533_;
		if (_tmp529__size == _tmp529__length) {
			_tmp529__size = 2 * _tmp529__size;
			_tmp529_ = g_renew (GHashTable*, _tmp529_, _tmp529__size + 1);
		}
		_tmp531_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
		dbus_message_iter_recurse (&_tmp530_, &_tmp532_);
		while (dbus_message_iter_get_arg_type (&_tmp532_)) {
			char* _key;
			GValue* _value;
			const char* _tmp534_;
			GValue _tmp535_ = {0};
			DBusMessageIter _tmp536_;
			dbus_message_iter_recurse (&_tmp532_, &_tmp533_);
			dbus_message_iter_get_basic (&_tmp533_, &_tmp534_);
			dbus_message_iter_next (&_tmp533_);
			_key = g_strdup (_tmp534_);
			dbus_message_iter_recurse (&_tmp533_, &_tmp536_);
			if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_BYTE) {
				guint8 _tmp537_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp537_);
				g_value_init (&_tmp535_, G_TYPE_UCHAR);
				g_value_set_uchar (&_tmp535_, _tmp537_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_BOOLEAN) {
				dbus_bool_t _tmp538_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp538_);
				g_value_init (&_tmp535_, G_TYPE_BOOLEAN);
				g_value_set_boolean (&_tmp535_, _tmp538_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_INT16) {
				dbus_int16_t _tmp539_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp539_);
				g_value_init (&_tmp535_, G_TYPE_INT);
				g_value_set_int (&_tmp535_, _tmp539_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_UINT16) {
				dbus_uint16_t _tmp540_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp540_);
				g_value_init (&_tmp535_, G_TYPE_UINT);
				g_value_set_uint (&_tmp535_, _tmp540_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_INT32) {
				dbus_int32_t _tmp541_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp541_);
				g_value_init (&_tmp535_, G_TYPE_INT);
				g_value_set_int (&_tmp535_, _tmp541_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_UINT32) {
				dbus_uint32_t _tmp542_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp542_);
				g_value_init (&_tmp535_, G_TYPE_UINT);
				g_value_set_uint (&_tmp535_, _tmp542_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_INT64) {
				dbus_int64_t _tmp543_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp543_);
				g_value_init (&_tmp535_, G_TYPE_INT64);
				g_value_set_int64 (&_tmp535_, _tmp543_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_UINT64) {
				dbus_uint64_t _tmp544_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp544_);
				g_value_init (&_tmp535_, G_TYPE_UINT64);
				g_value_set_uint64 (&_tmp535_, _tmp544_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_DOUBLE) {
				double _tmp545_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp545_);
				g_value_init (&_tmp535_, G_TYPE_DOUBLE);
				g_value_set_double (&_tmp535_, _tmp545_);
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_STRING) {
				const char* _tmp546_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp546_);
				g_value_init (&_tmp535_, G_TYPE_STRING);
				g_value_take_string (&_tmp535_, g_strdup (_tmp546_));
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_OBJECT_PATH) {
				const char* _tmp547_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp547_);
				g_value_init (&_tmp535_, G_TYPE_STRING);
				g_value_take_string (&_tmp535_, g_strdup (_tmp547_));
			} else if (dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_SIGNATURE) {
				const char* _tmp548_;
				dbus_message_iter_get_basic (&_tmp536_, &_tmp548_);
				g_value_init (&_tmp535_, G_TYPE_STRING);
				g_value_take_string (&_tmp535_, g_strdup (_tmp548_));
			} else if ((dbus_message_iter_get_arg_type (&_tmp536_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp536_) == DBUS_TYPE_STRING)) {
				const char** _tmp549_;
				int _tmp549__length;
				int _tmp549__size;
				int _tmp549__length1;
				DBusMessageIter _tmp550_;
				_tmp549_ = g_new (const char*, 5);
				_tmp549__length = 0;
				_tmp549__size = 4;
				_tmp549__length1 = 0;
				dbus_message_iter_recurse (&_tmp536_, &_tmp550_);
				for (; dbus_message_iter_get_arg_type (&_tmp550_); _tmp549__length1++) {
					const char* _tmp551_;
					if (_tmp549__size == _tmp549__length) {
						_tmp549__size = 2 * _tmp549__size;
						_tmp549_ = g_renew (const char*, _tmp549_, _tmp549__size + 1);
					}
					dbus_message_iter_get_basic (&_tmp550_, &_tmp551_);
					dbus_message_iter_next (&_tmp550_);
					_tmp549_[_tmp549__length++] = g_strdup (_tmp551_);
				}
				_tmp549_[_tmp549__length] = NULL;
				g_value_init (&_tmp535_, G_TYPE_STRV);
				g_value_take_boxed (&_tmp535_, _tmp549_);
			}
			dbus_message_iter_next (&_tmp533_);
			_value = g_memdup (&_tmp535_, sizeof (GValue));
			g_hash_table_insert (_tmp531_, _key, _value);
			dbus_message_iter_next (&_tmp532_);
		}
		dbus_message_iter_next (&_tmp530_);
		_tmp529_[_tmp529__length++] = _tmp531_;
	}
	_result_length1 = _tmp529__length1;
	_tmp529_[_tmp529__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp529_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static GHashTable** media_container2_dbus_proxy_ListItems (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp553_;
	dbus_uint32_t _tmp554_;
	char** _tmp555_;
	DBusMessageIter _tmp556_;
	int _tmp557_;
	GHashTable** _result;
	int _result_length1;
	GHashTable** _tmp559_;
	int _tmp559__length;
	int _tmp559__size;
	int _tmp559__length1;
	DBusMessageIter _tmp560_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.UPnP.MediaContainer2", "ListItems");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp553_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp553_);
	_tmp554_ = max;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp554_);
	_tmp555_ = filter;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp556_);
	for (_tmp557_ = 0; _tmp557_ < filter_length1; _tmp557_++) {
		const char* _tmp558_;
		_tmp558_ = *_tmp555_;
		dbus_message_iter_append_basic (&_tmp556_, DBUS_TYPE_STRING, &_tmp558_);
		_tmp555_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp556_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp582_;
			_edomain = DBUS_GERROR;
			_tmp582_ = _dbus_error.name + 27;
			if (strcmp (_tmp582_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp582_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp582_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp582_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp582_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp582_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp582_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp582_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp582_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp582_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp582_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp582_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp582_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp582_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp582_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp582_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp582_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp582_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp582_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp582_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp582_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp582_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp582_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp582_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp582_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp582_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp582_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp582_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp582_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp582_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp582_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp582_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp582_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aa{sv}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aa{sv}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp559_ = g_new (GHashTable*, 5);
	_tmp559__length = 0;
	_tmp559__size = 4;
	_tmp559__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp560_);
	for (; dbus_message_iter_get_arg_type (&_tmp560_); _tmp559__length1++) {
		GHashTable* _tmp561_;
		DBusMessageIter _tmp562_;
		DBusMessageIter _tmp563_;
		if (_tmp559__size == _tmp559__length) {
			_tmp559__size = 2 * _tmp559__size;
			_tmp559_ = g_renew (GHashTable*, _tmp559_, _tmp559__size + 1);
		}
		_tmp561_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
		dbus_message_iter_recurse (&_tmp560_, &_tmp562_);
		while (dbus_message_iter_get_arg_type (&_tmp562_)) {
			char* _key;
			GValue* _value;
			const char* _tmp564_;
			GValue _tmp565_ = {0};
			DBusMessageIter _tmp566_;
			dbus_message_iter_recurse (&_tmp562_, &_tmp563_);
			dbus_message_iter_get_basic (&_tmp563_, &_tmp564_);
			dbus_message_iter_next (&_tmp563_);
			_key = g_strdup (_tmp564_);
			dbus_message_iter_recurse (&_tmp563_, &_tmp566_);
			if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_BYTE) {
				guint8 _tmp567_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp567_);
				g_value_init (&_tmp565_, G_TYPE_UCHAR);
				g_value_set_uchar (&_tmp565_, _tmp567_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_BOOLEAN) {
				dbus_bool_t _tmp568_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp568_);
				g_value_init (&_tmp565_, G_TYPE_BOOLEAN);
				g_value_set_boolean (&_tmp565_, _tmp568_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_INT16) {
				dbus_int16_t _tmp569_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp569_);
				g_value_init (&_tmp565_, G_TYPE_INT);
				g_value_set_int (&_tmp565_, _tmp569_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_UINT16) {
				dbus_uint16_t _tmp570_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp570_);
				g_value_init (&_tmp565_, G_TYPE_UINT);
				g_value_set_uint (&_tmp565_, _tmp570_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_INT32) {
				dbus_int32_t _tmp571_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp571_);
				g_value_init (&_tmp565_, G_TYPE_INT);
				g_value_set_int (&_tmp565_, _tmp571_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_UINT32) {
				dbus_uint32_t _tmp572_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp572_);
				g_value_init (&_tmp565_, G_TYPE_UINT);
				g_value_set_uint (&_tmp565_, _tmp572_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_INT64) {
				dbus_int64_t _tmp573_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp573_);
				g_value_init (&_tmp565_, G_TYPE_INT64);
				g_value_set_int64 (&_tmp565_, _tmp573_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_UINT64) {
				dbus_uint64_t _tmp574_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp574_);
				g_value_init (&_tmp565_, G_TYPE_UINT64);
				g_value_set_uint64 (&_tmp565_, _tmp574_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_DOUBLE) {
				double _tmp575_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp575_);
				g_value_init (&_tmp565_, G_TYPE_DOUBLE);
				g_value_set_double (&_tmp565_, _tmp575_);
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_STRING) {
				const char* _tmp576_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp576_);
				g_value_init (&_tmp565_, G_TYPE_STRING);
				g_value_take_string (&_tmp565_, g_strdup (_tmp576_));
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_OBJECT_PATH) {
				const char* _tmp577_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp577_);
				g_value_init (&_tmp565_, G_TYPE_STRING);
				g_value_take_string (&_tmp565_, g_strdup (_tmp577_));
			} else if (dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_SIGNATURE) {
				const char* _tmp578_;
				dbus_message_iter_get_basic (&_tmp566_, &_tmp578_);
				g_value_init (&_tmp565_, G_TYPE_STRING);
				g_value_take_string (&_tmp565_, g_strdup (_tmp578_));
			} else if ((dbus_message_iter_get_arg_type (&_tmp566_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp566_) == DBUS_TYPE_STRING)) {
				const char** _tmp579_;
				int _tmp579__length;
				int _tmp579__size;
				int _tmp579__length1;
				DBusMessageIter _tmp580_;
				_tmp579_ = g_new (const char*, 5);
				_tmp579__length = 0;
				_tmp579__size = 4;
				_tmp579__length1 = 0;
				dbus_message_iter_recurse (&_tmp566_, &_tmp580_);
				for (; dbus_message_iter_get_arg_type (&_tmp580_); _tmp579__length1++) {
					const char* _tmp581_;
					if (_tmp579__size == _tmp579__length) {
						_tmp579__size = 2 * _tmp579__size;
						_tmp579_ = g_renew (const char*, _tmp579_, _tmp579__size + 1);
					}
					dbus_message_iter_get_basic (&_tmp580_, &_tmp581_);
					dbus_message_iter_next (&_tmp580_);
					_tmp579_[_tmp579__length++] = g_strdup (_tmp581_);
				}
				_tmp579_[_tmp579__length] = NULL;
				g_value_init (&_tmp565_, G_TYPE_STRV);
				g_value_take_boxed (&_tmp565_, _tmp579_);
			}
			dbus_message_iter_next (&_tmp563_);
			_value = g_memdup (&_tmp565_, sizeof (GValue));
			g_hash_table_insert (_tmp561_, _key, _value);
			dbus_message_iter_next (&_tmp562_);
		}
		dbus_message_iter_next (&_tmp560_);
		_tmp559_[_tmp559__length++] = _tmp561_;
	}
	_result_length1 = _tmp559__length1;
	_tmp559_[_tmp559__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp559_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container2_dbus_proxy_get_ChildCount (MediaContainer2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp583_;
	const char* _tmp584_;
	guint _result;
	dbus_uint32_t _tmp585_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp583_ = "org.gnome.UPnP.MediaContainer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp583_);
	_tmp584_ = "ChildCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp584_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp585_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp585_;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container2_dbus_proxy_get_ItemCount (MediaContainer2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp586_;
	const char* _tmp587_;
	guint _result;
	dbus_uint32_t _tmp588_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp586_ = "org.gnome.UPnP.MediaContainer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp586_);
	_tmp587_ = "ItemCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp587_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp588_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp588_;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container2_dbus_proxy_get_ContainerCount (MediaContainer2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp589_;
	const char* _tmp590_;
	guint _result;
	dbus_uint32_t _tmp591_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp589_ = "org.gnome.UPnP.MediaContainer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp589_);
	_tmp590_ = "ContainerCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp590_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp591_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp591_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean media_container2_dbus_proxy_get_Searchable (MediaContainer2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp592_;
	const char* _tmp593_;
	gboolean _result;
	dbus_bool_t _tmp594_;
	if (((MediaContainer2DBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp592_ = "org.gnome.UPnP.MediaContainer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp592_);
	_tmp593_ = "Searchable";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp593_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp594_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp594_;
	dbus_message_unref (_reply);
	return _result;
}


static void media_container2_dbus_proxy_media_container2__interface_init (MediaContainer2Iface* iface) {
	iface->ListChildren = media_container2_dbus_proxy_ListChildren;
	iface->ListContainers = media_container2_dbus_proxy_ListContainers;
	iface->ListItems = media_container2_dbus_proxy_ListItems;
	iface->get_ChildCount = media_container2_dbus_proxy_get_ChildCount;
	iface->get_ItemCount = media_container2_dbus_proxy_get_ItemCount;
	iface->get_ContainerCount = media_container2_dbus_proxy_get_ContainerCount;
	iface->get_Searchable = media_container2_dbus_proxy_get_Searchable;
}


static void media_container2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_container2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** media_item2_get_URLs (MediaItem2* self, int* result_length1) {
	return MEDIA_ITEM2_GET_INTERFACE (self)->get_URLs (self, result_length1);
}


char* media_item2_get_MIMEType (MediaItem2* self) {
	return MEDIA_ITEM2_GET_INTERFACE (self)->get_MIMEType (self);
}


void _media_item2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_item2_introspect (MediaItem2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem2\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item2_property_get (MediaItem2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem2") == 0) && (strcmp (property_name, "URLs") == 0)) {
		char** result;
		int result_length1;
		char** _tmp2_;
		DBusMessageIter _tmp3_;
		int _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = media_item2_get_URLs (self, &result_length1);
		_tmp2_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp3_);
		for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
			const char* _tmp5_;
			_tmp5_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_STRING, &_tmp5_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp3_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem2") == 0) && (strcmp (property_name, "MIMEType") == 0)) {
		char* result;
		const char* _tmp6_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_item2_get_MIMEType (self);
		_tmp6_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp6_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item2_property_get_all (MediaItem2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp7_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp7_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaItem2") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp8_;
			DBusMessageIter _tmp9_;
			int _tmp10_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "URLs";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = media_item2_get_URLs (self, &result_length1);
			_tmp8_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp9_);
			for (_tmp10_ = 0; _tmp10_ < result_length1; _tmp10_++) {
				const char* _tmp11_;
				_tmp11_ = *_tmp8_;
				dbus_message_iter_append_basic (&_tmp9_, DBUS_TYPE_STRING, &_tmp11_);
				_tmp8_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp9_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp12_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "MIMEType";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_item2_get_MIMEType (self);
			_tmp12_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp12_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_item2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_item2_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_item2_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_item2_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_item2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_item2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_item2_base_init (MediaItem2Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boxed ("URLs", "URLs", "URLs", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("MIMEType", "MIMEType", "MIMEType", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_ITEM2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_item2_dbus_vtable));
	}
}


GType media_item2_get_type (void) {
	static volatile gsize media_item2_type_id__volatile = 0;
	if (g_once_init_enter (&media_item2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaItem2Iface), (GBaseInitFunc) media_item2_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_item2_type_id;
		media_item2_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaItem2", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_item2_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_item2_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_item2_dbus_proxy_get_type);
		g_once_init_leave (&media_item2_type_id__volatile, media_item2_type_id);
	}
	return media_item2_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaItem2DBusProxy, media_item2_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_ITEM2, media_item2_dbus_proxy_media_item2__interface_init) );
MediaItem2* media_item2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaItem2* self;
	self = g_object_new (media_item2_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaItem2", NULL);
	return self;
}


static GObject* media_item2_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_item2_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_item2_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_item2_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_item2_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaItem2DBusProxy*) self)->disposed) {
		return;
	}
	((MediaItem2DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_item2_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_item2_dbus_proxy_parent_class)->dispose (self);
}


static void media_item2_dbus_proxy_class_init (MediaItem2DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_item2_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_item2_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_item2_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_item2_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM2_DBUS_PROXY_UR_LS, "URLs");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM2_DBUS_PROXY_MIME_TYPE, "MIMEType");
}


static void media_item2_dbus_proxy_init (MediaItem2DBusProxy* self) {
}


static char** media_item2_dbus_proxy_get_URLs (MediaItem2* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp595_;
	const char* _tmp596_;
	char** _result;
	int _result_length1;
	char** _tmp597_;
	int _tmp597__length;
	int _tmp597__size;
	int _tmp597__length1;
	DBusMessageIter _tmp598_;
	if (((MediaItem2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp595_ = "org.gnome.UPnP.MediaItem2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp595_);
	_tmp596_ = "URLs";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp596_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp597_ = g_new (char*, 5);
	_tmp597__length = 0;
	_tmp597__size = 4;
	_tmp597__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp598_);
	for (; dbus_message_iter_get_arg_type (&_tmp598_); _tmp597__length1++) {
		const char* _tmp599_;
		if (_tmp597__size == _tmp597__length) {
			_tmp597__size = 2 * _tmp597__size;
			_tmp597_ = g_renew (char*, _tmp597_, _tmp597__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp598_, &_tmp599_);
		dbus_message_iter_next (&_tmp598_);
		_tmp597_[_tmp597__length++] = g_strdup (_tmp599_);
	}
	_result_length1 = _tmp597__length1;
	_tmp597_[_tmp597__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp597_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* media_item2_dbus_proxy_get_MIMEType (MediaItem2* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp600_;
	const char* _tmp601_;
	char* _result;
	const char* _tmp602_;
	if (((MediaItem2DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp600_ = "org.gnome.UPnP.MediaItem2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp600_);
	_tmp601_ = "MIMEType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp601_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp602_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp602_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_item2_dbus_proxy_media_item2__interface_init (MediaItem2Iface* iface) {
	iface->get_URLs = media_item2_dbus_proxy_get_URLs;
	iface->get_MIMEType = media_item2_dbus_proxy_get_MIMEType;
}


static void media_item2_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_item2_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




