/* Services2.c generated by valac 0.10.0, the Vala compiler
 * generated from Services2.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gee.h>
#include <dbus/dbus.h>


#define TYPE_MEDIA_CONTAINER2 (media_container2_get_type ())
#define MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2))
#define IS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER2))
#define MEDIA_CONTAINER2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2Iface))

typedef struct _MediaContainer2 MediaContainer2;
typedef struct _MediaContainer2Iface MediaContainer2Iface;

#define TYPE_MEDIA_OBJECT2 (media_object2_get_type ())
#define MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT2, MediaObject2))
#define IS_MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT2))
#define MEDIA_OBJECT2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT2, MediaObject2Iface))

typedef struct _MediaObject2 MediaObject2;
typedef struct _MediaObject2Iface MediaObject2Iface;

#define DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2 (dvb_media_server2_device_groups_media_container2_get_type ())
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2))
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Class))
#define DVB_MEDIA_SERVER2_IS_DEVICE_GROUPS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_IS_DEVICE_GROUPS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Class))

typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2 DVBMediaServer2DeviceGroupsMediaContainer2;
typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2Class DVBMediaServer2DeviceGroupsMediaContainer2Class;
typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2Private DVBMediaServer2DeviceGroupsMediaContainer2Private;

#define DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2 (dvb_media_server2_channels_media_container2_get_type ())
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2))
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Class))
#define DVB_MEDIA_SERVER2_IS_CHANNELS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_IS_CHANNELS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Class))

typedef struct _DVBMediaServer2ChannelsMediaContainer2 DVBMediaServer2ChannelsMediaContainer2;
typedef struct _DVBMediaServer2ChannelsMediaContainer2Class DVBMediaServer2ChannelsMediaContainer2Class;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;
typedef struct _DVBMediaServer2ChannelsMediaContainer2Private DVBMediaServer2ChannelsMediaContainer2Private;

#define DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2 (dvb_media_server2_channel_media_item2_get_type ())
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2))
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Class))
#define DVB_MEDIA_SERVER2_IS_CHANNEL_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2))
#define DVB_MEDIA_SERVER2_IS_CHANNEL_MEDIA_ITEM2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2))
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Class))

typedef struct _DVBMediaServer2ChannelMediaItem2 DVBMediaServer2ChannelMediaItem2;
typedef struct _DVBMediaServer2ChannelMediaItem2Class DVBMediaServer2ChannelMediaItem2Class;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define TYPE_MEDIA_ITEM2 (media_item2_get_type ())
#define MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM2, MediaItem2))
#define IS_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM2))
#define MEDIA_ITEM2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM2, MediaItem2Iface))

typedef struct _MediaItem2 MediaItem2;
typedef struct _MediaItem2Iface MediaItem2Iface;
typedef struct _DVBMediaServer2ChannelMediaItem2Private DVBMediaServer2ChannelMediaItem2Private;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MediaContainer2Iface {
	GTypeInterface parent_iface;
	GHashTable** (*ListChildren) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListContainers) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListItems) (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
	guint (*get_ChildCount) (MediaContainer2* self);
	guint (*get_ItemCount) (MediaContainer2* self);
	guint (*get_ContainerCount) (MediaContainer2* self);
	gboolean (*get_Searchable) (MediaContainer2* self);
};

struct _MediaObject2Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject2* self);
	char* (*get_DisplayName) (MediaObject2* self);
	char* (*get_Type) (MediaObject2* self);
	char* (*get_Path) (MediaObject2* self);
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2 {
	GObject parent_instance;
	DVBMediaServer2DeviceGroupsMediaContainer2Private * priv;
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2Private {
	GeeHashMap* containers;
	char* path;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _DVBChannelGroupInfo {
	gint id;
	char* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, char** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
};

struct _DVBMediaServer2ChannelsMediaContainer2 {
	GObject parent_instance;
	DVBMediaServer2ChannelsMediaContainer2Private * priv;
	char* parent;
};

struct _DVBMediaServer2ChannelsMediaContainer2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2ChannelsMediaContainer2Private {
	DVBDeviceGroup* device_group;
	GeeHashMap* items;
};

struct _MediaItem2Iface {
	GTypeInterface parent_iface;
	char** (*get_URLs) (MediaItem2* self, int* result_length1);
	char* (*get_MIMEType) (MediaItem2* self);
};

struct _DVBMediaServer2ChannelMediaItem2 {
	GObject parent_instance;
	DVBMediaServer2ChannelMediaItem2Private * priv;
};

struct _DVBMediaServer2ChannelMediaItem2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2ChannelMediaItem2Private {
	DVBChannel* channel;
	char* parent;
};


static gpointer dvb_media_server2_device_groups_media_container2_parent_class = NULL;
static MediaContainer2Iface* dvb_media_server2_device_groups_media_container2_media_container2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_device_groups_media_container2_media_object2_parent_iface = NULL;
static gpointer dvb_media_server2_channels_media_container2_parent_class = NULL;
static MediaContainer2Iface* dvb_media_server2_channels_media_container2_media_container2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_channels_media_container2_media_object2_parent_iface = NULL;
static gpointer dvb_media_server2_channel_media_item2_parent_class = NULL;
static MediaItem2Iface* dvb_media_server2_channel_media_item2_media_item2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_channel_media_item2_media_object2_parent_iface = NULL;
extern DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_root_container;
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_root_container = NULL;

#define DVB_MEDIA_SERVER2_SERVICE_NAME "org.gnome.UPnP.MediaServer2.DVBDaemon"
#define DVB_MEDIA_SERVER2_ROOT_PATH "/org/gnome/UPnP/MediaServer2/DVBDaemon"
#define DVB_MEDIA_SERVER2_GROUP_PATH "/org/gnome/UPnP/MediaServer2/DVBDaemon/Group%u"
#define DVB_MEDIA_SERVER2_CHANNEL_PATH DVB_MEDIA_SERVER2_GROUP_PATH "/Channel%u"
MediaContainer2* media_container2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType media_container2_get_type (void) G_GNUC_CONST;
GType media_object2_get_type (void) G_GNUC_CONST;
MediaObject2* media_object2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_media_server2_device_groups_media_container2_get_type (void) G_GNUC_CONST;
GType dvb_media_server2_channels_media_container2_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Private))
enum  {
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PARENT,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PATH,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_DISPLAY_NAME,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_TYPE,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_ITEM_COUNT,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CHILD_COUNT,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CONTAINER_COUNT,
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_SEARCHABLE
};
void dvb_media_server2_device_groups_media_container2_create_container_services (DVBMediaServer2DeviceGroupsMediaContainer2* self);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static void dvb_media_server2_device_groups_media_container2_create_service (DVBMediaServer2DeviceGroupsMediaContainer2* self, DVBDeviceGroup* devgroup);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DBusGConnection* dvb_utils_get_dbus_connection (void);
DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_new (DVBDeviceGroup* devgroup, const char* parent);
DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent);
char* media_object2_get_Path (MediaObject2* self);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_media_server2_channels_media_container2_create_item_services (DVBMediaServer2ChannelsMediaContainer2* self);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
guint dvb_media_server2_get_num_elements (gint items, guint offset, guint max);
static void _vala_GValue_free (GValue* self);
char* media_object2_get_DisplayName (MediaObject2* self);
guint media_container2_get_ChildCount (MediaContainer2* self);
gboolean media_container2_get_Searchable (MediaContainer2* self);
char* media_object2_get_Type (MediaObject2* self);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListContainers (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static void dvb_media_server2_device_groups_media_container2_on_device_added (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
static void dvb_media_server2_device_groups_media_container2_on_device_removed (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id);
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_new (void);
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_construct (GType object_type);
guint media_container2_get_ContainerCount (MediaContainer2* self);
DVBIDBusManager* dvb_id_bus_manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
static void _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self);
static GObject * dvb_media_server2_device_groups_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_media_server2_device_groups_media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server2_device_groups_media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server2_device_groups_media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server2_device_groups_media_container2_introspect (DVBMediaServer2DeviceGroupsMediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static void dvb_media_server2_device_groups_media_container2_finalize (GObject* obj);
char* media_object2_get_Parent (MediaObject2* self);
guint media_container2_get_ItemCount (MediaContainer2* self);
static void dvb_media_server2_device_groups_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType dvb_media_server2_channel_media_item2_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Private))
enum  {
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PARENT,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PATH,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_DISPLAY_NAME,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_TYPE,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CHILD_COUNT,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_ITEM_COUNT,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CONTAINER_COUNT,
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_SEARCHABLE
};
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_media_server2_channels_media_container2_create_service (DVBMediaServer2ChannelsMediaContainer2* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_new (DVBChannel* channel, const char* parent);
DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_construct (GType object_type, DVBChannel* channel, const char* parent);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
GType media_item2_get_type (void) G_GNUC_CONST;
MediaItem2* media_item2_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char* media_item2_get_MIMEType (MediaItem2* self);
char** media_item2_get_URLs (MediaItem2* self, int* result_length1);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListItems (MediaContainer2* self, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error);
const char* dvb_device_group_get_Name (DVBDeviceGroup* self);
static GObject * dvb_media_server2_channels_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_media_server2_channels_media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server2_channels_media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server2_channels_media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server2_channels_media_container2_introspect (DVBMediaServer2ChannelsMediaContainer2* self, DBusConnection* connection, DBusMessage* message);
static void dvb_media_server2_channels_media_container2_finalize (GObject* obj);
static void dvb_media_server2_channels_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Private))
enum  {
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PARENT,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PATH,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_DISPLAY_NAME,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_UR_LS,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_MIME_TYPE,
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_TYPE
};
guint dvb_channel_get_GroupId (DVBChannel* self);
const char* dvb_channel_get_Name (DVBChannel* self);
char* dvb_channel_get_URL (DVBChannel* self);
void dvb_media_server2_channel_media_item2_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server2_channel_media_item2_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server2_channel_media_item2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server2_channel_media_item2_introspect (DVBMediaServer2ChannelMediaItem2* self, DBusConnection* connection, DBusMessage* message);
static void dvb_media_server2_channel_media_item2_finalize (GObject* obj);
static void dvb_media_server2_channel_media_item2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
gboolean dvb_media_server2_start_rygel_services (void);
static guint _dynamic_RequestName2 (DBusGProxy* self, const char* param1, guint param2, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _dvb_media_server2_device_groups_media_container2_dbus_path_vtable = {_dvb_media_server2_device_groups_media_container2_dbus_unregister, dvb_media_server2_device_groups_media_container2_dbus_message};
static const _DBusObjectVTable _dvb_media_server2_device_groups_media_container2_dbus_vtable = {dvb_media_server2_device_groups_media_container2_dbus_register_object};
static const DBusObjectPathVTable _dvb_media_server2_channels_media_container2_dbus_path_vtable = {_dvb_media_server2_channels_media_container2_dbus_unregister, dvb_media_server2_channels_media_container2_dbus_message};
static const _DBusObjectVTable _dvb_media_server2_channels_media_container2_dbus_vtable = {dvb_media_server2_channels_media_container2_dbus_register_object};
static const DBusObjectPathVTable _dvb_media_server2_channel_media_item2_dbus_path_vtable = {_dvb_media_server2_channel_media_item2_dbus_unregister, dvb_media_server2_channel_media_item2_dbus_message};
static const _DBusObjectVTable _dvb_media_server2_channel_media_item2_dbus_vtable = {dvb_media_server2_channel_media_item2_dbus_register_object};


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_media_server2_device_groups_media_container2_create_container_services (DVBMediaServer2DeviceGroupsMediaContainer2* self) {
	DVBManager* manager;
	g_return_if_fail (self != NULL);
	manager = _g_object_ref0 (dvb_manager_get_instance ());
	{
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _devgroup_it;
		_devgroup_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = dvb_manager_get_device_groups (manager))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			DVBDeviceGroup* devgroup;
			if (!gee_iterator_next (_devgroup_it)) {
				break;
			}
			devgroup = (DVBDeviceGroup*) gee_iterator_get (_devgroup_it);
			dvb_media_server2_device_groups_media_container2_create_service (self, devgroup);
			_g_object_unref0 (devgroup);
		}
		_g_object_unref0 (_devgroup_it);
	}
	_g_object_unref0 (manager);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


static void dvb_media_server2_device_groups_media_container2_create_service (DVBMediaServer2DeviceGroupsMediaContainer2* self, DVBDeviceGroup* devgroup) {
	DBusGConnection* conn;
	DVBMediaServer2ChannelsMediaContainer2* devgroup_container;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devgroup != NULL);
	g_debug ("Services2.vala:59: Creating container for device group %u", dvb_device_group_get_Id (devgroup));
	conn = dvb_utils_get_dbus_connection ();
	if (conn == NULL) {
		g_critical ("Services2.vala:63: Could not get DBus connection");
		_dbus_g_connection_unref0 (conn);
		return;
	}
	devgroup_container = dvb_media_server2_channels_media_container2_new (devgroup, self->priv->path);
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp0_ = media_object2_get_Path ((MediaObject2*) devgroup_container), (GObject*) devgroup_container);
	_g_free0 (_tmp0_);
	dvb_media_server2_channels_media_container2_create_item_services (devgroup_container);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (dvb_device_group_get_Id (devgroup)), devgroup_container);
	_g_object_unref0 (devgroup_container);
	_dbus_g_connection_unref0 (conn);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	guint num_elements;
	gint hash_length1;
	gint _hash_size_;
	GHashTable** _tmp0_;
	GHashTable** hash;
	gint i;
	GHashTable** _tmp10_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	num_elements = dvb_media_server2_get_num_elements (gee_map_get_size ((GeeMap*) self->priv->containers), offset, max);
	hash = (_tmp0_ = g_new0 (GHashTable*, num_elements + 1), hash_length1 = num_elements, _hash_size_ = hash_length1, _tmp0_);
	i = 0;
	{
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _container_it;
		_container_it = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) (_tmp1_ = gee_map_get_values ((GeeMap*) self->priv->containers))), _g_object_unref0 (_tmp1_), _tmp2_);
		while (TRUE) {
			DVBMediaServer2ChannelsMediaContainer2* container;
			if (!gee_iterator_next (_container_it)) {
				break;
			}
			container = (DVBMediaServer2ChannelsMediaContainer2*) gee_iterator_get (_container_it);
			if (i >= offset) {
				guint index;
				GHashTable* _tmp3_;
				GValue* _tmp4_ = NULL;
				GValue* _tmp5_ = NULL;
				GValue* _tmp6_ = NULL;
				GValue* _tmp7_ = NULL;
				GValue* _tmp8_ = NULL;
				GValue* _tmp9_ = NULL;
				index = i - offset;
				hash[index] = (_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _vala_GValue_free), _g_hash_table_unref0 (hash[index]), _tmp3_);
				g_hash_table_insert (hash[index], g_strdup ("Path"), (_tmp4_ = g_new0 (GValue, 1), g_value_init (_tmp4_, G_TYPE_STRING), g_value_take_string (_tmp4_, media_object2_get_Path ((MediaObject2*) container)), _tmp4_));
				g_hash_table_insert (hash[index], g_strdup ("DisplayName"), (_tmp5_ = g_new0 (GValue, 1), g_value_init (_tmp5_, G_TYPE_STRING), g_value_take_string (_tmp5_, media_object2_get_DisplayName ((MediaObject2*) container)), _tmp5_));
				g_hash_table_insert (hash[index], g_strdup ("ChildCount"), (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_UINT), g_value_set_uint (_tmp6_, media_container2_get_ChildCount ((MediaContainer2*) container)), _tmp6_));
				g_hash_table_insert (hash[index], g_strdup ("Searchable"), (_tmp7_ = g_new0 (GValue, 1), g_value_init (_tmp7_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp7_, media_container2_get_Searchable ((MediaContainer2*) container)), _tmp7_));
				g_hash_table_insert (hash[index], g_strdup ("Type"), (_tmp8_ = g_new0 (GValue, 1), g_value_init (_tmp8_, G_TYPE_STRING), g_value_take_string (_tmp8_, media_object2_get_Type ((MediaObject2*) container)), _tmp8_));
				g_hash_table_insert (hash[index], g_strdup ("Parent"), (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRING), g_value_take_string (_tmp9_, media_object2_get_Path ((MediaObject2*) self)), _tmp9_));
			}
			i++;
			if (i >= (offset + num_elements)) {
				_g_object_unref0 (container);
				break;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	result = (_tmp10_ = hash, *result_length1 = hash_length1, _tmp10_);
	return result;
	hash = (_vala_array_free (hash, hash_length1, (GDestroyNotify) g_hash_table_unref), NULL);
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp1__length1;
	gint __tmp1__size_;
	GHashTable** _tmp2_;
	gint _tmp0_;
	GHashTable** _tmp1_;
	GHashTable** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp1_ = (_tmp2_ = media_container2_ListContainers ((MediaContainer2*) self, offset, max, filter, filter_length1, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	GHashTable** _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = (_tmp0_ = g_new0 (GHashTable*, 0 + 1), *result_length1 = 0, _tmp0_);
	return result;
}


static void dvb_media_server2_device_groups_media_container2_on_device_added (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id) {
	DVBManager* manager;
	DVBDeviceGroup* devgroup;
	g_return_if_fail (self != NULL);
	manager = _g_object_ref0 (dvb_manager_get_instance ());
	devgroup = dvb_manager_get_device_group_if_exists (manager, group_id);
	dvb_media_server2_device_groups_media_container2_create_service (self, devgroup);
	g_signal_emit_by_name ((MediaContainer2*) self, "updated");
	_g_object_unref0 (devgroup);
	_g_object_unref0 (manager);
}


static void dvb_media_server2_device_groups_media_container2_on_device_removed (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (group_id), NULL);
	g_signal_emit_by_name ((MediaContainer2*) self, "updated");
}


DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_construct (GType object_type) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) g_object_new (object_type, NULL);
	return self;
}


DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_new (void) {
	return dvb_media_server2_device_groups_media_container2_construct (DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2);
}


static char* dvb_media_server2_device_groups_media_container2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = g_strdup (self->priv->path);
	return result;
}


static char* dvb_media_server2_device_groups_media_container2_real_get_Path (MediaObject2* base) {
	char* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = g_strdup (DVB_MEDIA_SERVER2_ROOT_PATH);
	return result;
}


static char* dvb_media_server2_device_groups_media_container2_real_get_DisplayName (MediaObject2* base) {
	char* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = g_strdup ("@REALNAME@'s TV on @HOSTNAME@");
	return result;
}


static char* dvb_media_server2_device_groups_media_container2_real_get_Type (MediaObject2* base) {
	char* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = g_strdup ("container");
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ItemCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = (guint) 0;
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ChildCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = media_container2_get_ContainerCount ((MediaContainer2*) self);
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ContainerCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = (guint) gee_map_get_size ((GeeMap*) self->priv->containers);
	return result;
}


static gboolean dvb_media_server2_device_groups_media_container2_real_get_Searchable (MediaContainer2* base) {
	gboolean result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = FALSE;
	return result;
}


static void _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server2_device_groups_media_container2_on_device_added (self, group_id);
}


static void _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server2_device_groups_media_container2_on_device_removed (self, group_id);
}


static GObject * dvb_media_server2_device_groups_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	parent_class = G_OBJECT_CLASS (dvb_media_server2_device_groups_media_container2_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (obj);
	{
		GeeHashMap* _tmp0_;
		DVBManager* manager;
		char* _tmp1_;
		self->priv->containers = (_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->containers), _tmp0_);
		manager = _g_object_ref0 (dvb_manager_get_instance ());
		g_signal_connect_object ((DVBIDBusManager*) manager, "group-added", (GCallback) _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added, self, 0);
		g_signal_connect_object ((DVBIDBusManager*) manager, "group-removed", (GCallback) _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed, self, 0);
		self->priv->path = (_tmp1_ = g_strdup (DVB_MEDIA_SERVER2_ROOT_PATH), _g_free0 (self->priv->path), _tmp1_);
		_g_object_unref0 (manager);
	}
	return obj;
}


void _dvb_media_server2_device_groups_media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server2_device_groups_media_container2_introspect (DVBMediaServer2DeviceGroupsMediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer2\">\n  <method name=\"ListChildren\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListContainers\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListItems\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <property name=\"ChildCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Searchable\" type=\"b\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject2\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n  <property name=\"Path\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server2_device_groups_media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server2_device_groups_media_container2_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_container2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server2_device_groups_media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server2_device_groups_media_container2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container2_dbus_register_object (connection, path, object);
	media_object2_dbus_register_object (connection, path, object);
}


static void dvb_media_server2_device_groups_media_container2_class_init (DVBMediaServer2DeviceGroupsMediaContainer2Class * klass) {
	dvb_media_server2_device_groups_media_container2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2DeviceGroupsMediaContainer2Private));
	G_OBJECT_CLASS (klass)->get_property = dvb_media_server2_device_groups_media_container2_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server2_device_groups_media_container2_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_device_groups_media_container2_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PATH, "Path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_TYPE, "Type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CHILD_COUNT, "ChildCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CONTAINER_COUNT, "ContainerCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_SEARCHABLE, "Searchable");
	g_type_set_qdata (DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server2_device_groups_media_container2_dbus_vtable));
}


static void dvb_media_server2_device_groups_media_container2_media_container2_interface_init (MediaContainer2Iface * iface) {
	dvb_media_server2_device_groups_media_container2_media_container2_parent_iface = g_type_interface_peek_parent (iface);
	iface->ListContainers = dvb_media_server2_device_groups_media_container2_real_ListContainers;
	iface->ListChildren = dvb_media_server2_device_groups_media_container2_real_ListChildren;
	iface->ListItems = dvb_media_server2_device_groups_media_container2_real_ListItems;
	iface->get_ItemCount = dvb_media_server2_device_groups_media_container2_real_get_ItemCount;
	iface->get_ChildCount = dvb_media_server2_device_groups_media_container2_real_get_ChildCount;
	iface->get_ContainerCount = dvb_media_server2_device_groups_media_container2_real_get_ContainerCount;
	iface->get_Searchable = dvb_media_server2_device_groups_media_container2_real_get_Searchable;
}


static void dvb_media_server2_device_groups_media_container2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_device_groups_media_container2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_device_groups_media_container2_real_get_Parent;
	iface->get_Path = dvb_media_server2_device_groups_media_container2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_device_groups_media_container2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_device_groups_media_container2_real_get_Type;
}


static void dvb_media_server2_device_groups_media_container2_instance_init (DVBMediaServer2DeviceGroupsMediaContainer2 * self) {
	self->priv = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_PRIVATE (self);
}


static void dvb_media_server2_device_groups_media_container2_finalize (GObject* obj) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (obj);
	_g_object_unref0 (self->priv->containers);
	_g_free0 (self->priv->path);
	G_OBJECT_CLASS (dvb_media_server2_device_groups_media_container2_parent_class)->finalize (obj);
}


/**
     * Holds all device groups
     *
     * It only contains containers only and no items
     */
GType dvb_media_server2_device_groups_media_container2_get_type (void) {
	static volatile gsize dvb_media_server2_device_groups_media_container2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_device_groups_media_container2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2DeviceGroupsMediaContainer2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_device_groups_media_container2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2DeviceGroupsMediaContainer2), 0, (GInstanceInitFunc) dvb_media_server2_device_groups_media_container2_instance_init, NULL };
		static const GInterfaceInfo media_container2_info = { (GInterfaceInitFunc) dvb_media_server2_device_groups_media_container2_media_container2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_device_groups_media_container2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_device_groups_media_container2_type_id;
		dvb_media_server2_device_groups_media_container2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2DeviceGroupsMediaContainer2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_device_groups_media_container2_type_id, TYPE_MEDIA_CONTAINER2, &media_container2_info);
		g_type_add_interface_static (dvb_media_server2_device_groups_media_container2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_device_groups_media_container2_type_id__volatile, dvb_media_server2_device_groups_media_container2_type_id);
	}
	return dvb_media_server2_device_groups_media_container2_type_id__volatile;
}


static void dvb_media_server2_device_groups_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PARENT:
		g_value_take_string (value, media_object2_get_Parent ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_PATH:
		g_value_take_string (value, media_object2_get_Path ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_DISPLAY_NAME:
		g_value_take_string (value, media_object2_get_DisplayName ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_TYPE:
		g_value_take_string (value, media_object2_get_Type ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_ITEM_COUNT:
		g_value_set_uint (value, media_container2_get_ItemCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CHILD_COUNT:
		g_value_set_uint (value, media_container2_get_ChildCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CONTAINER_COUNT:
		g_value_set_uint (value, media_container2_get_ContainerCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_SEARCHABLE:
		g_value_set_boolean (value, media_container2_get_Searchable ((MediaContainer2*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	DVBDeviceGroup* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServer2ChannelsMediaContainer2*) g_object_new (object_type, NULL);
	self->priv->device_group = (_tmp0_ = _g_object_ref0 (devgroup), _g_object_unref0 (self->priv->device_group), _tmp0_);
	self->parent = (_tmp1_ = g_strdup (parent), _g_free0 (self->parent), _tmp1_);
	return self;
}


DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_new (DVBDeviceGroup* devgroup, const char* parent) {
	return dvb_media_server2_channels_media_container2_construct (DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, devgroup, parent);
}


void dvb_media_server2_channels_media_container2_create_item_services (DVBMediaServer2ChannelsMediaContainer2* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _channel_it;
		_channel_it = gee_iterable_iterator ((GeeIterable*) dvb_device_group_get_Channels (self->priv->device_group));
		while (TRUE) {
			DVBChannel* channel;
			if (!gee_iterator_next (_channel_it)) {
				break;
			}
			channel = (DVBChannel*) gee_iterator_get (_channel_it);
			dvb_media_server2_channels_media_container2_create_service (self, channel);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
}


void dvb_media_server2_channels_media_container2_create_service (DVBMediaServer2ChannelsMediaContainer2* self, DVBChannel* channel) {
	DBusGConnection* conn;
	char* _tmp0_;
	char* _tmp1_;
	DVBMediaServer2ChannelMediaItem2* _tmp2_;
	DVBMediaServer2ChannelMediaItem2* channel_item;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_debug ("Services2.vala:204: Creating container for channel %u", dvb_channel_get_Sid (channel));
	conn = dvb_utils_get_dbus_connection ();
	if (conn == NULL) {
		g_critical ("Services2.vala:208: Could not get DBus connection");
		_dbus_g_connection_unref0 (conn);
		return;
	}
	channel_item = (_tmp2_ = dvb_media_server2_channel_media_item2_new (channel, _tmp1_ = g_strdup (_tmp0_ = media_object2_get_Path ((MediaObject2*) self))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp3_ = media_object2_get_Path ((MediaObject2*) channel_item), (GObject*) channel_item);
	_g_free0 (_tmp3_);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->items, GUINT_TO_POINTER (dvb_channel_get_Sid (channel)), channel_item);
	_g_object_unref0 (channel_item);
	_dbus_g_connection_unref0 (conn);
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	guint num_elements;
	gint hash_length1;
	gint _hash_size_;
	GHashTable** _tmp0_;
	GHashTable** hash;
	guint i;
	GHashTable** _tmp11_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	num_elements = dvb_media_server2_get_num_elements (gee_map_get_size ((GeeMap*) self->priv->items), offset, max);
	hash = (_tmp0_ = g_new0 (GHashTable*, num_elements + 1), hash_length1 = num_elements, _hash_size_ = hash_length1, _tmp0_);
	i = (guint) 0;
	{
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _item_it;
		_item_it = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) (_tmp1_ = gee_map_get_values ((GeeMap*) self->priv->items))), _g_object_unref0 (_tmp1_), _tmp2_);
		while (TRUE) {
			DVBMediaServer2ChannelMediaItem2* item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = (DVBMediaServer2ChannelMediaItem2*) gee_iterator_get (_item_it);
			if (i >= offset) {
				guint index;
				GHashTable* _tmp3_;
				GValue* _tmp4_ = NULL;
				GValue* _tmp5_ = NULL;
				GValue* _tmp6_ = NULL;
				GValue* _tmp7_ = NULL;
				gint _tmp8_;
				GValue* _tmp9_ = NULL;
				GValue* _tmp10_ = NULL;
				index = i - offset;
				hash[index] = (_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _vala_GValue_free), _g_hash_table_unref0 (hash[index]), _tmp3_);
				g_hash_table_insert (hash[index], g_strdup ("Path"), (_tmp4_ = g_new0 (GValue, 1), g_value_init (_tmp4_, G_TYPE_STRING), g_value_take_string (_tmp4_, media_object2_get_Path ((MediaObject2*) item)), _tmp4_));
				g_hash_table_insert (hash[index], g_strdup ("DisplayName"), (_tmp5_ = g_new0 (GValue, 1), g_value_init (_tmp5_, G_TYPE_STRING), g_value_take_string (_tmp5_, media_object2_get_DisplayName ((MediaObject2*) item)), _tmp5_));
				g_hash_table_insert (hash[index], g_strdup ("Type"), (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_STRING), g_value_take_string (_tmp6_, media_object2_get_Type ((MediaObject2*) item)), _tmp6_));
				g_hash_table_insert (hash[index], g_strdup ("MIMEType"), (_tmp7_ = g_new0 (GValue, 1), g_value_init (_tmp7_, G_TYPE_STRING), g_value_take_string (_tmp7_, media_item2_get_MIMEType ((MediaItem2*) item)), _tmp7_));
				g_hash_table_insert (hash[index], g_strdup ("URLs"), (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRV), g_value_take_boxed (_tmp9_, media_item2_get_URLs ((MediaItem2*) item, &_tmp8_)), _tmp9_));
				g_hash_table_insert (hash[index], g_strdup ("Parent"), (_tmp10_ = g_new0 (GValue, 1), g_value_init (_tmp10_, G_TYPE_STRING), g_value_take_string (_tmp10_, media_object2_get_Path ((MediaObject2*) self)), _tmp10_));
			}
			i++;
			if (i >= (offset + num_elements)) {
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = (_tmp11_ = hash, *result_length1 = hash_length1, _tmp11_);
	return result;
	hash = (_vala_array_free (hash, hash_length1, (GDestroyNotify) g_hash_table_unref), NULL);
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	GHashTable** _tmp0_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = (_tmp0_ = g_new0 (GHashTable*, 0 + 1), *result_length1 = 0, _tmp0_);
	return result;
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, char** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp1__length1;
	gint __tmp1__size_;
	GHashTable** _tmp2_;
	gint _tmp0_;
	GHashTable** _tmp1_;
	GHashTable** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp1_ = (_tmp2_ = media_container2_ListItems ((MediaContainer2*) self, offset, max, filter, filter_length1, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


static char* dvb_media_server2_channels_media_container2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = g_strdup (self->parent);
	return result;
}


static char* dvb_media_server2_channels_media_container2_real_get_Path (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = g_strdup_printf (DVB_MEDIA_SERVER2_GROUP_PATH, dvb_device_group_get_Id (self->priv->device_group));
	return result;
}


static char* dvb_media_server2_channels_media_container2_real_get_DisplayName (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = g_strdup (dvb_device_group_get_Name (self->priv->device_group));
	return result;
}


static char* dvb_media_server2_channels_media_container2_real_get_Type (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = g_strdup ("container");
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ChildCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = media_container2_get_ItemCount ((MediaContainer2*) self);
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ItemCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = (guint) gee_map_get_size ((GeeMap*) self->priv->items);
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ContainerCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = (guint) 0;
	return result;
}


static gboolean dvb_media_server2_channels_media_container2_real_get_Searchable (MediaContainer2* base) {
	gboolean result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = FALSE;
	return result;
}


static GObject * dvb_media_server2_channels_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServer2ChannelsMediaContainer2 * self;
	parent_class = G_OBJECT_CLASS (dvb_media_server2_channels_media_container2_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (obj);
	{
		GeeHashMap* _tmp0_;
		self->priv->items = (_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->items), _tmp0_);
	}
	return obj;
}


void _dvb_media_server2_channels_media_container2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server2_channels_media_container2_introspect (DVBMediaServer2ChannelsMediaContainer2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer2\">\n  <method name=\"ListChildren\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListContainers\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <method name=\"ListItems\">\n    <arg name=\"offset\" type=\"u\" direction=\"in\"/>\n    <arg name=\"max\" type=\"u\" direction=\"in\"/>\n    <arg name=\"filter\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aa{sv}\" direction=\"out\"/>\n  </method>\n  <property name=\"ChildCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Searchable\" type=\"b\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject2\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n  <property name=\"Path\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server2_channels_media_container2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server2_channels_media_container2_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_container2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server2_channels_media_container2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server2_channels_media_container2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container2_dbus_register_object (connection, path, object);
	media_object2_dbus_register_object (connection, path, object);
}


static void dvb_media_server2_channels_media_container2_class_init (DVBMediaServer2ChannelsMediaContainer2Class * klass) {
	dvb_media_server2_channels_media_container2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2ChannelsMediaContainer2Private));
	G_OBJECT_CLASS (klass)->get_property = dvb_media_server2_channels_media_container2_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server2_channels_media_container2_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_channels_media_container2_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PATH, "Path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_TYPE, "Type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CHILD_COUNT, "ChildCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CONTAINER_COUNT, "ContainerCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_SEARCHABLE, "Searchable");
	g_type_set_qdata (DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server2_channels_media_container2_dbus_vtable));
}


static void dvb_media_server2_channels_media_container2_media_container2_interface_init (MediaContainer2Iface * iface) {
	dvb_media_server2_channels_media_container2_media_container2_parent_iface = g_type_interface_peek_parent (iface);
	iface->ListItems = dvb_media_server2_channels_media_container2_real_ListItems;
	iface->ListContainers = dvb_media_server2_channels_media_container2_real_ListContainers;
	iface->ListChildren = dvb_media_server2_channels_media_container2_real_ListChildren;
	iface->get_ChildCount = dvb_media_server2_channels_media_container2_real_get_ChildCount;
	iface->get_ItemCount = dvb_media_server2_channels_media_container2_real_get_ItemCount;
	iface->get_ContainerCount = dvb_media_server2_channels_media_container2_real_get_ContainerCount;
	iface->get_Searchable = dvb_media_server2_channels_media_container2_real_get_Searchable;
}


static void dvb_media_server2_channels_media_container2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_channels_media_container2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_channels_media_container2_real_get_Parent;
	iface->get_Path = dvb_media_server2_channels_media_container2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_channels_media_container2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_channels_media_container2_real_get_Type;
}


static void dvb_media_server2_channels_media_container2_instance_init (DVBMediaServer2ChannelsMediaContainer2 * self) {
	self->priv = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_PRIVATE (self);
}


static void dvb_media_server2_channels_media_container2_finalize (GObject* obj) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (obj);
	_g_free0 (self->parent);
	_g_object_unref0 (self->priv->device_group);
	_g_object_unref0 (self->priv->items);
	G_OBJECT_CLASS (dvb_media_server2_channels_media_container2_parent_class)->finalize (obj);
}


/**
     * Holds a list of channels for a single device group
     *
     * It only contains items only and no containers
     */
GType dvb_media_server2_channels_media_container2_get_type (void) {
	static volatile gsize dvb_media_server2_channels_media_container2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_channels_media_container2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2ChannelsMediaContainer2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_channels_media_container2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2ChannelsMediaContainer2), 0, (GInstanceInitFunc) dvb_media_server2_channels_media_container2_instance_init, NULL };
		static const GInterfaceInfo media_container2_info = { (GInterfaceInitFunc) dvb_media_server2_channels_media_container2_media_container2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_channels_media_container2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_channels_media_container2_type_id;
		dvb_media_server2_channels_media_container2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2ChannelsMediaContainer2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_channels_media_container2_type_id, TYPE_MEDIA_CONTAINER2, &media_container2_info);
		g_type_add_interface_static (dvb_media_server2_channels_media_container2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_channels_media_container2_type_id__volatile, dvb_media_server2_channels_media_container2_type_id);
	}
	return dvb_media_server2_channels_media_container2_type_id__volatile;
}


static void dvb_media_server2_channels_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PARENT:
		g_value_take_string (value, media_object2_get_Parent ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_PATH:
		g_value_take_string (value, media_object2_get_Path ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_DISPLAY_NAME:
		g_value_take_string (value, media_object2_get_DisplayName ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_TYPE:
		g_value_take_string (value, media_object2_get_Type ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CHILD_COUNT:
		g_value_set_uint (value, media_container2_get_ChildCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_ITEM_COUNT:
		g_value_set_uint (value, media_container2_get_ItemCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CONTAINER_COUNT:
		g_value_set_uint (value, media_container2_get_ContainerCount ((MediaContainer2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_SEARCHABLE:
		g_value_set_boolean (value, media_container2_get_Searchable ((MediaContainer2*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_construct (GType object_type, DVBChannel* channel, const char* parent) {
	DVBMediaServer2ChannelMediaItem2 * self;
	DVBChannel* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServer2ChannelMediaItem2*) g_object_new (object_type, NULL);
	self->priv->channel = (_tmp0_ = _g_object_ref0 (channel), _g_object_unref0 (self->priv->channel), _tmp0_);
	self->priv->parent = (_tmp1_ = g_strdup (parent), _g_free0 (self->priv->parent), _tmp1_);
	return self;
}


DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_new (DVBChannel* channel, const char* parent) {
	return dvb_media_server2_channel_media_item2_construct (DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, channel, parent);
}


static char* dvb_media_server2_channel_media_item2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = g_strdup (self->priv->parent);
	return result;
}


static char* dvb_media_server2_channel_media_item2_real_get_Path (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = g_strdup_printf (DVB_MEDIA_SERVER2_CHANNEL_PATH, dvb_channel_get_GroupId (self->priv->channel), dvb_channel_get_Sid (self->priv->channel));
	return result;
}


static char* dvb_media_server2_channel_media_item2_real_get_DisplayName (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = g_strdup (dvb_channel_get_Name (self->priv->channel));
	return result;
}


static char** dvb_media_server2_channel_media_item2_real_get_URLs (MediaItem2* base, int* result_length1) {
	char** result;
	DVBMediaServer2ChannelMediaItem2* self;
	char** _tmp0_ = NULL;
	char** _tmp1_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = dvb_channel_get_URL (self->priv->channel), _tmp0_), *result_length1 = 1, _tmp1_);
	return result;
}


static char* dvb_media_server2_channel_media_item2_real_get_MIMEType (MediaItem2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = g_strdup ("video/mpeg");
	return result;
}


static char* dvb_media_server2_channel_media_item2_real_get_Type (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	result = g_strdup ("video");
	return result;
}


void _dvb_media_server2_channel_media_item2_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server2_channel_media_item2_introspect (DVBMediaServer2ChannelMediaItem2* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem2\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject2\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n  <property name=\"Path\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server2_channel_media_item2_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server2_channel_media_item2_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_item2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object2_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server2_channel_media_item2_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server2_channel_media_item2_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_item2_dbus_register_object (connection, path, object);
	media_object2_dbus_register_object (connection, path, object);
}


static void dvb_media_server2_channel_media_item2_class_init (DVBMediaServer2ChannelMediaItem2Class * klass) {
	dvb_media_server2_channel_media_item2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2ChannelMediaItem2Private));
	G_OBJECT_CLASS (klass)->get_property = dvb_media_server2_channel_media_item2_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_channel_media_item2_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PATH, "Path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_UR_LS, "URLs");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_MIME_TYPE, "MIMEType");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_TYPE, "Type");
	g_type_set_qdata (DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server2_channel_media_item2_dbus_vtable));
}


static void dvb_media_server2_channel_media_item2_media_item2_interface_init (MediaItem2Iface * iface) {
	dvb_media_server2_channel_media_item2_media_item2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_URLs = dvb_media_server2_channel_media_item2_real_get_URLs;
	iface->get_MIMEType = dvb_media_server2_channel_media_item2_real_get_MIMEType;
}


static void dvb_media_server2_channel_media_item2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_channel_media_item2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_channel_media_item2_real_get_Parent;
	iface->get_Path = dvb_media_server2_channel_media_item2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_channel_media_item2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_channel_media_item2_real_get_Type;
}


static void dvb_media_server2_channel_media_item2_instance_init (DVBMediaServer2ChannelMediaItem2 * self) {
	self->priv = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_PRIVATE (self);
}


static void dvb_media_server2_channel_media_item2_finalize (GObject* obj) {
	DVBMediaServer2ChannelMediaItem2 * self;
	self = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2 (obj);
	_g_object_unref0 (self->priv->channel);
	_g_free0 (self->priv->parent);
	G_OBJECT_CLASS (dvb_media_server2_channel_media_item2_parent_class)->finalize (obj);
}


/**
     * Holds a single channel
     */
GType dvb_media_server2_channel_media_item2_get_type (void) {
	static volatile gsize dvb_media_server2_channel_media_item2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_channel_media_item2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2ChannelMediaItem2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_channel_media_item2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2ChannelMediaItem2), 0, (GInstanceInitFunc) dvb_media_server2_channel_media_item2_instance_init, NULL };
		static const GInterfaceInfo media_item2_info = { (GInterfaceInitFunc) dvb_media_server2_channel_media_item2_media_item2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_channel_media_item2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_channel_media_item2_type_id;
		dvb_media_server2_channel_media_item2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2ChannelMediaItem2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_channel_media_item2_type_id, TYPE_MEDIA_ITEM2, &media_item2_info);
		g_type_add_interface_static (dvb_media_server2_channel_media_item2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_channel_media_item2_type_id__volatile, dvb_media_server2_channel_media_item2_type_id);
	}
	return dvb_media_server2_channel_media_item2_type_id__volatile;
}


static void dvb_media_server2_channel_media_item2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2ChannelMediaItem2 * self;
	int length;
	self = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2 (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PARENT:
		g_value_take_string (value, media_object2_get_Parent ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_PATH:
		g_value_take_string (value, media_object2_get_Path ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_DISPLAY_NAME:
		g_value_take_string (value, media_object2_get_DisplayName ((MediaObject2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_UR_LS:
		g_value_take_boxed (value, media_item2_get_URLs ((MediaItem2*) self, &length));
		break;
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_MIME_TYPE:
		g_value_take_string (value, media_item2_get_MIMEType ((MediaItem2*) self));
		break;
		case DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_TYPE:
		g_value_take_string (value, media_object2_get_Type ((MediaObject2*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


guint dvb_media_server2_get_num_elements (gint items, guint offset, guint max) {
	guint result = 0U;
	guint num_elements = 0U;
	if (max > 0) {
		if (max > (items - offset)) {
			num_elements = items - offset;
		} else {
			num_elements = max;
		}
	} else {
		num_elements = items - offset;
	}
	result = num_elements;
	return result;
}


static guint _dynamic_RequestName2 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


gboolean dvb_media_server2_start_rygel_services (void) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch189_g_error;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		request_name_result = _dynamic_RequestName2 (bus, DVB_MEDIA_SERVER2_SERVICE_NAME, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (bus);
			_dbus_g_connection_unref0 (conn);
			goto __catch189_g_error;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			DVBMediaServer2DeviceGroupsMediaContainer2* _tmp0_;
			char* _tmp1_;
			g_message ("Services2.vala:388: Creating new Rygel MediaServer D-Bus service");
			dvb_media_server2_root_container = (_tmp0_ = dvb_media_server2_device_groups_media_container2_new (), _g_object_unref0 (dvb_media_server2_root_container), _tmp0_);
			dvb_media_server2_device_groups_media_container2_create_container_services (dvb_media_server2_root_container);
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), (const char*) (_tmp1_ = media_object2_get_Parent ((MediaObject2*) dvb_media_server2_root_container)), (GObject*) dvb_media_server2_root_container);
			_g_free0 (_tmp1_);
		} else {
			g_warning ("Services2.vala:397: Rygel MediaServer D-Bus service is already running");
			result = FALSE;
			_g_object_unref0 (bus);
			_dbus_g_connection_unref0 (conn);
			return result;
		}
		_g_object_unref0 (bus);
		_dbus_g_connection_unref0 (conn);
	}
	goto __finally189;
	__catch189_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Services2.vala:402: Oops %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally189:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




