/* Utils.c generated by valac 0.11.3, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>

#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))



#define DVB_UTILS_NAME_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME
#define DVB_UTILS_READ_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue);
const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
DBusGConnection* dvb_utils_get_dbus_connection (void);
time_t dvb_utils_t_max (time_t a, time_t b);
time_t dvb_utils_t_min (time_t a, time_t b);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);


inline const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* eclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	_tmp0_ = g_type_class_ref (enumtype);
	eclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value (eclass, val);
	eval = _tmp1_;
	if (eval == NULL) {
		g_critical ("Utils.vala:32: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (eclass);
		return result;
	} else {
		result = (*eval).value_nick;
		_g_type_class_unref0 (eclass);
		return result;
	}
	_g_type_class_unref0 (eclass);
}


inline gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue) {
	gint _evalue = 0;
	gboolean result = FALSE;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* enumclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_type_class_ref (enumtype);
	enumclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value_by_name (enumclass, name);
	eval = _tmp1_;
	if (eval == NULL) {
		g_critical ("Utils.vala:44: Enum has no member named %s", name);
		result = FALSE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _evalue;
		}
		return result;
	} else {
		_evalue = (*eval).value;
		result = TRUE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _evalue;
		}
		return result;
	}
	_g_type_class_unref0 (enumclass);
	if (evalue) {
		*evalue = _evalue;
	}
}


inline const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* enumclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	_tmp0_ = g_type_class_ref (enumtype);
	enumclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value (enumclass, val);
	eval = _tmp1_;
	if (eval == NULL) {
		g_critical ("Utils.vala:57: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		result = (*eval).value_name;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GSList* create_dirs;
	GFile* _tmp0_;
	GFile* current_dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (directory != NULL);
	create_dirs = NULL;
	_tmp0_ = _g_object_ref0 (directory);
	current_dir = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_;
		if (!(current_dir != NULL)) {
			break;
		}
		_tmp1_ = g_file_query_exists (current_dir, NULL);
		if (_tmp1_) {
			break;
		}
		_tmp2_ = _g_object_ref0 (current_dir);
		create_dirs = g_slist_prepend (create_dirs, _tmp2_);
		_tmp3_ = g_file_get_parent (current_dir);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (current_dir);
		current_dir = _tmp4_;
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* _tmp5_;
			GFile* dir;
			_tmp5_ = _g_object_ref0 ((GFile*) dir_it->data);
			dir = _tmp5_;
			{
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				_tmp6_ = g_file_get_path (dir);
				_tmp7_ = _tmp6_;
				g_debug ("Utils.vala:75: Creating %s", _tmp7_);
				_g_free0 (_tmp7_);
				g_file_make_directory (dir, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dir);
					_g_object_unref0 (current_dir);
					__g_slist_free__g_object_unref0_0 (create_dirs);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
	_g_object_unref0 (current_dir);
	__g_slist_free__g_object_unref0_0 (create_dirs);
}


gchar* dvb_utils_remove_nonalphanums (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	gchar* new_text;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	regex = NULL;
	_tmp0_ = g_regex_new ("[^-_\\.a-zA-Z0-9]", 0, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch186_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_g_regex_unref0 (regex);
	regex = _tmp2_;
	goto __finally186;
	__catch186_g_regex_error:
	{
		GError * e;
		gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Utils.vala:85: RegexError: %s", e->message);
		_tmp3_ = g_strdup (text);
		result = _tmp3_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally186:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	new_text = NULL;
	_tmp4_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "_", 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch187_g_regex_error;
		}
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp5_;
	_g_free0 (new_text);
	new_text = _tmp6_;
	goto __finally187;
	__catch187_g_regex_error:
	{
		GError * e;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Utils.vala:93: RegexError: %s", e->message);
		_tmp7_ = g_strdup (text);
		result = _tmp7_;
		_g_error_free0 (e);
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally187:
	if (_inner_error_ != NULL) {
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_text;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * @returns: Difference in seconds
     */
inline time_t dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	time_t result;
	time_t _tmp0_;
	time_t ts1;
	time_t _tmp1_;
	time_t ts2;
	time_t diff;
	_tmp0_ = mktime (t1);
	ts1 = _tmp0_;
	_tmp1_ = mktime (t2);
	ts2 = _tmp1_;
	diff = ts1 - ts2;
	if (diff < 0) {
		result = (-1) * diff;
		return result;
	} else {
		result = diff;
		return result;
	}
}


/**
     * Creates Time of local time
     */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	time_t _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm _tmp7_ = {0};
	struct tm t;
	if (year >= 1900) {
		_tmp4_ = month >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = day >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = hour >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = minute >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = second >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_tmp5_ = time (NULL);
	_tmp7_ = (g_time_local (_tmp5_, &_tmp6_), _tmp6_);
	t = _tmp7_;
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	*result = t;
	return;
}


/**
     * Creates Time of UTC time
     */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	time_t _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm _tmp7_ = {0};
	struct tm t;
	if (year >= 1900) {
		_tmp4_ = month >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = day >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = hour >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = minute >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = second >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_tmp5_ = time (NULL);
	_tmp7_ = (g_time_gm (_tmp5_, &_tmp6_), _tmp6_);
	t = _tmp7_;
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	*result = t;
	return;
}


gboolean dvb_utils_is_readable_file (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* info;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GFileType _tmp3_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	info = NULL;
	_tmp0_ = g_file_query_info (file, DVB_UTILS_READ_ATTRS, 0, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch188_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (info);
	info = _tmp2_;
	goto __finally188;
	__catch188_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Utils.vala:162: Could not retrieve attributes: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally188:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = g_file_info_get_file_type (info);
	if (_tmp3_ != G_FILE_TYPE_REGULAR) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		g_critical ("Utils.vala:167: %s is not a regular file", _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp6_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp6_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = g_file_get_path (file);
		_tmp8_ = _tmp7_;
		g_critical ("Utils.vala:172: Cannot read %s", _tmp8_);
		_g_free0 (_tmp8_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GFileEnumerator* files;
	GFileEnumerator* _tmp0_ = NULL;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	GFileInfo* childinfo;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	files = NULL;
	_tmp0_ = g_file_enumerate_children (dir, DVB_UTILS_NAME_ATTRS, 0, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (files);
		return;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (files);
	files = _tmp2_;
	if (files == NULL) {
		_g_object_unref0 (files);
		return;
	}
	childinfo = NULL;
	while (TRUE) {
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		guint32 _tmp6_;
		guint32 type;
		const gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* child;
		_tmp3_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (childinfo);
			_g_object_unref0 (files);
			return;
		}
		_tmp5_ = _tmp4_;
		_g_object_unref0 (childinfo);
		childinfo = _tmp5_;
		if (!(childinfo != NULL)) {
			break;
		}
		_tmp6_ = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		type = _tmp6_;
		_tmp7_ = g_file_info_get_name (childinfo);
		_tmp8_ = g_file_get_child (dir, _tmp7_);
		child = _tmp8_;
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_utils_delete_dir_recursively (child, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp9_ = g_file_get_path (child);
				_tmp10_ = _tmp9_;
				g_debug ("Utils.vala:197: Deleting file %s", _tmp10_);
				_g_free0 (_tmp10_);
				g_file_delete (child, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
		}
		_g_object_unref0 (child);
	}
	_tmp11_ = g_file_get_path (dir);
	_tmp12_ = _tmp11_;
	g_debug ("Utils.vala:203: Deleting directory %s", _tmp12_);
	_g_free0 (_tmp12_);
	g_file_delete (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (childinfo);
		_g_object_unref0 (files);
		return;
	}
	_g_object_unref0 (childinfo);
	_g_object_unref0 (files);
}


inline DBusGConnection* dvb_utils_get_dbus_connection (void) {
	DBusGConnection* result = NULL;
	DBusGConnection* conn;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* _tmp1_;
	DBusGConnection* _tmp2_;
	GError * _inner_error_ = NULL;
	conn = NULL;
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch189_g_error;
	}
	_tmp2_ = _tmp1_;
	_dbus_g_connection_unref0 (conn);
	conn = _tmp2_;
	goto __finally189;
	__catch189_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Utils.vala:212: Could not get D-Bus session bus: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		_dbus_g_connection_unref0 (conn);
		return result;
	}
	__finally189:
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = conn;
	return result;
}


time_t dvb_utils_t_max (time_t a, time_t b) {
	time_t result;
	time_t _tmp0_;
	if (a < b) {
		_tmp0_ = b;
	} else {
		_tmp0_ = a;
	}
	result = _tmp0_;
	return result;
}


time_t dvb_utils_t_min (time_t a, time_t b) {
	time_t result;
	time_t _tmp0_;
	if (a < b) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	result = _tmp0_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched) {
	glong _unmatched = 0L;
	glong result = 0L;
	gint _tmp0_;
	glong len_a;
	gint _tmp1_;
	glong len_b;
	glong max = 0L;
	glong diff;
	g_return_val_if_fail (a != NULL, 0L);
	g_return_val_if_fail (b != NULL, 0L);
	_tmp0_ = strlen (a);
	len_a = (glong) _tmp0_;
	_tmp1_ = strlen (b);
	len_b = (glong) _tmp1_;
	if (len_a < len_b) {
		max = len_b;
		_unmatched = len_b - len_a;
	} else {
		max = len_a;
		_unmatched = len_a - len_b;
	}
	diff = (glong) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp3_;
				gchar _tmp4_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < max)) {
					break;
				}
				_tmp3_ = string_get (a, (glong) i);
				_tmp4_ = string_get (b, (glong) i);
				if (_tmp3_ != _tmp4_) {
					diff++;
				}
			}
		}
	}
	result = diff;
	if (unmatched) {
		*unmatched = _unmatched;
	}
	return result;
}



