
#include <src/Factory.h>
#include "src/SqliteEPGStore.h"




static DVBSqliteConfigTimersStore* dvb_factory_store = NULL;
static GStaticRecMutex dvb_factory_store_mutex = {0};
static DVBEPGStore* dvb_factory_epgstore = NULL;
static GStaticRecMutex dvb_factory_epgstore_mutex = {0};
static void dvb_factory_instance_init (DVBFactory * self);



DVBTimersStore* dvb_factory_get_timers_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_store = (_tmp0 = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	return (DVBTimersStore*) dvb_factory_store;
}


DVBConfigStore* dvb_factory_get_config_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_store = (_tmp0 = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	return (DVBConfigStore*) dvb_factory_store;
}


DVBEPGStore* dvb_factory_get_epg_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	if (dvb_factory_epgstore == NULL) {
		DVBEPGStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_epgstore = (_tmp0 = (DVBEPGStore*) dvb_sqlite_epg_store_new (), (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
	return dvb_factory_epgstore;
}


void dvb_factory_shutdown (void) {
	DVBSqliteConfigTimersStore* _tmp0;
	DVBEPGStore* _tmp1;
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	_tmp0 = NULL;
	dvb_factory_store = (_tmp0 = NULL, (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	_tmp1 = NULL;
	dvb_factory_epgstore = (_tmp1 = NULL, (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp1);
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
}


DVBFactory* dvb_factory_new (void) {
	DVBFactory* self;
	self = g_slice_new0 (DVBFactory);
	dvb_factory_instance_init (self);
	return self;
}


static void dvb_factory_instance_init (DVBFactory * self) {
}


void dvb_factory_free (DVBFactory* self) {
	g_slice_free (DVBFactory, self);
}




