
#ifndef __SRC_FACTORY_H__
#define __SRC_FACTORY_H__

#include <glib.h>
#include <glib-object.h>
#include "src/SqliteConfigTimersStore.h"
#include "src/EPGStore.h"
#include "src/TimersStore.h"
#include "src/ConfigStore.h"

G_BEGIN_DECLS

typedef struct _DVBFactory DVBFactory;

struct _DVBFactory {
};


DVBTimersStore* dvb_factory_get_timers_store (void);
DVBConfigStore* dvb_factory_get_config_store (void);
DVBEPGStore* dvb_factory_get_epg_store (void);
void dvb_factory_shutdown (void);
DVBFactory* dvb_factory_new (void);
void dvb_factory_free (DVBFactory* self);


G_END_DECLS

#endif
