
#ifndef __SRC_SCANNER_H__
#define __SRC_SCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee/hashset.h>
#include <gee/hashmap.h>
#include <stdlib.h>
#include <string.h>
#include "src/ChannelList.h"
#include "src/ScannedItem.h"
#include "src/Channel.h"
#include "src/Device.h"

G_BEGIN_DECLS


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

/**
     * An abstract class responsible for scanning for new channels
     */
struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
	GeeHashMap* transport_streams;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
};


void dvb_scanner_prepare (DVBScanner* self);
DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure);
DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self);
void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
void dvb_scanner_Run (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, const char* path);
void dvb_scanner_clear_and_reset_all (DVBScanner* self);
void dvb_scanner_clear_frequencies (DVBScanner* self);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
void dvb_scanner_start_scan (DVBScanner* self);
gboolean dvb_scanner_check_for_lock (DVBScanner* self);
gboolean dvb_scanner_wait_for_tables (DVBScanner* self);
void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self);
void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key);
void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self);
void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message);
void dvb_scanner_add_new_channel (DVBScanner* self, guint sid);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self);
GType dvb_scanner_get_type (void);


G_END_DECLS

#endif
