
#include <src/IDBusManager.h>

typedef DBusGProxy DVBIDBusManagerDBusProxy;
typedef DBusGProxyClass DVBIDBusManagerDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_manager_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_manager_introspect (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_property_get_all (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetTypeOfDeviceGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetRecorder (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_AddDeviceToExistingGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_RemoveDeviceFromGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetDeviceGroupName (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetChannelList (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetDeviceGroupMembers (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_manager_GetSchedule (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_manager_changed (GObject* _sender, guint group_id, guint change_type, DBusConnection* _connection);
static void _dbus_dvb_id_bus_manager_group_changed (GObject* _sender, guint group_id, guint adapter, guint frontend, guint change_type, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_manager_changed (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_manager_group_changed (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_manager_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static char** dvb_id_bus_manager_dbus_proxy_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1);
static guint* dvb_id_bus_manager_dbus_proxy_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1);
static char* dvb_id_bus_manager_dbus_proxy_GetTypeOfDeviceGroup (DVBIDBusManager* self, guint group_id);
static char* dvb_id_bus_manager_dbus_proxy_GetRecorder (DVBIDBusManager* self, guint group_id);
static gboolean dvb_id_bus_manager_dbus_proxy_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name);
static gboolean dvb_id_bus_manager_dbus_proxy_AddDeviceToExistingGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
static gboolean dvb_id_bus_manager_dbus_proxy_RemoveDeviceFromGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
static char* dvb_id_bus_manager_dbus_proxy_GetDeviceGroupName (DVBIDBusManager* self, guint group_id);
static char* dvb_id_bus_manager_dbus_proxy_GetChannelList (DVBIDBusManager* self, guint group_id);
static char** dvb_id_bus_manager_dbus_proxy_GetDeviceGroupMembers (DVBIDBusManager* self, guint group_id, int* result_length1);
static char* dvb_id_bus_manager_dbus_proxy_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend);
static char* dvb_id_bus_manager_dbus_proxy_GetSchedule (DVBIDBusManager* self, guint group_id, guint channel_sid);
static void dvb_id_bus_manager_dbus_proxy_interface_init (DVBIDBusManagerIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_manager_dbus_path_vtable = {_dvb_id_bus_manager_dbus_unregister, dvb_id_bus_manager_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_manager_dbus_vtable = {dvb_id_bus_manager_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @returns: Object path and interface to the scanner service
         *
         * Get the object path of the channel scanner for this device.
         */
char** dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetScannerForDevice (self, adapter, frontend, result_length1);
}


/**
         * @returns: Device groups' ID
         */
guint* dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetRegisteredDeviceGroups (self, result_length1);
}


/**
         * @group_id: ID of device group
         * @returns: Name of adapter type the group holds
         * or an empty string when group with given id doesn't exist.
         */
char* dvb_id_bus_manager_GetTypeOfDeviceGroup (DVBIDBusManager* self, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetTypeOfDeviceGroup (self, group_id);
}


/**
         * @group_id: ID of device group
         * @returns: Object path of the device's recorder
         * 
         * Returns the object path to the device's recorder.
         * The device group must be registered with AddDeviceToNewGroup () first.
         */
char* dvb_id_bus_manager_GetRecorder (DVBIDBusManager* self, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetRecorder (self, group_id);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @channels_conf: Path to channels.conf for this device
         * @recordings_dir: Path where the recordings should be stored
         * @name: Name of group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new DeviceGroup and new DVB device whereas the
         * DVB device is the reference device of this group (i.e.
         * all other devices of this group will inherit the settings
         * of the reference device).
         */
gboolean dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->AddDeviceToNewGroup (self, adapter, frontend, channels_conf, recordings_dir, name);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @group_id: ID of device group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new device and adds it to the specified DeviceGroup.
         * The new device will inherit all settings from the group's
         * reference device.
         */
gboolean dvb_id_bus_manager_AddDeviceToExistingGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->AddDeviceToExistingGroup (self, adapter, frontend, group_id);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @group_id: ID of device group
         * @returns: TRUE when device has been removed successfully
         *
         * Removes the device from the specified group. If the group contains
         * no devices after the removal it's removed as well.
         */
gboolean dvb_id_bus_manager_RemoveDeviceFromGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->RemoveDeviceFromGroup (self, adapter, frontend, group_id);
}


/**
         * @group_id: ID of device group
         * @returns: Name of specified device group or
         * empty string if group with given ID doesn't exist
         */
char* dvb_id_bus_manager_GetDeviceGroupName (DVBIDBusManager* self, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetDeviceGroupName (self, group_id);
}


/**
         * @group_id: ID of device group
         * @returns: Object path to the ChannelList service for this device
         *
         * The device group must be registered with AddDeviceToNewGroup () first.
         */
char* dvb_id_bus_manager_GetChannelList (DVBIDBusManager* self, guint group_id) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetChannelList (self, group_id);
}


/**
         * @group_id: ID of device group
         * @returns: List of paths to the devices that are part of
         * the specified group (e.g. /dev/dvb/adapter0/frontend0)
         */
char** dvb_id_bus_manager_GetDeviceGroupMembers (DVBIDBusManager* self, guint group_id, int* result_length1) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetDeviceGroupMembers (self, group_id, result_length1);
}


/**
         * @adapter: Adapter of device
         * @frontend: Frontend of device
         * @returns: The name of the device or "Unknown"
         *
         * The device must be part of group, otherwise "Unknown"
         * is returned.
         */
char* dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetNameOfRegisteredDevice (self, adapter, frontend);
}


/**
         * @group_id: ID of device group
         * @channel_sid: ID of the channel
         * @returns: Object path to Schedule service
         */
char* dvb_id_bus_manager_GetSchedule (DVBIDBusManager* self, guint group_id, guint channel_sid) {
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetSchedule (self, group_id, channel_sid);
}


void _dvb_id_bus_manager_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_manager_introspect (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Manager\">\n  <method name=\"GetScannerForDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRegisteredDeviceGroups\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTypeOfDeviceGroup\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRecorder\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"AddDeviceToNewGroup\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channels_conf\" type=\"s\" direction=\"in\"/>\n    <arg name=\"recordings_dir\" type=\"s\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddDeviceToExistingGroup\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveDeviceFromGroup\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDeviceGroupName\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelList\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDeviceGroupMembers\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"GetNameOfRegisteredDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetSchedule\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"group_id\" type=\"u\"/>\n    <arg name=\"change_type\" type=\"u\"/>\n  </signal>\n  <signal name=\"GroupChanged\">\n    <arg name=\"group_id\" type=\"u\"/>\n    <arg name=\"adapter\" type=\"u\"/>\n    <arg name=\"frontend\" type=\"u\"/>\n    <arg name=\"change_type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_property_get_all (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.Manager") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp1;
	guint frontend;
	dbus_uint32_t _tmp2;
	int result_length1;
	char** result;
	DBusMessage* reply;
	char** _tmp3;
	DBusMessageIter _tmp4;
	int _tmp5;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	adapter = _tmp1;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp2);
	dbus_message_iter_next (&iter);
	frontend = _tmp2;
	result_length1 = 0;
	result = dvb_id_bus_manager_GetScannerForDevice (self, adapter, frontend, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp3 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp4);
	for (_tmp5 = 0; _tmp5 < result_length1; _tmp5++) {
		const char* _tmp6;
		_tmp6 = *(_tmp3++);
		dbus_message_iter_append_basic (&_tmp4, DBUS_TYPE_STRING, &_tmp6);
	}
	dbus_message_iter_close_container (&iter, &_tmp4);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp7;
	DBusMessageIter _tmp8;
	int _tmp9;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_manager_GetRegisteredDeviceGroups (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp8);
	for (_tmp9 = 0; _tmp9 < result_length1; _tmp9++) {
		dbus_uint32_t _tmp10;
		_tmp10 = *(_tmp7++);
		dbus_message_iter_append_basic (&_tmp8, DBUS_TYPE_UINT32, &_tmp10);
	}
	dbus_message_iter_close_container (&iter, &_tmp8);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetTypeOfDeviceGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp11;
	char* result;
	DBusMessage* reply;
	const char* _tmp12;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp11);
	dbus_message_iter_next (&iter);
	group_id = _tmp11;
	result = dvb_id_bus_manager_GetTypeOfDeviceGroup (self, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp12 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp12);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetRecorder (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp13;
	char* result;
	DBusMessage* reply;
	const char* _tmp14;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp13);
	dbus_message_iter_next (&iter);
	group_id = _tmp13;
	result = dvb_id_bus_manager_GetRecorder (self, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp14 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp14);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp15;
	guint frontend;
	dbus_uint32_t _tmp16;
	const char* channels_conf;
	const char* _tmp17;
	const char* recordings_dir;
	const char* _tmp18;
	const char* name;
	const char* _tmp19;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp20;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uusss")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15);
	dbus_message_iter_next (&iter);
	adapter = _tmp15;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp16);
	dbus_message_iter_next (&iter);
	frontend = _tmp16;
	channels_conf = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp17);
	dbus_message_iter_next (&iter);
	channels_conf = g_strdup (_tmp17);
	recordings_dir = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	recordings_dir = g_strdup (_tmp18);
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp19);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp19);
	result = dvb_id_bus_manager_AddDeviceToNewGroup (self, adapter, frontend, channels_conf, recordings_dir, name);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp20 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp20);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_AddDeviceToExistingGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp21;
	guint frontend;
	dbus_uint32_t _tmp22;
	guint group_id;
	dbus_uint32_t _tmp23;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp24;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp21);
	dbus_message_iter_next (&iter);
	adapter = _tmp21;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp22);
	dbus_message_iter_next (&iter);
	frontend = _tmp22;
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	group_id = _tmp23;
	result = dvb_id_bus_manager_AddDeviceToExistingGroup (self, adapter, frontend, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp24 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp24);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_RemoveDeviceFromGroup (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp25;
	guint frontend;
	dbus_uint32_t _tmp26;
	guint group_id;
	dbus_uint32_t _tmp27;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp28;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp25);
	dbus_message_iter_next (&iter);
	adapter = _tmp25;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26);
	dbus_message_iter_next (&iter);
	frontend = _tmp26;
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp27);
	dbus_message_iter_next (&iter);
	group_id = _tmp27;
	result = dvb_id_bus_manager_RemoveDeviceFromGroup (self, adapter, frontend, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp28 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp28);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetDeviceGroupName (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp29;
	char* result;
	DBusMessage* reply;
	const char* _tmp30;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp29);
	dbus_message_iter_next (&iter);
	group_id = _tmp29;
	result = dvb_id_bus_manager_GetDeviceGroupName (self, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp30 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp30);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetChannelList (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp31;
	char* result;
	DBusMessage* reply;
	const char* _tmp32;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp31);
	dbus_message_iter_next (&iter);
	group_id = _tmp31;
	result = dvb_id_bus_manager_GetChannelList (self, group_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp32 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp32);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetDeviceGroupMembers (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp33;
	int result_length1;
	char** result;
	DBusMessage* reply;
	char** _tmp34;
	DBusMessageIter _tmp35;
	int _tmp36;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp33);
	dbus_message_iter_next (&iter);
	group_id = _tmp33;
	result_length1 = 0;
	result = dvb_id_bus_manager_GetDeviceGroupMembers (self, group_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp34 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp35);
	for (_tmp36 = 0; _tmp36 < result_length1; _tmp36++) {
		const char* _tmp37;
		_tmp37 = *(_tmp34++);
		dbus_message_iter_append_basic (&_tmp35, DBUS_TYPE_STRING, &_tmp37);
	}
	dbus_message_iter_close_container (&iter, &_tmp35);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp38;
	guint frontend;
	dbus_uint32_t _tmp39;
	char* result;
	DBusMessage* reply;
	const char* _tmp40;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp38);
	dbus_message_iter_next (&iter);
	adapter = _tmp38;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp39);
	dbus_message_iter_next (&iter);
	frontend = _tmp39;
	result = dvb_id_bus_manager_GetNameOfRegisteredDevice (self, adapter, frontend);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp40 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp40);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_manager_GetSchedule (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint group_id;
	dbus_uint32_t _tmp41;
	guint channel_sid;
	dbus_uint32_t _tmp42;
	char* result;
	DBusMessage* reply;
	const char* _tmp43;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp41);
	dbus_message_iter_next (&iter);
	group_id = _tmp41;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp42);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp42;
	result = dvb_id_bus_manager_GetSchedule (self, group_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp43 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp43);
	return reply;
}


DBusHandlerResult dvb_id_bus_manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_manager_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_manager_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetScannerForDevice")) {
		reply = _dbus_dvb_id_bus_manager_GetScannerForDevice (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetRegisteredDeviceGroups")) {
		reply = _dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetTypeOfDeviceGroup")) {
		reply = _dbus_dvb_id_bus_manager_GetTypeOfDeviceGroup (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetRecorder")) {
		reply = _dbus_dvb_id_bus_manager_GetRecorder (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "AddDeviceToNewGroup")) {
		reply = _dbus_dvb_id_bus_manager_AddDeviceToNewGroup (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "AddDeviceToExistingGroup")) {
		reply = _dbus_dvb_id_bus_manager_AddDeviceToExistingGroup (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "RemoveDeviceFromGroup")) {
		reply = _dbus_dvb_id_bus_manager_RemoveDeviceFromGroup (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetDeviceGroupName")) {
		reply = _dbus_dvb_id_bus_manager_GetDeviceGroupName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetChannelList")) {
		reply = _dbus_dvb_id_bus_manager_GetChannelList (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetDeviceGroupMembers")) {
		reply = _dbus_dvb_id_bus_manager_GetDeviceGroupMembers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetNameOfRegisteredDevice")) {
		reply = _dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Manager", "GetSchedule")) {
		reply = _dbus_dvb_id_bus_manager_GetSchedule (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_manager_changed (GObject* _sender, guint group_id, guint change_type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp44;
	dbus_uint32_t _tmp45;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Manager", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp44 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp44);
	_tmp45 = change_type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp45);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_manager_group_changed (GObject* _sender, guint group_id, guint adapter, guint frontend, guint change_type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp46;
	dbus_uint32_t _tmp47;
	dbus_uint32_t _tmp48;
	dbus_uint32_t _tmp49;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Manager", "GroupChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp46 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp46);
	_tmp47 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp47);
	_tmp48 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp48);
	_tmp49 = change_type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp49);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_manager_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_manager_dbus_path_vtable, object);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_manager_changed, connection);
	g_signal_connect (object, "group-changed", (GCallback) _dbus_dvb_id_bus_manager_group_changed, connection);
}


static void dvb_id_bus_manager_base_init (DVBIDBusManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("group_changed", DVB_TYPE_ID_BUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT_UINT, G_TYPE_NONE, 4, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_MANAGER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_manager_dbus_vtable));
	}
}


GType dvb_id_bus_manager_get_type (void) {
	static GType dvb_id_bus_manager_type_id = 0;
	if (dvb_id_bus_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusManagerIface), (GBaseInitFunc) dvb_id_bus_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_manager_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_manager_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusManagerDBusProxy, dvb_id_bus_manager_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_MANAGER, dvb_id_bus_manager_dbus_proxy_interface_init));
DVBIDBusManager* dvb_id_bus_manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusManager* self;
	char* filter;
	self = g_object_new (dvb_id_bus_manager_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Manager", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_manager_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_manager_changed (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint group_id;
	dbus_uint32_t _tmp50;
	guint change_type;
	dbus_uint32_t _tmp51;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp50);
	dbus_message_iter_next (&iter);
	group_id = _tmp50;
	change_type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp51);
	dbus_message_iter_next (&iter);
	change_type = _tmp51;
	g_signal_emit_by_name (self, "changed", group_id, change_type);
}


static void _dbus_handle_dvb_id_bus_manager_group_changed (DVBIDBusManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint group_id;
	dbus_uint32_t _tmp52;
	guint adapter;
	dbus_uint32_t _tmp53;
	guint frontend;
	dbus_uint32_t _tmp54;
	guint change_type;
	dbus_uint32_t _tmp55;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uuuu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	group_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp52);
	dbus_message_iter_next (&iter);
	group_id = _tmp52;
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp53);
	dbus_message_iter_next (&iter);
	adapter = _tmp53;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp54);
	dbus_message_iter_next (&iter);
	frontend = _tmp54;
	change_type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp55);
	dbus_message_iter_next (&iter);
	change_type = _tmp55;
	g_signal_emit_by_name (self, "group-changed", group_id, adapter, frontend, change_type);
}


DBusHandlerResult dvb_id_bus_manager_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Manager", "Changed")) {
			_dbus_handle_dvb_id_bus_manager_changed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Manager", "GroupChanged")) {
			_dbus_handle_dvb_id_bus_manager_group_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_manager_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_manager_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_manager_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_manager_dbus_proxy_class_init (DVBIDBusManagerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_manager_dbus_proxy_dispose;
}


static void dvb_id_bus_manager_dbus_proxy_init (DVBIDBusManagerDBusProxy* self) {
}


static char** dvb_id_bus_manager_dbus_proxy_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp56;
	dbus_uint32_t _tmp57;
	char** _result;
	int _result_length1;
	char** _tmp58;
	int _tmp58_length;
	int _tmp58_size;
	int _tmp58_length1;
	DBusMessageIter _tmp59;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetScannerForDevice");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp56 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp56);
	_tmp57 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp57);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp58 = g_new (char*, 5);
	_tmp58_length = 0;
	_tmp58_size = 4;
	_tmp58_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp59);
	for (; dbus_message_iter_get_arg_type (&_tmp59); _tmp58_length1++) {
		const char* _tmp60;
		if (_tmp58_size == _tmp58_length) {
			_tmp58_size = 2 * _tmp58_size;
			_tmp58 = g_renew (char*, _tmp58, _tmp58_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp59, &_tmp60);
		dbus_message_iter_next (&_tmp59);
		_tmp58[_tmp58_length++] = g_strdup (_tmp60);
	}
	_result_length1 = _tmp58_length1;
	_tmp58[_tmp58_length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp58;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_manager_dbus_proxy_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp61;
	int _tmp61_length;
	int _tmp61_size;
	int _tmp61_length1;
	DBusMessageIter _tmp62;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetRegisteredDeviceGroups");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp61 = g_new (guint, 5);
	_tmp61_length = 0;
	_tmp61_size = 4;
	_tmp61_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp62);
	for (; dbus_message_iter_get_arg_type (&_tmp62); _tmp61_length1++) {
		dbus_uint32_t _tmp63;
		if (_tmp61_size == _tmp61_length) {
			_tmp61_size = 2 * _tmp61_size;
			_tmp61 = g_renew (guint, _tmp61, _tmp61_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp62, &_tmp63);
		dbus_message_iter_next (&_tmp62);
		_tmp61[_tmp61_length++] = _tmp63;
	}
	_result_length1 = _tmp61_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp61;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetTypeOfDeviceGroup (DVBIDBusManager* self, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp64;
	char* _result;
	const char* _tmp65;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetTypeOfDeviceGroup");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp64);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp65);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp65);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetRecorder (DVBIDBusManager* self, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp66;
	char* _result;
	const char* _tmp67;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetRecorder");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp66 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp66);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp67);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp67);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_manager_dbus_proxy_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp68;
	dbus_uint32_t _tmp69;
	const char* _tmp70;
	const char* _tmp71;
	const char* _tmp72;
	gboolean _result;
	dbus_bool_t _tmp73;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "AddDeviceToNewGroup");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp68 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp68);
	_tmp69 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp69);
	_tmp70 = channels_conf;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp70);
	_tmp71 = recordings_dir;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp71);
	_tmp72 = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp72);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp73);
	dbus_message_iter_next (&_iter);
	_result = _tmp73;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_manager_dbus_proxy_AddDeviceToExistingGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp74;
	dbus_uint32_t _tmp75;
	dbus_uint32_t _tmp76;
	gboolean _result;
	dbus_bool_t _tmp77;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "AddDeviceToExistingGroup");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp74 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp74);
	_tmp75 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp75);
	_tmp76 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp76);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp77);
	dbus_message_iter_next (&_iter);
	_result = _tmp77;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_manager_dbus_proxy_RemoveDeviceFromGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp78;
	dbus_uint32_t _tmp79;
	dbus_uint32_t _tmp80;
	gboolean _result;
	dbus_bool_t _tmp81;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "RemoveDeviceFromGroup");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp78 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp78);
	_tmp79 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp79);
	_tmp80 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp80);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp81);
	dbus_message_iter_next (&_iter);
	_result = _tmp81;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetDeviceGroupName (DVBIDBusManager* self, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp82;
	char* _result;
	const char* _tmp83;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetDeviceGroupName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp82 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp82);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp83);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp83);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetChannelList (DVBIDBusManager* self, guint group_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp84;
	char* _result;
	const char* _tmp85;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetChannelList");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp84 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp84);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp85);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp85);
	dbus_message_unref (_reply);
	return _result;
}


static char** dvb_id_bus_manager_dbus_proxy_GetDeviceGroupMembers (DVBIDBusManager* self, guint group_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp86;
	char** _result;
	int _result_length1;
	char** _tmp87;
	int _tmp87_length;
	int _tmp87_size;
	int _tmp87_length1;
	DBusMessageIter _tmp88;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetDeviceGroupMembers");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp86 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp86);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp87 = g_new (char*, 5);
	_tmp87_length = 0;
	_tmp87_size = 4;
	_tmp87_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp88);
	for (; dbus_message_iter_get_arg_type (&_tmp88); _tmp87_length1++) {
		const char* _tmp89;
		if (_tmp87_size == _tmp87_length) {
			_tmp87_size = 2 * _tmp87_size;
			_tmp87 = g_renew (char*, _tmp87, _tmp87_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp88, &_tmp89);
		dbus_message_iter_next (&_tmp88);
		_tmp87[_tmp87_length++] = g_strdup (_tmp89);
	}
	_result_length1 = _tmp87_length1;
	_tmp87[_tmp87_length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp87;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp90;
	dbus_uint32_t _tmp91;
	char* _result;
	const char* _tmp92;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetNameOfRegisteredDevice");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp90 = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp90);
	_tmp91 = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp91);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp92);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp92);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_manager_dbus_proxy_GetSchedule (DVBIDBusManager* self, guint group_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp93;
	dbus_uint32_t _tmp94;
	char* _result;
	const char* _tmp95;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Manager", "GetSchedule");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp93 = group_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp93);
	_tmp94 = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp94);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp95);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp95);
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_manager_dbus_proxy_interface_init (DVBIDBusManagerIface* iface) {
	iface->GetScannerForDevice = dvb_id_bus_manager_dbus_proxy_GetScannerForDevice;
	iface->GetRegisteredDeviceGroups = dvb_id_bus_manager_dbus_proxy_GetRegisteredDeviceGroups;
	iface->GetTypeOfDeviceGroup = dvb_id_bus_manager_dbus_proxy_GetTypeOfDeviceGroup;
	iface->GetRecorder = dvb_id_bus_manager_dbus_proxy_GetRecorder;
	iface->AddDeviceToNewGroup = dvb_id_bus_manager_dbus_proxy_AddDeviceToNewGroup;
	iface->AddDeviceToExistingGroup = dvb_id_bus_manager_dbus_proxy_AddDeviceToExistingGroup;
	iface->RemoveDeviceFromGroup = dvb_id_bus_manager_dbus_proxy_RemoveDeviceFromGroup;
	iface->GetDeviceGroupName = dvb_id_bus_manager_dbus_proxy_GetDeviceGroupName;
	iface->GetChannelList = dvb_id_bus_manager_dbus_proxy_GetChannelList;
	iface->GetDeviceGroupMembers = dvb_id_bus_manager_dbus_proxy_GetDeviceGroupMembers;
	iface->GetNameOfRegisteredDevice = dvb_id_bus_manager_dbus_proxy_GetNameOfRegisteredDevice;
	iface->GetSchedule = dvb_id_bus_manager_dbus_proxy_GetSchedule;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, guint arg_4, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_uint (param_values + 4), data2);
}



