
#include <src/IDBusRecorder.h>

typedef DBusGProxy DVBIDBusRecorderDBusProxy;
typedef DBusGProxyClass DVBIDBusRecorderDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id);
static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1);
static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id);
static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_recorder_dbus_path_vtable = {_dvb_id_bus_recorder_dbus_unregister, dvb_id_bus_recorder_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_recorder_dbus_vtable = {dvb_id_bus_recorder_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         * 
         * Add a new timer
         */
guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         */
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerForEPGEvent (self, event_id, channel_sid);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->DeleteTimer (self, timer_id);
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         */
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetStartTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Same as dvb_recorder_GetStartTime()
         */
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetEndTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Duration in seconds or 0 if there's no timer with
         * the given id
         */
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetDuration (self, timer_id);
}


/**
         * @timer_id: Timer's id
         * @returns: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         */
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetChannelName (self, timer_id);
}


/**
         * @returns: The currently active timers
         */
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetActiveTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->IsTimerActive (self, timer_id);
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * Checks if a timer overlaps with the given event
         */
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimerForEvent (self, event_id, channel_sid);
}


void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Recorder\">\n  <method name=\"AddTimer\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerForEPGEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"DeleteTimer\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetEndTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetActiveTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsTimerActive\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimer\">\n    <arg name=\"start_year\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimerForEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <signal name=\"RecordingStarted\">\n    <arg name=\"timer_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"RecordingFinished\">\n    <arg name=\"recording_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"Changed\">\n    <arg name=\"timer_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.Recorder") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel;
	dbus_uint32_t _tmp1;
	gint start_year;
	dbus_int32_t _tmp2;
	gint start_month;
	dbus_int32_t _tmp3;
	gint start_day;
	dbus_int32_t _tmp4;
	gint start_hour;
	dbus_int32_t _tmp5;
	gint start_minute;
	dbus_int32_t _tmp6;
	guint duration;
	dbus_uint32_t _tmp7;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp8;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uiiiiiu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	channel = _tmp1;
	start_year = 0;
	dbus_message_iter_get_basic (&iter, &_tmp2);
	dbus_message_iter_next (&iter);
	start_year = _tmp2;
	start_month = 0;
	dbus_message_iter_get_basic (&iter, &_tmp3);
	dbus_message_iter_next (&iter);
	start_month = _tmp3;
	start_day = 0;
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	start_day = _tmp4;
	start_hour = 0;
	dbus_message_iter_get_basic (&iter, &_tmp5);
	dbus_message_iter_next (&iter);
	start_hour = _tmp5;
	start_minute = 0;
	dbus_message_iter_get_basic (&iter, &_tmp6);
	dbus_message_iter_next (&iter);
	start_minute = _tmp6;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp7);
	dbus_message_iter_next (&iter);
	duration = _tmp7;
	result = dvb_id_bus_recorder_AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp8 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp8);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp9;
	guint channel_sid;
	dbus_uint32_t _tmp10;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp11;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9);
	dbus_message_iter_next (&iter);
	event_id = _tmp9;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp10;
	result = dvb_id_bus_recorder_AddTimerForEPGEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp11 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp11);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp12;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp13;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp12);
	dbus_message_iter_next (&iter);
	timer_id = _tmp12;
	result = dvb_id_bus_recorder_DeleteTimer (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp13 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp13);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp14;
	DBusMessageIter _tmp15;
	int _tmp16;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp14 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp15);
	for (_tmp16 = 0; _tmp16 < result_length1; _tmp16++) {
		dbus_uint32_t _tmp17;
		_tmp17 = *(_tmp14++);
		dbus_message_iter_append_basic (&_tmp15, DBUS_TYPE_UINT32, &_tmp17);
	}
	dbus_message_iter_close_container (&iter, &_tmp15);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp18;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp19;
	DBusMessageIter _tmp20;
	int _tmp21;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	timer_id = _tmp18;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetStartTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp20);
	for (_tmp21 = 0; _tmp21 < result_length1; _tmp21++) {
		dbus_uint32_t _tmp22;
		_tmp22 = *(_tmp19++);
		dbus_message_iter_append_basic (&_tmp20, DBUS_TYPE_UINT32, &_tmp22);
	}
	dbus_message_iter_close_container (&iter, &_tmp20);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp23;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp24;
	DBusMessageIter _tmp25;
	int _tmp26;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	timer_id = _tmp23;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetEndTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp24 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp25);
	for (_tmp26 = 0; _tmp26 < result_length1; _tmp26++) {
		dbus_uint32_t _tmp27;
		_tmp27 = *(_tmp24++);
		dbus_message_iter_append_basic (&_tmp25, DBUS_TYPE_UINT32, &_tmp27);
	}
	dbus_message_iter_close_container (&iter, &_tmp25);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp28;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp29;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp28);
	dbus_message_iter_next (&iter);
	timer_id = _tmp28;
	result = dvb_id_bus_recorder_GetDuration (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp29 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp29);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp30;
	char* result;
	DBusMessage* reply;
	const char* _tmp31;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp30);
	dbus_message_iter_next (&iter);
	timer_id = _tmp30;
	result = dvb_id_bus_recorder_GetChannelName (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp31 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp31);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp32;
	DBusMessageIter _tmp33;
	int _tmp34;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetActiveTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp32 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp33);
	for (_tmp34 = 0; _tmp34 < result_length1; _tmp34++) {
		dbus_uint32_t _tmp35;
		_tmp35 = *(_tmp32++);
		dbus_message_iter_append_basic (&_tmp33, DBUS_TYPE_UINT32, &_tmp35);
	}
	dbus_message_iter_close_container (&iter, &_tmp33);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp36;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp37;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp36);
	dbus_message_iter_next (&iter);
	timer_id = _tmp36;
	result = dvb_id_bus_recorder_IsTimerActive (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp37 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp37);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint start_year;
	dbus_uint32_t _tmp38;
	guint start_month;
	dbus_uint32_t _tmp39;
	guint start_day;
	dbus_uint32_t _tmp40;
	guint start_hour;
	dbus_uint32_t _tmp41;
	guint start_minute;
	dbus_uint32_t _tmp42;
	guint duration;
	dbus_uint32_t _tmp43;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp44;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuuuuu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	start_year = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp38);
	dbus_message_iter_next (&iter);
	start_year = _tmp38;
	start_month = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp39);
	dbus_message_iter_next (&iter);
	start_month = _tmp39;
	start_day = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp40);
	dbus_message_iter_next (&iter);
	start_day = _tmp40;
	start_hour = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp41);
	dbus_message_iter_next (&iter);
	start_hour = _tmp41;
	start_minute = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp42);
	dbus_message_iter_next (&iter);
	start_minute = _tmp42;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp43);
	dbus_message_iter_next (&iter);
	duration = _tmp43;
	result = dvb_id_bus_recorder_HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp44 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp44);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp45;
	guint channel_sid;
	dbus_uint32_t _tmp46;
	DVBOverlapType result;
	DBusMessage* reply;
	dbus_int32_t _tmp47;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp45);
	dbus_message_iter_next (&iter);
	event_id = _tmp45;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp46);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp46;
	result = dvb_id_bus_recorder_HasTimerForEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp47 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT32, &_tmp47);
	return reply;
}


DBusHandlerResult dvb_id_bus_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_recorder_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_recorder_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimer")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimerForEPGEvent")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "DeleteTimer")) {
		reply = _dbus_dvb_id_bus_recorder_DeleteTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetStartTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetEndTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetEndTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetDuration")) {
		reply = _dbus_dvb_id_bus_recorder_GetDuration (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_recorder_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetActiveTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetActiveTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "IsTimerActive")) {
		reply = _dbus_dvb_id_bus_recorder_IsTimerActive (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimer")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimerForEvent")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimerForEvent (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp48;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingStarted");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp48);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp49;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingFinished");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp49 = recording_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp49);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp50;
	dbus_uint32_t _tmp51;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp50 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp50);
	_tmp51 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp51);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_recorder_dbus_path_vtable, object);
	}
	g_signal_connect (object, "recording-started", (GCallback) _dbus_dvb_id_bus_recorder_recording_started, connection);
	g_signal_connect (object, "recording-finished", (GCallback) _dbus_dvb_id_bus_recorder_recording_finished, connection);
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recorder_changed, connection);
}


static void dvb_id_bus_recorder_base_init (DVBIDBusRecorderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("recording_started", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("recording_finished", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_RECORDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_recorder_dbus_vtable));
	}
}


GType dvb_id_bus_recorder_get_type (void) {
	static GType dvb_id_bus_recorder_type_id = 0;
	if (dvb_id_bus_recorder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecorderIface), (GBaseInitFunc) dvb_id_bus_recorder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recorder_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecorder", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recorder_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_recorder_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecorderDBusProxy, dvb_id_bus_recorder_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDER, dvb_id_bus_recorder_dbus_proxy_interface_init));
DVBIDBusRecorder* dvb_id_bus_recorder_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusRecorder* self;
	char* filter;
	self = g_object_new (dvb_id_bus_recorder_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Recorder", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp52;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp52);
	dbus_message_iter_next (&iter);
	timer_id = _tmp52;
	g_signal_emit_by_name (self, "recording-started", timer_id);
}


static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 recording_id;
	dbus_uint32_t _tmp53;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	recording_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp53);
	dbus_message_iter_next (&iter);
	recording_id = _tmp53;
	g_signal_emit_by_name (self, "recording-finished", recording_id);
}


static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp54;
	guint type;
	dbus_uint32_t _tmp55;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp54);
	dbus_message_iter_next (&iter);
	timer_id = _tmp54;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp55);
	dbus_message_iter_next (&iter);
	type = _tmp55;
	g_signal_emit_by_name (self, "changed", timer_id, type);
}


DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingStarted")) {
			_dbus_handle_dvb_id_bus_recorder_recording_started (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingFinished")) {
			_dbus_handle_dvb_id_bus_recorder_recording_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "Changed")) {
			_dbus_handle_dvb_id_bus_recorder_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_recorder_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_recorder_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_recorder_dbus_proxy_class_init (DVBIDBusRecorderDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_recorder_dbus_proxy_dispose;
}


static void dvb_id_bus_recorder_dbus_proxy_init (DVBIDBusRecorderDBusProxy* self) {
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp56;
	dbus_int32_t _tmp57;
	dbus_int32_t _tmp58;
	dbus_int32_t _tmp59;
	dbus_int32_t _tmp60;
	dbus_int32_t _tmp61;
	dbus_uint32_t _tmp62;
	guint32 _result;
	dbus_uint32_t _tmp63;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp56 = channel;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp56);
	_tmp57 = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp57);
	_tmp58 = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp58);
	_tmp59 = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp59);
	_tmp60 = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp60);
	_tmp61 = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp61);
	_tmp62 = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp62);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp63);
	dbus_message_iter_next (&_iter);
	_result = _tmp63;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp64;
	dbus_uint32_t _tmp65;
	guint32 _result;
	dbus_uint32_t _tmp66;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimerForEPGEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp64);
	_tmp65 = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp65);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp66);
	dbus_message_iter_next (&_iter);
	_result = _tmp66;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp67;
	gboolean _result;
	dbus_bool_t _tmp68;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "DeleteTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp67 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp67);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp68);
	dbus_message_iter_next (&_iter);
	_result = _tmp68;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp69;
	int _tmp69_length;
	int _tmp69_size;
	int _tmp69_length1;
	DBusMessageIter _tmp70;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp69 = g_new (guint32, 5);
	_tmp69_length = 0;
	_tmp69_size = 4;
	_tmp69_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp70);
	for (; dbus_message_iter_get_arg_type (&_tmp70); _tmp69_length1++) {
		dbus_uint32_t _tmp71;
		if (_tmp69_size == _tmp69_length) {
			_tmp69_size = 2 * _tmp69_size;
			_tmp69 = g_renew (guint32, _tmp69, _tmp69_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp70, &_tmp71);
		dbus_message_iter_next (&_tmp70);
		_tmp69[_tmp69_length++] = _tmp71;
	}
	_result_length1 = _tmp69_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp69;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp72;
	guint32* _result;
	int _result_length1;
	guint32* _tmp73;
	int _tmp73_length;
	int _tmp73_size;
	int _tmp73_length1;
	DBusMessageIter _tmp74;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp72);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp73 = g_new (guint32, 5);
	_tmp73_length = 0;
	_tmp73_size = 4;
	_tmp73_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp74);
	for (; dbus_message_iter_get_arg_type (&_tmp74); _tmp73_length1++) {
		dbus_uint32_t _tmp75;
		if (_tmp73_size == _tmp73_length) {
			_tmp73_size = 2 * _tmp73_size;
			_tmp73 = g_renew (guint32, _tmp73, _tmp73_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp74, &_tmp75);
		dbus_message_iter_next (&_tmp74);
		_tmp73[_tmp73_length++] = _tmp75;
	}
	_result_length1 = _tmp73_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp73;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp76;
	guint* _result;
	int _result_length1;
	guint* _tmp77;
	int _tmp77_length;
	int _tmp77_size;
	int _tmp77_length1;
	DBusMessageIter _tmp78;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetEndTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp76 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp76);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp77 = g_new (guint, 5);
	_tmp77_length = 0;
	_tmp77_size = 4;
	_tmp77_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp78);
	for (; dbus_message_iter_get_arg_type (&_tmp78); _tmp77_length1++) {
		dbus_uint32_t _tmp79;
		if (_tmp77_size == _tmp77_length) {
			_tmp77_size = 2 * _tmp77_size;
			_tmp77 = g_renew (guint, _tmp77, _tmp77_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp78, &_tmp79);
		dbus_message_iter_next (&_tmp78);
		_tmp77[_tmp77_length++] = _tmp79;
	}
	_result_length1 = _tmp77_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp77;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp80;
	guint _result;
	dbus_uint32_t _tmp81;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetDuration");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp80 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp80);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp81);
	dbus_message_iter_next (&_iter);
	_result = _tmp81;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp82;
	char* _result;
	const char* _tmp83;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp82 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp82);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp83);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp83);
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp84;
	int _tmp84_length;
	int _tmp84_size;
	int _tmp84_length1;
	DBusMessageIter _tmp85;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetActiveTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp84 = g_new (guint32, 5);
	_tmp84_length = 0;
	_tmp84_size = 4;
	_tmp84_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp85);
	for (; dbus_message_iter_get_arg_type (&_tmp85); _tmp84_length1++) {
		dbus_uint32_t _tmp86;
		if (_tmp84_size == _tmp84_length) {
			_tmp84_size = 2 * _tmp84_size;
			_tmp84 = g_renew (guint32, _tmp84, _tmp84_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp85, &_tmp86);
		dbus_message_iter_next (&_tmp85);
		_tmp84[_tmp84_length++] = _tmp86;
	}
	_result_length1 = _tmp84_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp84;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp87;
	gboolean _result;
	dbus_bool_t _tmp88;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "IsTimerActive");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp87 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp87);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp88);
	dbus_message_iter_next (&_iter);
	_result = _tmp88;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp89;
	dbus_uint32_t _tmp90;
	dbus_uint32_t _tmp91;
	dbus_uint32_t _tmp92;
	dbus_uint32_t _tmp93;
	dbus_uint32_t _tmp94;
	gboolean _result;
	dbus_bool_t _tmp95;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp89 = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp89);
	_tmp90 = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp90);
	_tmp91 = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp91);
	_tmp92 = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp92);
	_tmp93 = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp93);
	_tmp94 = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp94);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp95);
	dbus_message_iter_next (&_iter);
	_result = _tmp95;
	dbus_message_unref (_reply);
	return _result;
}


static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp96;
	dbus_uint32_t _tmp97;
	DVBOverlapType _result;
	dbus_int32_t _tmp98;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimerForEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp96 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp96);
	_tmp97 = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp97);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp98);
	dbus_message_iter_next (&_iter);
	_result = _tmp98;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface) {
	iface->AddTimer = dvb_id_bus_recorder_dbus_proxy_AddTimer;
	iface->AddTimerForEPGEvent = dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_id_bus_recorder_dbus_proxy_DeleteTimer;
	iface->GetTimers = dvb_id_bus_recorder_dbus_proxy_GetTimers;
	iface->GetStartTime = dvb_id_bus_recorder_dbus_proxy_GetStartTime;
	iface->GetEndTime = dvb_id_bus_recorder_dbus_proxy_GetEndTime;
	iface->GetDuration = dvb_id_bus_recorder_dbus_proxy_GetDuration;
	iface->GetChannelName = dvb_id_bus_recorder_dbus_proxy_GetChannelName;
	iface->GetActiveTimers = dvb_id_bus_recorder_dbus_proxy_GetActiveTimers;
	iface->IsTimerActive = dvb_id_bus_recorder_dbus_proxy_IsTimerActive;
	iface->HasTimer = dvb_id_bus_recorder_dbus_proxy_HasTimer;
	iface->HasTimerForEvent = dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



