
#include <src/DeviceGroup.h>
#include <gee/set.h>
#include <gee/collection.h>
#include <gee/hashset.h>
#include "src/EPGScanner.h"
#include "src/Recorder.h"




struct _DVBDeviceGroupPrivate {
	guint _Id;
	char* _Name;
	DVBDevice* _reference_device;
	GeeSet* devices;
	DVBRecorder* _recorder;
	DVBEPGScanner* _epgscanner;
};

#define DVB_DEVICE_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupPrivate))
enum  {
	DVB_DEVICE_GROUP_DUMMY_PROPERTY,
	DVB_DEVICE_GROUP_SIZE,
	DVB_DEVICE_GROUP_ID,
	DVB_DEVICE_GROUP_CHANNELS,
	DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY,
	DVB_DEVICE_GROUP_TYPE,
	DVB_DEVICE_GROUP_RECORDER,
	DVB_DEVICE_GROUP_EPGSCANNER,
	DVB_DEVICE_GROUP_NAME,
	DVB_DEVICE_GROUP_REFERENCE_DEVICE
};
static GType dvb_device_group_real_get_element_type (GeeIterable* base);
static GeeIterator* dvb_device_group_real_iterator (GeeIterable* base);
static void dvb_device_group_set_Id (DVBDeviceGroup* self, guint value);
static void dvb_device_group_set_reference_device (DVBDeviceGroup* self, DVBDevice* value);
static guint _dvb_device_hash_ghash_func (void* key);
static gboolean _dvb_device_equal_gequal_func (void* a, void* b);
static GObject * dvb_device_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_device_group_parent_class = NULL;
static GeeIterableIface* dvb_device_group_gee_iterable_parent_iface = NULL;
static void dvb_device_group_finalize (GObject* obj);



/**
         * @reference_device: All devices of this group will inherit
         * the settings from this device
         */
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBDeviceGroup * self;
	DVBEPGScanner* _tmp0;
	DVBRecorder* _tmp1;
	g_return_val_if_fail (reference_device != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "Id";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, id);
	__params_it++;
	__params_it->name = "reference-device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, reference_device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	dvb_channel_list_set_group_id (dvb_device_get_Channels (self->priv->_reference_device), id);
	_tmp0 = NULL;
	self->priv->_epgscanner = (_tmp0 = dvb_epg_scanner_new (self), (self->priv->_epgscanner == NULL) ? NULL : (self->priv->_epgscanner = (g_object_unref (self->priv->_epgscanner), NULL)), _tmp0);
	_tmp1 = NULL;
	self->priv->_recorder = (_tmp1 = dvb_recorder_new (self), (self->priv->_recorder == NULL) ? NULL : (self->priv->_recorder = (g_object_unref (self->priv->_recorder), NULL)), _tmp1);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device) {
	return dvb_device_group_construct (DVB_TYPE_DEVICE_GROUP, id, reference_device);
}


void dvb_device_group_destroy (DVBDeviceGroup* self) {
	g_return_if_fail (self != NULL);
	g_debug ("DeviceGroup.vala:58: Destroying group %u", self->priv->_Id);
	dvb_epg_scanner_destroy (self->priv->_epgscanner);
	dvb_recorder_stop (self->priv->_recorder);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         *
         * Creates a new device first and adds it to the group.
         * The new device inherits the settings from the reference
         * device.
         */
void dvb_device_group_create_and_add_device (DVBDeviceGroup* self, guint adapter, guint frontend) {
	DVBDevice* new_dev;
	g_return_if_fail (self != NULL);
	new_dev = dvb_device_new (adapter, frontend, TRUE);
	dvb_device_group_add (self, new_dev);
	(new_dev == NULL) ? NULL : (new_dev = (g_object_unref (new_dev), NULL));
}


/**
         * Add device to group. The device's settings will be overridden
         * with those of the reference device.
         */
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	if (dvb_device_get_Type (device) != dvb_device_group_get_Type (self)) {
		g_warning ("DeviceGroup.vala:82: Cannot add device, because it is not of same type");
		return FALSE;
	}
	/* Set settings from reference device*/
	dvb_device_set_Channels (device, dvb_device_get_Channels (self->priv->_reference_device));
	dvb_device_set_RecordingsDirectory (device, dvb_device_get_RecordingsDirectory (self->priv->_reference_device));
	return gee_collection_add ((GeeCollection*) self->priv->devices, device);
}


gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	return gee_collection_contains ((GeeCollection*) self->priv->devices, device);
}


gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	return gee_collection_remove ((GeeCollection*) self->priv->devices, device);
}


/**
         * Get first device that isn't busy.
         * If all devices are busy NULL is returned.
         */
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeIterator* _dev_it;
		_dev_it = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
		while (gee_iterator_next (_dev_it)) {
			DVBDevice* dev;
			dev = (DVBDevice*) gee_iterator_get (_dev_it);
			if (!dvb_device_is_busy (dev)) {
				DVBDevice* _tmp0;
				_tmp0 = NULL;
				return (_tmp0 = dev, (_dev_it == NULL) ? NULL : (_dev_it = (g_object_unref (_dev_it), NULL)), _tmp0);
			}
			(dev == NULL) ? NULL : (dev = (g_object_unref (dev), NULL));
		}
		(_dev_it == NULL) ? NULL : (_dev_it = (g_object_unref (_dev_it), NULL));
	}
	return NULL;
}


static GType dvb_device_group_real_get_element_type (GeeIterable* base) {
	DVBDeviceGroup * self;
	self = (DVBDeviceGroup*) base;
	return DVB_TYPE_DEVICE;
}


static GeeIterator* dvb_device_group_real_iterator (GeeIterable* base) {
	DVBDeviceGroup * self;
	self = (DVBDeviceGroup*) base;
	return gee_iterable_iterator ((GeeIterable*) self->priv->devices);
}


gint dvb_device_group_get_size (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, 0);
	return gee_collection_get_size ((GeeCollection*) self->priv->devices);
}


guint dvb_device_group_get_Id (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Id;
}


static void dvb_device_group_set_Id (DVBDeviceGroup* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return dvb_device_get_Channels (self->priv->_reference_device);
}


GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return dvb_device_get_RecordingsDirectory (self->priv->_reference_device);
}


DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, 0);
	return dvb_device_get_Type (self->priv->_reference_device);
}


DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_recorder;
}


DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_epgscanner;
}


const char* dvb_device_group_get_Name (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Name;
}


void dvb_device_group_set_Name (DVBDeviceGroup* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Name = (g_free (self->priv->_Name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Name");
}


DVBDevice* dvb_device_group_get_reference_device (DVBDeviceGroup* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_reference_device;
}


static void dvb_device_group_set_reference_device (DVBDeviceGroup* self, DVBDevice* value) {
	DVBDevice* _tmp2;
	DVBDevice* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_reference_device = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_reference_device == NULL) ? NULL : (self->priv->_reference_device = (g_object_unref (self->priv->_reference_device), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "reference-device");
}


static guint _dvb_device_hash_ghash_func (void* key) {
	return dvb_device_hash (key);
}


static gboolean _dvb_device_equal_gequal_func (void* a, void* b) {
	return dvb_device_equal (a, b);
}


static GObject * dvb_device_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBDeviceGroupClass * klass;
	GObjectClass * parent_class;
	DVBDeviceGroup * self;
	klass = DVB_DEVICE_GROUP_CLASS (g_type_class_peek (DVB_TYPE_DEVICE_GROUP));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_DEVICE_GROUP (obj);
	{
		GeeSet* _tmp0;
		_tmp0 = NULL;
		self->priv->devices = (_tmp0 = (GeeSet*) gee_hash_set_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _dvb_device_hash_ghash_func, _dvb_device_equal_gequal_func), (self->priv->devices == NULL) ? NULL : (self->priv->devices = (g_object_unref (self->priv->devices), NULL)), _tmp0);
		gee_collection_add ((GeeCollection*) self->priv->devices, self->priv->_reference_device);
	}
	return obj;
}


static void dvb_device_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDeviceGroup * self;
	gpointer boxed;
	self = DVB_DEVICE_GROUP (object);
	switch (property_id) {
		case DVB_DEVICE_GROUP_SIZE:
		g_value_set_int (value, dvb_device_group_get_size (self));
		break;
		case DVB_DEVICE_GROUP_ID:
		g_value_set_uint (value, dvb_device_group_get_Id (self));
		break;
		case DVB_DEVICE_GROUP_CHANNELS:
		g_value_set_object (value, dvb_device_group_get_Channels (self));
		break;
		case DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_group_get_RecordingsDirectory (self));
		break;
		case DVB_DEVICE_GROUP_TYPE:
		g_value_set_enum (value, dvb_device_group_get_Type (self));
		break;
		case DVB_DEVICE_GROUP_RECORDER:
		g_value_set_object (value, dvb_device_group_get_recorder (self));
		break;
		case DVB_DEVICE_GROUP_EPGSCANNER:
		g_value_set_object (value, dvb_device_group_get_epgscanner (self));
		break;
		case DVB_DEVICE_GROUP_NAME:
		g_value_set_string (value, dvb_device_group_get_Name (self));
		break;
		case DVB_DEVICE_GROUP_REFERENCE_DEVICE:
		g_value_set_object (value, dvb_device_group_get_reference_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDeviceGroup * self;
	self = DVB_DEVICE_GROUP (object);
	switch (property_id) {
		case DVB_DEVICE_GROUP_ID:
		dvb_device_group_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_GROUP_NAME:
		dvb_device_group_set_Name (self, g_value_get_string (value));
		break;
		case DVB_DEVICE_GROUP_REFERENCE_DEVICE:
		dvb_device_group_set_reference_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_group_class_init (DVBDeviceGroupClass * klass) {
	dvb_device_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDeviceGroupPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_device_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_device_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_device_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_RECORDER, g_param_spec_object ("recorder", "recorder", "recorder", DVB_TYPE_RECORDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_EPGSCANNER, g_param_spec_object ("epgscanner", "epgscanner", "epgscanner", DVB_TYPE_EPG_SCANNER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_REFERENCE_DEVICE, g_param_spec_object ("reference-device", "reference-device", "reference-device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_device_group_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_device_group_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = dvb_device_group_real_get_element_type;
	iface->iterator = dvb_device_group_real_iterator;
}


static void dvb_device_group_instance_init (DVBDeviceGroup * self) {
	self->priv = DVB_DEVICE_GROUP_GET_PRIVATE (self);
}


static void dvb_device_group_finalize (GObject* obj) {
	DVBDeviceGroup * self;
	self = DVB_DEVICE_GROUP (obj);
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	(self->priv->_reference_device == NULL) ? NULL : (self->priv->_reference_device = (g_object_unref (self->priv->_reference_device), NULL));
	(self->priv->devices == NULL) ? NULL : (self->priv->devices = (g_object_unref (self->priv->devices), NULL));
	(self->priv->_recorder == NULL) ? NULL : (self->priv->_recorder = (g_object_unref (self->priv->_recorder), NULL));
	(self->priv->_epgscanner == NULL) ? NULL : (self->priv->_epgscanner = (g_object_unref (self->priv->_epgscanner), NULL));
	G_OBJECT_CLASS (dvb_device_group_parent_class)->finalize (obj);
}


GType dvb_device_group_get_type (void) {
	static GType dvb_device_group_type_id = 0;
	if (dvb_device_group_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDeviceGroup), 0, (GInstanceInitFunc) dvb_device_group_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_device_group_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_device_group_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDeviceGroup", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_device_group_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	}
	return dvb_device_group_type_id;
}




