
#ifndef __SRC_SCANNEDITEM_H__
#define __SRC_SCANNEDITEM_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;
typedef struct _DVBScannedItemPrivate DVBScannedItemPrivate;

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;
typedef struct _DVBScannedSatteliteItemPrivate DVBScannedSatteliteItemPrivate;

/**
     * This class represents a frequency and possibly other parameters
     * that are necessary to mark a frequency as scanned
     */
struct _DVBScannedItem {
	GObject parent_instance;
	DVBScannedItemPrivate * priv;
};

struct _DVBScannedItemClass {
	GObjectClass parent_class;
};

struct _DVBScannedSatteliteItem {
	DVBScannedItem parent_instance;
	DVBScannedSatteliteItemPrivate * priv;
};

struct _DVBScannedSatteliteItemClass {
	DVBScannedItemClass parent_class;
};


DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
guint dvb_scanned_item_hash (DVBScannedItem* o);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
GType dvb_scanned_item_get_type (void);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const char* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const char* polarization);
const char* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self);
GType dvb_scanned_sattelite_item_get_type (void);


G_END_DECLS

#endif
