
#include <src/Timer.h>
#include "src/Utils.h"




struct _DVBTimerPrivate {
	guint32 _Id;
	guint _ChannelSid;
	char* _Name;
	guint _Year;
	guint _Month;
	guint _Day;
	guint _Hour;
	guint _Minute;
	guint _Duration;
	struct tm starttime;
};

#define DVB_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TIMER, DVBTimerPrivate))
enum  {
	DVB_TIMER_DUMMY_PROPERTY,
	DVB_TIMER_ID,
	DVB_TIMER_CHANNEL_SID,
	DVB_TIMER_NAME,
	DVB_TIMER_YEAR,
	DVB_TIMER_MONTH,
	DVB_TIMER_DAY,
	DVB_TIMER_HOUR,
	DVB_TIMER_MINUTE,
	DVB_TIMER_DURATION
};
static DVBOverlapType dvb_timer_get_overlap (const time_t* this_start, const time_t* this_end, const time_t* other_start, const time_t* other_end);
static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self);
static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self);
static void dvb_timer_set_Id (DVBTimer* self, guint32 value);
static void dvb_timer_set_ChannelSid (DVBTimer* self, guint value);
static void dvb_timer_set_Name (DVBTimer* self, const char* value);
static void dvb_timer_set_Year (DVBTimer* self, guint value);
static void dvb_timer_set_Month (DVBTimer* self, guint value);
static void dvb_timer_set_Day (DVBTimer* self, guint value);
static void dvb_timer_set_Hour (DVBTimer* self, guint value);
static void dvb_timer_set_Minute (DVBTimer* self, guint value);
static void dvb_timer_set_Duration (DVBTimer* self, guint value);
static GObject * dvb_timer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_timer_parent_class = NULL;
static void dvb_timer_finalize (GObject* obj);



DVBTimer* dvb_timer_construct (GType object_type, guint32 id, guint channel_sid, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name) {
	GParameter * __params;
	GParameter * __params_it;
	DVBTimer * self;
	__params = g_new0 (GParameter, 9);
	__params_it = __params;
	__params_it->name = "Id";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, id);
	__params_it++;
	__params_it->name = "ChannelSid";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, channel_sid);
	__params_it++;
	__params_it->name = "Name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "Year";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, (guint) year);
	__params_it++;
	__params_it->name = "Month";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, (guint) month);
	__params_it++;
	__params_it->name = "Day";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, (guint) day);
	__params_it++;
	__params_it->name = "Hour";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, (guint) hour);
	__params_it++;
	__params_it->name = "Minute";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, (guint) minute);
	__params_it++;
	__params_it->name = "Duration";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, duration);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBTimer* dvb_timer_new (guint32 id, guint channel_sid, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name) {
	return dvb_timer_construct (DVB_TYPE_TIMER, id, channel_sid, year, month, day, hour, minute, duration, name);
}


/**
         * Whether the timer conflicts with the other one
         */
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2) {
	time_t this_start;
	time_t other_start;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t2 != NULL, FALSE);
	this_start = dvb_timer_get_start_time_timestamp (self);
	other_start = dvb_timer_get_start_time_timestamp (t2);
	if (this_start <= other_start) {
		time_t this_end;
		/* No conflict when this timer ends before other starts*/
		this_end = dvb_timer_get_end_time_timestamp (self);
		return this_end > other_start;
	} else {
		time_t other_end;
		/* No conflict when other timer ends before this starts*/
		other_end = dvb_timer_get_end_time_timestamp (t2);
		return other_end > this_start;
	}
}


/**
         * @duration: in minutes
         * @returns: The overlap between the timer and the given time range.
         * The timer is the reference, i.e. if the time range is completely
         * contained in the timer OverlapType.COMPLETE is returned.
         *
         * The given time range must be in local time.
         */
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	time_t this_start;
	time_t this_end;
	struct tm other_time;
	time_t other_start;
	time_t other_end;
	g_return_val_if_fail (self != NULL, 0);
	this_start = dvb_timer_get_start_time_timestamp (self);
	this_end = dvb_timer_get_end_time_timestamp (self);
	other_time = dvb_utils_create_time ((gint) start_year, (gint) start_month, (gint) start_day, (gint) start_hour, (gint) start_minute, 0);
	other_start = mktime (&other_time);
	other_time.tm_min = other_time.tm_min + ((gint) duration);
	other_end = mktime (&other_time);
	return dvb_timer_get_overlap (&this_start, &this_end, &other_start, &other_end);
}


/**
         * Same as get_overlap_local but the given time range is UTC time.
         */
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	time_t this_start;
	time_t this_end;
	struct tm other_time;
	time_t other_start;
	time_t other_end;
	g_return_val_if_fail (self != NULL, 0);
	this_start = dvb_timer_get_start_time_timestamp (self);
	this_end = dvb_timer_get_end_time_timestamp (self);
	other_time = dvb_utils_create_time ((gint) start_year, (gint) start_month, (gint) start_day, (gint) start_hour, (gint) start_minute, 0);
	other_start = timegm (&other_time);
	other_time.tm_min = other_time.tm_min + ((gint) duration);
	other_end = timegm (&other_time);
	return dvb_timer_get_overlap (&this_start, &this_end, &other_start, &other_end);
}


static DVBOverlapType dvb_timer_get_overlap (const time_t* this_start, const time_t* this_end, const time_t* other_start, const time_t* other_end) {
	if ((*this_start) <= (*other_start)) {
		/* No conflict when this timer ends before other starts*/
		if ((*this_end) <= (*other_start)) {
			/* this starts before other and ends before other starts*/
			return DVB_OVERLAP_TYPE_NONE;
		} else {
			if ((*this_end) >= (*other_end)) {
				return DVB_OVERLAP_TYPE_COMPLETE;
			} else {
				return DVB_OVERLAP_TYPE_PARTIAL;
			}
		}
	} else {
		/* No conflict when other timer ends before this starts*/
		if ((*this_end) <= (*other_end)) {
			/* this starts after other and ends before other*/
			return DVB_OVERLAP_TYPE_PARTIAL;
		} else {
			if ((*this_start) < (*other_end)) {
				return DVB_OVERLAP_TYPE_PARTIAL;
			} else {
				return DVB_OVERLAP_TYPE_NONE;
			}
		}
	}
}


guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1) {
	guint* _tmp1;
	gint start_size;
	gint start_length1;
	guint* _tmp0;
	guint* start;
	guint* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	start = (_tmp1 = (_tmp0 = g_new0 (guint, 5), _tmp0[0] = self->priv->_Year, _tmp0[1] = self->priv->_Month, _tmp0[2] = self->priv->_Day, _tmp0[3] = self->priv->_Hour, _tmp0[4] = self->priv->_Minute, _tmp0), start_length1 = 5, start_size = start_length1, _tmp1);
	_tmp2 = NULL;
	return (_tmp2 = start, *result_length1 = start_length1, _tmp2);
}


struct tm dvb_timer_get_start_time_time (DVBTimer* self) {
	return self->priv->starttime;
}


guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1) {
	time_t _tmp1 = {0};
	struct tm _tmp0 = {0};
	struct tm l;
	guint* _tmp2;
	guint* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	l = (localtime_r ((_tmp1 = dvb_timer_get_end_time_timestamp (self), &_tmp1), &_tmp0), _tmp0);
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = g_new0 (guint, 5), _tmp2[0] = (guint) (l.tm_year + 1900), _tmp2[1] = (guint) (l.tm_mon + 1), _tmp2[2] = (guint) l.tm_mday, _tmp2[3] = (guint) l.tm_hour, _tmp2[4] = (guint) l.tm_min, _tmp2), *result_length1 = 5, _tmp3);
}


/**
         * Whether the start time of the timer equals the current local time
         */
gboolean dvb_timer_is_start_due (DVBTimer* self) {
	time_t _tmp2 = {0};
	time_t _tmp0 = {0};
	struct tm _tmp1 = {0};
	struct tm localtime;
	gint year;
	gint month;
	gboolean _tmp3;
	gboolean _tmp4;
	gboolean _tmp5;
	gboolean _tmp6;
	g_return_val_if_fail (self != NULL, FALSE);
	localtime = (localtime_r ((_tmp2 = (time (&_tmp0), _tmp0), &_tmp2), &_tmp1), _tmp1);
	/* Convert to values of struct tm aka Time            */
	year = ((gint) self->priv->_Year) - 1900;
	month = ((gint) self->priv->_Month) - 1;
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (year == localtime.tm_year) {
		_tmp6 = month == localtime.tm_mon;
	} else {
		_tmp6 = FALSE;
	}
	if (_tmp6) {
		_tmp5 = self->priv->_Day == localtime.tm_mday;
	} else {
		_tmp5 = FALSE;
	}
	if (_tmp5) {
		_tmp4 = self->priv->_Hour == localtime.tm_hour;
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		_tmp3 = self->priv->_Minute == localtime.tm_min;
	} else {
		_tmp3 = FALSE;
	}
	return _tmp3;
}


/**
         * Whether the end time of the timer equals the current local time
         */
gboolean dvb_timer_is_end_due (DVBTimer* self) {
	time_t _tmp2 = {0};
	time_t _tmp0 = {0};
	struct tm _tmp1 = {0};
	struct tm localtime;
	time_t _tmp4 = {0};
	struct tm _tmp3 = {0};
	struct tm endtime;
	gboolean _tmp5;
	gboolean _tmp6;
	gboolean _tmp7;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	localtime = (localtime_r ((_tmp2 = (time (&_tmp0), _tmp0), &_tmp2), &_tmp1), _tmp1);
	endtime = (localtime_r ((_tmp4 = dvb_timer_get_end_time_timestamp (self), &_tmp4), &_tmp3), _tmp3);
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	if (endtime.tm_year == localtime.tm_year) {
		_tmp8 = endtime.tm_mon == localtime.tm_mon;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		_tmp7 = endtime.tm_mday == localtime.tm_mday;
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
		_tmp6 = endtime.tm_hour == localtime.tm_hour;
	} else {
		_tmp6 = FALSE;
	}
	if (_tmp6) {
		_tmp5 = endtime.tm_min == localtime.tm_min;
	} else {
		_tmp5 = FALSE;
	}
	return _tmp5;
}


/**
         * Whether the timer ends in the past
         */
gboolean dvb_timer_has_expired (DVBTimer* self) {
	time_t _tmp0 = {0};
	time_t current_time;
	time_t end_time;
	g_return_val_if_fail (self != NULL, FALSE);
	current_time = (time (&_tmp0), _tmp0);
	end_time = dvb_timer_get_end_time_timestamp (self);
	return end_time < current_time;
}


char* dvb_timer_to_string (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_strdup_printf ("channel: %u, start: %u-%u-%u %u:%u, duration: %u", self->priv->_ChannelSid, self->priv->_Year, self->priv->_Month, self->priv->_Day, self->priv->_Hour, self->priv->_Minute, self->priv->_Duration);
}


static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self) {
	struct tm t;
	t = dvb_utils_create_time ((gint) self->priv->_Year, (gint) self->priv->_Month, (gint) self->priv->_Day, (gint) self->priv->_Hour, (gint) self->priv->_Minute, 0);
	/* TODO Do we change the value of this.starttime each time?*/
	t.tm_min = t.tm_min + ((gint) self->priv->_Duration);
	return mktime (&t);
}


static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self) {
	struct tm t;
	t = dvb_timer_get_start_time_time (self);
	return mktime (&t);
}


guint32 dvb_timer_get_Id (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Id;
}


static void dvb_timer_set_Id (DVBTimer* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


guint dvb_timer_get_ChannelSid (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_ChannelSid;
}


static void dvb_timer_set_ChannelSid (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_ChannelSid = value;
	g_object_notify ((GObject *) self, "ChannelSid");
}


const char* dvb_timer_get_Name (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Name;
}


static void dvb_timer_set_Name (DVBTimer* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Name = (g_free (self->priv->_Name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Name");
}


guint dvb_timer_get_Year (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Year;
}


static void dvb_timer_set_Year (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Year = value;
	g_object_notify ((GObject *) self, "Year");
}


guint dvb_timer_get_Month (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Month;
}


static void dvb_timer_set_Month (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Month = value;
	g_object_notify ((GObject *) self, "Month");
}


guint dvb_timer_get_Day (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Day;
}


static void dvb_timer_set_Day (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Day = value;
	g_object_notify ((GObject *) self, "Day");
}


guint dvb_timer_get_Hour (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Hour;
}


static void dvb_timer_set_Hour (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Hour = value;
	g_object_notify ((GObject *) self, "Hour");
}


guint dvb_timer_get_Minute (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Minute;
}


static void dvb_timer_set_Minute (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Minute = value;
	g_object_notify ((GObject *) self, "Minute");
}


guint dvb_timer_get_Duration (DVBTimer* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Duration;
}


static void dvb_timer_set_Duration (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Duration = value;
	g_object_notify ((GObject *) self, "Duration");
}


static GObject * dvb_timer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBTimerClass * klass;
	GObjectClass * parent_class;
	DVBTimer * self;
	klass = DVB_TIMER_CLASS (g_type_class_peek (DVB_TYPE_TIMER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_TIMER (obj);
	{
		self->priv->starttime = dvb_utils_create_time ((gint) self->priv->_Year, (gint) self->priv->_Month, (gint) self->priv->_Day, (gint) self->priv->_Hour, (gint) self->priv->_Minute, 0);
	}
	return obj;
}


static void dvb_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	gpointer boxed;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		g_value_set_uint (value, dvb_timer_get_Id (self));
		break;
		case DVB_TIMER_CHANNEL_SID:
		g_value_set_uint (value, dvb_timer_get_ChannelSid (self));
		break;
		case DVB_TIMER_NAME:
		g_value_set_string (value, dvb_timer_get_Name (self));
		break;
		case DVB_TIMER_YEAR:
		g_value_set_uint (value, dvb_timer_get_Year (self));
		break;
		case DVB_TIMER_MONTH:
		g_value_set_uint (value, dvb_timer_get_Month (self));
		break;
		case DVB_TIMER_DAY:
		g_value_set_uint (value, dvb_timer_get_Day (self));
		break;
		case DVB_TIMER_HOUR:
		g_value_set_uint (value, dvb_timer_get_Hour (self));
		break;
		case DVB_TIMER_MINUTE:
		g_value_set_uint (value, dvb_timer_get_Minute (self));
		break;
		case DVB_TIMER_DURATION:
		g_value_set_uint (value, dvb_timer_get_Duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		dvb_timer_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_CHANNEL_SID:
		dvb_timer_set_ChannelSid (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_NAME:
		dvb_timer_set_Name (self, g_value_get_string (value));
		break;
		case DVB_TIMER_YEAR:
		dvb_timer_set_Year (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_MONTH:
		dvb_timer_set_Month (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_DAY:
		dvb_timer_set_Day (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_HOUR:
		dvb_timer_set_Hour (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_MINUTE:
		dvb_timer_set_Minute (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_DURATION:
		dvb_timer_set_Duration (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_timer_class_init (DVBTimerClass * klass) {
	dvb_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTimerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_timer_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_timer_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_CHANNEL_SID, g_param_spec_uint ("ChannelSid", "ChannelSid", "ChannelSid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_YEAR, g_param_spec_uint ("Year", "Year", "Year", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_MONTH, g_param_spec_uint ("Month", "Month", "Month", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_DAY, g_param_spec_uint ("Day", "Day", "Day", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_HOUR, g_param_spec_uint ("Hour", "Hour", "Hour", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_MINUTE, g_param_spec_uint ("Minute", "Minute", "Minute", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_DURATION, g_param_spec_uint ("Duration", "Duration", "Duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_timer_instance_init (DVBTimer * self) {
	self->priv = DVB_TIMER_GET_PRIVATE (self);
}


static void dvb_timer_finalize (GObject* obj) {
	DVBTimer * self;
	self = DVB_TIMER (obj);
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	G_OBJECT_CLASS (dvb_timer_parent_class)->finalize (obj);
}


GType dvb_timer_get_type (void) {
	static GType dvb_timer_type_id = 0;
	if (dvb_timer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTimer), 0, (GInstanceInitFunc) dvb_timer_instance_init, NULL };
		dvb_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBTimer", &g_define_type_info, 0);
	}
	return dvb_timer_type_id;
}




