
#ifndef __SRC_UTILS_H__
#define __SRC_UTILS_H__

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

G_BEGIN_DECLS



#define DVB_UTILS_BUFFER_SIZE 4096
const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue);
const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
char* dvb_utils_remove_nonalphanums (const char* text);
gint64 dvb_utils_difftime (const struct tm* t1, const struct tm* t2);
struct tm dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second);
struct tm dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);


G_END_DECLS

#endif
