/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_DEVICEGROUP_H__
#define __SRC_DEVICEGROUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "src/Device.h"
#include "src/ChannelList.h"

G_BEGIN_DECLS

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBRecordingThread DVBRecordingThread;
typedef struct _DVBRecordingThreadClass DVBRecordingThreadClass;
typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroupPrivate DVBDeviceGroupPrivate;

/**
     * A group of devices that share the same settings
     * (list of channels, recordings dir)
     */
struct _DVBDeviceGroup {
	GObject parent_instance;
	DVBDeviceGroupPrivate * priv;
};

struct _DVBDeviceGroupClass {
	GObjectClass parent_class;
};


DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_destroy (DVBDeviceGroup* self);
void dvb_device_group_create_and_add_device (DVBDeviceGroup* self, guint adapter, guint frontend);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
const char* dvb_device_group_get_Name (DVBDeviceGroup* self);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const char* value);
DVBDevice* dvb_device_group_get_reference_device (DVBDeviceGroup* self);
GType dvb_device_group_get_type (void);


G_END_DECLS

#endif
