/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_RECORDING_H__
#define __SRC_RECORDING_H__

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
typedef struct _DVBRecordingPrivate DVBRecordingPrivate;

/**
     * This class represents a finished recording
     */
struct _DVBRecording {
	GObject parent_instance;
	DVBRecordingPrivate * priv;
};

struct _DVBRecordingClass {
	GObjectClass parent_class;
};


guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
void dvb_recording_save_to_disk (DVBRecording* self, GError** error);
char* dvb_recording_serialize (DVBRecording* self);
DVBRecording* dvb_recording_deserialize (GFile* file, GError** error);
DVBRecording* dvb_recording_construct (GType object_type);
DVBRecording* dvb_recording_new (void);
guint32 dvb_recording_get_Id (DVBRecording* self);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
void dvb_recording_set_ChannelName (DVBRecording* self, const char* value);
GFile* dvb_recording_get_Location (DVBRecording* self);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
const char* dvb_recording_get_Name (DVBRecording* self);
void dvb_recording_set_Name (DVBRecording* self, const char* value);
const char* dvb_recording_get_Description (DVBRecording* self);
void dvb_recording_set_Description (DVBRecording* self, const char* value);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
GType dvb_recording_get_type (void);


G_END_DECLS

#endif
