/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_SQLITECONFIGTIMERSSTORE_H__
#define __SRC_SQLITECONFIGTIMERSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "src/ConfigStore.h"
#include "src/TimersStore.h"
#include "src/DeviceGroup.h"
#include "src/Device.h"
#include "src/Timer.h"

G_BEGIN_DECLS


#define DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE (dvb_sqlite_config_timers_store_get_type ())
#define DVB_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStore))
#define DVB_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStoreClass))
#define DVB_IS_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_IS_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_SQLITE_CONFIG_TIMERS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStoreClass))

typedef struct _DVBSqliteConfigTimersStore DVBSqliteConfigTimersStore;
typedef struct _DVBSqliteConfigTimersStoreClass DVBSqliteConfigTimersStoreClass;
typedef struct _DVBSqliteConfigTimersStorePrivate DVBSqliteConfigTimersStorePrivate;

struct _DVBSqliteConfigTimersStore {
	GObject parent_instance;
	DVBSqliteConfigTimersStorePrivate * priv;
};

struct _DVBSqliteConfigTimersStoreClass {
	GObjectClass parent_class;
};


gboolean dvb_sqlite_config_timers_store_contains_group (DVBSqliteConfigTimersStore* self, guint group_id);
gboolean dvb_sqlite_config_timers_store_contains_timer (DVBSqliteConfigTimersStore* self, guint timer_id);
DVBSqliteConfigTimersStore* dvb_sqlite_config_timers_store_construct (GType object_type);
DVBSqliteConfigTimersStore* dvb_sqlite_config_timers_store_new (void);
GType dvb_sqlite_config_timers_store_get_type (void);


G_END_DECLS

#endif
