/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/TimersStore.h>







GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->get_all_timers_of_device_group (self, dev);
}


gboolean dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->add_timer_to_device_group (self, timer, dev);
}


gboolean dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->remove_timer_from_device_group (self, timer_id, dev);
}


static void dvb_timers_store_base_init (DVBTimersStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_timers_store_get_type (void) {
	static GType dvb_timers_store_type_id = 0;
	if (dvb_timers_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimersStoreIface), (GBaseInitFunc) dvb_timers_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_timers_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBTimersStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_timers_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_timers_store_type_id;
}




