/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_UTILS_H__
#define __SRC_UTILS_H__

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

G_BEGIN_DECLS



#define DVB_UTILS_BUFFER_SIZE 4096
const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue);
const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
char* dvb_utils_remove_nonalphanums (const char* text);
gint64 dvb_utils_difftime (const struct tm* t1, const struct tm* t2);
struct tm dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second);
struct tm dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);


G_END_DECLS

#endif
