/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_CHANNELLISTWRITER_H__
#define __SRC_CHANNELLISTWRITER_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "src/Channel.h"

G_BEGIN_DECLS


#define DVB_TYPE_CHANNEL_LIST_WRITER (dvb_channel_list_writer_get_type ())
#define DVB_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriter))
#define DVB_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriterClass))
#define DVB_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST_WRITER))
#define DVB_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriterClass))

typedef struct _DVBChannelListWriter DVBChannelListWriter;
typedef struct _DVBChannelListWriterClass DVBChannelListWriterClass;
typedef struct _DVBChannelListWriterPrivate DVBChannelListWriterPrivate;

/**
     * Example:
     * try {
     *     var writer = new DVB.ChannelListWriter (File.new_for_path ("/path/to/channels.conf"));
     *     foreach (DVB.Channel c in reader.Channels) {
     *         writer.write (c);
     *     }
     *     writer.close ();
     * } catch (IOError e) {
     *     error (e.message);
     * }
     */
struct _DVBChannelListWriter {
	GObject parent_instance;
	DVBChannelListWriterPrivate * priv;
};

struct _DVBChannelListWriterClass {
	GObjectClass parent_class;
};


DVBChannelListWriter* dvb_channel_list_writer_construct (GType object_type, GFile* file, GError** error);
DVBChannelListWriter* dvb_channel_list_writer_new (GFile* file, GError** error);
void dvb_channel_list_writer_write (DVBChannelListWriter* self, DVBChannel* channel, GError** error);
gboolean dvb_channel_list_writer_close (DVBChannelListWriter* self, GError** error);
GFile* dvb_channel_list_writer_get_file (DVBChannelListWriter* self);
GType dvb_channel_list_writer_get_type (void);


G_END_DECLS

#endif
