/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_EPGSCANNER_H__
#define __SRC_EPGSCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include "src/DeviceGroup.h"

G_BEGIN_DECLS


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};


DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
void dvb_epg_scanner_destroy (DVBEPGScanner* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
DVBDeviceGroup* dvb_epg_scanner_get_DeviceGroup (DVBEPGScanner* self);
void dvb_epg_scanner_set_DeviceGroup (DVBEPGScanner* self, DVBDeviceGroup* value);
GType dvb_epg_scanner_get_type (void);


G_END_DECLS

#endif
