/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/IDBusRecorder.h>

typedef DBusGProxy DVBIDBusRecorderDBusProxy;
typedef DBusGProxyClass DVBIDBusRecorderDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id);
static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1);
static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id);
static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_recorder_dbus_path_vtable = {_dvb_id_bus_recorder_dbus_unregister, dvb_id_bus_recorder_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_recorder_dbus_vtable = {dvb_id_bus_recorder_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         * 
         * Add a new timer
         */
guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * Works the same way as AddTimer() but adds a margin before and
         * after the timer.
         */
guint32 dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         */
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerForEPGEvent (self, event_id, channel_sid);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->DeleteTimer (self, timer_id);
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         */
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetStartTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Same as dvb_recorder_GetStartTime()
         */
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetEndTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Duration in seconds or 0 if there's no timer with
         * the given id
         */
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetDuration (self, timer_id);
}


/**
         * @timer_id: Timer's id
         * @returns: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         */
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetChannelName (self, timer_id);
}


/**
         * @returns: The currently active timers
         */
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetActiveTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->IsTimerActive (self, timer_id);
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * Checks if a timer overlaps with the given event
         */
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimerForEvent (self, event_id, channel_sid);
}


void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Recorder\">\n  <method name=\"AddTimer\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerWithMargin\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerForEPGEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"DeleteTimer\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetEndTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetActiveTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsTimerActive\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimer\">\n    <arg name=\"start_year\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimerForEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <signal name=\"RecordingStarted\">\n    <arg name=\"timer_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"RecordingFinished\">\n    <arg name=\"recording_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"Changed\">\n    <arg name=\"timer_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.Recorder") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel;
	dbus_uint32_t _tmp1;
	gint start_year;
	dbus_int32_t _tmp2;
	gint start_month;
	dbus_int32_t _tmp3;
	gint start_day;
	dbus_int32_t _tmp4;
	gint start_hour;
	dbus_int32_t _tmp5;
	gint start_minute;
	dbus_int32_t _tmp6;
	guint duration;
	dbus_uint32_t _tmp7;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp8;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uiiiiiu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	channel = _tmp1;
	start_year = 0;
	dbus_message_iter_get_basic (&iter, &_tmp2);
	dbus_message_iter_next (&iter);
	start_year = _tmp2;
	start_month = 0;
	dbus_message_iter_get_basic (&iter, &_tmp3);
	dbus_message_iter_next (&iter);
	start_month = _tmp3;
	start_day = 0;
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	start_day = _tmp4;
	start_hour = 0;
	dbus_message_iter_get_basic (&iter, &_tmp5);
	dbus_message_iter_next (&iter);
	start_hour = _tmp5;
	start_minute = 0;
	dbus_message_iter_get_basic (&iter, &_tmp6);
	dbus_message_iter_next (&iter);
	start_minute = _tmp6;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp7);
	dbus_message_iter_next (&iter);
	duration = _tmp7;
	result = dvb_id_bus_recorder_AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp8 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp8);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel;
	dbus_uint32_t _tmp9;
	gint start_year;
	dbus_int32_t _tmp10;
	gint start_month;
	dbus_int32_t _tmp11;
	gint start_day;
	dbus_int32_t _tmp12;
	gint start_hour;
	dbus_int32_t _tmp13;
	gint start_minute;
	dbus_int32_t _tmp14;
	guint duration;
	dbus_uint32_t _tmp15;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp16;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uiiiiiu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9);
	dbus_message_iter_next (&iter);
	channel = _tmp9;
	start_year = 0;
	dbus_message_iter_get_basic (&iter, &_tmp10);
	dbus_message_iter_next (&iter);
	start_year = _tmp10;
	start_month = 0;
	dbus_message_iter_get_basic (&iter, &_tmp11);
	dbus_message_iter_next (&iter);
	start_month = _tmp11;
	start_day = 0;
	dbus_message_iter_get_basic (&iter, &_tmp12);
	dbus_message_iter_next (&iter);
	start_day = _tmp12;
	start_hour = 0;
	dbus_message_iter_get_basic (&iter, &_tmp13);
	dbus_message_iter_next (&iter);
	start_hour = _tmp13;
	start_minute = 0;
	dbus_message_iter_get_basic (&iter, &_tmp14);
	dbus_message_iter_next (&iter);
	start_minute = _tmp14;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15);
	dbus_message_iter_next (&iter);
	duration = _tmp15;
	result = dvb_id_bus_recorder_AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp16 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp16);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp17;
	guint channel_sid;
	dbus_uint32_t _tmp18;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp19;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17);
	dbus_message_iter_next (&iter);
	event_id = _tmp17;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp18;
	result = dvb_id_bus_recorder_AddTimerForEPGEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp19);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp20;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp21;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20);
	dbus_message_iter_next (&iter);
	timer_id = _tmp20;
	result = dvb_id_bus_recorder_DeleteTimer (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp21);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp22;
	DBusMessageIter _tmp23;
	int _tmp24;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp22 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp23);
	for (_tmp24 = 0; _tmp24 < result_length1; _tmp24++) {
		dbus_uint32_t _tmp25;
		_tmp25 = *_tmp22;
		dbus_message_iter_append_basic (&_tmp23, DBUS_TYPE_UINT32, &_tmp25);
		_tmp22++;
	}
	dbus_message_iter_close_container (&iter, &_tmp23);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp26;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp27;
	DBusMessageIter _tmp28;
	int _tmp29;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26);
	dbus_message_iter_next (&iter);
	timer_id = _tmp26;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetStartTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp27 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp28);
	for (_tmp29 = 0; _tmp29 < result_length1; _tmp29++) {
		dbus_uint32_t _tmp30;
		_tmp30 = *_tmp27;
		dbus_message_iter_append_basic (&_tmp28, DBUS_TYPE_UINT32, &_tmp30);
		_tmp27++;
	}
	dbus_message_iter_close_container (&iter, &_tmp28);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp31;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp32;
	DBusMessageIter _tmp33;
	int _tmp34;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp31);
	dbus_message_iter_next (&iter);
	timer_id = _tmp31;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetEndTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp32 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp33);
	for (_tmp34 = 0; _tmp34 < result_length1; _tmp34++) {
		dbus_uint32_t _tmp35;
		_tmp35 = *_tmp32;
		dbus_message_iter_append_basic (&_tmp33, DBUS_TYPE_UINT32, &_tmp35);
		_tmp32++;
	}
	dbus_message_iter_close_container (&iter, &_tmp33);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp36;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp37;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp36);
	dbus_message_iter_next (&iter);
	timer_id = _tmp36;
	result = dvb_id_bus_recorder_GetDuration (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp37 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp37);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp38;
	char* result;
	DBusMessage* reply;
	const char* _tmp39;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp38);
	dbus_message_iter_next (&iter);
	timer_id = _tmp38;
	result = dvb_id_bus_recorder_GetChannelName (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp39 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp39);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp40;
	DBusMessageIter _tmp41;
	int _tmp42;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetActiveTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp40 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp41);
	for (_tmp42 = 0; _tmp42 < result_length1; _tmp42++) {
		dbus_uint32_t _tmp43;
		_tmp43 = *_tmp40;
		dbus_message_iter_append_basic (&_tmp41, DBUS_TYPE_UINT32, &_tmp43);
		_tmp40++;
	}
	dbus_message_iter_close_container (&iter, &_tmp41);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp44;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp45;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp44);
	dbus_message_iter_next (&iter);
	timer_id = _tmp44;
	result = dvb_id_bus_recorder_IsTimerActive (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp45 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp45);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint start_year;
	dbus_uint32_t _tmp46;
	guint start_month;
	dbus_uint32_t _tmp47;
	guint start_day;
	dbus_uint32_t _tmp48;
	guint start_hour;
	dbus_uint32_t _tmp49;
	guint start_minute;
	dbus_uint32_t _tmp50;
	guint duration;
	dbus_uint32_t _tmp51;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp52;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuuuuu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	start_year = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp46);
	dbus_message_iter_next (&iter);
	start_year = _tmp46;
	start_month = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp47);
	dbus_message_iter_next (&iter);
	start_month = _tmp47;
	start_day = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp48);
	dbus_message_iter_next (&iter);
	start_day = _tmp48;
	start_hour = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp49);
	dbus_message_iter_next (&iter);
	start_hour = _tmp49;
	start_minute = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp50);
	dbus_message_iter_next (&iter);
	start_minute = _tmp50;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp51);
	dbus_message_iter_next (&iter);
	duration = _tmp51;
	result = dvb_id_bus_recorder_HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp52 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp52);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp53;
	guint channel_sid;
	dbus_uint32_t _tmp54;
	DVBOverlapType result;
	DBusMessage* reply;
	dbus_int32_t _tmp55;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp53);
	dbus_message_iter_next (&iter);
	event_id = _tmp53;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp54);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp54;
	result = dvb_id_bus_recorder_HasTimerForEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp55 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT32, &_tmp55);
	return reply;
}


DBusHandlerResult dvb_id_bus_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_recorder_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_recorder_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimer")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimerWithMargin")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimerWithMargin (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimerForEPGEvent")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "DeleteTimer")) {
		reply = _dbus_dvb_id_bus_recorder_DeleteTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetStartTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetEndTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetEndTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetDuration")) {
		reply = _dbus_dvb_id_bus_recorder_GetDuration (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_recorder_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetActiveTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetActiveTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "IsTimerActive")) {
		reply = _dbus_dvb_id_bus_recorder_IsTimerActive (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimer")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimerForEvent")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimerForEvent (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp56;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingStarted");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp56 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp56);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp57;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingFinished");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp57 = recording_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp57);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp58;
	dbus_uint32_t _tmp59;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp58 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp58);
	_tmp59 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp59);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_recorder_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "recording-started", (GCallback) _dbus_dvb_id_bus_recorder_recording_started, connection);
	g_signal_connect (object, "recording-finished", (GCallback) _dbus_dvb_id_bus_recorder_recording_finished, connection);
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recorder_changed, connection);
}


static void dvb_id_bus_recorder_base_init (DVBIDBusRecorderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("recording_started", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("recording_finished", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_RECORDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_recorder_dbus_vtable));
	}
}


GType dvb_id_bus_recorder_get_type (void) {
	static GType dvb_id_bus_recorder_type_id = 0;
	if (dvb_id_bus_recorder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecorderIface), (GBaseInitFunc) dvb_id_bus_recorder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recorder_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecorder", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recorder_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_recorder_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecorderDBusProxy, dvb_id_bus_recorder_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDER, dvb_id_bus_recorder_dbus_proxy_interface_init));
DVBIDBusRecorder* dvb_id_bus_recorder_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusRecorder* self;
	char* filter;
	self = g_object_new (dvb_id_bus_recorder_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Recorder", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp60;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp60);
	dbus_message_iter_next (&iter);
	timer_id = _tmp60;
	g_signal_emit_by_name (self, "recording-started", timer_id);
}


static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 recording_id;
	dbus_uint32_t _tmp61;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	recording_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp61);
	dbus_message_iter_next (&iter);
	recording_id = _tmp61;
	g_signal_emit_by_name (self, "recording-finished", recording_id);
}


static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp62;
	guint type;
	dbus_uint32_t _tmp63;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp62);
	dbus_message_iter_next (&iter);
	timer_id = _tmp62;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp63);
	dbus_message_iter_next (&iter);
	type = _tmp63;
	g_signal_emit_by_name (self, "changed", timer_id, type);
}


DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingStarted")) {
			_dbus_handle_dvb_id_bus_recorder_recording_started (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingFinished")) {
			_dbus_handle_dvb_id_bus_recorder_recording_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "Changed")) {
			_dbus_handle_dvb_id_bus_recorder_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_recorder_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_recorder_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_recorder_dbus_proxy_class_init (DVBIDBusRecorderDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_recorder_dbus_proxy_dispose;
}


static void dvb_id_bus_recorder_dbus_proxy_init (DVBIDBusRecorderDBusProxy* self) {
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp64;
	dbus_int32_t _tmp65;
	dbus_int32_t _tmp66;
	dbus_int32_t _tmp67;
	dbus_int32_t _tmp68;
	dbus_int32_t _tmp69;
	dbus_uint32_t _tmp70;
	guint32 _result;
	dbus_uint32_t _tmp71;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64 = channel;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp64);
	_tmp65 = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp65);
	_tmp66 = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp66);
	_tmp67 = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp67);
	_tmp68 = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp68);
	_tmp69 = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp69);
	_tmp70 = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp70);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp71);
	dbus_message_iter_next (&_iter);
	_result = _tmp71;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp72;
	dbus_int32_t _tmp73;
	dbus_int32_t _tmp74;
	dbus_int32_t _tmp75;
	dbus_int32_t _tmp76;
	dbus_int32_t _tmp77;
	dbus_uint32_t _tmp78;
	guint32 _result;
	dbus_uint32_t _tmp79;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimerWithMargin");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72 = channel;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp72);
	_tmp73 = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp73);
	_tmp74 = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp74);
	_tmp75 = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp75);
	_tmp76 = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp76);
	_tmp77 = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp77);
	_tmp78 = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp78);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp79);
	dbus_message_iter_next (&_iter);
	_result = _tmp79;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp80;
	dbus_uint32_t _tmp81;
	guint32 _result;
	dbus_uint32_t _tmp82;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimerForEPGEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp80 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp80);
	_tmp81 = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp81);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp82);
	dbus_message_iter_next (&_iter);
	_result = _tmp82;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp83;
	gboolean _result;
	dbus_bool_t _tmp84;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "DeleteTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp83 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp83);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp84);
	dbus_message_iter_next (&_iter);
	_result = _tmp84;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp85;
	int _tmp85_length;
	int _tmp85_size;
	int _tmp85_length1;
	DBusMessageIter _tmp86;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp85 = g_new (guint32, 5);
	_tmp85_length = 0;
	_tmp85_size = 4;
	_tmp85_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp86);
	for (; dbus_message_iter_get_arg_type (&_tmp86); _tmp85_length1++) {
		dbus_uint32_t _tmp87;
		if (_tmp85_size == _tmp85_length) {
			_tmp85_size = 2 * _tmp85_size;
			_tmp85 = g_renew (guint32, _tmp85, _tmp85_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp86, &_tmp87);
		dbus_message_iter_next (&_tmp86);
		_tmp85[_tmp85_length++] = _tmp87;
	}
	_result_length1 = _tmp85_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp85;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp88;
	guint32* _result;
	int _result_length1;
	guint32* _tmp89;
	int _tmp89_length;
	int _tmp89_size;
	int _tmp89_length1;
	DBusMessageIter _tmp90;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp88 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp88);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp89 = g_new (guint32, 5);
	_tmp89_length = 0;
	_tmp89_size = 4;
	_tmp89_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp90);
	for (; dbus_message_iter_get_arg_type (&_tmp90); _tmp89_length1++) {
		dbus_uint32_t _tmp91;
		if (_tmp89_size == _tmp89_length) {
			_tmp89_size = 2 * _tmp89_size;
			_tmp89 = g_renew (guint32, _tmp89, _tmp89_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp90, &_tmp91);
		dbus_message_iter_next (&_tmp90);
		_tmp89[_tmp89_length++] = _tmp91;
	}
	_result_length1 = _tmp89_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp89;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp92;
	guint* _result;
	int _result_length1;
	guint* _tmp93;
	int _tmp93_length;
	int _tmp93_size;
	int _tmp93_length1;
	DBusMessageIter _tmp94;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetEndTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp92 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp92);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp93 = g_new (guint, 5);
	_tmp93_length = 0;
	_tmp93_size = 4;
	_tmp93_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp94);
	for (; dbus_message_iter_get_arg_type (&_tmp94); _tmp93_length1++) {
		dbus_uint32_t _tmp95;
		if (_tmp93_size == _tmp93_length) {
			_tmp93_size = 2 * _tmp93_size;
			_tmp93 = g_renew (guint, _tmp93, _tmp93_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp94, &_tmp95);
		dbus_message_iter_next (&_tmp94);
		_tmp93[_tmp93_length++] = _tmp95;
	}
	_result_length1 = _tmp93_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp93;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp96;
	guint _result;
	dbus_uint32_t _tmp97;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetDuration");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp96 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp96);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp97);
	dbus_message_iter_next (&_iter);
	_result = _tmp97;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp98;
	char* _result;
	const char* _tmp99;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp98 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp98);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp99);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp99);
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp100;
	int _tmp100_length;
	int _tmp100_size;
	int _tmp100_length1;
	DBusMessageIter _tmp101;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetActiveTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp100 = g_new (guint32, 5);
	_tmp100_length = 0;
	_tmp100_size = 4;
	_tmp100_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp101);
	for (; dbus_message_iter_get_arg_type (&_tmp101); _tmp100_length1++) {
		dbus_uint32_t _tmp102;
		if (_tmp100_size == _tmp100_length) {
			_tmp100_size = 2 * _tmp100_size;
			_tmp100 = g_renew (guint32, _tmp100, _tmp100_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp101, &_tmp102);
		dbus_message_iter_next (&_tmp101);
		_tmp100[_tmp100_length++] = _tmp102;
	}
	_result_length1 = _tmp100_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp100;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp103;
	gboolean _result;
	dbus_bool_t _tmp104;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "IsTimerActive");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp103 = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp103);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp104);
	dbus_message_iter_next (&_iter);
	_result = _tmp104;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp105;
	dbus_uint32_t _tmp106;
	dbus_uint32_t _tmp107;
	dbus_uint32_t _tmp108;
	dbus_uint32_t _tmp109;
	dbus_uint32_t _tmp110;
	gboolean _result;
	dbus_bool_t _tmp111;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp105 = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp105);
	_tmp106 = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp106);
	_tmp107 = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp107);
	_tmp108 = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp108);
	_tmp109 = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp109);
	_tmp110 = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp110);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp111);
	dbus_message_iter_next (&_iter);
	_result = _tmp111;
	dbus_message_unref (_reply);
	return _result;
}


static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp112;
	dbus_uint32_t _tmp113;
	DVBOverlapType _result;
	dbus_int32_t _tmp114;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimerForEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp112 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp112);
	_tmp113 = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp113);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp114);
	dbus_message_iter_next (&_iter);
	_result = _tmp114;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface) {
	iface->AddTimer = dvb_id_bus_recorder_dbus_proxy_AddTimer;
	iface->AddTimerWithMargin = dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_id_bus_recorder_dbus_proxy_DeleteTimer;
	iface->GetTimers = dvb_id_bus_recorder_dbus_proxy_GetTimers;
	iface->GetStartTime = dvb_id_bus_recorder_dbus_proxy_GetStartTime;
	iface->GetEndTime = dvb_id_bus_recorder_dbus_proxy_GetEndTime;
	iface->GetDuration = dvb_id_bus_recorder_dbus_proxy_GetDuration;
	iface->GetChannelName = dvb_id_bus_recorder_dbus_proxy_GetChannelName;
	iface->GetActiveTimers = dvb_id_bus_recorder_dbus_proxy_GetActiveTimers;
	iface->IsTimerActive = dvb_id_bus_recorder_dbus_proxy_IsTimerActive;
	iface->HasTimer = dvb_id_bus_recorder_dbus_proxy_HasTimer;
	iface->HasTimerForEvent = dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



