/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/Channel.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/collection.h>
#include <gee/arraylist.h>
#include "src/Schedule.h"




struct _DVBChannelPrivate {
	guint _GroupId;
	char* _Name;
	guint _TransportStreamId;
	char* _Network;
	guint* _LogicalChannelNumber;
	guint _VideoPID;
	GeeList* _AudioPIDs;
	guint _Frequency;
	gboolean _Scrambled;
	DVBSchedule* schedule;
	guint sid;
};

#define DVB_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL, DVBChannelPrivate))
enum  {
	DVB_CHANNEL_DUMMY_PROPERTY,
	DVB_CHANNEL_SID,
	DVB_CHANNEL_GROUP_ID,
	DVB_CHANNEL_NAME,
	DVB_CHANNEL_TRANSPORT_STREAM_ID,
	DVB_CHANNEL_NETWORK,
	DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER,
	DVB_CHANNEL_VIDEO_PID,
	DVB_CHANNEL_AUDIO_PI_DS,
	DVB_CHANNEL_FREQUENCY,
	DVB_CHANNEL_SCRAMBLED,
	DVB_CHANNEL_SCHEDULE
};
static gboolean dvb_channel_real_is_valid (DVBChannel* self);
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel);
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source);
static char* dvb_channel_real_to_string (DVBChannel* self);
static guint* _uint_dup (guint* self);
static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_channel_parent_class = NULL;
static void dvb_channel_finalize (GObject* obj);



char* dvb_channel_get_audio_pids_string (DVBChannel* self) {
	GString* apids;
	gint i;
	const char* _tmp2;
	char* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	apids = g_string_new ("");
	i = 1;
	{
		GeeIterator* _pid_it;
		_pid_it = gee_iterable_iterator ((GeeIterable*) self->priv->_AudioPIDs);
		while (gee_iterator_next (_pid_it)) {
			guint pid;
			pid = GPOINTER_TO_UINT (gee_iterator_get (_pid_it));
			if (i == gee_collection_get_size ((GeeCollection*) self->priv->_AudioPIDs)) {
				char* _tmp0;
				_tmp0 = NULL;
				g_string_append (apids, _tmp0 = g_strdup_printf ("%u", pid));
				_tmp0 = (g_free (_tmp0), NULL);
			} else {
				char* _tmp1;
				_tmp1 = NULL;
				g_string_append (apids, _tmp1 = g_strdup_printf ("%u,", pid));
				_tmp1 = (g_free (_tmp1), NULL);
			}
			i++;
		}
		(_pid_it == NULL) ? NULL : (_pid_it = (g_object_unref (_pid_it), NULL));
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = apids->str, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), (apids == NULL) ? NULL : (apids = (g_string_free (apids, TRUE), NULL)), _tmp3);
}


static gboolean dvb_channel_real_is_valid (DVBChannel* self) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (self->priv->_Name != NULL) {
		_tmp2 = self->priv->_Frequency != 0;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		_tmp1 = dvb_channel_get_Sid (self) != 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		gboolean _tmp3;
		_tmp3 = FALSE;
		if (self->priv->_VideoPID != 0) {
			_tmp3 = TRUE;
		} else {
			_tmp3 = gee_collection_get_size ((GeeCollection*) self->priv->_AudioPIDs) != 0;
		}
		_tmp0 = _tmp3;
	} else {
		_tmp0 = FALSE;
	}
	return _tmp0;
}


gboolean dvb_channel_is_valid (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->is_valid (self);
}


/**
         * @returns: TRUE if both channels are part of the same
         * transport stream (TS).
         *
         * Channels that are part of the same TS can be viewed/recorded
         * at the same time with a single device.
         */
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	return self->priv->_Frequency == channel->priv->_Frequency;
}


gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	return DVB_CHANNEL_GET_CLASS (self)->on_same_transport_stream (self, channel);
}


/**
         * @returns: TRUE of both channels are identical
         */
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	return self->priv->sid == dvb_channel_get_Sid (channel);
}


gboolean dvb_channel_equals (DVBChannel* self, DVBChannel* channel) {
	return DVB_CHANNEL_GET_CLASS (self)->equals (self, channel);
}


static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_setup_dvb_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


/**
         * @source: Either dvbbasebin or dvbsrc
         *
         * Set properties of source so that the channel can be watched
         */
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source) {
	DVB_CHANNEL_GET_CLASS (self)->setup_dvb_source (self, source);
}


static char* dvb_channel_real_to_string (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* dvb_channel_to_string (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->to_string (self);
}


guint dvb_channel_get_Sid (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->sid;
}


void dvb_channel_set_Sid (DVBChannel* self, guint value) {
	DVBSchedule* _tmp1;
	g_return_if_fail (self != NULL);
	self->priv->sid = value;
	_tmp1 = NULL;
	self->priv->schedule = (_tmp1 = dvb_schedule_new (self), (self->priv->schedule == NULL) ? NULL : (self->priv->schedule = (g_object_unref (self->priv->schedule), NULL)), _tmp1);
	g_object_notify ((GObject *) self, "Sid");
}


guint dvb_channel_get_GroupId (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_GroupId;
}


void dvb_channel_set_GroupId (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_GroupId = value;
	g_object_notify ((GObject *) self, "GroupId");
}


const char* dvb_channel_get_Name (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Name;
}


void dvb_channel_set_Name (DVBChannel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Name = (g_free (self->priv->_Name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Name");
}


guint dvb_channel_get_TransportStreamId (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_TransportStreamId;
}


void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_TransportStreamId = value;
	g_object_notify ((GObject *) self, "TransportStreamId");
}


const char* dvb_channel_get_Network (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Network;
}


void dvb_channel_set_Network (DVBChannel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Network = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Network = (g_free (self->priv->_Network), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Network");
}


guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_LogicalChannelNumber;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value) {
	guint* _tmp2;
	guint* _tmp1;
	g_return_if_fail (self != NULL);
	self->priv->_LogicalChannelNumber = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : _uint_dup (_tmp1)), (self->priv->_LogicalChannelNumber == NULL) ? NULL : (self->priv->_LogicalChannelNumber = (g_free (self->priv->_LogicalChannelNumber), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "LogicalChannelNumber");
}


guint dvb_channel_get_VideoPID (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_VideoPID;
}


void dvb_channel_set_VideoPID (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_VideoPID = value;
	g_object_notify ((GObject *) self, "VideoPID");
}


GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_AudioPIDs;
}


void dvb_channel_set_AudioPIDs (DVBChannel* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_AudioPIDs = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_AudioPIDs == NULL) ? NULL : (self->priv->_AudioPIDs = (g_object_unref (self->priv->_AudioPIDs), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "AudioPIDs");
}


guint dvb_channel_get_Frequency (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Frequency;
}


void dvb_channel_set_Frequency (DVBChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frequency = value;
	g_object_notify ((GObject *) self, "Frequency");
}


gboolean dvb_channel_get_Scrambled (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_Scrambled;
}


void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_Scrambled = value;
	g_object_notify ((GObject *) self, "Scrambled");
}


DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->schedule;
}


static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBChannelClass * klass;
	GObjectClass * parent_class;
	DVBChannel * self;
	klass = DVB_CHANNEL_CLASS (g_type_class_peek (DVB_TYPE_CHANNEL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL (obj);
	{
		GeeArrayList* _tmp0;
		_tmp0 = NULL;
		dvb_channel_set_AudioPIDs (self, (GeeList*) (_tmp0 = gee_array_list_new (G_TYPE_UINT, NULL, NULL, g_direct_equal)));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
	}
	return obj;
}


static void dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	gpointer boxed;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		g_value_set_uint (value, dvb_channel_get_Sid (self));
		break;
		case DVB_CHANNEL_GROUP_ID:
		g_value_set_uint (value, dvb_channel_get_GroupId (self));
		break;
		case DVB_CHANNEL_NAME:
		g_value_set_string (value, dvb_channel_get_Name (self));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		g_value_set_uint (value, dvb_channel_get_TransportStreamId (self));
		break;
		case DVB_CHANNEL_NETWORK:
		g_value_set_string (value, dvb_channel_get_Network (self));
		break;
		case DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER:
		g_value_set_uint (value, dvb_channel_get_LogicalChannelNumber (self));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		g_value_set_uint (value, dvb_channel_get_VideoPID (self));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		g_value_set_object (value, dvb_channel_get_AudioPIDs (self));
		break;
		case DVB_CHANNEL_FREQUENCY:
		g_value_set_uint (value, dvb_channel_get_Frequency (self));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		g_value_set_boolean (value, dvb_channel_get_Scrambled (self));
		break;
		case DVB_CHANNEL_SCHEDULE:
		g_value_set_object (value, dvb_channel_get_Schedule (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		dvb_channel_set_Sid (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_GROUP_ID:
		dvb_channel_set_GroupId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NAME:
		dvb_channel_set_Name (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		dvb_channel_set_TransportStreamId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NETWORK:
		dvb_channel_set_Network (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER:
		dvb_channel_set_LogicalChannelNumber (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		dvb_channel_set_VideoPID (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		dvb_channel_set_AudioPIDs (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_FREQUENCY:
		dvb_channel_set_Frequency (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		dvb_channel_set_Scrambled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_class_init (DVBChannelClass * klass) {
	dvb_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_finalize;
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->on_same_transport_stream = dvb_channel_real_on_same_transport_stream;
	DVB_CHANNEL_CLASS (klass)->equals = dvb_channel_real_equals;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_channel_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SID, g_param_spec_uint ("Sid", "Sid", "Sid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_TRANSPORT_STREAM_ID, g_param_spec_uint ("TransportStreamId", "TransportStreamId", "TransportStreamId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NETWORK, g_param_spec_string ("Network", "Network", "Network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER, g_param_spec_uint ("LogicalChannelNumber", "LogicalChannelNumber", "LogicalChannelNumber", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_VIDEO_PID, g_param_spec_uint ("VideoPID", "VideoPID", "VideoPID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_AUDIO_PI_DS, g_param_spec_object ("AudioPIDs", "AudioPIDs", "AudioPIDs", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCRAMBLED, g_param_spec_boolean ("Scrambled", "Scrambled", "Scrambled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCHEDULE, g_param_spec_object ("Schedule", "Schedule", "Schedule", DVB_TYPE_SCHEDULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dvb_channel_instance_init (DVBChannel * self) {
	self->priv = DVB_CHANNEL_GET_PRIVATE (self);
}


static void dvb_channel_finalize (GObject* obj) {
	DVBChannel * self;
	self = DVB_CHANNEL (obj);
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	self->priv->_Network = (g_free (self->priv->_Network), NULL);
	(self->priv->_LogicalChannelNumber == NULL) ? NULL : (self->priv->_LogicalChannelNumber = (g_free (self->priv->_LogicalChannelNumber), NULL));
	(self->priv->_AudioPIDs == NULL) ? NULL : (self->priv->_AudioPIDs = (g_object_unref (self->priv->_AudioPIDs), NULL));
	(self->priv->schedule == NULL) ? NULL : (self->priv->schedule = (g_object_unref (self->priv->schedule), NULL));
	G_OBJECT_CLASS (dvb_channel_parent_class)->finalize (obj);
}


GType dvb_channel_get_type (void) {
	static GType dvb_channel_type_id = 0;
	if (dvb_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannel), 0, (GInstanceInitFunc) dvb_channel_instance_init, NULL };
		dvb_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return dvb_channel_type_id;
}




