/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_IDBUSCHANNELLIST_H__
#define __SRC_IDBUSCHANNELLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1);
	char* (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id);
	char* (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id);
	char* (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id);
};


guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
char* dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id);
void dvb_id_bus_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_channel_list_get_type (void);
DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);


G_END_DECLS

#endif
