/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_IDBUSRECORDER_H__
#define __SRC_IDBUSRECORDER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/OverlapType.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	guint32 (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
	guint32 (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
	guint32 (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1);
	guint32* (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
	guint* (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
	guint (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id);
	char* (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
};


guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
guint32 dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id);
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1);
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id);
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id);
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id);
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
void dvb_id_bus_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_recorder_get_type (void);
DVBIDBusRecorder* dvb_id_bus_recorder_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);


G_END_DECLS

#endif
