/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/Settings.h>




struct _DVBSettingsPrivate {
	GKeyFile* keyfile;
};

#define DVB_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SETTINGS, DVBSettingsPrivate))
enum  {
	DVB_SETTINGS_DUMMY_PROPERTY
};
#define DVB_SETTINGS_DEFAULT_SETTINGS "[timers]\n        margin_start=5\n        margin_end=5\n        [epg]\n        scan_interval=30"
static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_settings_parent_class = NULL;
static void dvb_settings_finalize (GObject* obj);



GFile* dvb_settings_get_settings_file (DVBSettings* self) {
	GFile* config_dir;
	GFile* our_config;
	GFile* settings_file;
	GFile* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	config_dir = g_file_new_for_path (g_get_user_config_dir ());
	our_config = g_file_get_child (config_dir, "gnome-dvb-daemon");
	settings_file = g_file_get_child (our_config, "settings.ini");
	_tmp0 = NULL;
	return (_tmp0 = settings_file, (config_dir == NULL) ? NULL : (config_dir = (g_object_unref (config_dir), NULL)), (our_config == NULL) ? NULL : (our_config = (g_object_unref (our_config), NULL)), _tmp0);
}


gboolean dvb_settings_load (DVBSettings* self) {
	GError * inner_error;
	GFile* settings_file;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	settings_file = dvb_settings_get_settings_file (self);
	if (!g_file_query_exists (settings_file, NULL)) {
		GFileOutputStream* stream;
		stream = NULL;
		{
			GFileOutputStream* _tmp0;
			GFileOutputStream* _tmp1;
			_tmp0 = g_file_create (settings_file, 0, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch25_g_error;
				goto __finally25;
			}
			_tmp1 = NULL;
			stream = (_tmp1 = _tmp0, (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), _tmp1);
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				char* _tmp2;
				gboolean _tmp3;
				_tmp2 = NULL;
				g_critical ("Settings.vala:63: Could not create file %s: %s", _tmp2 = g_file_get_path (settings_file), e->message);
				_tmp2 = (g_free (_tmp2), NULL);
				return (_tmp3 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), _tmp3);
			}
		}
		__finally25:
		if (inner_error != NULL) {
			(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
			(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		{
			g_output_stream_write ((GOutputStream*) stream, DVB_SETTINGS_DEFAULT_SETTINGS, (gsize) strlen (DVB_SETTINGS_DEFAULT_SETTINGS), NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch26_g_error;
				goto __finally26;
			}
		}
		goto __finally26;
		__catch26_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				char* _tmp4;
				gboolean _tmp5;
				_tmp4 = NULL;
				g_critical ("Settings.vala:71: Could not write to file %s: %s", _tmp4 = g_file_get_path (settings_file), e->message);
				_tmp4 = (g_free (_tmp4), NULL);
				g_output_stream_close ((GOutputStream*) stream, NULL, &inner_error);
				if (inner_error != NULL) {
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
					(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
					(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return FALSE;
				}
				return (_tmp5 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), _tmp5);
			}
		}
		__finally26:
		if (inner_error != NULL) {
			(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
			(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		{
			g_output_stream_close ((GOutputStream*) stream, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch27_g_error;
				goto __finally27;
			}
		}
		goto __finally27;
		__catch27_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_critical ("Settings.vala:80: %s", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally27:
		if (inner_error != NULL) {
			(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
			(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
	}
	{
		char* _tmp6;
		_tmp6 = NULL;
		g_key_file_load_from_file (self->priv->keyfile, _tmp6 = g_file_get_path (settings_file), 0, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch28_g_key_file_error;
			}
			goto __finally28;
		}
		_tmp6 = (g_free (_tmp6), NULL);
	}
	goto __finally28;
	__catch28_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp7;
			g_critical ("Settings.vala:87: Could not load settings: %s", e->message);
			return (_tmp7 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), _tmp7);
		}
	}
	__finally28:
	if (inner_error != NULL) {
		(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return (_tmp8 = TRUE, (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), _tmp8);
}


gboolean dvb_settings_save (DVBSettings* self) {
	GError * inner_error;
	GFile* settings_file;
	GFileOutputStream* stream;
	char* data;
	gsize data_len;
	gboolean _tmp9;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	settings_file = dvb_settings_get_settings_file (self);
	stream = NULL;
	{
		GFileOutputStream* _tmp0;
		GFileOutputStream* _tmp1;
		_tmp0 = g_file_replace (settings_file, NULL, TRUE, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch29_g_error;
			goto __finally29;
		}
		_tmp1 = NULL;
		stream = (_tmp1 = _tmp0, (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), _tmp1);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp2;
			gboolean _tmp3;
			_tmp2 = NULL;
			g_critical ("Settings.vala:101: Could not replace file %s: %s", _tmp2 = g_file_get_path (settings_file), e->message);
			_tmp2 = (g_free (_tmp2), NULL);
			return (_tmp3 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), _tmp3);
		}
	}
	__finally29:
	if (inner_error != NULL) {
		(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	data = NULL;
	data_len = 0UL;
	{
		char* _tmp4;
		char* _tmp5;
		_tmp4 = g_key_file_to_data (self->priv->keyfile, &data_len, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch30_g_key_file_error;
			}
			goto __finally30;
		}
		_tmp5 = NULL;
		data = (_tmp5 = _tmp4, data = (g_free (data), NULL), _tmp5);
	}
	goto __finally30;
	__catch30_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp6;
			/* Never happens*/
			return (_tmp6 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), data = (g_free (data), NULL), _tmp6);
		}
	}
	__finally30:
	if (inner_error != NULL) {
		(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		data = (g_free (data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	{
		g_output_stream_write ((GOutputStream*) stream, data, data_len, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch31_g_error;
			goto __finally31;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp7;
			gboolean _tmp8;
			_tmp7 = NULL;
			g_critical ("Settings.vala:118: Could not write to file %s: %s", _tmp7 = g_file_get_path (settings_file), e->message);
			_tmp7 = (g_free (_tmp7), NULL);
			g_output_stream_close ((GOutputStream*) stream, NULL, &inner_error);
			if (inner_error != NULL) {
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
				(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
				data = (g_free (data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
				return FALSE;
			}
			return (_tmp8 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), data = (g_free (data), NULL), _tmp8);
		}
	}
	__finally31:
	if (inner_error != NULL) {
		(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		data = (g_free (data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	{
		g_output_stream_close ((GOutputStream*) stream, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch32_g_error;
			goto __finally32;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical ("Settings.vala:128: %s", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally32:
	if (inner_error != NULL) {
		(settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		data = (g_free (data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return (_tmp9 = FALSE, (settings_file == NULL) ? NULL : (settings_file = (g_object_unref (settings_file), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), data = (g_free (data), NULL), _tmp9);
}


char* dvb_settings_get_string (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	GError * inner_error;
	char* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	_tmp0 = g_key_file_get_string (self->priv->keyfile, group_name, key, &inner_error);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	return _tmp0;
}


gboolean dvb_settings_get_boolean (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	GError * inner_error;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	inner_error = NULL;
	_tmp0 = g_key_file_get_boolean (self->priv->keyfile, group_name, key, &inner_error);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
	}
	return _tmp0;
}


gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	GError * inner_error;
	gint _tmp0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	inner_error = NULL;
	_tmp0 = g_key_file_get_integer (self->priv->keyfile, group_name, key, &inner_error);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return 0;
		}
	}
	return _tmp0;
}


double dvb_settings_get_double (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	GError * inner_error;
	double _tmp0;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (group_name != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	inner_error = NULL;
	_tmp0 = g_key_file_get_double (self->priv->keyfile, group_name, key, &inner_error);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return 0.0;
		}
	}
	return _tmp0;
}


char** dvb_settings_get_string_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	GError * inner_error;
	char** _tmp2;
	gint _tmp1_size;
	gint _tmp1_length1;
	gint _tmp0;
	char** _tmp1;
	char** _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = (_tmp2 = g_key_file_get_string_list (self->priv->keyfile, group_name, key, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = _tmp1, *result_length1 = _tmp1_length1, _tmp3);
}


gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	GError * inner_error;
	gboolean* _tmp2;
	gint _tmp1_size;
	gint _tmp1_length1;
	gint _tmp0;
	gboolean* _tmp1;
	gboolean* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = (_tmp2 = g_key_file_get_boolean_list (self->priv->keyfile, group_name, key, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = _tmp1, *result_length1 = _tmp1_length1, _tmp3);
}


gint* dvb_settings_get_integer_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	GError * inner_error;
	gint* _tmp2;
	gint _tmp1_size;
	gint _tmp1_length1;
	gint _tmp0;
	gint* _tmp1;
	gint* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = (_tmp2 = g_key_file_get_integer_list (self->priv->keyfile, group_name, key, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = _tmp1, *result_length1 = _tmp1_length1, _tmp3);
}


double* dvb_settings_get_double_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	GError * inner_error;
	double* _tmp2;
	gint _tmp1_size;
	gint _tmp1_length1;
	gint _tmp0;
	double* _tmp1;
	double* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = (_tmp2 = g_key_file_get_double_list (self->priv->keyfile, group_name, key, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
	if (inner_error != NULL) {
		if (inner_error->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, inner_error);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = _tmp1, *result_length1 = _tmp1_length1, _tmp3);
}


void dvb_settings_set_string (DVBSettings* self, const char* group_name, const char* key, const char* val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	g_key_file_set_string (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_boolean (DVBSettings* self, const char* group_name, const char* key, gboolean val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_double (DVBSettings* self, const char* group_name, const char* key, double val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_integer (DVBSettings* self, const char* group_name, const char* key, gint val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_string_list (DVBSettings* self, const char* group_name, const char* key, char** val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_string_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_boolean_list (DVBSettings* self, const char* group_name, const char* key, gboolean* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_double_list (DVBSettings* self, const char* group_name, const char* key, double* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_integer_list (DVBSettings* self, const char* group_name, const char* key, gint* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer_list (self->priv->keyfile, group_name, key, val, val_length1);
}


DVBSettings* dvb_settings_construct (GType object_type) {
	DVBSettings * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBSettings* dvb_settings_new (void) {
	return dvb_settings_construct (DVB_TYPE_SETTINGS);
}


static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBSettingsClass * klass;
	GObjectClass * parent_class;
	DVBSettings * self;
	klass = DVB_SETTINGS_CLASS (g_type_class_peek (DVB_TYPE_SETTINGS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SETTINGS (obj);
	{
		GKeyFile* _tmp0;
		_tmp0 = NULL;
		self->priv->keyfile = (_tmp0 = g_key_file_new (), (self->priv->keyfile == NULL) ? NULL : (self->priv->keyfile = (g_key_file_free (self->priv->keyfile), NULL)), _tmp0);
	}
	return obj;
}


static void dvb_settings_class_init (DVBSettingsClass * klass) {
	dvb_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSettingsPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_settings_finalize;
}


static void dvb_settings_instance_init (DVBSettings * self) {
	self->priv = DVB_SETTINGS_GET_PRIVATE (self);
}


static void dvb_settings_finalize (GObject* obj) {
	DVBSettings * self;
	self = DVB_SETTINGS (obj);
	(self->priv->keyfile == NULL) ? NULL : (self->priv->keyfile = (g_key_file_free (self->priv->keyfile), NULL));
	G_OBJECT_CLASS (dvb_settings_parent_class)->finalize (obj);
}


GType dvb_settings_get_type (void) {
	static GType dvb_settings_type_id = 0;
	if (dvb_settings_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSettings), 0, (GInstanceInitFunc) dvb_settings_instance_init, NULL };
		dvb_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSettings", &g_define_type_info, 0);
	}
	return dvb_settings_type_id;
}




