/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_FACTORY_H__
#define __SRC_FACTORY_H__

#include <glib.h>
#include <glib-object.h>
#include "src/TimersStore.h"
#include "src/Settings.h"
#include "src/EPGStore.h"
#include "src/ConfigStore.h"
#include "src/SqliteConfigTimersStore.h"

G_BEGIN_DECLS

typedef struct _DVBFactory DVBFactory;

struct _DVBFactory {
};


DVBTimersStore* dvb_factory_get_timers_store (void);
DVBConfigStore* dvb_factory_get_config_store (void);
DVBEPGStore* dvb_factory_get_epg_store (void);
DVBSettings* dvb_factory_get_settings (void);
void dvb_factory_shutdown (void);
DVBFactory* dvb_factory_new (void);
void dvb_factory_free (DVBFactory* self);


G_END_DECLS

#endif
