/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_SETTINGS_H__
#define __SRC_SETTINGS_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS


#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
typedef struct _DVBSettingsPrivate DVBSettingsPrivate;

struct _DVBSettings {
	GObject parent_instance;
	DVBSettingsPrivate * priv;
};

struct _DVBSettingsClass {
	GObjectClass parent_class;
};


#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
GFile* dvb_settings_get_settings_file (DVBSettings* self);
gboolean dvb_settings_load (DVBSettings* self);
gboolean dvb_settings_save (DVBSettings* self);
char* dvb_settings_get_string (DVBSettings* self, const char* group_name, const char* key, GError** error);
gboolean dvb_settings_get_boolean (DVBSettings* self, const char* group_name, const char* key, GError** error);
gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error);
double dvb_settings_get_double (DVBSettings* self, const char* group_name, const char* key, GError** error);
char** dvb_settings_get_string_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
gint* dvb_settings_get_integer_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
double* dvb_settings_get_double_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
void dvb_settings_set_string (DVBSettings* self, const char* group_name, const char* key, const char* val, GError** error);
void dvb_settings_set_boolean (DVBSettings* self, const char* group_name, const char* key, gboolean val, GError** error);
void dvb_settings_set_double (DVBSettings* self, const char* group_name, const char* key, double val, GError** error);
void dvb_settings_set_integer (DVBSettings* self, const char* group_name, const char* key, gint val, GError** error);
void dvb_settings_set_string_list (DVBSettings* self, const char* group_name, const char* key, char** val, int val_length1, GError** error);
void dvb_settings_set_boolean_list (DVBSettings* self, const char* group_name, const char* key, gboolean* val, int val_length1, GError** error);
void dvb_settings_set_double_list (DVBSettings* self, const char* group_name, const char* key, double* val, int val_length1, GError** error);
void dvb_settings_set_integer_list (DVBSettings* self, const char* group_name, const char* key, gint* val, int val_length1, GError** error);
DVBSettings* dvb_settings_construct (GType object_type);
DVBSettings* dvb_settings_new (void);
GType dvb_settings_get_type (void);


G_END_DECLS

#endif
