/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_RTSP_MEDIAMAPPING_H__
#define __SRC_RTSP_MEDIAMAPPING_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-media-mapping.h>
#include <gst/rtsp-server/rtsp-media-factory.h>
#include <gst/rtsp/gstrtspconnection.h>

G_BEGIN_DECLS


#define DVB_TYPE_MEDIA_MAPPING (dvb_media_mapping_get_type ())
#define DVB_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMapping))
#define DVB_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))
#define DVB_IS_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_MAPPING))
#define DVB_IS_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_MAPPING))
#define DVB_MEDIA_MAPPING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))

typedef struct _DVBMediaMapping DVBMediaMapping;
typedef struct _DVBMediaMappingClass DVBMediaMappingClass;
typedef struct _DVBMediaMappingPrivate DVBMediaMappingPrivate;

struct _DVBMediaMapping {
	GstRTSPMediaMapping parent_instance;
	DVBMediaMappingPrivate * priv;
};

struct _DVBMediaMappingClass {
	GstRTSPMediaMappingClass parent_class;
};


DVBMediaMapping* dvb_media_mapping_construct (GType object_type);
DVBMediaMapping* dvb_media_mapping_new (void);
GType dvb_media_mapping_get_type (void);


G_END_DECLS

#endif
