/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define DVB_TYPE_EPG_STORE (dvb_epg_store_get_type ())
#define DVB_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_STORE, DVBEPGStore))
#define DVB_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_STORE))
#define DVB_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_EPG_STORE, DVBEPGStoreIface))

typedef struct _DVBEPGStore DVBEPGStore;
typedef struct _DVBEPGStoreIface DVBEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

struct _DVBEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
	DVBEvent* (*get_event) (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
	gboolean (*remove_event) (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
	gboolean (*contains_event) (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
	GeeList* (*get_events) (DVBEPGStore* self, guint channel_sid, guint group_id);
	gboolean (*remove_events_of_group) (DVBEPGStore* self, guint group_id);
};



gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
GType dvb_epg_store_get_type (void);
gboolean dvb_epg_store_add_or_update_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
DVBEvent* dvb_epg_store_get_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
gboolean dvb_epg_store_remove_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
gboolean dvb_epg_store_contains_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
GeeList* dvb_epg_store_get_events (DVBEPGStore* self, guint channel_sid, guint group_id);
gboolean dvb_epg_store_remove_events_of_group (DVBEPGStore* self, guint group_id);



gboolean dvb_epg_store_add_or_update_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->add_or_update_event (self, event, channel_sid, group_id);
}


DVBEvent* dvb_epg_store_get_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->get_event (self, event_id, channel_sid, group_id);
}


gboolean dvb_epg_store_remove_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->remove_event (self, event_id, channel_sid, group_id);
}


gboolean dvb_epg_store_contains_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->contains_event (self, event, channel_sid, group_id);
}


GeeList* dvb_epg_store_get_events (DVBEPGStore* self, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->get_events (self, channel_sid, group_id);
}


gboolean dvb_epg_store_remove_events_of_group (DVBEPGStore* self, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->remove_events_of_group (self, group_id);
}


static void dvb_epg_store_base_init (DVBEPGStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_epg_store_get_type (void) {
	static GType dvb_epg_store_type_id = 0;
	if (dvb_epg_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGStoreIface), (GBaseInitFunc) dvb_epg_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_epg_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBEPGStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_epg_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_epg_store_type_id;
}




