/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>

typedef struct _DVBFactory DVBFactory;

#define DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE (dvb_sqlite_config_timers_store_get_type ())
#define DVB_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStore))
#define DVB_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStoreClass))
#define DVB_IS_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_IS_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_SQLITE_CONFIG_TIMERS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBSqliteConfigTimersStoreClass))

typedef struct _DVBSqliteConfigTimersStore DVBSqliteConfigTimersStore;
typedef struct _DVBSqliteConfigTimersStoreClass DVBSqliteConfigTimersStoreClass;

#define DVB_TYPE_EPG_STORE (dvb_epg_store_get_type ())
#define DVB_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_STORE, DVBEPGStore))
#define DVB_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_STORE))
#define DVB_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_EPG_STORE, DVBEPGStoreIface))

typedef struct _DVBEPGStore DVBEPGStore;
typedef struct _DVBEPGStoreIface DVBEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;

#define DVB_TYPE_TIMERS_STORE (dvb_timers_store_get_type ())
#define DVB_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStore))
#define DVB_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMERS_STORE))
#define DVB_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStoreIface))

typedef struct _DVBTimersStore DVBTimersStore;
typedef struct _DVBTimersStoreIface DVBTimersStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_CONFIG_STORE (dvb_config_store_get_type ())
#define DVB_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStore))
#define DVB_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CONFIG_STORE))
#define DVB_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStoreIface))

typedef struct _DVBConfigStore DVBConfigStore;
typedef struct _DVBConfigStoreIface DVBConfigStoreIface;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_SQLITE_EPG_STORE (dvb_sqlite_epg_store_get_type ())
#define DVB_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStore))
#define DVB_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStoreClass))
#define DVB_IS_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SQLITE_EPG_STORE))
#define DVB_IS_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SQLITE_EPG_STORE))
#define DVB_SQLITE_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStoreClass))

typedef struct _DVBSqliteEPGStore DVBSqliteEPGStore;
typedef struct _DVBSqliteEPGStoreClass DVBSqliteEPGStoreClass;

struct _DVBFactory {
};

struct _DVBEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
	DVBEvent* (*get_event) (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
	gboolean (*remove_event) (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id);
	gboolean (*contains_event) (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id);
	GeeList* (*get_events) (DVBEPGStore* self, guint channel_sid, guint group_id);
	gboolean (*remove_events_of_group) (DVBEPGStore* self, guint group_id);
};

struct _DVBTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBTimersStore* self, DVBDeviceGroup* dev);
	gboolean (*add_timer_to_device_group) (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
	gboolean (*remove_timer_from_device_group) (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
};

struct _DVBConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBConfigStore* self);
	gboolean (*add_device_group) (DVBConfigStore* self, DVBDeviceGroup* dev_group);
	gboolean (*remove_device_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
	gboolean (*add_device_to_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	gboolean (*remove_device_from_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	gboolean (*update_from_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
};


static DVBSqliteConfigTimersStore* dvb_factory_store;
static DVBSqliteConfigTimersStore* dvb_factory_store = NULL;
static GStaticRecMutex dvb_factory_store_mutex;
static GStaticRecMutex dvb_factory_store_mutex = {0};
static DVBEPGStore* dvb_factory_epgstore;
static DVBEPGStore* dvb_factory_epgstore = NULL;
static GStaticRecMutex dvb_factory_epgstore_mutex;
static GStaticRecMutex dvb_factory_epgstore_mutex = {0};
static DVBSettings* dvb_factory_settings;
static DVBSettings* dvb_factory_settings = NULL;
static GStaticRecMutex dvb_factory_settings_mutex;
static GStaticRecMutex dvb_factory_settings_mutex = {0};

void dvb_factory_free (DVBFactory* self);
GType dvb_sqlite_config_timers_store_get_type (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
GType dvb_epg_store_get_type (void);
GType dvb_settings_get_type (void);
DVBSqliteConfigTimersStore* dvb_sqlite_config_timers_store_new (void);
DVBSqliteConfigTimersStore* dvb_sqlite_config_timers_store_construct (GType object_type);
GType dvb_device_group_get_type (void);
GType dvb_timer_get_type (void);
GType dvb_timers_store_get_type (void);
DVBTimersStore* dvb_factory_get_timers_store (void);
GType dvb_device_get_type (void);
GType dvb_config_store_get_type (void);
DVBConfigStore* dvb_factory_get_config_store (void);
DVBSqliteEPGStore* dvb_sqlite_epg_store_new (void);
DVBSqliteEPGStore* dvb_sqlite_epg_store_construct (GType object_type);
GType dvb_sqlite_epg_store_get_type (void);
DVBEPGStore* dvb_factory_get_epg_store (void);
DVBSettings* dvb_settings_new (void);
DVBSettings* dvb_settings_construct (GType object_type);
gboolean dvb_settings_load (DVBSettings* self);
DVBSettings* dvb_factory_get_settings (void);
gboolean dvb_settings_save (DVBSettings* self);
void dvb_factory_shutdown (void);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_new (void);
static void dvb_factory_instance_init (DVBFactory * self);



DVBTimersStore* dvb_factory_get_timers_store (void) {
	DVBTimersStore* result;
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0_;
		_tmp0_ = NULL;
		dvb_factory_store = (_tmp0_ = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	result = (DVBTimersStore*) dvb_factory_store;
	return result;
}


DVBConfigStore* dvb_factory_get_config_store (void) {
	DVBConfigStore* result;
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0_;
		_tmp0_ = NULL;
		dvb_factory_store = (_tmp0_ = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	result = (DVBConfigStore*) dvb_factory_store;
	return result;
}


DVBEPGStore* dvb_factory_get_epg_store (void) {
	DVBEPGStore* result;
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	if (dvb_factory_epgstore == NULL) {
		DVBEPGStore* _tmp0_;
		_tmp0_ = NULL;
		dvb_factory_epgstore = (_tmp0_ = (DVBEPGStore*) dvb_sqlite_epg_store_new (), (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
	result = dvb_factory_epgstore;
	return result;
}


DVBSettings* dvb_factory_get_settings (void) {
	DVBSettings* result;
	g_static_rec_mutex_lock (&dvb_factory_settings_mutex);
	if (dvb_factory_settings == NULL) {
		DVBSettings* _tmp0_;
		_tmp0_ = NULL;
		dvb_factory_settings = (_tmp0_ = dvb_settings_new (), (dvb_factory_settings == NULL) ? NULL : (dvb_factory_settings = (g_object_unref (dvb_factory_settings), NULL)), _tmp0_);
		dvb_settings_load (dvb_factory_settings);
	}
	g_static_rec_mutex_unlock (&dvb_factory_settings_mutex);
	result = dvb_factory_settings;
	return result;
}


void dvb_factory_shutdown (void) {
	DVBSqliteConfigTimersStore* _tmp0_;
	DVBEPGStore* _tmp1_;
	DVBSettings* _tmp2_;
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	_tmp0_ = NULL;
	dvb_factory_store = (_tmp0_ = NULL, (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0_);
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	_tmp1_ = NULL;
	dvb_factory_epgstore = (_tmp1_ = NULL, (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp1_);
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
	g_static_rec_mutex_lock (&dvb_factory_settings_mutex);
	if (dvb_factory_settings != NULL) {
		dvb_settings_save (dvb_factory_settings);
	}
	_tmp2_ = NULL;
	dvb_factory_settings = (_tmp2_ = NULL, (dvb_factory_settings == NULL) ? NULL : (dvb_factory_settings = (g_object_unref (dvb_factory_settings), NULL)), _tmp2_);
	g_static_rec_mutex_unlock (&dvb_factory_settings_mutex);
}


DVBFactory* dvb_factory_new (void) {
	DVBFactory* self;
	self = g_slice_new0 (DVBFactory);
	dvb_factory_instance_init (self);
	return self;
}


static void dvb_factory_instance_init (DVBFactory * self) {
}


void dvb_factory_free (DVBFactory* self) {
	g_slice_free (DVBFactory, self);
}




