/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;
typedef struct _DVBIDBusRecordingsStoreDBusProxy DVBIDBusRecordingsStoreDBusProxy;
typedef DBusGProxyClass DVBIDBusRecordingsStoreDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBRecordingInfo {
	guint32 id;
	char* name;
	char* description;
	gint64 length;
	gint64 start_timestamp;
	char* channel;
	char* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1);
	char* (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	char* (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	char* (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	guint* (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
	gint64 (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	gint64 (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	char* (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	DVBRecordingInfo (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id);
};

struct _DVBIDBusRecordingsStoreDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType dvb_recording_info_get_type (void);
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void);
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1);
char* dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id);
char* dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id);
char* dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id);
guint* dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
gint64 dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id);
gint64 dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id);
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id);
char* dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id);
DVBRecordingInfo dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id);
void dvb_id_bus_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_recordings_store_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_introspect (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get_all (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, DBusConnection* _connection);
GType dvb_id_bus_recordings_store_dbus_proxy_get_type (void);
DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_recordings_store_changed (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_recordings_store_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_RECORDINGS_STORE_DBUS_PROXY_DUMMY_PROPERTY
};
static guint32* dvb_id_bus_recordings_store_dbus_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id);
static guint* dvb_id_bus_recordings_store_dbus_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id);
static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id);
static gboolean dvb_id_bus_recordings_store_dbus_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id);
static DVBRecordingInfo dvb_id_bus_recordings_store_dbus_proxy_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id);
static void dvb_id_bus_recordings_store_dbus_proxy_interface_init (DVBIDBusRecordingsStoreIface* iface);
static void dvb_id_bus_recordings_store_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_recordings_store_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_recordings_store_dbus_path_vtable = {_dvb_id_bus_recordings_store_dbus_unregister, dvb_id_bus_recordings_store_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_recordings_store_dbus_vtable = {dvb_id_bus_recordings_store_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest) {
	const char* _tmp3_;
	const char* _tmp2_;
	const char* _tmp1_;
	const char* _tmp0_;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	dest->id = self->id;
	dest->name = (_tmp0_ = self->name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	dest->description = (_tmp1_ = self->description, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	dest->length = self->length;
	dest->start_timestamp = self->start_timestamp;
	dest->channel = (_tmp2_ = self->channel, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	dest->location = (_tmp3_ = self->location, (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
}


void dvb_recording_info_destroy (DVBRecordingInfo* self) {
	self->name = (g_free (self->name), NULL);
	self->description = (g_free (self->description), NULL);
	self->channel = (g_free (self->channel), NULL);
	self->location = (g_free (self->location), NULL);
}


DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self) {
	DVBRecordingInfo* dup;
	dup = g_new0 (DVBRecordingInfo, 1);
	dvb_recording_info_copy (self, dup);
	return dup;
}


void dvb_recording_info_free (DVBRecordingInfo* self) {
	dvb_recording_info_destroy (self);
	g_free (self);
}


GType dvb_recording_info_get_type (void) {
	static GType dvb_recording_info_type_id = 0;
	if (dvb_recording_info_type_id == 0) {
		dvb_recording_info_type_id = g_boxed_type_register_static ("DVBRecordingInfo", (GBoxedCopyFunc) dvb_recording_info_dup, (GBoxedFreeFunc) dvb_recording_info_free);
	}
	return dvb_recording_info_type_id;
}


/**
         * @returns: A list of ids for all recordings
         */
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetRecordings (self, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: The location of the recording on the filesystem
         */
char* dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLocation (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The name of the recording (e.g. the name of
         * a TV show)
         */
char* dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetName (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: A short text describing the recorded item
         * (e.g. the description from EPG)
         */
char* dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetDescription (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The starting time of the recording
         */
guint* dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTime (self, rec_id, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: Start time as UNIX timestamp
         */
gint64 dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTimestamp (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The length of the recording in seconds
         * or -1 if no recording with the given id exists
         */
gint64 dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLength (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->Delete (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The channel's name or an empty string if
         * rec_id doesn't exist
         */
char* dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetChannelName (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         *
         * This method can be used to retrieve all informations
         * about a particular recording at once
         */
DVBRecordingInfo dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetAllInformations (self, rec_id);
}


void _dvb_id_bus_recordings_store_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_introspect (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.RecordingsStore\">\n  <method name=\"GetRecordings\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocation\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDescription\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTimestamp\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"x\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLength\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"x\" direction=\"out\"/>\n  </method>\n  <method name=\"Delete\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllInformations\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"(ussxxss)\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"rec_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get_all (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp4_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4_);
	if (strcmp (interface_name, "org.gnome.DVB.RecordingsStore") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp5_;
	DBusMessageIter _tmp6_;
	int _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recordings_store_GetRecordings (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp6_);
	for (_tmp7_ = 0; _tmp7_ < result_length1; _tmp7_++) {
		dbus_uint32_t _tmp8_;
		_tmp8_ = *_tmp5_;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_UINT32, &_tmp8_);
		_tmp5_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp6_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp9_;
	char* result;
	DBusMessage* reply;
	const char* _tmp10_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp9_;
	result = dvb_id_bus_recordings_store_GetLocation (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp10_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp10_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp11_;
	char* result;
	DBusMessage* reply;
	const char* _tmp12_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp11_;
	result = dvb_id_bus_recordings_store_GetName (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp12_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp12_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp13_;
	char* result;
	DBusMessage* reply;
	const char* _tmp14_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp13_;
	result = dvb_id_bus_recordings_store_GetDescription (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp14_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp14_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp15_;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp16_;
	DBusMessageIter _tmp17_;
	int _tmp18_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp15_;
	result_length1 = 0;
	result = dvb_id_bus_recordings_store_GetStartTime (self, rec_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp16_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp17_);
	for (_tmp18_ = 0; _tmp18_ < result_length1; _tmp18_++) {
		dbus_uint32_t _tmp19_;
		_tmp19_ = *_tmp16_;
		dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_UINT32, &_tmp19_);
		_tmp16_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp17_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp20_;
	gint64 result;
	DBusMessage* reply;
	dbus_int64_t _tmp21_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp20_;
	result = dvb_id_bus_recordings_store_GetStartTimestamp (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT64, &_tmp21_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp22_;
	gint64 result;
	DBusMessage* reply;
	dbus_int64_t _tmp23_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp22_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp22_;
	result = dvb_id_bus_recordings_store_GetLength (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp23_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT64, &_tmp23_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp24_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp25_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp24_;
	result = dvb_id_bus_recordings_store_Delete (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp25_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp25_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp26_;
	char* result;
	DBusMessage* reply;
	const char* _tmp27_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp26_;
	result = dvb_id_bus_recordings_store_GetChannelName (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp27_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp27_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp28_;
	DVBRecordingInfo result;
	DBusMessage* reply;
	DBusMessageIter _tmp29_;
	dbus_uint32_t _tmp30_;
	const char* _tmp31_;
	const char* _tmp32_;
	dbus_int64_t _tmp33_;
	dbus_int64_t _tmp34_;
	const char* _tmp35_;
	const char* _tmp36_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp28_;
	result = dvb_id_bus_recordings_store_GetAllInformations (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_STRUCT, NULL, &_tmp29_);
	_tmp30_ = result.id;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_UINT32, &_tmp30_);
	_tmp31_ = result.name;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_STRING, &_tmp31_);
	_tmp32_ = result.description;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_STRING, &_tmp32_);
	_tmp33_ = result.length;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_INT64, &_tmp33_);
	_tmp34_ = result.start_timestamp;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_INT64, &_tmp34_);
	_tmp35_ = result.channel;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_STRING, &_tmp35_);
	_tmp36_ = result.location;
	dbus_message_iter_append_basic (&_tmp29_, DBUS_TYPE_STRING, &_tmp36_);
	dbus_message_iter_close_container (&iter, &_tmp29_);
	dvb_recording_info_destroy (&result);
	return reply;
}


DBusHandlerResult dvb_id_bus_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_recordings_store_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_recordings_store_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetRecordings")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetRecordings (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetLocation")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetLocation (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetName")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetDescription")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetStartTime")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetStartTimestamp")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetLength")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetLength (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "Delete")) {
		reply = _dbus_dvb_id_bus_recordings_store_Delete (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetAllInformations")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetAllInformations (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp37_;
	dbus_uint32_t _tmp38_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.RecordingsStore", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp37_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp37_);
	_tmp38_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp38_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_recordings_store_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recordings_store_changed, connection);
}


static void dvb_id_bus_recordings_store_base_init (DVBIDBusRecordingsStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDINGS_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_RECORDINGS_STORE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_recordings_store_dbus_vtable));
	}
}


GType dvb_id_bus_recordings_store_get_type (void) {
	static GType dvb_id_bus_recordings_store_type_id = 0;
	if (dvb_id_bus_recordings_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecordingsStoreIface), (GBaseInitFunc) dvb_id_bus_recordings_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recordings_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecordingsStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recordings_store_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_recordings_store_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_recordings_store_dbus_proxy_get_type);
	}
	return dvb_id_bus_recordings_store_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecordingsStoreDBusProxy, dvb_id_bus_recordings_store_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDINGS_STORE, dvb_id_bus_recordings_store_dbus_proxy_interface_init));
DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusRecordingsStore* self;
	self = g_object_new (dvb_id_bus_recordings_store_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.RecordingsStore", NULL);
	return self;
}


static GObject* dvb_id_bus_recordings_store_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_recordings_store_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recordings_store_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_recordings_store_changed (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 rec_id;
	dbus_uint32_t _tmp39_;
	guint type;
	dbus_uint32_t _tmp40_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp39_);
	dbus_message_iter_next (&iter);
	rec_id = _tmp39_;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp40_);
	dbus_message_iter_next (&iter);
	type = _tmp40_;
	g_signal_emit_by_name (self, "changed", rec_id, type);
}


DBusHandlerResult dvb_id_bus_recordings_store_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.RecordingsStore", "Changed")) {
			_dbus_handle_dvb_id_bus_recordings_store_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_recordings_store_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recordings_store_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_recordings_store_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_recordings_store_dbus_proxy_class_init (DVBIDBusRecordingsStoreDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_recordings_store_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_recordings_store_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_recordings_store_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_recordings_store_dbus_proxy_set_property;
}


static void dvb_id_bus_recordings_store_dbus_proxy_init (DVBIDBusRecordingsStoreDBusProxy* self) {
}


static guint32* dvb_id_bus_recordings_store_dbus_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp41_;
	int _tmp41__length;
	int _tmp41__size;
	int _tmp41__length1;
	DBusMessageIter _tmp42_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetRecordings");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp41_ = g_new (guint32, 5);
	_tmp41__length = 0;
	_tmp41__size = 4;
	_tmp41__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp42_);
	for (; dbus_message_iter_get_arg_type (&_tmp42_); _tmp41__length1++) {
		dbus_uint32_t _tmp43_;
		if (_tmp41__size == _tmp41__length) {
			_tmp41__size = 2 * _tmp41__size;
			_tmp41_ = g_renew (guint32, _tmp41_, _tmp41__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp42_, &_tmp43_);
		dbus_message_iter_next (&_tmp42_);
		_tmp41_[_tmp41__length++] = _tmp43_;
	}
	_result_length1 = _tmp41__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp41_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp44_;
	char* _result;
	const char* _tmp45_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetLocation");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp44_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp44_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp45_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp45_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp46_;
	char* _result;
	const char* _tmp47_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp46_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp46_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp47_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp47_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp48_;
	char* _result;
	const char* _tmp49_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp48_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp49_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp49_);
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_recordings_store_dbus_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp50_;
	guint* _result;
	int _result_length1;
	guint* _tmp51_;
	int _tmp51__length;
	int _tmp51__size;
	int _tmp51__length1;
	DBusMessageIter _tmp52_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp50_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp50_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp51_ = g_new (guint, 5);
	_tmp51__length = 0;
	_tmp51__size = 4;
	_tmp51__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp52_);
	for (; dbus_message_iter_get_arg_type (&_tmp52_); _tmp51__length1++) {
		dbus_uint32_t _tmp53_;
		if (_tmp51__size == _tmp51__length) {
			_tmp51__size = 2 * _tmp51__size;
			_tmp51_ = g_renew (guint, _tmp51_, _tmp51__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp52_, &_tmp53_);
		dbus_message_iter_next (&_tmp52_);
		_tmp51_[_tmp51__length++] = _tmp53_;
	}
	_result_length1 = _tmp51__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp51_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp54_;
	gint64 _result;
	dbus_int64_t _tmp55_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return 0LL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetStartTimestamp");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp54_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp54_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp55_);
	dbus_message_iter_next (&_iter);
	_result = _tmp55_;
	dbus_message_unref (_reply);
	return _result;
}


static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp56_;
	gint64 _result;
	dbus_int64_t _tmp57_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return 0LL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetLength");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp56_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp56_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp57_);
	dbus_message_iter_next (&_iter);
	_result = _tmp57_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_dbus_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp58_;
	gboolean _result;
	dbus_bool_t _tmp59_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "Delete");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp58_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp58_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp59_);
	dbus_message_iter_next (&_iter);
	_result = _tmp59_;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp60_;
	char* _result;
	const char* _tmp61_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp60_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp60_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp61_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp61_);
	dbus_message_unref (_reply);
	return _result;
}


static DVBRecordingInfo dvb_id_bus_recordings_store_dbus_proxy_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp62_;
	DVBRecordingInfo _result;
	DVBRecordingInfo _tmp63_;
	DBusMessageIter _tmp64_;
	dbus_uint32_t _tmp65_;
	const char* _tmp66_;
	const char* _tmp67_;
	dbus_int64_t _tmp68_;
	dbus_int64_t _tmp69_;
	const char* _tmp70_;
	const char* _tmp71_;
	if (((DVBIDBusRecordingsStoreDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetAllInformations");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp62_ = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp62_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_tmp64_);
	dbus_message_iter_get_basic (&_tmp64_, &_tmp65_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.id = _tmp65_;
	dbus_message_iter_get_basic (&_tmp64_, &_tmp66_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.name = g_strdup (_tmp66_);
	dbus_message_iter_get_basic (&_tmp64_, &_tmp67_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.description = g_strdup (_tmp67_);
	dbus_message_iter_get_basic (&_tmp64_, &_tmp68_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.length = _tmp68_;
	dbus_message_iter_get_basic (&_tmp64_, &_tmp69_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.start_timestamp = _tmp69_;
	dbus_message_iter_get_basic (&_tmp64_, &_tmp70_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.channel = g_strdup (_tmp70_);
	dbus_message_iter_get_basic (&_tmp64_, &_tmp71_);
	dbus_message_iter_next (&_tmp64_);
	_tmp63_.location = g_strdup (_tmp71_);
	dbus_message_iter_next (&_iter);
	_result = _tmp63_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_recordings_store_dbus_proxy_interface_init (DVBIDBusRecordingsStoreIface* iface) {
	iface->GetRecordings = dvb_id_bus_recordings_store_dbus_proxy_GetRecordings;
	iface->GetLocation = dvb_id_bus_recordings_store_dbus_proxy_GetLocation;
	iface->GetName = dvb_id_bus_recordings_store_dbus_proxy_GetName;
	iface->GetDescription = dvb_id_bus_recordings_store_dbus_proxy_GetDescription;
	iface->GetStartTime = dvb_id_bus_recordings_store_dbus_proxy_GetStartTime;
	iface->GetStartTimestamp = dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp;
	iface->GetLength = dvb_id_bus_recordings_store_dbus_proxy_GetLength;
	iface->Delete = dvb_id_bus_recordings_store_dbus_proxy_Delete;
	iface->GetChannelName = dvb_id_bus_recordings_store_dbus_proxy_GetChannelName;
	iface->GetAllInformations = dvb_id_bus_recordings_store_dbus_proxy_GetAllInformations;
}


static void dvb_id_bus_recordings_store_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_recordings_store_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



