/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define DVB_TYPE_TIMERS_STORE (dvb_timers_store_get_type ())
#define DVB_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStore))
#define DVB_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMERS_STORE))
#define DVB_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStoreIface))

typedef struct _DVBTimersStore DVBTimersStore;
typedef struct _DVBTimersStoreIface DVBTimersStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

struct _DVBTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBTimersStore* self, DVBDeviceGroup* dev);
	gboolean (*add_timer_to_device_group) (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
	gboolean (*remove_timer_from_device_group) (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
};



GType dvb_device_group_get_type (void);
GType dvb_timer_get_type (void);
GType dvb_timers_store_get_type (void);
GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev);
gboolean dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
gboolean dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);



GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->get_all_timers_of_device_group (self, dev);
}


gboolean dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->add_timer_to_device_group (self, timer, dev);
}


gboolean dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->remove_timer_from_device_group (self, timer_id, dev);
}


static void dvb_timers_store_base_init (DVBTimersStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_timers_store_get_type (void) {
	static GType dvb_timers_store_type_id = 0;
	if (dvb_timers_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimersStoreIface), (GBaseInitFunc) dvb_timers_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_timers_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBTimersStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_timers_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_timers_store_type_id;
}




