/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())
typedef struct _DVBIDBusRecorderDBusProxy DVBIDBusRecorderDBusProxy;
typedef DBusGProxyClass DVBIDBusRecorderDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	guint32 (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
	guint32 (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
	guint32 (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1);
	guint32* (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
	guint* (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
	guint (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id);
	char* (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
};

struct _DVBIDBusRecorderDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType dvb_overlap_type_get_type (void);
GType dvb_id_bus_recorder_get_type (void);
guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
guint32 dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id);
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1);
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id);
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id);
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id);
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
void dvb_id_bus_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection);
static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection);
GType dvb_id_bus_recorder_dbus_proxy_get_type (void);
DVBIDBusRecorder* dvb_id_bus_recorder_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_RECORDER_DBUS_PROXY_DUMMY_PROPERTY
};
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1);
static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id);
static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id);
static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1);
static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id);
static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid);
static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface);
static void dvb_id_bus_recorder_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_recorder_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_recorder_dbus_path_vtable = {_dvb_id_bus_recorder_dbus_unregister, dvb_id_bus_recorder_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_recorder_dbus_vtable = {dvb_id_bus_recorder_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         * 
         * Add a new timer
         */
guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * Works the same way as AddTimer() but adds a margin before and
         * after the timer.
         */
guint32 dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         */
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerForEPGEvent (self, event_id, channel_sid);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->DeleteTimer (self, timer_id);
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         */
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetStartTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Same as dvb_recorder_GetStartTime()
         */
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetEndTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Duration in seconds or 0 if there's no timer with
         * the given id
         */
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetDuration (self, timer_id);
}


/**
         * @timer_id: Timer's id
         * @returns: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         */
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetChannelName (self, timer_id);
}


/**
         * @returns: The currently active timers
         */
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetActiveTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->IsTimerActive (self, timer_id);
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * Checks if a timer overlaps with the given event
         */
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimerForEvent (self, event_id, channel_sid);
}


void _dvb_id_bus_recorder_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_recorder_introspect (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Recorder\">\n  <method name=\"AddTimer\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerWithMargin\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerForEPGEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"DeleteTimer\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetEndTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetActiveTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsTimerActive\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimer\">\n    <arg name=\"start_year\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimerForEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <signal name=\"RecordingStarted\">\n    <arg name=\"timer_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"RecordingFinished\">\n    <arg name=\"recording_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"Changed\">\n    <arg name=\"timer_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_property_get_all (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.DVB.Recorder") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel;
	dbus_uint32_t _tmp1_;
	gint start_year;
	dbus_int32_t _tmp2_;
	gint start_month;
	dbus_int32_t _tmp3_;
	gint start_day;
	dbus_int32_t _tmp4_;
	gint start_hour;
	dbus_int32_t _tmp5_;
	gint start_minute;
	dbus_int32_t _tmp6_;
	guint duration;
	dbus_uint32_t _tmp7_;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp8_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uiiiiiu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	channel = _tmp1_;
	start_year = 0;
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	start_year = _tmp2_;
	start_month = 0;
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	start_month = _tmp3_;
	start_day = 0;
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	start_day = _tmp4_;
	start_hour = 0;
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	start_hour = _tmp5_;
	start_minute = 0;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	start_minute = _tmp6_;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	duration = _tmp7_;
	result = dvb_id_bus_recorder_AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp8_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp8_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel;
	dbus_uint32_t _tmp9_;
	gint start_year;
	dbus_int32_t _tmp10_;
	gint start_month;
	dbus_int32_t _tmp11_;
	gint start_day;
	dbus_int32_t _tmp12_;
	gint start_hour;
	dbus_int32_t _tmp13_;
	gint start_minute;
	dbus_int32_t _tmp14_;
	guint duration;
	dbus_uint32_t _tmp15_;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp16_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uiiiiiu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	channel = _tmp9_;
	start_year = 0;
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	start_year = _tmp10_;
	start_month = 0;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	start_month = _tmp11_;
	start_day = 0;
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	start_day = _tmp12_;
	start_hour = 0;
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	start_hour = _tmp13_;
	start_minute = 0;
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	start_minute = _tmp14_;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	duration = _tmp15_;
	result = dvb_id_bus_recorder_AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp16_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp16_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp17_;
	guint channel_sid;
	dbus_uint32_t _tmp18_;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp19_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	event_id = _tmp17_;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18_);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp18_;
	result = dvb_id_bus_recorder_AddTimerForEPGEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp19_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp20_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp21_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp20_;
	result = dvb_id_bus_recorder_DeleteTimer (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp21_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp22_;
	DBusMessageIter _tmp23_;
	int _tmp24_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp22_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp23_);
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		dbus_uint32_t _tmp25_;
		_tmp25_ = *_tmp22_;
		dbus_message_iter_append_basic (&_tmp23_, DBUS_TYPE_UINT32, &_tmp25_);
		_tmp22_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp23_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp26_;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp27_;
	DBusMessageIter _tmp28_;
	int _tmp29_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp26_;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetStartTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp27_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp28_);
	for (_tmp29_ = 0; _tmp29_ < result_length1; _tmp29_++) {
		dbus_uint32_t _tmp30_;
		_tmp30_ = *_tmp27_;
		dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_UINT32, &_tmp30_);
		_tmp27_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp28_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp31_;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp32_;
	DBusMessageIter _tmp33_;
	int _tmp34_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp31_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp31_;
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetEndTime (self, timer_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp32_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp33_);
	for (_tmp34_ = 0; _tmp34_ < result_length1; _tmp34_++) {
		dbus_uint32_t _tmp35_;
		_tmp35_ = *_tmp32_;
		dbus_message_iter_append_basic (&_tmp33_, DBUS_TYPE_UINT32, &_tmp35_);
		_tmp32_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp33_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp36_;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp37_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp36_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp36_;
	result = dvb_id_bus_recorder_GetDuration (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp37_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp37_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp38_;
	char* result;
	DBusMessage* reply;
	const char* _tmp39_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp38_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp38_;
	result = dvb_id_bus_recorder_GetChannelName (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp39_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp39_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp40_;
	DBusMessageIter _tmp41_;
	int _tmp42_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recorder_GetActiveTimers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp40_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp41_);
	for (_tmp42_ = 0; _tmp42_ < result_length1; _tmp42_++) {
		dbus_uint32_t _tmp43_;
		_tmp43_ = *_tmp40_;
		dbus_message_iter_append_basic (&_tmp41_, DBUS_TYPE_UINT32, &_tmp43_);
		_tmp40_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp41_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 timer_id;
	dbus_uint32_t _tmp44_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp45_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp44_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp44_;
	result = dvb_id_bus_recorder_IsTimerActive (self, timer_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp45_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp45_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint start_year;
	dbus_uint32_t _tmp46_;
	guint start_month;
	dbus_uint32_t _tmp47_;
	guint start_day;
	dbus_uint32_t _tmp48_;
	guint start_hour;
	dbus_uint32_t _tmp49_;
	guint start_minute;
	dbus_uint32_t _tmp50_;
	guint duration;
	dbus_uint32_t _tmp51_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp52_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuuuuu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	start_year = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp46_);
	dbus_message_iter_next (&iter);
	start_year = _tmp46_;
	start_month = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp47_);
	dbus_message_iter_next (&iter);
	start_month = _tmp47_;
	start_day = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp48_);
	dbus_message_iter_next (&iter);
	start_day = _tmp48_;
	start_hour = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp49_);
	dbus_message_iter_next (&iter);
	start_hour = _tmp49_;
	start_minute = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp50_);
	dbus_message_iter_next (&iter);
	start_minute = _tmp50_;
	duration = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp51_);
	dbus_message_iter_next (&iter);
	duration = _tmp51_;
	result = dvb_id_bus_recorder_HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp52_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp52_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint event_id;
	dbus_uint32_t _tmp53_;
	guint channel_sid;
	dbus_uint32_t _tmp54_;
	DVBOverlapType result;
	DBusMessage* reply;
	dbus_int32_t _tmp55_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp53_);
	dbus_message_iter_next (&iter);
	event_id = _tmp53_;
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp54_);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp54_;
	result = dvb_id_bus_recorder_HasTimerForEvent (self, event_id, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp55_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT32, &_tmp55_);
	return reply;
}


DBusHandlerResult dvb_id_bus_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_recorder_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_recorder_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimer")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimerWithMargin")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimerWithMargin (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "AddTimerForEPGEvent")) {
		reply = _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "DeleteTimer")) {
		reply = _dbus_dvb_id_bus_recorder_DeleteTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetStartTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetEndTime")) {
		reply = _dbus_dvb_id_bus_recorder_GetEndTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetDuration")) {
		reply = _dbus_dvb_id_bus_recorder_GetDuration (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_recorder_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "GetActiveTimers")) {
		reply = _dbus_dvb_id_bus_recorder_GetActiveTimers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "IsTimerActive")) {
		reply = _dbus_dvb_id_bus_recorder_IsTimerActive (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimer")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimer (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Recorder", "HasTimerForEvent")) {
		reply = _dbus_dvb_id_bus_recorder_HasTimerForEvent (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp56_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingStarted");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp56_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp56_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp57_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "RecordingFinished");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp57_ = recording_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp57_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp58_;
	dbus_uint32_t _tmp59_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Recorder", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp58_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp58_);
	_tmp59_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp59_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_recorder_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "recording-started", (GCallback) _dbus_dvb_id_bus_recorder_recording_started, connection);
	g_signal_connect (object, "recording-finished", (GCallback) _dbus_dvb_id_bus_recorder_recording_finished, connection);
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recorder_changed, connection);
}


static void dvb_id_bus_recorder_base_init (DVBIDBusRecorderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("recording_started", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("recording_finished", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_RECORDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_recorder_dbus_vtable));
	}
}


GType dvb_id_bus_recorder_get_type (void) {
	static GType dvb_id_bus_recorder_type_id = 0;
	if (dvb_id_bus_recorder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecorderIface), (GBaseInitFunc) dvb_id_bus_recorder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recorder_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecorder", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recorder_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_recorder_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_recorder_dbus_proxy_get_type);
	}
	return dvb_id_bus_recorder_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecorderDBusProxy, dvb_id_bus_recorder_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDER, dvb_id_bus_recorder_dbus_proxy_interface_init));
DVBIDBusRecorder* dvb_id_bus_recorder_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusRecorder* self;
	self = g_object_new (dvb_id_bus_recorder_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Recorder", NULL);
	return self;
}


static GObject* dvb_id_bus_recorder_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_recorder_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp60_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp60_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp60_;
	g_signal_emit_by_name (self, "recording-started", timer_id);
}


static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 recording_id;
	dbus_uint32_t _tmp61_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	recording_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp61_);
	dbus_message_iter_next (&iter);
	recording_id = _tmp61_;
	g_signal_emit_by_name (self, "recording-finished", recording_id);
}


static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 timer_id;
	dbus_uint32_t _tmp62_;
	guint type;
	dbus_uint32_t _tmp63_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	timer_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp62_);
	dbus_message_iter_next (&iter);
	timer_id = _tmp62_;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp63_);
	dbus_message_iter_next (&iter);
	type = _tmp63_;
	g_signal_emit_by_name (self, "changed", timer_id, type);
}


DBusHandlerResult dvb_id_bus_recorder_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingStarted")) {
			_dbus_handle_dvb_id_bus_recorder_recording_started (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "RecordingFinished")) {
			_dbus_handle_dvb_id_bus_recorder_recording_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Recorder", "Changed")) {
			_dbus_handle_dvb_id_bus_recorder_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_recorder_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusRecorderDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_recorder_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_recorder_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_recorder_dbus_proxy_class_init (DVBIDBusRecorderDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_recorder_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_recorder_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_recorder_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_recorder_dbus_proxy_set_property;
}


static void dvb_id_bus_recorder_dbus_proxy_init (DVBIDBusRecorderDBusProxy* self) {
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp64_;
	dbus_int32_t _tmp65_;
	dbus_int32_t _tmp66_;
	dbus_int32_t _tmp67_;
	dbus_int32_t _tmp68_;
	dbus_int32_t _tmp69_;
	dbus_uint32_t _tmp70_;
	guint32 _result;
	dbus_uint32_t _tmp71_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64_ = channel;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp64_);
	_tmp65_ = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp65_);
	_tmp66_ = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp66_);
	_tmp67_ = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp67_);
	_tmp68_ = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp68_);
	_tmp69_ = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp69_);
	_tmp70_ = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp70_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp71_);
	dbus_message_iter_next (&_iter);
	_result = _tmp71_;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp72_;
	dbus_int32_t _tmp73_;
	dbus_int32_t _tmp74_;
	dbus_int32_t _tmp75_;
	dbus_int32_t _tmp76_;
	dbus_int32_t _tmp77_;
	dbus_uint32_t _tmp78_;
	guint32 _result;
	dbus_uint32_t _tmp79_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimerWithMargin");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72_ = channel;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp72_);
	_tmp73_ = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp73_);
	_tmp74_ = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp74_);
	_tmp75_ = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp75_);
	_tmp76_ = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp76_);
	_tmp77_ = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp77_);
	_tmp78_ = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp78_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp79_);
	dbus_message_iter_next (&_iter);
	_result = _tmp79_;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp80_;
	dbus_uint32_t _tmp81_;
	guint32 _result;
	dbus_uint32_t _tmp82_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "AddTimerForEPGEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp80_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp80_);
	_tmp81_ = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp81_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp82_);
	dbus_message_iter_next (&_iter);
	_result = _tmp82_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp83_;
	gboolean _result;
	dbus_bool_t _tmp84_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "DeleteTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp83_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp83_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp84_);
	dbus_message_iter_next (&_iter);
	_result = _tmp84_;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp85_;
	int _tmp85__length;
	int _tmp85__size;
	int _tmp85__length1;
	DBusMessageIter _tmp86_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp85_ = g_new (guint32, 5);
	_tmp85__length = 0;
	_tmp85__size = 4;
	_tmp85__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp86_);
	for (; dbus_message_iter_get_arg_type (&_tmp86_); _tmp85__length1++) {
		dbus_uint32_t _tmp87_;
		if (_tmp85__size == _tmp85__length) {
			_tmp85__size = 2 * _tmp85__size;
			_tmp85_ = g_renew (guint32, _tmp85_, _tmp85__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp86_, &_tmp87_);
		dbus_message_iter_next (&_tmp86_);
		_tmp85_[_tmp85__length++] = _tmp87_;
	}
	_result_length1 = _tmp85__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp85_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp88_;
	guint32* _result;
	int _result_length1;
	guint32* _tmp89_;
	int _tmp89__length;
	int _tmp89__size;
	int _tmp89__length1;
	DBusMessageIter _tmp90_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp88_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp88_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp89_ = g_new (guint32, 5);
	_tmp89__length = 0;
	_tmp89__size = 4;
	_tmp89__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp90_);
	for (; dbus_message_iter_get_arg_type (&_tmp90_); _tmp89__length1++) {
		dbus_uint32_t _tmp91_;
		if (_tmp89__size == _tmp89__length) {
			_tmp89__size = 2 * _tmp89__size;
			_tmp89_ = g_renew (guint32, _tmp89_, _tmp89__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp90_, &_tmp91_);
		dbus_message_iter_next (&_tmp90_);
		_tmp89_[_tmp89__length++] = _tmp91_;
	}
	_result_length1 = _tmp89__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp89_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_recorder_dbus_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp92_;
	guint* _result;
	int _result_length1;
	guint* _tmp93_;
	int _tmp93__length;
	int _tmp93__size;
	int _tmp93__length1;
	DBusMessageIter _tmp94_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetEndTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp92_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp92_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp93_ = g_new (guint, 5);
	_tmp93__length = 0;
	_tmp93__size = 4;
	_tmp93__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp94_);
	for (; dbus_message_iter_get_arg_type (&_tmp94_); _tmp93__length1++) {
		dbus_uint32_t _tmp95_;
		if (_tmp93__size == _tmp93__length) {
			_tmp93__size = 2 * _tmp93__size;
			_tmp93_ = g_renew (guint, _tmp93_, _tmp93__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp94_, &_tmp95_);
		dbus_message_iter_next (&_tmp94_);
		_tmp93_[_tmp93__length++] = _tmp95_;
	}
	_result_length1 = _tmp93__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp93_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_recorder_dbus_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp96_;
	guint _result;
	dbus_uint32_t _tmp97_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetDuration");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp96_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp96_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp97_);
	dbus_message_iter_next (&_iter);
	_result = _tmp97_;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recorder_dbus_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp98_;
	char* _result;
	const char* _tmp99_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp98_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp98_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp99_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp99_);
	dbus_message_unref (_reply);
	return _result;
}


static guint32* dvb_id_bus_recorder_dbus_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp100_;
	int _tmp100__length;
	int _tmp100__size;
	int _tmp100__length1;
	DBusMessageIter _tmp101_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "GetActiveTimers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp100_ = g_new (guint32, 5);
	_tmp100__length = 0;
	_tmp100__size = 4;
	_tmp100__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp101_);
	for (; dbus_message_iter_get_arg_type (&_tmp101_); _tmp100__length1++) {
		dbus_uint32_t _tmp102_;
		if (_tmp100__size == _tmp100__length) {
			_tmp100__size = 2 * _tmp100__size;
			_tmp100_ = g_renew (guint32, _tmp100_, _tmp100__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp101_, &_tmp102_);
		dbus_message_iter_next (&_tmp101_);
		_tmp100_[_tmp100__length++] = _tmp102_;
	}
	_result_length1 = _tmp100__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp100_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp103_;
	gboolean _result;
	dbus_bool_t _tmp104_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "IsTimerActive");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp103_ = timer_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp103_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp104_);
	dbus_message_iter_next (&_iter);
	_result = _tmp104_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recorder_dbus_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp105_;
	dbus_uint32_t _tmp106_;
	dbus_uint32_t _tmp107_;
	dbus_uint32_t _tmp108_;
	dbus_uint32_t _tmp109_;
	dbus_uint32_t _tmp110_;
	gboolean _result;
	dbus_bool_t _tmp111_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimer");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp105_ = start_year;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp105_);
	_tmp106_ = start_month;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp106_);
	_tmp107_ = start_day;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp107_);
	_tmp108_ = start_hour;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp108_);
	_tmp109_ = start_minute;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp109_);
	_tmp110_ = duration;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp110_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp111_);
	dbus_message_iter_next (&_iter);
	_result = _tmp111_;
	dbus_message_unref (_reply);
	return _result;
}


static DVBOverlapType dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp112_;
	dbus_uint32_t _tmp113_;
	DVBOverlapType _result;
	dbus_int32_t _tmp114_;
	if (((DVBIDBusRecorderDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Recorder", "HasTimerForEvent");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp112_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp112_);
	_tmp113_ = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp113_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp114_);
	dbus_message_iter_next (&_iter);
	_result = _tmp114_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_recorder_dbus_proxy_interface_init (DVBIDBusRecorderIface* iface) {
	iface->AddTimer = dvb_id_bus_recorder_dbus_proxy_AddTimer;
	iface->AddTimerWithMargin = dvb_id_bus_recorder_dbus_proxy_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = dvb_id_bus_recorder_dbus_proxy_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_id_bus_recorder_dbus_proxy_DeleteTimer;
	iface->GetTimers = dvb_id_bus_recorder_dbus_proxy_GetTimers;
	iface->GetStartTime = dvb_id_bus_recorder_dbus_proxy_GetStartTime;
	iface->GetEndTime = dvb_id_bus_recorder_dbus_proxy_GetEndTime;
	iface->GetDuration = dvb_id_bus_recorder_dbus_proxy_GetDuration;
	iface->GetChannelName = dvb_id_bus_recorder_dbus_proxy_GetChannelName;
	iface->GetActiveTimers = dvb_id_bus_recorder_dbus_proxy_GetActiveTimers;
	iface->IsTimerActive = dvb_id_bus_recorder_dbus_proxy_IsTimerActive;
	iface->HasTimer = dvb_id_bus_recorder_dbus_proxy_HasTimer;
	iface->HasTimerForEvent = dvb_id_bus_recorder_dbus_proxy_HasTimerForEvent;
}


static void dvb_id_bus_recorder_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_recorder_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



