/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <gio/gio.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_ID_BUS_SATELLITE_SCANNER (dvb_id_bus_satellite_scanner_get_type ())
#define DVB_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScanner))
#define DVB_IS_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER))
#define DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScannerIface))

typedef struct _DVBIDBusSatelliteScanner DVBIDBusSatelliteScanner;
typedef struct _DVBIDBusSatelliteScannerIface DVBIDBusSatelliteScannerIface;
typedef struct _DVBIDBusSatelliteScannerDBusProxy DVBIDBusSatelliteScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusSatelliteScannerDBusProxyClass;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;
typedef struct _DVBSatelliteScannerPrivate DVBSatelliteScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBIDBusSatelliteScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusSatelliteScanner* self);
	void (*Destroy) (DVBIDBusSatelliteScanner* self);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusSatelliteScanner* self, const char* path);
	gboolean (*WriteChannelsToFile) (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
	void (*AddScanningData) (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
	gboolean (*AddScanningDataFromFile) (DVBIDBusSatelliteScanner* self, const char* path);
};

struct _DVBIDBusSatelliteScannerDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

/**
     * An abstract class responsible for scanning for new channels
     */
struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
	GeeHashMap* transport_streams;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
};

struct _DVBSatelliteScanner {
	DVBScanner parent_instance;
	DVBSatelliteScannerPrivate * priv;
};

struct _DVBSatelliteScannerClass {
	DVBScannerClass parent_class;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_satellite_scanner_parent_class = NULL;
static DVBIDBusSatelliteScannerIface* dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = NULL;

GType dvb_id_bus_satellite_scanner_get_type (void);
void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self);
void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self);
gboolean dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path);
gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path);
void dvb_id_bus_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_introspect (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_property_get_all (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection);
static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection);
GType dvb_id_bus_satellite_scanner_dbus_proxy_get_type (void);
DVBIDBusSatelliteScanner* dvb_id_bus_satellite_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_SATELLITE_SCANNER_DBUS_PROXY_DUMMY_PROPERTY
};
static void dvb_id_bus_satellite_scanner_dbus_proxy_Run (DVBIDBusSatelliteScanner* self);
static void dvb_id_bus_satellite_scanner_dbus_proxy_Destroy (DVBIDBusSatelliteScanner* self);
static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path);
static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
static void dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path);
static void dvb_id_bus_satellite_scanner_dbus_proxy_interface_init (DVBIDBusSatelliteScannerIface* iface);
static void dvb_id_bus_satellite_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_satellite_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_scanner_get_type (void);
GType dvb_scanned_item_get_type (void);
GType dvb_channel_get_type (void);
GType dvb_channel_list_get_type (void);
GType dvb_satellite_scanner_get_type (void);
enum  {
	DVB_SATELLITE_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key);
static void dvb_satellite_scanner_real_prepare (DVBScanner* base);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const char* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const char* polarization);
GType dvb_scanned_sattelite_item_get_type (void);
static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBSatelliteChannel* dvb_satellite_channel_new (void);
DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type);
GType dvb_satellite_channel_get_type (void);
static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const char* value);
void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value);
void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value);
static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
void dvb_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_satellite_scanner_introspect (DVBSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
void dvb_scanner_Run (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const char* path);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_satellite_scanner_dbus_path_vtable = {_dvb_id_bus_satellite_scanner_dbus_unregister, dvb_id_bus_satellite_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_satellite_scanner_dbus_vtable = {dvb_id_bus_satellite_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_satellite_scanner_dbus_path_vtable = {_dvb_satellite_scanner_dbus_unregister, dvb_satellite_scanner_dbus_message};
static const _DBusObjectVTable _dvb_satellite_scanner_dbus_vtable = {dvb_satellite_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteAllChannelsToFile (self, path);
}


gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, channel_sids, channel_sids_length1, path);
}


void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, polarization, symbol_rate);
}


/* "horizontal", "vertical"
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


void _dvb_id_bus_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_introspect (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Satellite\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"polarization\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_property_get_all (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Satellite") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_satellite_scanner_Run (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_satellite_scanner_Destroy (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path;
	const char* _tmp1_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp1_);
	result = dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	path = (g_free (path), NULL);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp2_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint* channel_sids;
	int channel_sids_length1;
	guint* _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	char* path;
	const char* _tmp6_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "aus")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_sids = NULL;
	channel_sids_length1 = 0;
	_tmp3_ = g_new (guint, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		dbus_uint32_t _tmp5_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (guint, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = _tmp5_;
	}
	channel_sids_length1 = _tmp3__length1;
	dbus_message_iter_next (&iter);
	channel_sids = _tmp3_;
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp6_);
	result = dvb_id_bus_satellite_scanner_WriteChannelsToFile (self, channel_sids, channel_sids_length1, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	channel_sids = (g_free (channel_sids), NULL);
	path = (g_free (path), NULL);
	_tmp7_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp7_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency;
	dbus_uint32_t _tmp8_;
	char* polarization;
	const char* _tmp9_;
	guint symbol_rate;
	dbus_uint32_t _tmp10_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "usu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	frequency = _tmp8_;
	polarization = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	polarization = g_strdup (_tmp9_);
	symbol_rate = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	symbol_rate = _tmp10_;
	dvb_id_bus_satellite_scanner_AddScanningData (self, frequency, polarization, symbol_rate);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	polarization = (g_free (polarization), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path;
	const char* _tmp11_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp12_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp11_);
	result = dvb_id_bus_satellite_scanner_AddScanningDataFromFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	path = (g_free (path), NULL);
	_tmp12_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp12_);
	return reply;
}


DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "Run")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "Destroy")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "WriteAllChannelsToFile")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "WriteChannelsToFile")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "AddScanningData")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "AddScanningDataFromFile")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp13_;
	dbus_uint32_t _tmp14_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp13_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp13_);
	_tmp14_ = freq_left;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp14_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp15_;
	dbus_uint32_t _tmp16_;
	const char* _tmp17_;
	const char* _tmp18_;
	const char* _tmp19_;
	dbus_bool_t _tmp20_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp15_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp15_);
	_tmp16_ = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp16_);
	_tmp17_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17_);
	_tmp18_ = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18_);
	_tmp19_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	_tmp20_ = scrambled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp20_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_satellite_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_satellite_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_satellite_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_satellite_scanner_channel_added, connection);
}


static void dvb_id_bus_satellite_scanner_base_init (DVBIDBusSatelliteScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_type_set_qdata (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_satellite_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_satellite_scanner_get_type (void) {
	static GType dvb_id_bus_satellite_scanner_type_id = 0;
	if (dvb_id_bus_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusSatelliteScannerIface), (GBaseInitFunc) dvb_id_bus_satellite_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_satellite_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSatelliteScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_satellite_scanner_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_satellite_scanner_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_satellite_scanner_dbus_proxy_get_type);
	}
	return dvb_id_bus_satellite_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusSatelliteScannerDBusProxy, dvb_id_bus_satellite_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, dvb_id_bus_satellite_scanner_dbus_proxy_interface_init));
DVBIDBusSatelliteScanner* dvb_id_bus_satellite_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusSatelliteScanner* self;
	self = g_object_new (dvb_id_bus_satellite_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Satellite", NULL);
	return self;
}


static GObject* dvb_id_bus_satellite_scanner_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_satellite_scanner_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_satellite_scanner_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp21_;
	guint freq_left;
	dbus_uint32_t _tmp22_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp21_);
	dbus_message_iter_next (&iter);
	frequency = _tmp21_;
	freq_left = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp22_);
	dbus_message_iter_next (&iter);
	freq_left = _tmp22_;
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp23_;
	guint sid;
	dbus_uint32_t _tmp24_;
	const char* name;
	const char* _tmp25_;
	const char* network;
	const char* _tmp26_;
	const char* type;
	const char* _tmp27_;
	gboolean scrambled;
	dbus_bool_t _tmp28_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uusssb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23_);
	dbus_message_iter_next (&iter);
	frequency = _tmp23_;
	sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	sid = _tmp24_;
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp25_);
	network = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	network = g_strdup (_tmp26_);
	type = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	type = g_strdup (_tmp27_);
	scrambled = FALSE;
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	scrambled = _tmp28_;
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
}


DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "FrequencyScanned")) {
			_dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "Finished")) {
			_dbus_handle_dvb_id_bus_satellite_scanner_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "ChannelAdded")) {
			_dbus_handle_dvb_id_bus_satellite_scanner_channel_added (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_satellite_scanner_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_satellite_scanner_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_class_init (DVBIDBusSatelliteScannerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_satellite_scanner_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_satellite_scanner_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_satellite_scanner_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_satellite_scanner_dbus_proxy_set_property;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_init (DVBIDBusSatelliteScannerDBusProxy* self) {
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_Run (DVBIDBusSatelliteScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_Destroy (DVBIDBusSatelliteScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp29_;
	gboolean _result;
	dbus_bool_t _tmp30_;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "WriteAllChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp29_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30_);
	dbus_message_iter_next (&_iter);
	_result = _tmp30_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _tmp31_;
	DBusMessageIter _tmp32_;
	int _tmp33_;
	const char* _tmp35_;
	gboolean _result;
	dbus_bool_t _tmp36_;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp31_ = channel_sids;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "u", &_tmp32_);
	for (_tmp33_ = 0; _tmp33_ < channel_sids_length1; _tmp33_++) {
		dbus_uint32_t _tmp34_;
		_tmp34_ = *_tmp31_;
		dbus_message_iter_append_basic (&_tmp32_, DBUS_TYPE_UINT32, &_tmp34_);
		_tmp31_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp32_);
	_tmp35_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp35_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp36_);
	dbus_message_iter_next (&_iter);
	_result = _tmp36_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp37_;
	const char* _tmp38_;
	dbus_uint32_t _tmp39_;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp37_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp37_);
	_tmp38_ = polarization;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp38_);
	_tmp39_ = symbol_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp39_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp40_;
	gboolean _result;
	dbus_bool_t _tmp41_;
	if (((DVBIDBusSatelliteScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp40_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp41_);
	dbus_message_iter_next (&_iter);
	_result = _tmp41_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_interface_init (DVBIDBusSatelliteScannerIface* iface) {
	iface->Run = dvb_id_bus_satellite_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_satellite_scanner_dbus_proxy_Destroy;
	iface->WriteAllChannelsToFile = dvb_id_bus_satellite_scanner_dbus_proxy_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBSatelliteScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device) {
	return dvb_satellite_scanner_construct (DVB_TYPE_SATELLITE_SCANNER, device);
}


static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate) {
	DVBSatelliteScanner * self;
	GstStructure* tuning_params;
	const GstStructure* _tmp0_;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (polarization != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "polarization", G_TYPE_STRING, polarization, NULL);
	_tmp0_ = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0_ = tuning_params, (_tmp0_ == NULL) ? NULL : gst_structure_copy (_tmp0_)));
	(tuning_params == NULL) ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL));
}


static char* string_chug (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchug (_result_);
	result = _result_;
	return result;
}


static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path) {
	DVBSatelliteScanner * self;
	gboolean result;
	GError * _inner_error_;
	GFile* datafile;
	char* contents;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("SatelliteScanner.vala:69: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = dvb_utils_read_file_contents (datafile, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp1_ = NULL;
		contents = (_tmp1_ = _tmp0_, contents = (g_free (contents), NULL), _tmp1_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("SatelliteScanner.vala:75: Could not read %s: %s", e->message, path);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (contents == NULL) {
		result = FALSE;
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		return result;
	}
	/* line looks like:
	 S freq pol sr fec*/
	{
		char** _tmp2_;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		_tmp2_ = NULL;
		line_collection = _tmp2_ = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp2_);
		for (line_it = 0; line_it < _vala_array_length (_tmp2_); line_it = line_it + 1) {
			const char* _tmp8_;
			char* line;
			_tmp8_ = NULL;
			line = (_tmp8_ = line_collection[line_it], (_tmp8_ == NULL) ? NULL : g_strdup (_tmp8_));
			{
				char* _tmp3_;
				char** _tmp5_;
				gint cols_size;
				gint cols_length1;
				char** _tmp4_;
				char** cols;
				gint cols_length;
				guint freq;
				guint symbol_rate;
				char* pol;
				char* lower_pol;
				_tmp3_ = NULL;
				line = (_tmp3_ = string_chug (line), line = (g_free (line), NULL), _tmp3_);
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				cols = (_tmp5_ = _tmp4_ = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = _vala_array_length (_tmp4_), cols_size = cols_length1, _tmp5_);
				cols_length = 0;
				while (TRUE) {
					if (!(cols[cols_length] != NULL)) {
						break;
					}
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				symbol_rate = ((guint) atoi (cols[3])) / 1000;
				pol = NULL;
				lower_pol = g_utf8_strdown (cols[2], -1);
				if (_vala_strcmp0 (lower_pol, "h") == 0) {
					char* _tmp6_;
					_tmp6_ = NULL;
					pol = (_tmp6_ = g_strdup ("horizontal"), pol = (g_free (pol), NULL), _tmp6_);
				} else {
					if (_vala_strcmp0 (lower_pol, "v") == 0) {
						char* _tmp7_;
						_tmp7_ = NULL;
						pol = (_tmp7_ = g_strdup ("vertical"), pol = (g_free (pol), NULL), _tmp7_);
					} else {
						line = (g_free (line), NULL);
						cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
						pol = (g_free (pol), NULL);
						lower_pol = (g_free (lower_pol), NULL);
						continue;
					}
				}
				/* TODO what about fec?*/
				dvb_id_bus_satellite_scanner_AddScanningData ((DVBIDBusSatelliteScanner*) self, freq, pol, symbol_rate);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				pol = (g_free (pol), NULL);
				lower_pol = (g_free (lower_pol), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
	contents = (g_free (contents), NULL);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void dvb_satellite_scanner_real_prepare (DVBScanner* base) {
	DVBSatelliteScanner * self;
	GstElement* dvbsrc;
	char** _tmp1_;
	gint uint_keys_size;
	gint uint_keys_length1;
	char** _tmp0_;
	char** uint_keys;
	char* polarity;
	guint code_rate;
	self = (DVBSatelliteScanner*) base;
	g_debug ("SatelliteScanner.vala:116: Setting up pipeline for DVB-S scan");
	dvbsrc = gst_bin_get_by_name (GST_BIN (DVB_SCANNER (self)->pipeline), "dvbsrc");
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	uint_keys = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("frequency"), _tmp0_[1] = g_strdup ("symbol-rate"), _tmp0_), uint_keys_length1 = 2, uint_keys_size = uint_keys_length1, _tmp1_);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = uint_keys;
		key_collection_length1 = uint_keys_length1;
		for (key_it = 0; key_it < uint_keys_length1; key_it = key_it + 1) {
			const char* _tmp2_;
			char* key;
			_tmp2_ = NULL;
			key = (_tmp2_ = key_collection[key_it], (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
			{
				dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, key);
				key = (g_free (key), NULL);
			}
		}
	}
	polarity = string_substring (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "polarization"), (glong) 0, (glong) 1);
	g_object_set ((GObject*) dvbsrc, "polarity", polarity, NULL);
	code_rate = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "inner-fec", &code_rate);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", code_rate, NULL);
	(dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL));
	uint_keys = (_vala_array_free (uint_keys, uint_keys_length1, (GDestroyNotify) g_free), NULL);
	polarity = (g_free (polarity), NULL);
}


static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBSatelliteScanner * self;
	DVBScannedItem* result;
	char* pol;
	guint freq;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	/* dup string because get_string returns weak string*/
	pol = g_strdup_printf ("%s", gst_structure_get_string (structure, "polarization"));
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	result = (DVBScannedItem*) dvb_scanned_sattelite_item_new (freq, pol);
	pol = (g_free (pol), NULL);
	return result;
}


static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base) {
	DVBSatelliteScanner * self;
	DVBChannel* result;
	self = (DVBSatelliteScanner*) base;
	result = (DVBChannel*) dvb_satellite_channel_new ();
	return result;
}


static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBSatelliteScanner * self;
	DVBSatelliteChannel* _tmp0_;
	DVBSatelliteChannel* sc;
	guint freq;
	char* _tmp1_;
	guint srate;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_SATELLITE_CHANNEL (channel)) {
		return;
	}
	_tmp0_ = NULL;
	sc = (_tmp0_ = DVB_SATELLITE_CHANNEL (channel), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) sc, freq);
	_tmp1_ = NULL;
	dvb_satellite_channel_set_Polarization (sc, _tmp1_ = string_substring (gst_structure_get_string (delivery, "polarization"), (glong) 0, (glong) 1));
	_tmp1_ = (g_free (_tmp1_), NULL);
	srate = 0U;
	gst_structure_get_uint (delivery, "symbol-rate", &srate);
	dvb_satellite_channel_set_SymbolRate (sc, srate);
	/* TODO*/
	dvb_satellite_channel_set_DiseqcSource (sc, -1);
	(sc == NULL) ? NULL : (sc = (g_object_unref (sc), NULL));
}


void _dvb_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_satellite_scanner_introspect (DVBSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Satellite\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"polarization\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_satellite_scanner_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_satellite_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_satellite_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_satellite_scanner_dbus_register_object (connection, path, object);
}


static void dvb_satellite_scanner_class_init (DVBSatelliteScannerClass * klass) {
	dvb_satellite_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_satellite_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_satellite_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_satellite_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_satellite_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_SATELLITE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_satellite_scanner_dbus_vtable));
}


static void dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init (DVBIDBusSatelliteScannerIface * iface) {
	dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_satellite_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_satellite_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
}


static void dvb_satellite_scanner_instance_init (DVBSatelliteScanner * self) {
}


GType dvb_satellite_scanner_get_type (void) {
	static GType dvb_satellite_scanner_type_id = 0;
	if (dvb_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteScanner), 0, (GInstanceInitFunc) dvb_satellite_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_satellite_scanner_info = { (GInterfaceInitFunc) dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_satellite_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBSatelliteScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_satellite_scanner_type_id, DVB_TYPE_ID_BUS_SATELLITE_SCANNER, &dvb_id_bus_satellite_scanner_info);
	}
	return dvb_satellite_scanner_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



