/* CableScanner.c generated by valac 0.12.0, the Vala compiler
 * generated from CableScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;
typedef struct _DVBCableScannerPrivate DVBCableScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBCableScanner {
	DVBScanner parent_instance;
	DVBCableScannerPrivate * priv;
};

struct _DVBCableScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;


static gpointer dvb_cable_scanner_parent_class = NULL;
static DVBIDBusScannerIface* dvb_cable_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_cable_scanner_get_type (void) G_GNUC_CONST;
enum  {
	DVB_CABLE_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
static gboolean dvb_cable_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const gchar* modulation, guint symbol_rate, const gchar* code_rate);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_cable_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line);
static void dvb_cable_scanner_real_prepare (DVBScanner* base);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string);
static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base);
DVBCableChannel* dvb_cable_channel_new_without_schedule (void);
DVBCableChannel* dvb_cable_channel_construct_without_schedule (GType object_type);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device) {
	DVBCableScanner * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBCableScanner*) g_object_new (object_type, "Device", device, NULL);
	return self;
}


DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device) {
	return dvb_cable_scanner_construct (DVB_TYPE_CABLE_SCANNER, device);
}


static gboolean dvb_cable_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBCableScanner * self;
	gboolean result = FALSE;
	guint frequency = 0U;
	guint symbol_rate = 0U;
	gchar* modulation = NULL;
	gchar* code_rate = NULL;
	GVariant* _var = NULL;
	gconstpointer _tmp0_ = NULL;
	guint32 _tmp1_;
	gconstpointer _tmp2_ = NULL;
	guint32 _tmp3_;
	gconstpointer _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = g_hash_table_lookup (data, "frequency");
	_var = (GVariant*) _tmp0_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp1_ = g_variant_get_uint32 (_var);
	frequency = (guint) _tmp1_;
	_tmp2_ = g_hash_table_lookup (data, "symbol-rate");
	_var = (GVariant*) _tmp2_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp3_ = g_variant_get_uint32 (_var);
	symbol_rate = (guint) _tmp3_;
	_tmp4_ = g_hash_table_lookup (data, "inner-fec");
	_var = (GVariant*) _tmp4_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp5_ = g_variant_get_string (_var, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (code_rate);
	code_rate = _tmp6_;
	_tmp7_ = g_hash_table_lookup (data, "modulation");
	_var = (GVariant*) _tmp7_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp8_ = g_variant_get_string (_var, NULL);
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (modulation);
	modulation = _tmp9_;
	dvb_cable_scanner_add_scanning_data (self, frequency, modulation, symbol_rate, code_rate);
	result = TRUE;
	_g_free0 (code_rate);
	_g_free0 (modulation);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const gchar* modulation, guint symbol_rate, const gchar* code_rate) {
	GstStructure* _tmp0_ = NULL;
	GstStructure* tuning_params;
	GstStructure* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	_tmp0_ = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "inner-fec", G_TYPE_STRING, code_rate, "modulation", G_TYPE_STRING, modulation, NULL);
	tuning_params = _tmp0_;
	_tmp1_ = _gst_structure_copy0 (tuning_params);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _tmp1_);
	_gst_structure_free0 (tuning_params);
}


static void dvb_cable_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line) {
	DVBCableScanner * self;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** cols;
	gint cols_length1;
	gint _cols_size_;
	gint _tmp2_;
	guint freq;
	gchar* _tmp3_;
	gchar* modulation;
	gint _tmp4_;
	guint symbol_rate;
	gchar* _tmp5_;
	gchar* code_rate;
	self = (DVBCableScanner*) base;
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_regex_split_simple ("\\s+", line, 0, 0);
	cols = _tmp1_;
	cols_length1 = _vala_array_length (_tmp0_);
	_cols_size_ = _vala_array_length (_tmp0_);
	if (cols_length1 < 5) {
		cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp2_ = atoi (cols[1]);
	freq = (guint) _tmp2_;
	_tmp3_ = g_strdup (cols[4]);
	modulation = _tmp3_;
	_tmp4_ = atoi (cols[2]);
	symbol_rate = (guint) (_tmp4_ / 1000);
	_tmp5_ = g_strdup (cols[3]);
	code_rate = _tmp5_;
	dvb_cable_scanner_add_scanning_data (self, freq, modulation, symbol_rate, code_rate);
	_g_free0 (code_rate);
	_g_free0 (modulation);
	cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_cable_scanner_real_prepare (DVBScanner* base) {
	DVBCableScanner * self;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	const gchar* _tmp5_ = NULL;
	DVBDvbSrcModulation _tmp6_;
	const gchar* _tmp7_ = NULL;
	DVBDvbSrcCodeRate _tmp8_;
	self = (DVBCableScanner*) base;
	g_debug ("CableScanner.vala:87: Setting up pipeline for DVB-C scan");
	_tmp0_ = gst_bin_get_by_name (GST_BIN (((DVBScanner*) self)->pipeline), "dvbsrc");
	dvbsrc = _tmp0_;
	_tmp1_ = g_strdup ("frequency");
	_tmp2_ = g_strdup ("symbol-rate");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	keys = _tmp3_;
	keys_length1 = 2;
	_keys_size_ = 2;
	{
		gchar** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
			gchar* _tmp4_;
			gchar* key;
			_tmp4_ = g_strdup (key_collection[key_it]);
			key = _tmp4_;
			{
				dvb_scanner_set_uint_property (dvbsrc, ((DVBScanner*) self)->current_tuning_params, key);
				_g_free0 (key);
			}
		}
	}
	_tmp5_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "modulation");
	_tmp6_ = dvb_get_modulation_val (_tmp5_);
	g_object_set ((GObject*) dvbsrc, "modulation", _tmp6_, NULL);
	_tmp7_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "inner-fec");
	_tmp8_ = dvb_get_code_rate_val (_tmp7_);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", _tmp8_, NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_gst_object_unref0 (dvbsrc);
}


static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBCableScanner * self;
	DVBScannedItem* result = NULL;
	guint freq = 0U;
	guint _tmp0_;
	DVBScannedItem* _tmp1_ = NULL;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	gst_structure_get_uint (structure, "frequency", &_tmp0_);
	freq = _tmp0_;
	_tmp1_ = dvb_scanned_item_new (freq);
	result = _tmp1_;
	return result;
}


static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base) {
	DVBCableScanner * self;
	DVBChannel* result = NULL;
	DVBCableChannel* _tmp0_ = NULL;
	self = (DVBCableScanner*) base;
	_tmp0_ = dvb_cable_channel_new_without_schedule ();
	result = (DVBChannel*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBCableScanner * self;
	DVBCableChannel* _tmp0_;
	DVBCableChannel* cc;
	const gchar* _tmp1_ = NULL;
	DVBDvbSrcModulation _tmp2_;
	guint freq = 0U;
	guint _tmp3_;
	guint symbol_rate = 0U;
	guint _tmp4_;
	const gchar* _tmp5_ = NULL;
	DVBDvbSrcCodeRate _tmp6_;
	self = (DVBCableScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_CABLE_CHANNEL (channel)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (DVB_CABLE_CHANNEL (channel));
	cc = _tmp0_;
	dvb_cable_channel_set_Inversion (cc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	_tmp1_ = gst_structure_get_string (delivery, "modulation");
	_tmp2_ = dvb_get_modulation_val (_tmp1_);
	dvb_cable_channel_set_Modulation (cc, _tmp2_);
	gst_structure_get_uint (delivery, "frequency", &_tmp3_);
	freq = _tmp3_;
	dvb_channel_set_Frequency ((DVBChannel*) cc, freq);
	gst_structure_get_uint (delivery, "symbol-rate", &_tmp4_);
	symbol_rate = _tmp4_;
	dvb_cable_channel_set_SymbolRate (cc, symbol_rate);
	_tmp5_ = gst_structure_get_string (delivery, "inner-fec");
	_tmp6_ = dvb_get_code_rate_val (_tmp5_);
	dvb_cable_channel_set_CodeRate (cc, _tmp6_);
	_g_object_unref0 (cc);
}


static void dvb_cable_scanner_class_init (DVBCableScannerClass * klass) {
	dvb_cable_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_cable_scanner_real_add_scanning_data_from_string;
	DVB_SCANNER_CLASS (klass)->prepare = dvb_cable_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_cable_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_cable_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_cable_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_cable_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_cable_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner* ,GHashTable* ,GError**)) dvb_cable_scanner_real_AddScanningData;
	iface->Run = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,guint* ,int ,const gchar* ,GError**)) dvb_scanner_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_AddScanningDataFromFile;
}


static void dvb_cable_scanner_instance_init (DVBCableScanner * self) {
}


GType dvb_cable_scanner_get_type (void) {
	static volatile gsize dvb_cable_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_cable_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableScanner), 0, (GInstanceInitFunc) dvb_cable_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_cable_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_cable_scanner_type_id;
		dvb_cable_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBCableScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_cable_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_cable_scanner_type_id__volatile, dvb_cable_scanner_type_id);
	}
	return dvb_cable_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



