/* Manager.c generated by valac 0.12.0, the Vala compiler
 * generated from Manager.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gudev/gudev.h>
#include <stdio.h>


#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_hash_table_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_hash_table_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
};

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};

struct _DVBManagerPrivate {
	GeeHashMap* scanners;
	GStaticRecMutex __lock_scanners;
	GeeHashMap* devices;
	GStaticRecMutex __lock_devices;
	guint device_group_counter;
	GUdevClient* udev_client;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	gchar* (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};


static gpointer dvb_manager_parent_class = NULL;
static DVBLoggingLogger* dvb_manager_log;
static DVBLoggingLogger* dvb_manager_log = NULL;
static DVBManager* dvb_manager_instance;
static DVBManager* dvb_manager_instance = NULL;
static GStaticRecMutex dvb_manager_instance_mutex;
static GStaticRecMutex dvb_manager_instance_mutex = {0};
extern GDBusConnection* main_conn;
static DVBIDBusManagerIface* dvb_manager_dvb_id_bus_manager_parent_iface = NULL;

GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
GType dvb_manager_get_type (void) G_GNUC_CONST;
GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
#define DVB_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MANAGER, DVBManagerPrivate))
enum  {
	DVB_MANAGER_DUMMY_PROPERTY,
	DVB_MANAGER_DEVICE_GROUPS
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBManager* dvb_manager_get_instance (void);
DVBManager* dvb_manager_new (void);
DVBManager* dvb_manager_construct (GType object_type);
void dvb_manager_shutdown (void);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_device_group_destroy (DVBDeviceGroup* self);
static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
#define DVB_CONSTANTS_DBUS_SCANNER_PATH "/org/gnome/DVB/Scanner/%d/%d"
GType dvb_device_get_type (void) G_GNUC_CONST;
static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_terrestrial_scanner_get_type (void) G_GNUC_CONST;
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_satellite_scanner_get_type (void) G_GNUC_CONST;
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_cable_scanner_get_type (void) G_GNUC_CONST;
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner);
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self);
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error);
#define DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH "/org/gnome/DVB/DeviceGroup/%u"
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error);
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
GQuark dvb_device_error_quark (void);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error);
gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group);
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error);
const gchar* dvb_device_get_Name (DVBDevice* self);
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error);
static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error);
GQuark dvb_database_sql_error_quark (void);
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_channel_groups (DVBdatabaseConfigStore* self, GError** error);
gint dvb_channel_group_get_id (DVBChannelGroup* self);
const gchar* dvb_channel_group_get_name (DVBChannelGroup* self);
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length);
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error);
gboolean dvb_database_config_store_add_channel_group (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_group (DVBdatabaseConfigStore* self, gint group_id, GError** error);
static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_list_free__g_hash_table_unref0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_database_config_store_add_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend);
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
DVBdatabaseTimersStore* dvb_factory_get_timers_store (void);
GeeList* dvb_database_timers_store_get_all_timers_of_device_group (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
GType dvb_recorder_get_type (void) G_GNUC_CONST;
DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
gboolean dvb_database_config_store_remove_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
gboolean dvb_database_epg_store_remove_events_of_group (DVBdatabaseEPGStore* self, guint group_id, GError** error);
gboolean dvb_database_timers_store_remove_all_timers_from_device_group (DVBdatabaseTimersStore* self, guint group_id, GError** error);
static void dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id);
GeeList* dvb_database_config_store_get_all_device_groups (DVBdatabaseConfigStore* self, GError** error);
static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device);
gboolean dvb_database_config_store_get_parent_group (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
static void dvb_manager_finalize (GObject* obj);
static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* DVB_MANAGER_UDEV_SUBSYSTEMS[2] = {"dvb", NULL};

DVBManager* dvb_manager_get_instance (void) {
	DVBManager* result = NULL;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	if (dvb_manager_instance == NULL) {
		DVBManager* _tmp0_ = NULL;
		_tmp0_ = dvb_manager_new ();
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = _tmp0_;
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	result = dvb_manager_instance;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_manager_shutdown (void) {
	DVBManager* _tmp0_;
	DVBManager* m;
	GError * _inner_error_ = NULL;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	_tmp0_ = _g_object_ref0 (dvb_manager_instance);
	m = _tmp0_;
	if (dvb_manager_instance != NULL) {
		_g_object_unref0 (m->priv->udev_client);
		m->priv->udev_client = NULL;
		{
			g_static_rec_mutex_lock (&m->priv->__lock_scanners);
			{
				GeeCollection* _tmp1_ = NULL;
				GeeCollection* _tmp2_;
				GeeIterator* _tmp3_ = NULL;
				GeeIterator* _tmp4_;
				GeeIterator* _scanner_it;
				_tmp1_ = gee_map_get_values ((GeeMap*) m->priv->scanners);
				_tmp2_ = _tmp1_;
				_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
				_tmp4_ = _tmp3_;
				_g_object_unref0 (_tmp2_);
				_scanner_it = _tmp4_;
				while (TRUE) {
					gboolean _tmp5_;
					gpointer _tmp6_ = NULL;
					DVBScanner* scanner;
					_tmp5_ = gee_iterator_next (_scanner_it);
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = gee_iterator_get (_scanner_it);
					scanner = (DVBScanner*) _tmp6_;
					dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:76: Stopping scanner");
					dvb_scanner_do_destroy (scanner);
					_g_object_unref0 (scanner);
				}
				_g_object_unref0 (_scanner_it);
			}
			gee_abstract_map_clear ((GeeAbstractMap*) m->priv->scanners);
			__finally80:
			g_static_rec_mutex_unlock (&m->priv->__lock_scanners);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			g_static_rec_mutex_lock (&m->priv->__lock_devices);
			{
				GeeCollection* _tmp7_ = NULL;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_;
				GeeIterator* _devgrp_it;
				_tmp7_ = gee_map_get_values ((GeeMap*) m->priv->devices);
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_devgrp_it = _tmp10_;
				while (TRUE) {
					gboolean _tmp11_;
					gpointer _tmp12_ = NULL;
					DVBDeviceGroup* devgrp;
					_tmp11_ = gee_iterator_next (_devgrp_it);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = gee_iterator_get (_devgrp_it);
					devgrp = (DVBDeviceGroup*) _tmp12_;
					dvb_device_group_destroy (devgrp);
					_g_object_unref0 (devgrp);
				}
				_g_object_unref0 (_devgrp_it);
			}
			gee_abstract_map_clear ((GeeAbstractMap*) m->priv->devices);
			__finally81:
			g_static_rec_mutex_unlock (&m->priv->__lock_devices);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = NULL;
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_g_object_unref0 (m);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @opath: Object path of the scanner service
         * @dbusiface: DBus interface of the scanner service
         * @returns: TRUE on success
         *
         * Get the object path of the channel scanner for this device.
         */
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self) {
	dvb_manager_on_scanner_destroyed (self, _sender);
}


static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error) {
	DVBManager * self;
	char* _opath = NULL;
	gchar* _dbusiface = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* path;
	char* _tmp1_ = NULL;
	DVBDevice* device = NULL;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* reg_dev;
	DVBAdapterType _tmp7_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	path = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_opath);
	_opath = _tmp1_;
	_tmp2_ = dvb_manager_get_registered_device (self, adapter, frontend);
	reg_dev = _tmp2_;
	if (reg_dev == NULL) {
		DVBDevice* _tmp3_ = NULL;
		_tmp3_ = dvb_device_new_with_type (adapter, frontend);
		_g_object_unref0 (device);
		device = _tmp3_;
	} else {
		DVBDeviceGroup* _tmp4_ = NULL;
		DVBDeviceGroup* _tmp5_;
		DVBDevice* _tmp6_;
		_tmp4_ = dvb_manager_get_device_group_of_device (self, reg_dev);
		_tmp5_ = _tmp4_;
		dvb_device_group_stop_epg_scanner (_tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = _g_object_ref0 (reg_dev);
		_g_object_unref0 (device);
		device = _tmp6_;
	}
	_tmp7_ = dvb_device_get_Type (device);
	switch (_tmp7_) {
		case DVB_ADAPTER_TYPE_DVB_C:
		case DVB_ADAPTER_TYPE_DVB_S:
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("org.gnome.DVB.Scanner");
			_g_free0 (_dbusiface);
			_dbusiface = _tmp8_;
			break;
		}
		default:
		{
			_g_free0 (_dbusiface);
			_dbusiface = NULL;
			break;
		}
	}
	if (_dbusiface == NULL) {
		gchar* _tmp9_;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:136: Unknown adapter type");
		_tmp9_ = g_strdup ("");
		_g_free0 (_dbusiface);
		_dbusiface = _tmp9_;
		result = FALSE;
		_g_object_unref0 (reg_dev);
		_g_object_unref0 (device);
		_g_free0 (path);
		if (opath) {
			*opath = _opath;
		} else {
			_g_free0 (_opath);
		}
		if (dbusiface) {
			*dbusiface = _dbusiface;
		} else {
			_g_free0 (_dbusiface);
		}
		return result;
	}
	{
		gboolean _tmp10_;
		g_static_rec_mutex_lock (&self->priv->__lock_scanners);
		_tmp10_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->scanners, path);
		if (!_tmp10_) {
			DVBScanner* scanner;
			DVBAdapterType _tmp11_;
			scanner = NULL;
			_tmp11_ = dvb_device_get_Type (device);
			switch (_tmp11_) {
				case DVB_ADAPTER_TYPE_DVB_T:
				{
					DVBTerrestrialScanner* _tmp12_ = NULL;
					_tmp12_ = dvb_terrestrial_scanner_new (device);
					_g_object_unref0 (scanner);
					scanner = (DVBScanner*) _tmp12_;
					break;
				}
				case DVB_ADAPTER_TYPE_DVB_S:
				{
					DVBSatelliteScanner* _tmp13_ = NULL;
					_tmp13_ = dvb_satellite_scanner_new (device);
					_g_object_unref0 (scanner);
					scanner = (DVBScanner*) _tmp13_;
					break;
				}
				case DVB_ADAPTER_TYPE_DVB_C:
				{
					DVBCableScanner* _tmp14_ = NULL;
					_tmp14_ = dvb_cable_scanner_new (device);
					_g_object_unref0 (scanner);
					scanner = (DVBScanner*) _tmp14_;
					break;
				}
				default:
				break;
			}
			dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_SCANNER, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, path, DVB_ID_BUS_SCANNER (scanner));
			g_signal_connect_object (scanner, "destroyed", (GCallback) _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed, self, 0);
			gee_abstract_map_set ((GeeAbstractMap*) self->priv->scanners, path, scanner);
			dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:164: Created new Scanner D-Bus service for adapter %u, fr" \
"ontend %u (%s)", adapter, frontend, _dbusiface);
			_g_object_unref0 (scanner);
		}
		__finally82:
		g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (reg_dev);
				_g_object_unref0 (device);
				_g_free0 (path);
				return FALSE;
			} else {
				_g_object_unref0 (reg_dev);
				_g_object_unref0 (device);
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (reg_dev);
	_g_object_unref0 (device);
	_g_free0 (path);
	if (opath) {
		*opath = _opath;
	} else {
		_g_free0 (_opath);
	}
	if (dbusiface) {
		*dbusiface = _dbusiface;
	} else {
		_g_free0 (_dbusiface);
	}
	return result;
}


/**
         * @group_id: A group ID
         * @path: Device group's DBus path
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error) {
	DVBManager * self;
	char* _opath = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
		if (_tmp0_) {
			gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			char* _tmp3_ = NULL;
			_tmp1_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, group_id);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (_opath);
			_opath = _tmp3_;
			_g_free0 (_tmp2_);
			ret = TRUE;
		} else {
			char* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("");
			_g_free0 (_opath);
			_opath = _tmp4_;
			ret = FALSE;
		}
		__finally83:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (opath) {
		*opath = _opath;
	} else {
		_g_free0 (_opath);
	}
	return result;
}


/**
         * @returns: Device groups' DBus path
         */
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	char** result = NULL;
	gint _tmp0_;
	char** _tmp1_ = NULL;
	char** devs;
	gint devs_length1;
	gint _devs_size_;
	gint i;
	char** _tmp12_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->devices);
	_tmp1_ = g_new0 (char*, _tmp0_ + 1);
	devs = _tmp1_;
	devs_length1 = _tmp0_;
	_devs_size_ = _tmp0_;
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _key_it;
			_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->devices);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_key_it = _tmp5_;
			while (TRUE) {
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				guint key;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				char* _tmp10_ = NULL;
				char* _tmp11_;
				_tmp6_ = gee_iterator_next (_key_it);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp7_);
				_tmp8_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, key);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (devs[i]);
				devs[i] = _tmp11_;
				_g_free0 (_tmp9_);
				i++;
			}
			_g_object_unref0 (_key_it);
		}
		__finally84:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			} else {
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp12_ = devs;
	*result_length1 = devs_length1;
	result = _tmp12_;
	return result;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @channels_conf: Path to channels.conf for this device
         * @recordings_dir: Path where the recordings should be stored
         * @name: Name of group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new DeviceGroup and new DVB device whereas the
         * DVB device is the reference device of this group (i.e.
         * all other devices of this group will inherit the settings
         * of the reference device).
         */
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* chan_file;
	GFile* _tmp1_ = NULL;
	GFile* rec_dir;
	DVBDevice* device = NULL;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* _tmp3_;
	gboolean _tmp4_;
	DVBDeviceGroup* _tmp5_ = NULL;
	DVBDeviceGroup* devgroup;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (channels_conf != NULL, FALSE);
	g_return_val_if_fail (recordings_dir != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (channels_conf);
	chan_file = _tmp0_;
	_tmp1_ = g_file_new_for_path (recordings_dir);
	rec_dir = _tmp1_;
	_tmp2_ = dvb_device_new_full (adapter, frontend, chan_file, rec_dir, self->priv->device_group_counter + 1, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DEVICE_ERROR) {
			goto __catch85_dvb_device_error;
		}
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (device);
	device = _tmp3_;
	goto __finally85;
	__catch85_dvb_device_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:234: Could not create device: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	__finally85:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			return FALSE;
		} else {
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp4_ = dvb_manager_device_is_in_any_group (self, device);
	if (_tmp4_) {
		result = FALSE;
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	self->priv->device_group_counter++;
	_tmp5_ = dvb_device_group_new (self->priv->device_group_counter, device, TRUE);
	devgroup = _tmp5_;
	dvb_device_group_set_Name (devgroup, name);
	dvb_manager_restore_device_group (self, devgroup);
	g_signal_emit_by_name ((DVBIDBusManager*) self, "group-added", self->priv->device_group_counter);
	result = TRUE;
	_g_object_unref0 (devgroup);
	_g_object_unref0 (device);
	_g_object_unref0 (rec_dir);
	_g_object_unref0 (chan_file);
	return result;
}


/**
         * @adapter: Adapter of device
         * @frontend: Frontend of device
         * @name: The name of the device or "Unknown"
         * @returns: TRUE on success
         *
         * The device must be part of group, otherwise "Unknown"
         * is returned.
         */
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error) {
	DVBManager * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* dev;
	self = (DVBManager*) base;
	_tmp0_ = dvb_manager_get_registered_device (self, adapter, frontend);
	dev = _tmp0_;
	if (dev == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (_name);
		_name = _tmp1_;
		result = FALSE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _name;
		} else {
			_g_free0 (_name);
		}
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = dvb_device_get_Name (dev);
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_name);
		_name = _tmp3_;
		result = TRUE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _name;
		} else {
			_g_free0 (_name);
		}
		return result;
	}
	_g_object_unref0 (dev);
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
}


/**
         * @returns: the numner of configured device groups
         */
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error) {
	DVBManager * self;
	gint result = 0;
	gint _tmp0_;
	self = (DVBManager*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->devices);
	result = _tmp0_;
	return result;
}


/**
         * @returns: ID and name of each channel group
         */
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_group_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	DVBChannelGroupInfo* result = NULL;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	GeeList* groups = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_;
	gint _tmp5_;
	DVBChannelGroupInfo* _tmp6_ = NULL;
	DVBChannelGroupInfo* arr;
	gint arr_length1;
	gint _arr_size_;
	DVBChannelGroupInfo* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	_tmp1_ = dvb_database_config_store_get_channel_groups (config, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch86_dvb_database_sql_error;
		}
		_g_object_unref0 (groups);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (groups);
	groups = _tmp2_;
	goto __finally86;
	__catch86_dvb_database_sql_error:
	{
		GError * e;
		DVBChannelGroupInfo* _tmp3_ = NULL;
		DVBChannelGroupInfo* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:292: %s", e->message);
		_tmp3_ = g_new0 (DVBChannelGroupInfo, 0);
		_tmp4_ = _tmp3_;
		*result_length1 = 0;
		result = _tmp4_;
		_g_error_free0 (e);
		_g_object_unref0 (groups);
		_g_object_unref0 (config);
		return result;
	}
	__finally86:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			return NULL;
		} else {
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = gee_collection_get_size ((GeeCollection*) groups);
	_tmp6_ = g_new0 (DVBChannelGroupInfo, _tmp5_);
	arr = _tmp6_;
	arr_length1 = _tmp5_;
	_arr_size_ = _tmp5_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				DVBChannelGroup* cg;
				DVBChannelGroupInfo _tmp9_ = {0};
				DVBChannelGroupInfo _tmp10_ = {0};
				DVBChannelGroupInfo _tmp11_;
				gint _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				if (!(i < arr_length1)) {
					break;
				}
				_tmp8_ = gee_list_get (groups, i);
				cg = (DVBChannelGroup*) _tmp8_;
				memset (&_tmp9_, 0, sizeof (DVBChannelGroupInfo));
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_;
				dvb_channel_group_info_destroy (&arr[i]);
				arr[i] = _tmp11_;
				_tmp12_ = dvb_channel_group_get_id (cg);
				arr[i].id = _tmp12_;
				_tmp13_ = dvb_channel_group_get_name (cg);
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (arr[i].name);
				arr[i].name = _tmp14_;
				_g_object_unref0 (cg);
			}
		}
	}
	_tmp15_ = arr;
	*result_length1 = arr_length1;
	result = _tmp15_;
	_g_object_unref0 (groups);
	_g_object_unref0 (config);
	return result;
}


/**
         * @name: Name of the new group
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error) {
	DVBManager * self;
	gint _channel_group_id = 0;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	gint _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	_tmp2_ = dvb_database_config_store_add_channel_group (config, name, &_tmp1_, &_inner_error_);
	_channel_group_id = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch87_dvb_database_sql_error;
		}
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = _tmp3_;
	goto __finally87;
	__catch87_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:315: %s", e->message);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally87:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	if (channel_group_id) {
		*channel_group_id = _channel_group_id;
	}
	return result;
}


/**
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	_tmp1_ = dvb_database_config_store_remove_channel_group (config, channel_group_id, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch88_dvb_database_sql_error;
		}
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = _tmp2_;
	goto __finally88;
	__catch88_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:331: %s", e->message);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally88:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	return result;
}


/**
         * @returns: informations about all connected
         * devices retrieved via udev
         */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _g_list_free__g_hash_table_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_hash_table_unref0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	GHashTable** result = NULL;
	GList* _tmp0_ = NULL;
	GList* devices;
	GList* devices_list;
	guint _tmp23_;
	GHashTable** _tmp24_ = NULL;
	GHashTable** arr;
	gint arr_length1;
	gint _arr_size_;
	GHashTable** _tmp30_;
	self = (DVBManager*) base;
	_tmp0_ = g_udev_client_query_by_subsystem (self->priv->udev_client, "dvb");
	devices = _tmp0_;
	devices_list = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				gconstpointer _tmp3_ = NULL;
				GUdevDevice* _tmp4_;
				GUdevDevice* dev;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* device_file;
				gboolean _tmp7_ = FALSE;
				GHashTable* _tmp9_ = NULL;
				GHashTable* map;
				GHashTable* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GUdevDevice* _tmp13_ = NULL;
				GUdevDevice* _tmp14_;
				GUdevDevice* parent;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = g_list_length (devices);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = g_list_nth_data (devices, (guint) i);
				_tmp4_ = _g_object_ref0 ((GUdevDevice*) _tmp3_);
				dev = _tmp4_;
				_tmp5_ = g_udev_device_get_device_file (dev);
				_tmp6_ = g_strdup (_tmp5_);
				device_file = _tmp6_;
				if (device_file == NULL) {
					_tmp7_ = TRUE;
				} else {
					gboolean _tmp8_;
					_tmp8_ = string_contains (device_file, "frontend");
					_tmp7_ = !_tmp8_;
				}
				if (_tmp7_) {
					_g_free0 (device_file);
					_g_object_unref0 (dev);
					continue;
				}
				_tmp9_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
				map = _tmp9_;
				_tmp10_ = _g_hash_table_ref0 (map);
				devices_list = g_list_prepend (devices_list, _tmp10_);
				_tmp11_ = g_strdup ("device_file");
				_tmp12_ = g_strdup (device_file);
				g_hash_table_insert (map, _tmp11_, _tmp12_);
				_tmp13_ = g_udev_device_get_parent (dev);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				parent = _tmp14_;
				if (parent != NULL) {
					gchar* attr = NULL;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					_tmp15_ = g_udev_device_get_sysfs_attr (parent, "manufacturer");
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (attr);
					attr = _tmp16_;
					if (attr != NULL) {
						gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp17_ = g_strdup ("manufacturer");
						_tmp18_ = g_strdup (attr);
						g_hash_table_insert (map, _tmp17_, _tmp18_);
					}
					_tmp19_ = g_udev_device_get_sysfs_attr (parent, "product");
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (attr);
					attr = _tmp20_;
					if (attr != NULL) {
						gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp21_ = g_strdup ("product");
						_tmp22_ = g_strdup (attr);
						g_hash_table_insert (map, _tmp21_, _tmp22_);
					}
					_g_free0 (attr);
				}
				_g_object_unref0 (parent);
				_g_hash_table_unref0 (map);
				_g_free0 (device_file);
				_g_object_unref0 (dev);
			}
		}
	}
	_tmp23_ = g_list_length (devices_list);
	_tmp24_ = g_new0 (GHashTable*, _tmp23_ + 1);
	arr = _tmp24_;
	arr_length1 = _tmp23_;
	_arr_size_ = _tmp23_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				guint _tmp26_;
				gconstpointer _tmp27_ = NULL;
				GHashTable* _tmp28_;
				GHashTable* _tmp29_;
				if (!_tmp25_) {
					i++;
				}
				_tmp25_ = FALSE;
				_tmp26_ = g_list_length (devices_list);
				if (!(i < _tmp26_)) {
					break;
				}
				_tmp27_ = g_list_nth_data (devices_list, (guint) i);
				_tmp28_ = _g_hash_table_ref0 ((GHashTable*) _tmp27_);
				_tmp29_ = _tmp28_;
				_g_hash_table_unref0 (arr[i]);
				arr[i] = _tmp29_;
			}
		}
	}
	_tmp30_ = arr;
	*result_length1 = arr_length1;
	result = _tmp30_;
	__g_list_free__g_hash_table_unref0_0 (devices_list);
	__g_list_free__g_object_unref0_0 (devices);
	return result;
}


/**
         * @returns: Whether the device has been added successfully
         *
         * Register device, create Recorder and ChannelList D-Bus service
         */
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self) {
	dvb_manager_on_device_removed_from_group (self, _sender, adapter, frontend);
}


gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint group_id;
	gint _tmp1_;
	DVBAdapterType _tmp2_;
	DVBdatabaseConfigStore* _tmp4_ = NULL;
	DVBdatabaseConfigStore* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp0_ = dvb_device_group_get_Id (devgroup);
	group_id = _tmp0_;
	_tmp1_ = dvb_device_group_get_size (devgroup);
	dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:385: Adding device group %u with %d devices", group_id, _tmp1_);
	_tmp2_ = dvb_device_group_get_Type (devgroup);
	if (_tmp2_ == DVB_ADAPTER_TYPE_UNKNOWN) {
		guint _tmp3_;
		_tmp3_ = dvb_device_group_get_Id (devgroup);
		dvb_logging_logger_warning (dvb_manager_log, "Manager.vala:389: Not adding device group %u of unknown type", _tmp3_);
		result = FALSE;
		return result;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id), devgroup);
		__finally89:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp4_ = dvb_factory_get_config_store ();
	_tmp5_ = _tmp4_;
	dvb_database_config_store_add_device_group (_tmp5_, devgroup, &_inner_error_);
	_g_object_unref0 (_tmp5_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch90_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	goto __finally90;
	__catch90_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:400: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally90:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_signal_connect_object ((DVBIDBusDeviceGroup*) devgroup, "device-removed", (GCallback) _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed, self, 0);
	_tmp6_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, group_id);
	path = _tmp6_;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, path, (DVBIDBusDeviceGroup*) devgroup);
	if (group_id > self->priv->device_group_counter) {
		self->priv->device_group_counter = group_id;
	}
	dvb_device_group_start_epg_scanner (devgroup);
	result = TRUE;
	_g_free0 (path);
	return result;
}


gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group) {
	gboolean result = FALSE;
	guint _tmp0_;
	DVBChannelList* _tmp1_ = NULL;
	DVBAdapterType _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device_group != NULL, FALSE);
	_tmp0_ = dvb_device_group_get_Id (device_group);
	dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:418: Restoring group %u", _tmp0_);
	_tmp1_ = dvb_device_group_get_Channels (device_group);
	_tmp2_ = dvb_device_group_get_Type (device_group);
	dvb_channel_list_load (_tmp1_, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch91_g_error;
	}
	goto __finally91;
	__catch91_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:423: Error reading channels from file: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally91:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = dvb_manager_add_device_group (self, device_group);
	result = _tmp3_;
	return result;
}


void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	guint _tmp0_;
	DVBdatabaseTimersStore* _tmp1_ = NULL;
	DVBdatabaseTimersStore* timers_store;
	GeeList* timers = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_;
	guint32 max_id;
	DVBRecorder* _tmp5_ = NULL;
	DVBRecorder* _tmp6_;
	DVBRecorder* rec;
	DVBRecordingsStore* _tmp15_ = NULL;
	DVBRecordingsStore* _tmp16_;
	DVBRecordingsStore* recstore;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = dvb_device_group_get_Id (device_group);
	dvb_logging_logger_info (dvb_manager_log, "Manager.vala:431: Restoring timers of device group %u", _tmp0_);
	_tmp1_ = dvb_factory_get_timers_store ();
	timers_store = _tmp1_;
	_tmp2_ = dvb_database_timers_store_get_all_timers_of_device_group (timers_store, device_group, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch92_dvb_database_sql_error;
		}
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (timers);
	timers = _tmp3_;
	goto __finally92;
	__catch92_dvb_database_sql_error:
	{
		GError * e;
		guint _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = dvb_device_group_get_Id (device_group);
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:439: Failed retrieving timers of group %u: %s", _tmp4_, e->message);
		_g_error_free0 (e);
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		return;
	}
	__finally92:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	max_id = (guint32) 0;
	_tmp5_ = dvb_device_group_get_recorder (device_group);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	rec = _tmp6_;
	{
		GeeList* _tmp7_;
		GeeList* _t_list;
		gint _tmp8_;
		gint _t_size;
		gint _t_index;
		_tmp7_ = _g_object_ref0 (timers);
		_t_list = _tmp7_;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _t_list);
		_t_size = _tmp8_;
		_t_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			DVBTimer* t;
			guint32 _tmp10_;
			guint32 rec_id = 0U;
			guint32 _tmp12_;
			gboolean _tmp13_;
			_t_index = _t_index + 1;
			if (!(_t_index < _t_size)) {
				break;
			}
			_tmp9_ = gee_list_get (_t_list, _t_index);
			t = (DVBTimer*) _tmp9_;
			_tmp10_ = dvb_timer_get_Id (t);
			if (_tmp10_ > max_id) {
				guint32 _tmp11_;
				_tmp11_ = dvb_timer_get_Id (t);
				max_id = _tmp11_;
			}
			_tmp13_ = dvb_recorder_add_timer (rec, t, &_tmp12_);
			rec_id = _tmp12_;
			if (!_tmp13_) {
				guint32 _tmp14_;
				_tmp14_ = dvb_timer_get_Id (t);
				dvb_database_timers_store_remove_timer_from_device_group (timers_store, (guint) _tmp14_, device_group, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch93_dvb_database_sql_error;
					}
					_g_object_unref0 (t);
					_g_object_unref0 (_t_list);
					_g_object_unref0 (rec);
					_g_object_unref0 (timers);
					_g_object_unref0 (timers_store);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				goto __finally93;
				__catch93_dvb_database_sql_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					dvb_logging_logger_error (dvb_manager_log, "Manager.vala:453: Failed removing timer: %s", e->message);
					_g_error_free0 (e);
				}
				__finally93:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (t);
					_g_object_unref0 (_t_list);
					_g_object_unref0 (rec);
					_g_object_unref0 (timers);
					_g_object_unref0 (timers_store);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	_tmp15_ = dvb_recordings_store_get_instance ();
	_tmp16_ = _g_object_ref0 (_tmp15_);
	recstore = _tmp16_;
	dvb_recordings_store_update_last_id (recstore, max_id);
	_g_object_unref0 (recstore);
	_g_object_unref0 (rec);
	_g_object_unref0 (timers);
	_g_object_unref0 (timers_store);
}


void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = dvb_manager_restore_device_group (self, device_group);
	if (_tmp0_) {
		dvb_manager_restore_timers (self, device_group);
	}
}


DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id) {
	DVBDeviceGroup* result = NULL;
	DVBDeviceGroup* _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
			_g_object_unref0 (_result_);
			_result_ = (DVBDeviceGroup*) _tmp1_;
		}
		__finally94:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_result_ = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _group_id_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->devices);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_group_id_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint group_id;
				gpointer _tmp6_ = NULL;
				DVBDeviceGroup* devgroup;
				gboolean _tmp7_;
				_tmp4_ = gee_iterator_next (_group_id_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_group_id_it);
				group_id = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				devgroup = (DVBDeviceGroup*) _tmp6_;
				_tmp7_ = dvb_device_group_contains (devgroup, device);
				if (_tmp7_) {
					_result_ = TRUE;
					_g_object_unref0 (devgroup);
					break;
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
		__finally95:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner) {
	DVBDevice* _tmp0_ = NULL;
	guint _tmp1_;
	guint adapter;
	DVBDevice* _tmp2_ = NULL;
	guint _tmp3_;
	guint frontend;
	gchar* _tmp4_ = NULL;
	gchar* path;
	DVBDevice* _tmp5_ = NULL;
	DVBDeviceGroup* _tmp6_ = NULL;
	DVBDeviceGroup* devgroup;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = dvb_scanner_get_Device (scanner);
	_tmp1_ = dvb_device_get_Adapter (_tmp0_);
	adapter = _tmp1_;
	_tmp2_ = dvb_scanner_get_Device (scanner);
	_tmp3_ = dvb_device_get_Frontend (_tmp2_);
	frontend = _tmp3_;
	_tmp4_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	path = _tmp4_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_scanners);
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->scanners, path, NULL);
		__finally96:
		g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:501: Destroying scanner for adapter %u, frontend %u (%s)", adapter, frontend, path);
	_tmp5_ = dvb_scanner_get_Device (scanner);
	_tmp6_ = dvb_manager_get_device_group_of_device (self, _tmp5_);
	devgroup = _tmp6_;
	if (devgroup != NULL) {
		dvb_device_group_start_epg_scanner (devgroup);
	}
	_g_object_unref0 (devgroup);
	_g_free0 (path);
}


static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	DVBDevice* _result_;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* fake_device;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = dvb_device_new (adapter, frontend);
	fake_device = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeSet* _tmp1_ = NULL;
			GeeSet* _tmp2_;
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _tmp4_;
			GeeIterator* _group_id_it;
			_tmp1_ = gee_map_get_keys ((GeeMap*) self->priv->devices);
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_group_id_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				guint group_id;
				gpointer _tmp7_ = NULL;
				DVBDeviceGroup* devgroup;
				gboolean _tmp8_;
				_tmp5_ = gee_iterator_next (_group_id_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = gee_iterator_get (_group_id_it);
				group_id = GPOINTER_TO_UINT (_tmp6_);
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				devgroup = (DVBDeviceGroup*) _tmp7_;
				_tmp8_ = dvb_device_group_contains (devgroup, fake_device);
				if (_tmp8_) {
					{
						GeeIterator* _tmp9_ = NULL;
						GeeIterator* _device_it;
						_tmp9_ = gee_iterable_iterator ((GeeIterable*) devgroup);
						_device_it = _tmp9_;
						while (TRUE) {
							gboolean _tmp10_;
							gpointer _tmp11_ = NULL;
							DVBDevice* device;
							gboolean _tmp12_;
							_tmp10_ = gee_iterator_next (_device_it);
							if (!_tmp10_) {
								break;
							}
							_tmp11_ = gee_iterator_get (_device_it);
							device = (DVBDevice*) _tmp11_;
							_tmp12_ = dvb_device_equal (fake_device, device);
							if (_tmp12_) {
								DVBDevice* _tmp13_;
								_tmp13_ = _g_object_ref0 (device);
								_g_object_unref0 (_result_);
								_result_ = _tmp13_;
								_g_object_unref0 (device);
								break;
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
		__finally97:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (fake_device);
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	_g_object_unref0 (fake_device);
	return result;
}


static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device) {
	DVBDeviceGroup* result = NULL;
	DVBDeviceGroup* _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_result_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _group_id_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->devices);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_group_id_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint group_id;
				gpointer _tmp6_ = NULL;
				DVBDeviceGroup* devgroup;
				gboolean _tmp7_;
				_tmp4_ = gee_iterator_next (_group_id_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_group_id_it);
				group_id = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				devgroup = (DVBDeviceGroup*) _tmp6_;
				_tmp7_ = dvb_device_group_contains (devgroup, device);
				if (_tmp7_) {
					{
						GeeIterator* _tmp8_ = NULL;
						GeeIterator* _grp_device_it;
						_tmp8_ = gee_iterable_iterator ((GeeIterable*) devgroup);
						_grp_device_it = _tmp8_;
						while (TRUE) {
							gboolean _tmp9_;
							gpointer _tmp10_ = NULL;
							DVBDevice* grp_device;
							gboolean _tmp11_;
							_tmp9_ = gee_iterator_next (_grp_device_it);
							if (!_tmp9_) {
								break;
							}
							_tmp10_ = gee_iterator_get (_grp_device_it);
							grp_device = (DVBDevice*) _tmp10_;
							_tmp11_ = dvb_device_equal (grp_device, device);
							if (_tmp11_) {
								DVBDeviceGroup* _tmp12_;
								_tmp12_ = _g_object_ref0 (devgroup);
								_g_object_unref0 (_result_);
								_result_ = _tmp12_;
								_g_object_unref0 (grp_device);
								break;
							}
							_g_object_unref0 (grp_device);
						}
						_g_object_unref0 (_grp_device_it);
					}
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
		__finally98:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend) {
	DVBDeviceGroup* _tmp0_;
	DVBDeviceGroup* devgroup;
	guint _tmp1_;
	guint group_id;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (idevgroup != NULL);
	_tmp0_ = _g_object_ref0 (DVB_DEVICE_GROUP (idevgroup));
	devgroup = _tmp0_;
	_tmp1_ = dvb_device_group_get_Id (devgroup);
	group_id = _tmp1_;
	_tmp2_ = dvb_device_group_get_size (devgroup);
	if (_tmp2_ == 0) {
		gboolean success = FALSE;
		{
			gboolean _tmp3_;
			g_static_rec_mutex_lock (&self->priv->__lock_devices);
			_tmp3_ = gee_abstract_map_unset ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id), NULL);
			success = _tmp3_;
			__finally99:
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (success) {
			DVBdatabaseConfigStore* _tmp4_ = NULL;
			DVBdatabaseConfigStore* _tmp5_;
			DVBdatabaseEPGStore* _tmp6_ = NULL;
			DVBdatabaseEPGStore* _tmp7_;
			guint _tmp8_;
			DVBdatabaseTimersStore* _tmp9_ = NULL;
			DVBdatabaseTimersStore* _tmp10_;
			guint _tmp11_;
			dvb_device_group_destroy (devgroup);
			_tmp4_ = dvb_factory_get_config_store ();
			_tmp5_ = _tmp4_;
			dvb_database_config_store_remove_device_group (_tmp5_, devgroup, &_inner_error_);
			_g_object_unref0 (_tmp5_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch100_dvb_database_sql_error;
				}
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp6_ = dvb_factory_get_epg_store ();
			_tmp7_ = _tmp6_;
			_tmp8_ = dvb_device_group_get_Id (devgroup);
			dvb_database_epg_store_remove_events_of_group (_tmp7_, _tmp8_, &_inner_error_);
			_g_object_unref0 (_tmp7_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch100_dvb_database_sql_error;
				}
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp9_ = dvb_factory_get_timers_store ();
			_tmp10_ = _tmp9_;
			_tmp11_ = dvb_device_group_get_Id (devgroup);
			dvb_database_timers_store_remove_all_timers_from_device_group (_tmp10_, _tmp11_, &_inner_error_);
			_g_object_unref0 (_tmp10_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch100_dvb_database_sql_error;
				}
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			g_signal_emit_by_name ((DVBIDBusManager*) self, "group-removed", group_id);
			goto __finally100;
			__catch100_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				dvb_logging_logger_error (dvb_manager_log, "Manager.vala:573: %s", e->message);
				_g_error_free0 (e);
			}
			__finally100:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (devgroup);
}


static void dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id) {
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config_store;
	GeeList* groups = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_factory_get_config_store ();
	config_store = _tmp0_;
	_tmp1_ = dvb_database_config_store_get_all_device_groups (config_store, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch101_dvb_database_sql_error;
		}
		_g_object_unref0 (groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (groups);
	groups = _tmp2_;
	goto __finally101;
	__catch101_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_manager_log, "Manager.vala:586: Error restoring group %u: %s", group_id, e->message);
		_g_error_free0 (e);
		_g_object_unref0 (groups);
		_g_object_unref0 (config_store);
		return;
	}
	__finally101:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GeeList* _tmp3_;
		GeeList* _group_list;
		gint _tmp4_;
		gint _group_size;
		gint _group_index;
		_tmp3_ = _g_object_ref0 (groups);
		_group_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _group_list);
		_group_size = _tmp4_;
		_group_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			DVBDeviceGroup* group;
			guint _tmp6_;
			_group_index = _group_index + 1;
			if (!(_group_index < _group_size)) {
				break;
			}
			_tmp5_ = gee_list_get (_group_list, _group_index);
			group = (DVBDeviceGroup*) _tmp5_;
			_tmp6_ = dvb_device_group_get_Id (group);
			if (_tmp6_ == group_id) {
				dvb_manager_restore_device_group_and_timers (self, group);
			}
			_g_object_unref0 (group);
		}
		_g_object_unref0 (_group_list);
	}
	_g_object_unref0 (groups);
	_g_object_unref0 (config_store);
}


static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	if (g_strcmp0 (action, "add") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (action, "remove") == 0;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* dev_file;
		guint adapter;
		guint frontend;
		gint _tmp3_;
		guint group_id = 0U;
		gboolean found;
		DVBdatabaseConfigStore* _tmp4_ = NULL;
		DVBdatabaseConfigStore* config_store;
		guint _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		DVBDeviceGroup* _tmp8_ = NULL;
		DVBDeviceGroup* group;
		_tmp1_ = g_udev_device_get_device_file (device);
		_tmp2_ = g_strdup (_tmp1_);
		dev_file = _tmp2_;
		adapter = (guint) (-1);
		frontend = (guint) (-1);
		_tmp3_ = sscanf (dev_file, "/dev/dvb/adapter%u/frontend%u", &adapter, &frontend);
		if (_tmp3_ != 2) {
			_g_free0 (dev_file);
			return;
		}
		found = FALSE;
		_tmp4_ = dvb_factory_get_config_store ();
		config_store = _tmp4_;
		_tmp6_ = dvb_database_config_store_get_parent_group (config_store, adapter, frontend, &_tmp5_, &_inner_error_);
		group_id = _tmp5_;
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch102_dvb_database_sql_error;
			}
			_g_object_unref0 (config_store);
			_g_free0 (dev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		found = _tmp7_;
		goto __finally102;
		__catch102_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("Manager.vala:614: %s", e->message);
			_g_error_free0 (e);
		}
		__finally102:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config_store);
			_g_free0 (dev_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!found) {
			_g_object_unref0 (config_store);
			_g_free0 (dev_file);
			return;
		}
		dvb_logging_logger_debug (dvb_manager_log, "Manager.vala:619: %s device %s, part of group %u", action, dev_file, group_id);
		_tmp8_ = dvb_manager_get_device_group_if_exists (self, group_id);
		group = _tmp8_;
		if (group != NULL) {
			dvb_device_group_stop_epg_scanner (group);
		}
		if (g_strcmp0 (action, "add") == 0) {
			if (group == NULL) {
				dvb_manager_create_device_group_by_id (self, group_id);
			} else {
				DVBDevice* _tmp9_ = NULL;
				DVBDevice* dvb_device;
				_tmp9_ = dvb_device_new_with_type (adapter, frontend);
				dvb_device = _tmp9_;
				if (dvb_device == NULL) {
					_g_object_unref0 (dvb_device);
					_g_object_unref0 (group);
					_g_object_unref0 (config_store);
					_g_free0 (dev_file);
					return;
				}
				dvb_device_group_add (group, dvb_device);
				_g_object_unref0 (dvb_device);
			}
		} else {
			DVBDevice* _tmp10_ = NULL;
			DVBDevice* dvb_device;
			_tmp10_ = dvb_device_new (adapter, frontend);
			dvb_device = _tmp10_;
			dvb_device_group_remove (group, dvb_device);
			_g_object_unref0 (dvb_device);
		}
		if (group != NULL) {
			dvb_device_group_start_epg_scanner (group);
		}
		_g_object_unref0 (group);
		_g_object_unref0 (config_store);
		_g_free0 (dev_file);
	}
}


DVBManager* dvb_manager_construct (GType object_type) {
	DVBManager * self = NULL;
	self = (DVBManager*) g_object_new (object_type, NULL);
	return self;
}


DVBManager* dvb_manager_new (void) {
	return dvb_manager_construct (DVB_TYPE_MANAGER);
}


GeeCollection* dvb_manager_get_device_groups (DVBManager* self) {
	GeeCollection* result;
	GeeCollection* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->devices);
	result = _tmp0_;
	return result;
}


static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	dvb_manager_on_udev_event (self, action, device);
}


static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBManager * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GUdevClient* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MANAGER (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_TYPE_SCANNER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, g_direct_equal);
	_g_object_unref0 (self->priv->scanners);
	self->priv->scanners = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp1_;
	self->priv->device_group_counter = (guint) 0;
	_tmp2_ = g_udev_client_new (DVB_MANAGER_UDEV_SUBSYSTEMS);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp2_;
	g_signal_connect_object (self->priv->udev_client, "uevent", (GCallback) _dvb_manager_on_udev_event_g_udev_client_uevent, self, 0);
	return obj;
}


static void dvb_manager_class_init (DVBManagerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GStaticRecMutex _tmp2_ = {0};
	GStaticRecMutex _tmp3_ = {0};
	dvb_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MANAGER_DEVICE_GROUPS, g_param_spec_object ("device-groups", "device-groups", "device-groups", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_manager_log = _tmp1_;
	g_static_rec_mutex_init (&_tmp2_);
	_tmp3_ = _tmp2_;
	dvb_manager_instance_mutex = _tmp3_;
}


static void dvb_manager_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface * iface) {
	dvb_manager_dvb_id_bus_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetScannerForDevice = (gboolean (*)(DVBIDBusManager* ,guint ,guint ,char** ,gchar** ,GError**)) dvb_manager_real_GetScannerForDevice;
	iface->GetDeviceGroup = (gboolean (*)(DVBIDBusManager* ,guint ,char** ,GError**)) dvb_manager_real_GetDeviceGroup;
	iface->GetRegisteredDeviceGroups = (char** (*)(DVBIDBusManager* ,int* ,GError**)) dvb_manager_real_GetRegisteredDeviceGroups;
	iface->AddDeviceToNewGroup = (gboolean (*)(DVBIDBusManager* ,guint ,guint ,const gchar* ,const gchar* ,const gchar* ,GError**)) dvb_manager_real_AddDeviceToNewGroup;
	iface->GetNameOfRegisteredDevice = (gboolean (*)(DVBIDBusManager* ,guint ,guint ,gchar** ,GError**)) dvb_manager_real_GetNameOfRegisteredDevice;
	iface->GetDeviceGroupSize = (gint (*)(DVBIDBusManager* ,GError**)) dvb_manager_real_GetDeviceGroupSize;
	iface->GetChannelGroups = (DVBChannelGroupInfo* (*)(DVBIDBusManager* ,int* ,GError**)) dvb_manager_real_GetChannelGroups;
	iface->AddChannelGroup = (gboolean (*)(DVBIDBusManager* ,const gchar* ,gint* ,GError**)) dvb_manager_real_AddChannelGroup;
	iface->RemoveChannelGroup = (gboolean (*)(DVBIDBusManager* ,gint ,GError**)) dvb_manager_real_RemoveChannelGroup;
	iface->GetDevices = (GHashTable** (*)(DVBIDBusManager* ,int* ,GError**)) dvb_manager_real_GetDevices;
}


static void dvb_manager_instance_init (DVBManager * self) {
	self->priv = DVB_MANAGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_scanners);
	g_static_rec_mutex_init (&self->priv->__lock_devices);
}


static void dvb_manager_finalize (GObject* obj) {
	DVBManager * self;
	self = DVB_MANAGER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_scanners);
	_g_object_unref0 (self->priv->scanners);
	g_static_rec_mutex_free (&self->priv->__lock_devices);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->udev_client);
	G_OBJECT_CLASS (dvb_manager_parent_class)->finalize (obj);
}


GType dvb_manager_get_type (void) {
	static volatile gsize dvb_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManager), 0, (GInstanceInitFunc) dvb_manager_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_manager_info = { (GInterfaceInitFunc) dvb_manager_dvb_id_bus_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_manager_type_id;
		dvb_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManager", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_manager_type_id, DVB_TYPE_ID_BUS_MANAGER, &dvb_id_bus_manager_info);
		g_once_init_leave (&dvb_manager_type_id__volatile, dvb_manager_type_id);
	}
	return dvb_manager_type_id__volatile;
}


static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBManager * self;
	self = DVB_MANAGER (object);
	switch (property_id) {
		case DVB_MANAGER_DEVICE_GROUPS:
		g_value_take_object (value, dvb_manager_get_device_groups (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



