/* ChannelListWriter.c generated by valac 0.12.0, the Vala compiler
 * generated from ChannelListWriter.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;
typedef struct _DVBioChannelListWriterPrivate DVBioChannelListWriterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

struct _DVBioChannelListWriter {
	GObject parent_instance;
	DVBioChannelListWriterPrivate * priv;
};

struct _DVBioChannelListWriterClass {
	GObjectClass parent_class;
};

struct _DVBioChannelListWriterPrivate {
	GFile* _file;
	GOutputStream* stream;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;


static gpointer dvb_io_channel_list_writer_parent_class = NULL;

GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_WRITER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_WRITER_FILE
};
static void dvb_io_channel_list_writer_open_stream (DVBioChannelListWriter* self, GError** error);
GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self);
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error);
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBSatelliteChannel* channel, GError** error);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBCableChannel* channel, GError** error);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
guint dvb_channel_get_Frequency (DVBChannel* self);
static gchar* dvb_io_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const gchar* prefix);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self);
const gchar* dvb_satellite_channel_get_Polarization (DVBSatelliteChannel* self);
gint dvb_satellite_channel_get_DiseqcSource (DVBSatelliteChannel* self);
guint dvb_satellite_channel_get_SymbolRate (DVBSatelliteChannel* self);
DVBDvbSrcInversion dvb_cable_channel_get_Inversion (DVBCableChannel* self);
guint dvb_cable_channel_get_SymbolRate (DVBCableChannel* self);
DVBDvbSrcCodeRate dvb_cable_channel_get_CodeRate (DVBCableChannel* self);
DVBDvbSrcModulation dvb_cable_channel_get_Modulation (DVBCableChannel* self);
const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value);
static void dvb_io_channel_list_writer_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void dvb_io_channel_list_writer_open_stream (DVBioChannelListWriter* self, GError** error) {
	GFileOutputStream* fostream;
	gboolean _tmp0_;
	GBufferedOutputStream* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	fostream = NULL;
	_tmp0_ = g_file_query_exists (self->priv->_file, NULL);
	if (_tmp0_) {
		GFileOutputStream* _tmp1_ = NULL;
		GFileOutputStream* _tmp2_;
		_tmp1_ = g_file_replace (self->priv->_file, NULL, TRUE, 0, NULL, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_g_object_unref0 (fostream);
		fostream = _tmp2_;
	} else {
		GFileOutputStream* _tmp3_ = NULL;
		GFileOutputStream* _tmp4_;
		_tmp3_ = g_file_create (self->priv->_file, 0, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_g_object_unref0 (fostream);
		fostream = _tmp4_;
	}
	_tmp5_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) fostream);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = (GOutputStream*) _tmp5_;
	_g_object_unref0 (fostream);
}


DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file) {
	DVBioChannelListWriter * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (DVBioChannelListWriter*) g_object_new (object_type, "file", file, NULL);
	return self;
}


DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file) {
	return dvb_io_channel_list_writer_construct (DVB_IO_TYPE_CHANNEL_LIST_WRITER, file);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	gchar* buffer = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp3_;
	guint apid = 0U;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_;
	guint _tmp8_;
	guint _tmp9_;
	gchar* _tmp10_ = NULL;
	guint8* _tmp11_ = NULL;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	if (self->priv->stream == NULL) {
		dvb_io_channel_list_writer_open_stream (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	if (self->priv->stream == NULL) {
		return;
	}
	_tmp0_ = dvb_channel_get_Name (channel);
	_tmp1_ = g_strdup_printf ("%s:", _tmp0_);
	_g_free0 (buffer);
	buffer = _tmp1_;
	_tmp2_ = string_get_data (buffer, &_tmp3_);
	g_output_stream_write_all (self->priv->stream, _tmp2_, (gsize) _tmp3_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	if (DVB_IS_TERRESTRIAL_CHANNEL (channel)) {
		dvb_io_channel_list_writer_write_terrestrial_channel (self, DVB_TERRESTRIAL_CHANNEL (channel), &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (buffer);
			return;
		}
	} else {
		if (DVB_IS_SATELLITE_CHANNEL (channel)) {
			dvb_io_channel_list_writer_write_satellite_channel (self, DVB_SATELLITE_CHANNEL (channel), &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (buffer);
				return;
			}
		} else {
			if (DVB_IS_CABLE_CHANNEL (channel)) {
				dvb_io_channel_list_writer_write_cable_channel (self, DVB_CABLE_CHANNEL (channel), &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (buffer);
					return;
				}
			} else {
				g_warning ("ChannelListWriter.vala:76: Unknown channel type");
			}
		}
	}
	_tmp4_ = dvb_channel_get_AudioPIDs (channel);
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	if (_tmp5_ == 0) {
		apid = (guint) 0;
	} else {
		GeeList* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		_tmp6_ = dvb_channel_get_AudioPIDs (channel);
		_tmp7_ = gee_list_get (_tmp6_, 0);
		apid = GPOINTER_TO_UINT (_tmp7_);
	}
	_tmp8_ = dvb_channel_get_VideoPID (channel);
	_tmp9_ = dvb_channel_get_Sid (channel);
	_tmp10_ = g_strdup_printf (":%u:%u:%u\n", _tmp8_, apid, _tmp9_);
	_g_free0 (buffer);
	buffer = _tmp10_;
	_tmp11_ = string_get_data (buffer, &_tmp12_);
	g_output_stream_write_all (self->priv->stream, _tmp11_, (gsize) _tmp12_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	_g_free0 (buffer);
}


gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->stream == NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_output_stream_close (self->priv->stream, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error) {
	gchar** _tmp0_ = NULL;
	gchar** elements;
	gint elements_length1;
	gint _elements_size_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	DVBDvbSrcInversion _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	DVBDvbSrcBandwidth _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	DVBDvbSrcCodeRate _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	DVBDvbSrcCodeRate _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	DVBDvbSrcModulation _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	DVBDvbSrcTransmissionMode _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	DVBDvbSrcGuard _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	DVBDvbSrcHierarchy _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* buffer;
	guint8* _tmp29_ = NULL;
	gint _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_new0 (gchar*, 9 + 1);
	elements = _tmp0_;
	elements_length1 = 9;
	_elements_size_ = 9;
	_tmp1_ = dvb_channel_get_Frequency ((DVBChannel*) channel);
	_tmp2_ = g_strdup_printf ("%u", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (elements[0]);
	elements[0] = _tmp3_;
	_tmp4_ = dvb_terrestrial_channel_get_Inversion (channel);
	_tmp5_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) _tmp4_, "DVB_DVB_SRC_INVERSION_");
	_tmp6_ = _tmp5_;
	_g_free0 (elements[1]);
	elements[1] = _tmp6_;
	_tmp7_ = dvb_terrestrial_channel_get_Bandwidth (channel);
	_tmp8_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) _tmp7_, "DVB_DVB_SRC_BANDWIDTH_");
	_tmp9_ = _tmp8_;
	_g_free0 (elements[2]);
	elements[2] = _tmp9_;
	_tmp10_ = dvb_terrestrial_channel_get_CodeRateHP (channel);
	_tmp11_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp10_, "DVB_DVB_SRC_CODE_RATE_");
	_tmp12_ = _tmp11_;
	_g_free0 (elements[3]);
	elements[3] = _tmp12_;
	_tmp13_ = dvb_terrestrial_channel_get_CodeRateLP (channel);
	_tmp14_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp13_, "DVB_DVB_SRC_CODE_RATE_");
	_tmp15_ = _tmp14_;
	_g_free0 (elements[4]);
	elements[4] = _tmp15_;
	_tmp16_ = dvb_terrestrial_channel_get_Constellation (channel);
	_tmp17_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) _tmp16_, "DVB_DVB_SRC_MODULATION_");
	_tmp18_ = _tmp17_;
	_g_free0 (elements[5]);
	elements[5] = _tmp18_;
	_tmp19_ = dvb_terrestrial_channel_get_TransmissionMode (channel);
	_tmp20_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) _tmp19_, "DVB_DVB_SRC_TRANSMISSION_MODE_");
	_tmp21_ = _tmp20_;
	_g_free0 (elements[6]);
	elements[6] = _tmp21_;
	_tmp22_ = dvb_terrestrial_channel_get_GuardInterval (channel);
	_tmp23_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_GUARD, (gint) _tmp22_, "DVB_DVB_SRC_GUARD_");
	_tmp24_ = _tmp23_;
	_g_free0 (elements[7]);
	elements[7] = _tmp24_;
	_tmp25_ = dvb_terrestrial_channel_get_Hierarchy (channel);
	_tmp26_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) _tmp25_, "DVB_DVB_SRC_HIERARCHY_");
	_tmp27_ = _tmp26_;
	_g_free0 (elements[8]);
	elements[8] = _tmp27_;
	_tmp28_ = g_strjoinv (":", elements);
	buffer = _tmp28_;
	_tmp29_ = string_get_data (buffer, &_tmp30_);
	g_output_stream_write_all (self->priv->stream, _tmp29_, (gsize) _tmp30_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_free0 (buffer);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBSatelliteChannel* channel, GError** error) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* buffer;
	guint8* _tmp5_ = NULL;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = dvb_channel_get_Frequency ((DVBChannel*) channel);
	_tmp1_ = dvb_satellite_channel_get_Polarization (channel);
	_tmp2_ = dvb_satellite_channel_get_DiseqcSource (channel);
	_tmp3_ = dvb_satellite_channel_get_SymbolRate (channel);
	_tmp4_ = g_strdup_printf ("%u:%s:%d:%u", _tmp0_ / 1000, _tmp1_, _tmp2_, _tmp3_);
	buffer = _tmp4_;
	_tmp5_ = string_get_data (buffer, &_tmp6_);
	g_output_stream_write_all (self->priv->stream, _tmp5_, (gsize) _tmp6_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	_g_free0 (buffer);
}


static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBCableChannel* channel, GError** error) {
	gchar** _tmp0_ = NULL;
	gchar** elements;
	gint elements_length1;
	gint _elements_size_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	DVBDvbSrcInversion _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	guint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	DVBDvbSrcCodeRate _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	DVBDvbSrcModulation _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* buffer;
	guint8* _tmp17_ = NULL;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_new0 (gchar*, 5 + 1);
	elements = _tmp0_;
	elements_length1 = 5;
	_elements_size_ = 5;
	_tmp1_ = dvb_channel_get_Frequency ((DVBChannel*) channel);
	_tmp2_ = g_strdup_printf ("%u", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (elements[0]);
	elements[0] = _tmp3_;
	_tmp4_ = dvb_cable_channel_get_Inversion (channel);
	_tmp5_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) _tmp4_, "DVB_DVB_SRC_INVERSION_");
	_tmp6_ = _tmp5_;
	_g_free0 (elements[1]);
	elements[1] = _tmp6_;
	_tmp7_ = dvb_cable_channel_get_SymbolRate (channel);
	_tmp8_ = g_strdup_printf ("%u", _tmp7_ * 1000);
	_tmp9_ = _tmp8_;
	_g_free0 (elements[2]);
	elements[2] = _tmp9_;
	_tmp10_ = dvb_cable_channel_get_CodeRate (channel);
	_tmp11_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp10_, "DVB_DVB_SRC_CODE_RATE_");
	_tmp12_ = _tmp11_;
	_g_free0 (elements[3]);
	elements[3] = _tmp12_;
	_tmp13_ = dvb_cable_channel_get_Modulation (channel);
	_tmp14_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) _tmp13_, "DVB_DVB_SRC_MODULATION_");
	_tmp15_ = _tmp14_;
	_g_free0 (elements[4]);
	elements[4] = _tmp15_;
	_tmp16_ = g_strjoinv (":", elements);
	buffer = _tmp16_;
	_tmp17_ = string_get_data (buffer, &_tmp18_);
	g_output_stream_write_all (self->priv->stream, _tmp17_, (gsize) _tmp18_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_free0 (buffer);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* dvb_io_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const gchar* prefix) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* name;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = dvb_utils_get_name_by_value_from_enum (enumtype, val);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	if (name == NULL) {
		result = NULL;
		_g_free0 (name);
		return result;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = strlen (prefix);
		_tmp3_ = strlen (name);
		_tmp4_ = strlen (prefix);
		_tmp5_ = string_substring (name, (glong) _tmp2_, (glong) (_tmp3_ - _tmp4_));
		result = _tmp5_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
	g_object_notify ((GObject *) self, "file");
}


static void dvb_io_channel_list_writer_class_init (DVBioChannelListWriterClass * klass) {
	dvb_io_channel_list_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_WRITER_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_io_channel_list_writer_instance_init (DVBioChannelListWriter * self) {
	self->priv = DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_writer_finalize (GObject* obj) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (obj);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (dvb_io_channel_list_writer_parent_class)->finalize (obj);
}


/**
     * Example:
     * try {
     *     var writer = new DVB.ChannelListWriter (File.new_for_path ("/path/to/channels.conf"));
     *     foreach (DVB.Channel c in reader.Channels) {
     *         writer.write (c);
     *     }
     *     writer.close ();
     * } catch (IOError e) {
     *     error (e.message);
     * }
     */
GType dvb_io_channel_list_writer_get_type (void) {
	static volatile gsize dvb_io_channel_list_writer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListWriter), 0, (GInstanceInitFunc) dvb_io_channel_list_writer_instance_init, NULL };
		GType dvb_io_channel_list_writer_type_id;
		dvb_io_channel_list_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListWriter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_writer_type_id__volatile, dvb_io_channel_list_writer_type_id);
	}
	return dvb_io_channel_list_writer_type_id__volatile;
}


static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		g_value_set_object (value, dvb_io_channel_list_writer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		dvb_io_channel_list_writer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



