/* Logging.c generated by valac 0.12.0, the Vala compiler
 * generated from Logging.vala, do not modify */

/*
 * Copyright (C) 2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>


#define DVB_LOGGING_TYPE_LOG_LEVEL (dvb_logging_log_level_get_type ())

#define DVB_LOGGING_TYPE_FORMATTER (dvb_logging_formatter_get_type ())
#define DVB_LOGGING_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatter))
#define DVB_LOGGING_IS_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FORMATTER))
#define DVB_LOGGING_FORMATTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatterIface))

typedef struct _DVBLoggingFormatter DVBLoggingFormatter;
typedef struct _DVBLoggingFormatterIface DVBLoggingFormatterIface;

#define DVB_LOGGING_TYPE_HANDLER (dvb_logging_handler_get_type ())
#define DVB_LOGGING_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandler))
#define DVB_LOGGING_IS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_HANDLER))
#define DVB_LOGGING_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandlerIface))

typedef struct _DVBLoggingHandler DVBLoggingHandler;
typedef struct _DVBLoggingHandlerIface DVBLoggingHandlerIface;

#define DVB_LOGGING_TYPE_DEFAULT_FORMATTER (dvb_logging_default_formatter_get_type ())
#define DVB_LOGGING_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatter))
#define DVB_LOGGING_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))

typedef struct _DVBLoggingDefaultFormatter DVBLoggingDefaultFormatter;
typedef struct _DVBLoggingDefaultFormatterClass DVBLoggingDefaultFormatterClass;
typedef struct _DVBLoggingDefaultFormatterPrivate DVBLoggingDefaultFormatterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_LOGGING_TYPE_COLOR_FORMATTER (dvb_logging_color_formatter_get_type ())
#define DVB_LOGGING_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatter))
#define DVB_LOGGING_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))
#define DVB_LOGGING_IS_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_IS_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_COLOR_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))

typedef struct _DVBLoggingColorFormatter DVBLoggingColorFormatter;
typedef struct _DVBLoggingColorFormatterClass DVBLoggingColorFormatterClass;
typedef struct _DVBLoggingColorFormatterPrivate DVBLoggingColorFormatterPrivate;

#define DVB_LOGGING_TYPE_CONSOLE_HANDLER (dvb_logging_console_handler_get_type ())
#define DVB_LOGGING_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandler))
#define DVB_LOGGING_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))
#define DVB_LOGGING_IS_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_IS_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_CONSOLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))

typedef struct _DVBLoggingConsoleHandler DVBLoggingConsoleHandler;
typedef struct _DVBLoggingConsoleHandlerClass DVBLoggingConsoleHandlerClass;
typedef struct _DVBLoggingConsoleHandlerPrivate DVBLoggingConsoleHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_LOGGING_TYPE_FILE_HANDLER (dvb_logging_file_handler_get_type ())
#define DVB_LOGGING_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandler))
#define DVB_LOGGING_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))
#define DVB_LOGGING_IS_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_IS_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_FILE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))

typedef struct _DVBLoggingFileHandler DVBLoggingFileHandler;
typedef struct _DVBLoggingFileHandlerClass DVBLoggingFileHandlerClass;
typedef struct _DVBLoggingFileHandlerPrivate DVBLoggingFileHandlerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;
typedef struct _DVBLoggingLoggerPrivate DVBLoggingLoggerPrivate;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
typedef struct _DVBLoggingLogManagerPrivate DVBLoggingLogManagerPrivate;

typedef enum  {
	DVB_LOGGING_LOG_LEVEL_LOG,
	DVB_LOGGING_LOG_LEVEL_DEBUG,
	DVB_LOGGING_LOG_LEVEL_INFO,
	DVB_LOGGING_LOG_LEVEL_WARNING,
	DVB_LOGGING_LOG_LEVEL_ERROR
} DVBLoggingLogLevel;

struct _DVBLoggingFormatterIface {
	GTypeInterface parent_iface;
	gchar* (*format) (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingHandlerIface {
	GTypeInterface parent_iface;
	void (*publish) (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
	void (*close) (DVBLoggingHandler* self);
	DVBLoggingFormatter* (*get_formatter) (DVBLoggingHandler* self);
	void (*set_formatter) (DVBLoggingHandler* self, DVBLoggingFormatter* value);
	DVBLoggingLogLevel (*get_threshold) (DVBLoggingHandler* self);
	void (*set_threshold) (DVBLoggingHandler* self, DVBLoggingLogLevel value);
};

struct _DVBLoggingDefaultFormatter {
	GObject parent_instance;
	DVBLoggingDefaultFormatterPrivate * priv;
};

struct _DVBLoggingDefaultFormatterClass {
	GObjectClass parent_class;
	gchar* (*get_level_name) (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
	gchar* (*format) (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingColorFormatter {
	DVBLoggingDefaultFormatter parent_instance;
	DVBLoggingColorFormatterPrivate * priv;
};

struct _DVBLoggingColorFormatterClass {
	DVBLoggingDefaultFormatterClass parent_class;
};

struct _DVBLoggingConsoleHandler {
	GObject parent_instance;
	DVBLoggingConsoleHandlerPrivate * priv;
};

struct _DVBLoggingConsoleHandlerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingConsoleHandlerPrivate {
	DVBLoggingFormatter* _formatter;
	DVBLoggingLogLevel _threshold;
};

struct _DVBLoggingFileHandler {
	GObject parent_instance;
	DVBLoggingFileHandlerPrivate * priv;
};

struct _DVBLoggingFileHandlerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingFileHandlerPrivate {
	DVBLoggingFormatter* _formatter;
	DVBLoggingLogLevel _threshold;
	gint _limit;
	gint _count;
	gchar* _pattern;
	GOutputStream* os;
	gint file_size;
	gint file_index;
};

struct _DVBLoggingLogger {
	GObject parent_instance;
	DVBLoggingLoggerPrivate * priv;
};

struct _DVBLoggingLoggerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingLoggerPrivate {
	gchar* _name;
	GeeHashSet* handlers;
	GStaticRecMutex __lock_handlers;
};

struct _DVBLoggingLogManager {
	GObject parent_instance;
	DVBLoggingLogManagerPrivate * priv;
};

struct _DVBLoggingLogManagerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingLogManagerPrivate {
	GeeHashMap* loggers;
	GStaticRecMutex __lock_loggers;
};


static gpointer dvb_logging_default_formatter_parent_class = NULL;
static DVBLoggingFormatterIface* dvb_logging_default_formatter_dvb_logging_formatter_parent_iface = NULL;
static gpointer dvb_logging_color_formatter_parent_class = NULL;
static gchar** dvb_logging_color_formatter_colormap;
static gint dvb_logging_color_formatter_colormap_length1;
static gchar** dvb_logging_color_formatter_colormap = NULL;
static gint dvb_logging_color_formatter_colormap_length1 = 0;
static gint _dvb_logging_color_formatter_colormap_size_ = 0;
static gpointer dvb_logging_console_handler_parent_class = NULL;
static DVBLoggingHandlerIface* dvb_logging_console_handler_dvb_logging_handler_parent_iface = NULL;
static gpointer dvb_logging_file_handler_parent_class = NULL;
static DVBLoggingHandlerIface* dvb_logging_file_handler_dvb_logging_handler_parent_iface = NULL;
static gpointer dvb_logging_logger_parent_class = NULL;
static gpointer dvb_logging_log_manager_parent_class = NULL;
static DVBLoggingLogManager* dvb_logging_log_manager_instance;
static DVBLoggingLogManager* dvb_logging_log_manager_instance = NULL;
static GStaticRecMutex dvb_logging_log_manager_instance_mutex;
static GStaticRecMutex dvb_logging_log_manager_instance_mutex = {0};

GType dvb_logging_log_level_get_type (void) G_GNUC_CONST;
GType dvb_logging_formatter_get_type (void) G_GNUC_CONST;
gchar* dvb_logging_formatter_format (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
GType dvb_logging_handler_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_publish (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
void dvb_logging_handler_close (DVBLoggingHandler* self);
DVBLoggingFormatter* dvb_logging_handler_get_formatter (DVBLoggingHandler* self);
void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value);
DVBLoggingLogLevel dvb_logging_handler_get_threshold (DVBLoggingHandler* self);
void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value);
GType dvb_logging_default_formatter_get_type (void) G_GNUC_CONST;
enum  {
	DVB_LOGGING_DEFAULT_FORMATTER_DUMMY_PROPERTY
};
gchar* dvb_logging_default_formatter_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
static gchar* dvb_logging_default_formatter_real_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
gchar* dvb_logging_default_formatter_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
static gchar* dvb_logging_default_formatter_real_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
DVBLoggingDefaultFormatter* dvb_logging_default_formatter_new (void);
DVBLoggingDefaultFormatter* dvb_logging_default_formatter_construct (GType object_type);
GType dvb_logging_color_formatter_get_type (void) G_GNUC_CONST;
enum  {
	DVB_LOGGING_COLOR_FORMATTER_DUMMY_PROPERTY
};
#define DVB_LOGGING_COLOR_FORMATTER_clear "\033[00m"
static gchar* dvb_logging_color_formatter_real_get_level_name (DVBLoggingDefaultFormatter* base, DVBLoggingLogLevel level);
static gchar* dvb_logging_color_formatter_real_format (DVBLoggingDefaultFormatter* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void);
DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type);
static void dvb_logging_color_formatter_finalize (GObject* obj);
GType dvb_logging_console_handler_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_CONSOLE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerPrivate))
enum  {
	DVB_LOGGING_CONSOLE_HANDLER_DUMMY_PROPERTY,
	DVB_LOGGING_CONSOLE_HANDLER_FORMATTER,
	DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD
};
static void dvb_logging_console_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
static void dvb_logging_console_handler_real_close (DVBLoggingHandler* base);
DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void);
DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type);
static void dvb_logging_console_handler_finalize (GObject* obj);
static void _vala_dvb_logging_console_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_console_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_file_handler_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_FILE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerPrivate))
enum  {
	DVB_LOGGING_FILE_HANDLER_DUMMY_PROPERTY,
	DVB_LOGGING_FILE_HANDLER_FORMATTER,
	DVB_LOGGING_FILE_HANDLER_THRESHOLD,
	DVB_LOGGING_FILE_HANDLER_LIMIT,
	DVB_LOGGING_FILE_HANDLER_COUNT,
	DVB_LOGGING_FILE_HANDLER_PATTERN
};
DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error);
DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error);
static void dvb_logging_file_handler_rotate (DVBLoggingFileHandler* self, GError** error);
static void dvb_logging_file_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self);
static void dvb_logging_file_handler_real_close (DVBLoggingHandler* base);
static GFile* dvb_logging_file_handler_get_next_file (DVBLoggingFileHandler* self);
gint dvb_logging_file_handler_get_count (DVBLoggingFileHandler* self);
const gchar* dvb_logging_file_handler_get_pattern (DVBLoggingFileHandler* self);
void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value);
void dvb_logging_file_handler_set_count (DVBLoggingFileHandler* self, gint value);
static void dvb_logging_file_handler_set_pattern (DVBLoggingFileHandler* self, const gchar* value);
static void dvb_logging_file_handler_finalize (GObject* obj);
static void _vala_dvb_logging_file_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_file_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerPrivate))
enum  {
	DVB_LOGGING_LOGGER_DUMMY_PROPERTY,
	DVB_LOGGING_LOGGER_NAME
};
void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
void dvb_logging_logger_removeHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
GeeHashSet* dvb_logging_logger_getHandlers (DVBLoggingLogger* self);
static inline void dvb_logging_logger_log_full (DVBLoggingLogger* self, DVBLoggingLogLevel level, const gchar* format, va_list args);
const gchar* dvb_logging_logger_get_name (DVBLoggingLogger* self);
void dvb_logging_logger_log (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBLoggingLogger* dvb_logging_logger_new (void);
DVBLoggingLogger* dvb_logging_logger_construct (GType object_type);
void dvb_logging_logger_set_name (DVBLoggingLogger* self, const gchar* value);
static GObject * dvb_logging_logger_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_logging_logger_finalize (GObject* obj);
static void _vala_dvb_logging_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_LOG_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerPrivate))
enum  {
	DVB_LOGGING_LOG_MANAGER_DUMMY_PROPERTY
};
#define DVB_LOGGING_LOG_MANAGER_DEFAULT_NAME "default"
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogManager* dvb_logging_log_manager_new (void);
DVBLoggingLogManager* dvb_logging_log_manager_construct (GType object_type);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBLoggingLogger* dvb_logging_log_manager_getLogger (DVBLoggingLogManager* self, const gchar* name);
static DVBLoggingLogger* dvb_logging_log_manager_createLogger (DVBLoggingLogManager* self, const gchar* name);
void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self);
static GObject * dvb_logging_log_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_logging_log_manager_finalize (GObject* obj);


GType dvb_logging_log_level_get_type (void) {
	static volatile gsize dvb_logging_log_level_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_LOGGING_LOG_LEVEL_LOG, "DVB_LOGGING_LOG_LEVEL_LOG", "log"}, {DVB_LOGGING_LOG_LEVEL_DEBUG, "DVB_LOGGING_LOG_LEVEL_DEBUG", "debug"}, {DVB_LOGGING_LOG_LEVEL_INFO, "DVB_LOGGING_LOG_LEVEL_INFO", "info"}, {DVB_LOGGING_LOG_LEVEL_WARNING, "DVB_LOGGING_LOG_LEVEL_WARNING", "warning"}, {DVB_LOGGING_LOG_LEVEL_ERROR, "DVB_LOGGING_LOG_LEVEL_ERROR", "error"}, {0, NULL, NULL}};
		GType dvb_logging_log_level_type_id;
		dvb_logging_log_level_type_id = g_enum_register_static ("DVBLoggingLogLevel", values);
		g_once_init_leave (&dvb_logging_log_level_type_id__volatile, dvb_logging_log_level_type_id);
	}
	return dvb_logging_log_level_type_id__volatile;
}


gchar* dvb_logging_formatter_format (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	return DVB_LOGGING_FORMATTER_GET_INTERFACE (self)->format (self, logger_name, level, format);
}


static void dvb_logging_formatter_base_init (DVBLoggingFormatterIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_logging_formatter_get_type (void) {
	static volatile gsize dvb_logging_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingFormatterIface), (GBaseInitFunc) dvb_logging_formatter_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_logging_formatter_type_id;
		dvb_logging_formatter_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBLoggingFormatter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_logging_formatter_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&dvb_logging_formatter_type_id__volatile, dvb_logging_formatter_type_id);
	}
	return dvb_logging_formatter_type_id__volatile;
}


void dvb_logging_handler_publish (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->publish (self, logger_name, level, format, args);
}


void dvb_logging_handler_close (DVBLoggingHandler* self) {
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->close (self);
}


DVBLoggingFormatter* dvb_logging_handler_get_formatter (DVBLoggingHandler* self) {
	return DVB_LOGGING_HANDLER_GET_INTERFACE (self)->get_formatter (self);
}


void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value) {
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->set_formatter (self, value);
}


DVBLoggingLogLevel dvb_logging_handler_get_threshold (DVBLoggingHandler* self) {
	return DVB_LOGGING_HANDLER_GET_INTERFACE (self)->get_threshold (self);
}


void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value) {
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->set_threshold (self, value);
}


static void dvb_logging_handler_base_init (DVBLoggingHandlerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("formatter", "formatter", "formatter", DVB_LOGGING_TYPE_FORMATTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_enum ("threshold", "threshold", "threshold", DVB_LOGGING_TYPE_LOG_LEVEL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType dvb_logging_handler_get_type (void) {
	static volatile gsize dvb_logging_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingHandlerIface), (GBaseInitFunc) dvb_logging_handler_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_logging_handler_type_id;
		dvb_logging_handler_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBLoggingHandler", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_logging_handler_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&dvb_logging_handler_type_id__volatile, dvb_logging_handler_type_id);
	}
	return dvb_logging_handler_type_id__volatile;
}


static gchar* dvb_logging_default_formatter_real_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level) {
	gchar* result = NULL;
	gchar* lvlstr;
	g_return_val_if_fail (self != NULL, NULL);
	lvlstr = NULL;
	switch (level) {
		case DVB_LOGGING_LOG_LEVEL_LOG:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("LOG");
			_g_free0 (lvlstr);
			lvlstr = _tmp0_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("DEBUG");
			_g_free0 (lvlstr);
			lvlstr = _tmp1_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_INFO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("INFO");
			_g_free0 (lvlstr);
			lvlstr = _tmp2_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("WARNING");
			_g_free0 (lvlstr);
			lvlstr = _tmp3_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_ERROR:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ERROR");
			_g_free0 (lvlstr);
			lvlstr = _tmp4_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = lvlstr;
	return result;
}


gchar* dvb_logging_default_formatter_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level) {
	return DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS (self)->get_level_name (self, level);
}


static gchar* dvb_logging_default_formatter_real_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* lvlstr;
	gchar* _tmp1_ = NULL;
	gchar* msg;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (logger_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = dvb_logging_default_formatter_get_level_name (self, level);
	lvlstr = _tmp0_;
	_tmp1_ = g_strdup_printf ("%-12s %-12s %s\n", logger_name, lvlstr, format);
	msg = _tmp1_;
	result = msg;
	_g_free0 (lvlstr);
	return result;
}


gchar* dvb_logging_default_formatter_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	return DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS (self)->format (self, logger_name, level, format);
}


DVBLoggingDefaultFormatter* dvb_logging_default_formatter_construct (GType object_type) {
	DVBLoggingDefaultFormatter * self = NULL;
	self = (DVBLoggingDefaultFormatter*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingDefaultFormatter* dvb_logging_default_formatter_new (void) {
	return dvb_logging_default_formatter_construct (DVB_LOGGING_TYPE_DEFAULT_FORMATTER);
}


static void dvb_logging_default_formatter_class_init (DVBLoggingDefaultFormatterClass * klass) {
	dvb_logging_default_formatter_parent_class = g_type_class_peek_parent (klass);
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->get_level_name = dvb_logging_default_formatter_real_get_level_name;
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->format = dvb_logging_default_formatter_real_format;
}


static void dvb_logging_default_formatter_dvb_logging_formatter_interface_init (DVBLoggingFormatterIface * iface) {
	dvb_logging_default_formatter_dvb_logging_formatter_parent_iface = g_type_interface_peek_parent (iface);
	iface->format = (gchar* (*)(DVBLoggingFormatter* ,const gchar* ,DVBLoggingLogLevel ,const gchar*)) dvb_logging_default_formatter_format;
}


static void dvb_logging_default_formatter_instance_init (DVBLoggingDefaultFormatter * self) {
}


GType dvb_logging_default_formatter_get_type (void) {
	static volatile gsize dvb_logging_default_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_default_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingDefaultFormatterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_default_formatter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingDefaultFormatter), 0, (GInstanceInitFunc) dvb_logging_default_formatter_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_formatter_info = { (GInterfaceInitFunc) dvb_logging_default_formatter_dvb_logging_formatter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_default_formatter_type_id;
		dvb_logging_default_formatter_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingDefaultFormatter", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_default_formatter_type_id, DVB_LOGGING_TYPE_FORMATTER, &dvb_logging_formatter_info);
		g_once_init_leave (&dvb_logging_default_formatter_type_id__volatile, dvb_logging_default_formatter_type_id);
	}
	return dvb_logging_default_formatter_type_id__volatile;
}


static gchar* dvb_logging_color_formatter_real_get_level_name (DVBLoggingDefaultFormatter* base, DVBLoggingLogLevel level) {
	DVBLoggingColorFormatter * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* lvlstr;
	gchar* _tmp1_ = NULL;
	self = (DVBLoggingColorFormatter*) base;
	_tmp0_ = DVB_LOGGING_DEFAULT_FORMATTER_CLASS (dvb_logging_color_formatter_parent_class)->get_level_name (DVB_LOGGING_DEFAULT_FORMATTER (self), level);
	lvlstr = _tmp0_;
	_tmp1_ = g_strdup_printf ("%s%s%s", dvb_logging_color_formatter_colormap[level], lvlstr, DVB_LOGGING_COLOR_FORMATTER_clear);
	result = _tmp1_;
	_g_free0 (lvlstr);
	return result;
}


static gchar* dvb_logging_color_formatter_real_format (DVBLoggingDefaultFormatter* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	DVBLoggingColorFormatter * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* lvlstr;
	gchar* msg = NULL;
	self = (DVBLoggingColorFormatter*) base;
	g_return_val_if_fail (logger_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = dvb_logging_default_formatter_get_level_name ((DVBLoggingDefaultFormatter*) self, level);
	lvlstr = _tmp0_;
	if (level < DVB_LOGGING_LOG_LEVEL_INFO) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup_printf ("%-12s %-20s %s\n", logger_name, lvlstr, format);
		_g_free0 (msg);
		msg = _tmp1_;
	} else {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup_printf ("%-12s %-23s %s\n", logger_name, lvlstr, format);
		_g_free0 (msg);
		msg = _tmp2_;
	}
	result = msg;
	_g_free0 (lvlstr);
	return result;
}


DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type) {
	DVBLoggingColorFormatter * self = NULL;
	self = (DVBLoggingColorFormatter*) dvb_logging_default_formatter_construct (object_type);
	return self;
}


DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void) {
	return dvb_logging_color_formatter_construct (DVB_LOGGING_TYPE_COLOR_FORMATTER);
}


static void dvb_logging_color_formatter_class_init (DVBLoggingColorFormatterClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	dvb_logging_color_formatter_parent_class = g_type_class_peek_parent (klass);
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->get_level_name = dvb_logging_color_formatter_real_get_level_name;
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->format = dvb_logging_color_formatter_real_format;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_color_formatter_finalize;
	_tmp0_ = g_strdup ("\033[37m");
	_tmp1_ = g_strdup ("\033[36m");
	_tmp2_ = g_strdup ("\033[32;01m");
	_tmp3_ = g_strdup ("\033[33;01m");
	_tmp4_ = g_strdup ("\033[31;01m");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	dvb_logging_color_formatter_colormap = _tmp5_;
	dvb_logging_color_formatter_colormap_length1 = 5;
}


static void dvb_logging_color_formatter_instance_init (DVBLoggingColorFormatter * self) {
}


static void dvb_logging_color_formatter_finalize (GObject* obj) {
	DVBLoggingColorFormatter * self;
	self = DVB_LOGGING_COLOR_FORMATTER (obj);
	G_OBJECT_CLASS (dvb_logging_color_formatter_parent_class)->finalize (obj);
}


GType dvb_logging_color_formatter_get_type (void) {
	static volatile gsize dvb_logging_color_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_color_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingColorFormatterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_color_formatter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingColorFormatter), 0, (GInstanceInitFunc) dvb_logging_color_formatter_instance_init, NULL };
		GType dvb_logging_color_formatter_type_id;
		dvb_logging_color_formatter_type_id = g_type_register_static (DVB_LOGGING_TYPE_DEFAULT_FORMATTER, "DVBLoggingColorFormatter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_color_formatter_type_id__volatile, dvb_logging_color_formatter_type_id);
	}
	return dvb_logging_color_formatter_type_id__volatile;
}


static void dvb_logging_console_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	DVBLoggingConsoleHandler * self;
	DVBLoggingLogLevel _tmp0_;
	DVBLoggingFormatter* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* msg;
	self = (DVBLoggingConsoleHandler*) base;
	g_return_if_fail (logger_name != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self);
	if (level < _tmp0_) {
		return;
	}
	_tmp1_ = dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self);
	_tmp2_ = dvb_logging_formatter_format (_tmp1_, logger_name, level, format);
	msg = _tmp2_;
	if (level > DVB_LOGGING_LOG_LEVEL_INFO) {
		vfprintf (stderr, msg, args);
	} else {
		vfprintf (stdout, msg, args);
	}
	_g_free0 (msg);
}


static void dvb_logging_console_handler_real_close (DVBLoggingHandler* base) {
	DVBLoggingConsoleHandler * self;
	self = (DVBLoggingConsoleHandler*) base;
}


DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type) {
	DVBLoggingConsoleHandler * self = NULL;
	self = (DVBLoggingConsoleHandler*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void) {
	return dvb_logging_console_handler_construct (DVB_LOGGING_TYPE_CONSOLE_HANDLER);
}


static DVBLoggingFormatter* dvb_logging_console_handler_real_get_formatter (DVBLoggingHandler* base) {
	DVBLoggingFormatter* result;
	DVBLoggingConsoleHandler* self;
	self = (DVBLoggingConsoleHandler*) base;
	result = self->priv->_formatter;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_logging_console_handler_real_set_formatter (DVBLoggingHandler* base, DVBLoggingFormatter* value) {
	DVBLoggingConsoleHandler* self;
	DVBLoggingFormatter* _tmp0_;
	self = (DVBLoggingConsoleHandler*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_formatter);
	self->priv->_formatter = _tmp0_;
	g_object_notify ((GObject *) self, "formatter");
}


static DVBLoggingLogLevel dvb_logging_console_handler_real_get_threshold (DVBLoggingHandler* base) {
	DVBLoggingLogLevel result;
	DVBLoggingConsoleHandler* self;
	self = (DVBLoggingConsoleHandler*) base;
	result = self->priv->_threshold;
	return result;
}


static void dvb_logging_console_handler_real_set_threshold (DVBLoggingHandler* base, DVBLoggingLogLevel value) {
	DVBLoggingConsoleHandler* self;
	self = (DVBLoggingConsoleHandler*) base;
	self->priv->_threshold = value;
	g_object_notify ((GObject *) self, "threshold");
}


static void dvb_logging_console_handler_class_init (DVBLoggingConsoleHandlerClass * klass) {
	dvb_logging_console_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingConsoleHandlerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_console_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_console_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_console_handler_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_LOGGING_CONSOLE_HANDLER_FORMATTER, "formatter");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD, "threshold");
}


static void dvb_logging_console_handler_dvb_logging_handler_interface_init (DVBLoggingHandlerIface * iface) {
	dvb_logging_console_handler_dvb_logging_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->publish = (void (*)(DVBLoggingHandler* ,const gchar* ,DVBLoggingLogLevel ,const gchar* ,va_list)) dvb_logging_console_handler_real_publish;
	iface->close = (void (*)(DVBLoggingHandler*)) dvb_logging_console_handler_real_close;
	iface->get_formatter = dvb_logging_console_handler_real_get_formatter;
	iface->set_formatter = dvb_logging_console_handler_real_set_formatter;
	iface->get_threshold = dvb_logging_console_handler_real_get_threshold;
	iface->set_threshold = dvb_logging_console_handler_real_set_threshold;
}


static void dvb_logging_console_handler_instance_init (DVBLoggingConsoleHandler * self) {
	DVBLoggingDefaultFormatter* _tmp0_ = NULL;
	self->priv = DVB_LOGGING_CONSOLE_HANDLER_GET_PRIVATE (self);
	_tmp0_ = dvb_logging_default_formatter_new ();
	self->priv->_formatter = (DVBLoggingFormatter*) _tmp0_;
	self->priv->_threshold = DVB_LOGGING_LOG_LEVEL_LOG;
}


static void dvb_logging_console_handler_finalize (GObject* obj) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (obj);
	_g_object_unref0 (self->priv->_formatter);
	G_OBJECT_CLASS (dvb_logging_console_handler_parent_class)->finalize (obj);
}


GType dvb_logging_console_handler_get_type (void) {
	static volatile gsize dvb_logging_console_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_console_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingConsoleHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_console_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingConsoleHandler), 0, (GInstanceInitFunc) dvb_logging_console_handler_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_handler_info = { (GInterfaceInitFunc) dvb_logging_console_handler_dvb_logging_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_console_handler_type_id;
		dvb_logging_console_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingConsoleHandler", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_console_handler_type_id, DVB_LOGGING_TYPE_HANDLER, &dvb_logging_handler_info);
		g_once_init_leave (&dvb_logging_console_handler_type_id__volatile, dvb_logging_console_handler_type_id);
	}
	return dvb_logging_console_handler_type_id__volatile;
}


static void _vala_dvb_logging_console_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_CONSOLE_HANDLER_FORMATTER:
		g_value_set_object (value, dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD:
		g_value_set_enum (value, dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_console_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_CONSOLE_HANDLER_FORMATTER:
		dvb_logging_handler_set_formatter ((DVBLoggingHandler*) self, g_value_get_object (value));
		break;
		case DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD:
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error) {
	DVBLoggingFileHandler * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file_pattern != NULL, NULL);
	self = (DVBLoggingFileHandler*) g_object_new (object_type, "pattern", file_pattern, NULL);
	self->priv->file_index = 0;
	dvb_logging_file_handler_rotate (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error) {
	return dvb_logging_file_handler_construct (DVB_LOGGING_TYPE_FILE_HANDLER, file_pattern, error);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


static void dvb_logging_file_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	DVBLoggingFileHandler * self;
	DVBLoggingLogLevel _tmp0_;
	DVBLoggingFormatter* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* msg;
	gchar* _tmp3_ = NULL;
	gchar* txt;
	guint8* _tmp5_ = NULL;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBLoggingFileHandler*) base;
	g_return_if_fail (logger_name != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self);
	if (level < _tmp0_) {
		return;
	}
	_tmp1_ = dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self);
	_tmp2_ = dvb_logging_formatter_format (_tmp1_, logger_name, level, format);
	msg = _tmp2_;
	_tmp3_ = g_strdup_vprintf (msg, args);
	txt = _tmp3_;
	if (self->priv->_limit > 0) {
		gint _tmp4_;
		_tmp4_ = strlen (txt);
		self->priv->file_size = self->priv->file_size + _tmp4_;
		if (self->priv->file_size > self->priv->_limit) {
			dvb_logging_file_handler_rotate (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch70_g_error;
			}
		}
	}
	_tmp5_ = string_get_data (txt, &_tmp6_);
	g_output_stream_write (self->priv->os, _tmp5_, (gsize) _tmp6_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch70_g_error;
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Error in FileHandler.publish: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		_g_free0 (txt);
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (txt);
	_g_free0 (msg);
}


static void dvb_logging_file_handler_real_close (DVBLoggingHandler* base) {
	DVBLoggingFileHandler * self;
	GError * _inner_error_ = NULL;
	self = (DVBLoggingFileHandler*) base;
	g_output_stream_close (self->priv->os, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch71_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally71;
	__catch71_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Error in FileHandler.close: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void dvb_logging_file_handler_rotate (DVBLoggingFileHandler* self, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFileOutputStream* fos = NULL;
	gboolean _tmp1_;
	GBufferedOutputStream* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->os != NULL) {
		dvb_logging_handler_close ((DVBLoggingHandler*) self);
	}
	_tmp0_ = dvb_logging_file_handler_get_next_file (self);
	file = _tmp0_;
	_tmp1_ = g_file_query_exists (file, NULL);
	if (_tmp1_) {
		GFileOutputStream* _tmp2_ = NULL;
		GFileOutputStream* _tmp3_;
		_tmp2_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fos);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (fos);
		fos = _tmp3_;
	} else {
		GFileOutputStream* _tmp4_ = NULL;
		GFileOutputStream* _tmp5_;
		_tmp4_ = g_file_create (file, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fos);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (fos);
		fos = _tmp5_;
	}
	_tmp6_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) fos);
	_g_object_unref0 (self->priv->os);
	self->priv->os = (GOutputStream*) _tmp6_;
	self->priv->file_size = 0;
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}


static GFile* dvb_logging_file_handler_get_next_file (DVBLoggingFileHandler* self) {
	GFile* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->file_index == self->priv->_count) {
		self->priv->file_index = 0;
	}
	_tmp0_ = self->priv->file_index;
	self->priv->file_index = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf (self->priv->_pattern, _tmp0_);
	filename = _tmp1_;
	_tmp2_ = g_file_new_for_path (filename);
	result = _tmp2_;
	_g_free0 (filename);
	return result;
}


static DVBLoggingFormatter* dvb_logging_file_handler_real_get_formatter (DVBLoggingHandler* base) {
	DVBLoggingFormatter* result;
	DVBLoggingFileHandler* self;
	self = (DVBLoggingFileHandler*) base;
	result = self->priv->_formatter;
	return result;
}


static void dvb_logging_file_handler_real_set_formatter (DVBLoggingHandler* base, DVBLoggingFormatter* value) {
	DVBLoggingFileHandler* self;
	DVBLoggingFormatter* _tmp0_;
	self = (DVBLoggingFileHandler*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_formatter);
	self->priv->_formatter = _tmp0_;
	g_object_notify ((GObject *) self, "formatter");
}


static DVBLoggingLogLevel dvb_logging_file_handler_real_get_threshold (DVBLoggingHandler* base) {
	DVBLoggingLogLevel result;
	DVBLoggingFileHandler* self;
	self = (DVBLoggingFileHandler*) base;
	result = self->priv->_threshold;
	return result;
}


static void dvb_logging_file_handler_real_set_threshold (DVBLoggingHandler* base, DVBLoggingLogLevel value) {
	DVBLoggingFileHandler* self;
	self = (DVBLoggingFileHandler*) base;
	self->priv->_threshold = value;
	g_object_notify ((GObject *) self, "threshold");
}


gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_limit;
	return result;
}


void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_limit = value;
	g_object_notify ((GObject *) self, "limit");
}


gint dvb_logging_file_handler_get_count (DVBLoggingFileHandler* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_count;
	return result;
}


void dvb_logging_file_handler_set_count (DVBLoggingFileHandler* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_count = value;
	g_object_notify ((GObject *) self, "count");
}


const gchar* dvb_logging_file_handler_get_pattern (DVBLoggingFileHandler* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pattern;
	return result;
}


static void dvb_logging_file_handler_set_pattern (DVBLoggingFileHandler* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_pattern);
	self->priv->_pattern = _tmp0_;
	g_object_notify ((GObject *) self, "pattern");
}


static void dvb_logging_file_handler_class_init (DVBLoggingFileHandlerClass * klass) {
	dvb_logging_file_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingFileHandlerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_file_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_file_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_file_handler_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_FORMATTER, "formatter");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_THRESHOLD, "threshold");
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_LIMIT, g_param_spec_int ("limit", "limit", "limit", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_COUNT, g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_PATTERN, g_param_spec_string ("pattern", "pattern", "pattern", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_logging_file_handler_dvb_logging_handler_interface_init (DVBLoggingHandlerIface * iface) {
	dvb_logging_file_handler_dvb_logging_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->publish = (void (*)(DVBLoggingHandler* ,const gchar* ,DVBLoggingLogLevel ,const gchar* ,va_list)) dvb_logging_file_handler_real_publish;
	iface->close = (void (*)(DVBLoggingHandler*)) dvb_logging_file_handler_real_close;
	iface->get_formatter = dvb_logging_file_handler_real_get_formatter;
	iface->set_formatter = dvb_logging_file_handler_real_set_formatter;
	iface->get_threshold = dvb_logging_file_handler_real_get_threshold;
	iface->set_threshold = dvb_logging_file_handler_real_set_threshold;
}


static void dvb_logging_file_handler_instance_init (DVBLoggingFileHandler * self) {
	DVBLoggingDefaultFormatter* _tmp0_ = NULL;
	self->priv = DVB_LOGGING_FILE_HANDLER_GET_PRIVATE (self);
	_tmp0_ = dvb_logging_default_formatter_new ();
	self->priv->_formatter = (DVBLoggingFormatter*) _tmp0_;
	self->priv->_threshold = DVB_LOGGING_LOG_LEVEL_LOG;
	self->priv->_limit = 0;
	self->priv->_count = 1;
}


static void dvb_logging_file_handler_finalize (GObject* obj) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (obj);
	_g_object_unref0 (self->priv->_formatter);
	_g_free0 (self->priv->_pattern);
	_g_object_unref0 (self->priv->os);
	G_OBJECT_CLASS (dvb_logging_file_handler_parent_class)->finalize (obj);
}


GType dvb_logging_file_handler_get_type (void) {
	static volatile gsize dvb_logging_file_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_file_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingFileHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_file_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingFileHandler), 0, (GInstanceInitFunc) dvb_logging_file_handler_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_handler_info = { (GInterfaceInitFunc) dvb_logging_file_handler_dvb_logging_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_file_handler_type_id;
		dvb_logging_file_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingFileHandler", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_file_handler_type_id, DVB_LOGGING_TYPE_HANDLER, &dvb_logging_handler_info);
		g_once_init_leave (&dvb_logging_file_handler_type_id__volatile, dvb_logging_file_handler_type_id);
	}
	return dvb_logging_file_handler_type_id__volatile;
}


static void _vala_dvb_logging_file_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_FILE_HANDLER_FORMATTER:
		g_value_set_object (value, dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_FILE_HANDLER_THRESHOLD:
		g_value_set_enum (value, dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_FILE_HANDLER_LIMIT:
		g_value_set_int (value, dvb_logging_file_handler_get_limit (self));
		break;
		case DVB_LOGGING_FILE_HANDLER_COUNT:
		g_value_set_int (value, dvb_logging_file_handler_get_count (self));
		break;
		case DVB_LOGGING_FILE_HANDLER_PATTERN:
		g_value_set_string (value, dvb_logging_file_handler_get_pattern (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_file_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_FILE_HANDLER_FORMATTER:
		dvb_logging_handler_set_formatter ((DVBLoggingHandler*) self, g_value_get_object (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_THRESHOLD:
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) self, g_value_get_enum (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_LIMIT:
		dvb_logging_file_handler_set_limit (self, g_value_get_int (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_COUNT:
		dvb_logging_file_handler_set_count (self, g_value_get_int (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_PATTERN:
		dvb_logging_file_handler_set_pattern (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handler != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->handlers, handler);
		__finally72:
		g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_logging_logger_removeHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handler != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->handlers, handler);
		__finally73:
		g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


GeeHashSet* dvb_logging_logger_getHandlers (DVBLoggingLogger* self) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->handlers);
	result = _tmp0_;
	return result;
}


static inline void dvb_logging_logger_log_full (DVBLoggingLogger* self, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _handler_it;
			_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->handlers);
			_handler_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBLoggingHandler* handler;
				va_list l;
				_tmp1_ = gee_iterator_next (_handler_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_handler_it);
				handler = (DVBLoggingHandler*) _tmp2_;
				va_copy (l, args);
				dvb_logging_handler_publish (handler, self->priv->_name, level, format, l);
				va_end (l);
				_g_object_unref0 (handler);
			}
			_g_object_unref0 (_handler_it);
		}
		__finally74:
		g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_logging_logger_log (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_LOG, format, l);
	va_end (l);
}


void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_DEBUG, format, l);
	va_end (l);
}


void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_INFO, format, l);
	va_end (l);
}


void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_WARNING, format, l);
	va_end (l);
}


void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_ERROR, format, l);
	va_end (l);
}


DVBLoggingLogger* dvb_logging_logger_construct (GType object_type) {
	DVBLoggingLogger * self = NULL;
	self = (DVBLoggingLogger*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingLogger* dvb_logging_logger_new (void) {
	return dvb_logging_logger_construct (DVB_LOGGING_TYPE_LOGGER);
}


const gchar* dvb_logging_logger_get_name (DVBLoggingLogger* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void dvb_logging_logger_set_name (DVBLoggingLogger* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	g_object_notify ((GObject *) self, "name");
}


static GObject * dvb_logging_logger_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBLoggingLogger * self;
	GeeHashSet* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_logging_logger_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_LOGGING_LOGGER (obj);
	_tmp0_ = gee_hash_set_new (DVB_LOGGING_TYPE_HANDLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	_g_object_unref0 (self->priv->handlers);
	self->priv->handlers = _tmp0_;
	return obj;
}


static void dvb_logging_logger_class_init (DVBLoggingLoggerClass * klass) {
	dvb_logging_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingLoggerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_logger_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_logging_logger_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_logger_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_LOGGER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_logging_logger_instance_init (DVBLoggingLogger * self) {
	self->priv = DVB_LOGGING_LOGGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_handlers);
}


static void dvb_logging_logger_finalize (GObject* obj) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (obj);
	_g_free0 (self->priv->_name);
	g_static_rec_mutex_free (&self->priv->__lock_handlers);
	_g_object_unref0 (self->priv->handlers);
	G_OBJECT_CLASS (dvb_logging_logger_parent_class)->finalize (obj);
}


GType dvb_logging_logger_get_type (void) {
	static volatile gsize dvb_logging_logger_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingLogger), 0, (GInstanceInitFunc) dvb_logging_logger_instance_init, NULL };
		GType dvb_logging_logger_type_id;
		dvb_logging_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingLogger", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_logger_type_id__volatile, dvb_logging_logger_type_id);
	}
	return dvb_logging_logger_type_id__volatile;
}


static void _vala_dvb_logging_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (object);
	switch (property_id) {
		case DVB_LOGGING_LOGGER_NAME:
		g_value_set_string (value, dvb_logging_logger_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (object);
	switch (property_id) {
		case DVB_LOGGING_LOGGER_NAME:
		dvb_logging_logger_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void) {
	DVBLoggingLogManager* result = NULL;
	g_static_rec_mutex_lock (&dvb_logging_log_manager_instance_mutex);
	if (dvb_logging_log_manager_instance == NULL) {
		DVBLoggingLogManager* _tmp0_ = NULL;
		_tmp0_ = dvb_logging_log_manager_new ();
		_g_object_unref0 (dvb_logging_log_manager_instance);
		dvb_logging_log_manager_instance = _tmp0_;
	}
	g_static_rec_mutex_unlock (&dvb_logging_log_manager_instance_mutex);
	result = dvb_logging_log_manager_instance;
	return result;
}


DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_logging_log_manager_getLogger (self, DVB_LOGGING_LOG_MANAGER_DEFAULT_NAME);
	result = _tmp0_;
	return result;
}


DVBLoggingLogger* dvb_logging_log_manager_getLogger (DVBLoggingLogManager* self, const gchar* name) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* l = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_loggers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->loggers, name);
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->loggers, name);
			_g_object_unref0 (l);
			l = (DVBLoggingLogger*) _tmp1_;
		} else {
			DVBLoggingLogger* _tmp2_ = NULL;
			_tmp2_ = dvb_logging_log_manager_createLogger (self, name);
			_g_object_unref0 (l);
			l = _tmp2_;
		}
		__finally75:
		g_static_rec_mutex_unlock (&self->priv->__lock_loggers);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (l);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = l;
	return result;
}


static DVBLoggingLogger* dvb_logging_log_manager_createLogger (DVBLoggingLogManager* self, const gchar* name) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBLoggingLogger* l;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = dvb_logging_logger_new ();
	l = _tmp0_;
	dvb_logging_logger_set_name (l, name);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->loggers, name, l);
	result = l;
	return result;
}


void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_loggers);
		{
			GeeCollection* _tmp0_ = NULL;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _logger_it;
			_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->loggers);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_logger_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				DVBLoggingLogger* logger;
				_tmp4_ = gee_iterator_next (_logger_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_logger_it);
				logger = (DVBLoggingLogger*) _tmp5_;
				{
					GeeHashSet* _tmp6_ = NULL;
					GeeHashSet* _tmp7_;
					GeeIterator* _tmp8_ = NULL;
					GeeIterator* _tmp9_;
					GeeIterator* _handler_it;
					_tmp6_ = dvb_logging_logger_getHandlers (logger);
					_tmp7_ = _tmp6_;
					_tmp8_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (_tmp7_);
					_handler_it = _tmp9_;
					while (TRUE) {
						gboolean _tmp10_;
						gpointer _tmp11_ = NULL;
						DVBLoggingHandler* handler;
						_tmp10_ = gee_iterator_next (_handler_it);
						if (!_tmp10_) {
							break;
						}
						_tmp11_ = gee_iterator_get (_handler_it);
						handler = (DVBLoggingHandler*) _tmp11_;
						dvb_logging_handler_close (handler);
						_g_object_unref0 (handler);
					}
					_g_object_unref0 (_handler_it);
				}
				_g_object_unref0 (logger);
			}
			_g_object_unref0 (_logger_it);
		}
		gee_abstract_map_clear ((GeeAbstractMap*) self->priv->loggers);
		__finally76:
		g_static_rec_mutex_unlock (&self->priv->__lock_loggers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBLoggingLogManager* dvb_logging_log_manager_construct (GType object_type) {
	DVBLoggingLogManager * self = NULL;
	self = (DVBLoggingLogManager*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingLogManager* dvb_logging_log_manager_new (void) {
	return dvb_logging_log_manager_construct (DVB_LOGGING_TYPE_LOG_MANAGER);
}


static GObject * dvb_logging_log_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBLoggingLogManager * self;
	GeeHashMap* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_logging_log_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_LOGGING_LOG_MANAGER (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_LOGGING_TYPE_LOGGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, g_direct_equal);
	_g_object_unref0 (self->priv->loggers);
	self->priv->loggers = _tmp0_;
	return obj;
}


static void dvb_logging_log_manager_class_init (DVBLoggingLogManagerClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	GStaticRecMutex _tmp1_ = {0};
	dvb_logging_log_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingLogManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_logging_log_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_log_manager_finalize;
	g_static_rec_mutex_init (&_tmp0_);
	_tmp1_ = _tmp0_;
	dvb_logging_log_manager_instance_mutex = _tmp1_;
}


static void dvb_logging_log_manager_instance_init (DVBLoggingLogManager * self) {
	self->priv = DVB_LOGGING_LOG_MANAGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_loggers);
}


static void dvb_logging_log_manager_finalize (GObject* obj) {
	DVBLoggingLogManager * self;
	self = DVB_LOGGING_LOG_MANAGER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_loggers);
	_g_object_unref0 (self->priv->loggers);
	G_OBJECT_CLASS (dvb_logging_log_manager_parent_class)->finalize (obj);
}


GType dvb_logging_log_manager_get_type (void) {
	static volatile gsize dvb_logging_log_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_log_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingLogManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_log_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingLogManager), 0, (GInstanceInitFunc) dvb_logging_log_manager_instance_init, NULL };
		GType dvb_logging_log_manager_type_id;
		dvb_logging_log_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingLogManager", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_log_manager_type_id__volatile, dvb_logging_log_manager_type_id);
	}
	return dvb_logging_log_manager_type_id__volatile;
}



