/* EPGScanner.c generated by valac 0.14.0, the Vala compiler
 * generated from EPGScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};

struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* DeviceGroup;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GQueue* channels;
	GSource* scan_source;
	GSource* queue_source;
	gint stop_counter;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	guint bus_watch_id;
	GeeHashMap* channel_events;
	GStaticRecMutex __lock_channel_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_epg_scanner_parent_class = NULL;
static DVBLoggingLogger* dvb_epg_scanner_log;
static DVBLoggingLogger* dvb_epg_scanner_log = NULL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL = 0;

GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
#define DVB_EPG_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=0:16:17:18 stats-report" \
"ing-interval=0 ! mpegtsparse ! fakesink silent=true"
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (DVBFactory* self);
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self);
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
static void* dvb_epg_scanner_worker (DVBEPGScanner* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gboolean dvb_event_has_expired (DVBEvent* self);
guint dvb_event_hash (DVBEvent* event);
static guint _dvb_event_hash_ghash_func (gconstpointer key);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_epg_scanner_finalize (GObject* obj);


/**
         * @device: The device where EPG should be collected from
         */
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	DVBEPGScanner * self = NULL;
	DVBDeviceGroup* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBEPGScanner*) g_object_new (object_type, NULL);
	_tmp0_ = device;
	self->priv->DeviceGroup = _tmp0_;
	_tmp1_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
	if (_tmp1_ == (-1)) {
		DVBFactory* _tmp2_;
		DVBFactory* _tmp3_;
		DVBSettings* _tmp4_ = NULL;
		DVBSettings* _tmp5_;
		DVBSettings* settings;
		DVBSettings* _tmp6_;
		gint _tmp7_ = 0;
		_tmp2_ = dvb_factory_new ();
		_tmp3_ = _tmp2_;
		_tmp4_ = dvb_factory_get_settings (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		settings = _tmp5_;
		_tmp6_ = settings;
		_tmp7_ = dvb_settings_get_epg_scan_interval (_tmp6_);
		dvb_epg_scanner_CHECK_EIT_INTERVAL = _tmp7_;
		_g_object_unref0 (settings);
	}
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


/**
         * Stop collecting EPG data
         */
void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:75: Stopping EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->stop_counter;
	if (_tmp5_ == 0) {
		dvb_epg_scanner_remove_timeouts (self);
		dvb_epg_scanner_reset (self);
	}
	_tmp6_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp6_ + 1;
}


static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self) {
	GSource* _tmp0_;
	GSource* _tmp2_;
	GMainLoop* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_source;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->scan_source;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->scan_source);
		self->priv->scan_source = NULL;
	}
	_tmp2_ = self->priv->queue_source;
	if (_tmp2_ != NULL) {
		GSource* _tmp3_;
		_tmp3_ = self->priv->queue_source;
		g_source_destroy (_tmp3_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = NULL;
	}
	_tmp4_ = self->priv->loop;
	if (_tmp4_ != NULL) {
		GMainLoop* _tmp5_;
		GThread* _tmp6_;
		_tmp5_ = self->priv->loop;
		g_main_loop_quit (_tmp5_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		_tmp6_ = self->priv->worker_thread;
		g_thread_join (_tmp6_);
		self->priv->worker_thread = NULL;
	}
}


static void* dvb_epg_scanner_worker (DVBEPGScanner* self) {
	void* result = NULL;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->loop;
	g_main_loop_run (_tmp0_);
	result = NULL;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	DVBChannel* c = NULL;
	GQueue* _tmp14_;
	GeeHashMap* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GstElement* _tmp0_;
		_tmp0_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp1_;
			_tmp1_ = self->priv->pipeline;
			if (_tmp1_ != NULL) {
				GMainContext* _tmp2_;
				guint _tmp3_;
				GSource* _tmp4_ = NULL;
				GSource* _tmp5_;
				GSource* bus_watch_source;
				GSource* _tmp6_;
				GstElement* _tmp8_;
				GstElement* _tmp9_;
				_tmp2_ = self->priv->context;
				_tmp3_ = self->priv->bus_watch_id;
				_tmp4_ = g_main_context_find_source_by_id (_tmp2_, _tmp3_);
				_tmp5_ = _g_source_ref0 (_tmp4_);
				bus_watch_source = _tmp5_;
				_tmp6_ = bus_watch_source;
				if (_tmp6_ != NULL) {
					GSource* _tmp7_;
					_tmp7_ = bus_watch_source;
					g_source_destroy (_tmp7_);
					self->priv->bus_watch_id = (guint) 0;
				}
				_tmp8_ = self->priv->pipeline;
				gst_element_set_state (_tmp8_, GST_STATE_NULL);
				_tmp9_ = self->priv->pipeline;
				gst_element_get_state (_tmp9_, NULL, NULL, (GstClockTime) (-1));
				_gst_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = NULL;
				_g_source_unref0 (bus_watch_source);
			}
		}
		__finally60:
		{
			GstElement* _tmp10_;
			_tmp10_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GQueue* _tmp11_;
		gpointer _tmp12_ = NULL;
		DVBChannel* _tmp13_;
		_tmp11_ = self->priv->channels;
		_tmp12_ = g_queue_pop_head (_tmp11_);
		_g_object_unref0 (c);
		c = (DVBChannel*) _tmp12_;
		_tmp13_ = c;
		if (!(_tmp13_ != NULL)) {
			break;
		}
	}
	_tmp14_ = self->priv->channels;
	g_queue_clear (_tmp14_);
	_tmp15_ = self->priv->channel_events;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp15_);
	_g_object_unref0 (c);
}


/**
         * Start collection EPG data for all channels
         */
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_epg_scanner_worker (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_bus_watch_func (self, bus, message);
	return result;
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_scan_new_frequency (self);
	return result;
}


gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gint _tmp4_;
	GMainContext* _tmp5_;
	GMainLoop* _tmp6_;
	gint _tmp12_;
	gint _tmp13_;
	DVBDeviceGroup* _tmp25_;
	DVBDevice* _tmp26_ = NULL;
	DVBDevice* device;
	DVBDevice* _tmp27_;
	GSource* _tmp51_;
	GSource* _tmp52_;
	GSource* _tmp53_;
	GMainContext* _tmp54_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:137: Starting EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->context;
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp6_;
	{
		GThread* _tmp7_ = NULL;
		GThread* _tmp8_;
		_tmp7_ = g_thread_create (_dvb_epg_scanner_worker_gthread_func, self, TRUE, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch61_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		self->priv->worker_thread = _tmp8_;
	}
	goto __finally61;
	__catch61_g_thread_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = dvb_epg_scanner_log;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		dvb_logging_logger_error (_tmp9_, "EPGScanner.vala:143: Could not create thread: %s", _tmp11_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally61:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp12_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp12_ - 1;
	_tmp13_ = self->priv->stop_counter;
	if (_tmp13_ > 0) {
		result = FALSE;
		return result;
	}
	self->priv->stop_counter = 0;
	{
		DVBDeviceGroup* _tmp14_;
		DVBChannelList* _tmp15_;
		DVBChannelList* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _c_it;
		_tmp14_ = self->priv->DeviceGroup;
		_tmp15_ = dvb_device_group_get_Channels (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_c_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			DVBChannel* c;
			GQueue* _tmp22_;
			DVBChannel* _tmp23_;
			DVBChannel* _tmp24_;
			_tmp18_ = _c_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _c_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			c = (DVBChannel*) _tmp21_;
			_tmp22_ = self->priv->channels;
			_tmp23_ = c;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			g_queue_push_tail (_tmp22_, _tmp24_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	_tmp25_ = self->priv->DeviceGroup;
	_tmp26_ = dvb_device_group_get_next_free_device (_tmp25_);
	device = _tmp26_;
	_tmp27_ = device;
	if (_tmp27_ == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	{
		GstElement* _tmp28_;
		_tmp28_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp45_;
			GstBus* _tmp46_ = NULL;
			GstBus* bus;
			GstBus* _tmp47_;
			GMainContext* _tmp48_;
			guint _tmp49_ = 0U;
			{
				DVBDevice* _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				DVBDevice* _tmp32_;
				guint _tmp33_;
				guint _tmp34_;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				GstElement* _tmp37_ = NULL;
				GstElement* _tmp38_;
				GstElement* _tmp39_;
				_tmp29_ = device;
				_tmp30_ = dvb_device_get_Adapter (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = device;
				_tmp33_ = dvb_device_get_Frontend (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup_printf (DVB_EPG_SCANNER_PIPELINE_TEMPLATE, _tmp31_, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = gst_parse_launch (_tmp36_, &_inner_error_);
				_tmp38_ = _tmp37_;
				_g_free0 (_tmp36_);
				_tmp39_ = _tmp38_;
				if (_inner_error_ != NULL) {
					goto __catch63_g_error;
				}
				_gst_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = _tmp39_;
			}
			goto __finally63;
			__catch63_g_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp40_;
				GError* _tmp41_;
				const gchar* _tmp42_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp40_ = dvb_epg_scanner_log;
				_tmp41_ = e;
				_tmp42_ = _tmp41_->message;
				dvb_logging_logger_error (_tmp40_, "EPGScanner.vala:163: Could not create pipeline: %s", _tmp42_);
				result = FALSE;
				_g_error_free0 (e);
				{
					GstElement* _tmp43_;
					_tmp43_ = self->priv->pipeline;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				return result;
			}
			__finally63:
			if (_inner_error_ != NULL) {
				{
					GstElement* _tmp44_;
					_tmp44_ = self->priv->pipeline;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp45_ = self->priv->pipeline;
			_tmp46_ = gst_element_get_bus (_tmp45_);
			bus = _tmp46_;
			_tmp47_ = bus;
			_tmp48_ = self->priv->context;
			_tmp49_ = gst_bus_add_watch_context (_tmp47_, _dvb_epg_scanner_bus_watch_func_gst_bus_func, self, _tmp48_);
			self->priv->bus_watch_id = _tmp49_;
			_gst_object_unref0 (bus);
		}
		__finally62:
		{
			GstElement* _tmp50_;
			_tmp50_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp51_ = g_timeout_source_new_seconds ((guint) DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION);
	_g_source_unref0 (self->priv->scan_source);
	self->priv->scan_source = _tmp51_;
	_tmp52_ = self->priv->scan_source;
	g_source_set_callback (_tmp52_, _dvb_epg_scanner_scan_new_frequency_gsource_func, g_object_ref (self), g_object_unref);
	_tmp53_ = self->priv->scan_source;
	_tmp54_ = self->priv->context;
	g_source_attach (_tmp53_, _tmp54_);
	result = FALSE;
	_g_object_unref0 (device);
	return result;
}


/**
         * Scan the next frequency for EPG data
         */
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_start (self);
	return result;
}


static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	gboolean result = FALSE;
	GQueue* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GQueue* _tmp46_;
	gpointer _tmp47_ = NULL;
	DVBChannel* channel;
	DVBChannel* _tmp48_;
	DVBSchedule* _tmp49_;
	DVBSchedule* _tmp50_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->channel_events;
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			GeeHashMap* _tmp33_;
			{
				GeeHashMap* _tmp1_;
				GeeSet* _tmp2_;
				GeeSet* _tmp3_;
				GeeSet* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _sid_it;
				_tmp1_ = self->priv->channel_events;
				_tmp2_ = gee_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_sid_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					guint sid;
					DVBDeviceGroup* _tmp11_;
					DVBChannelList* _tmp12_;
					DVBChannelList* _tmp13_;
					guint _tmp14_;
					DVBChannel* _tmp15_ = NULL;
					DVBChannel* channel;
					DVBChannel* _tmp16_;
					GeeHashMap* _tmp18_;
					guint _tmp19_;
					gpointer _tmp20_ = NULL;
					GeeHashSet* list;
					DVBLoggingLogger* _tmp21_;
					GeeHashSet* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					DVBChannel* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					guint _tmp28_;
					DVBChannel* _tmp29_;
					DVBSchedule* _tmp30_;
					DVBSchedule* _tmp31_;
					GeeHashSet* _tmp32_;
					_tmp7_ = _sid_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _sid_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					sid = GPOINTER_TO_UINT (_tmp10_);
					_tmp11_ = self->priv->DeviceGroup;
					_tmp12_ = dvb_device_group_get_Channels (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = sid;
					_tmp15_ = dvb_channel_list_get_channel (_tmp13_, _tmp14_);
					channel = _tmp15_;
					_tmp16_ = channel;
					if (_tmp16_ == NULL) {
						guint _tmp17_;
						_tmp17_ = sid;
						g_warning ("EPGScanner.vala:187: Could not find channel %u for this device", _tmp17_);
						_g_object_unref0 (channel);
						continue;
					}
					_tmp18_ = self->priv->channel_events;
					_tmp19_ = sid;
					_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, GUINT_TO_POINTER (_tmp19_));
					list = (GeeHashSet*) _tmp20_;
					_tmp21_ = dvb_epg_scanner_log;
					_tmp22_ = list;
					_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = channel;
					_tmp26_ = dvb_channel_get_Name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = sid;
					dvb_logging_logger_debug (_tmp21_, "EPGScanner.vala:192: Adding %d events of channel %s (%u)", _tmp24_, _tmp27_, _tmp28_);
					_tmp29_ = channel;
					_tmp30_ = dvb_channel_get_Schedule (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = list;
					dvb_schedule_add_all (_tmp31_, (GeeCollection*) _tmp32_);
					_g_object_unref0 (list);
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_sid_it);
			}
			_tmp33_ = self->priv->channel_events;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp33_);
		}
		__finally64:
		{
			GeeHashMap* _tmp34_;
			_tmp34_ = self->priv->channel_events;
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp35_ = self->priv->channels;
	_tmp36_ = g_queue_is_empty (_tmp35_);
	if (_tmp36_) {
		DVBLoggingLogger* _tmp37_;
		DVBDeviceGroup* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		gint _tmp41_;
		GSource* _tmp42_;
		GSource* _tmp43_;
		GSource* _tmp44_;
		GMainContext* _tmp45_;
		_tmp37_ = dvb_epg_scanner_log;
		_tmp38_ = self->priv->DeviceGroup;
		_tmp39_ = dvb_device_group_get_Id (_tmp38_);
		_tmp40_ = _tmp39_;
		dvb_logging_logger_debug (_tmp37_, "EPGScanner.vala:200: Finished EPG scan for group %u", _tmp40_);
		dvb_epg_scanner_reset (self);
		_tmp41_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
		_tmp42_ = g_timeout_source_new_seconds ((guint) _tmp41_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = _tmp42_;
		_tmp43_ = self->priv->queue_source;
		g_source_set_callback (_tmp43_, _dvb_epg_scanner_start_gsource_func, g_object_ref (self), g_object_unref);
		_tmp44_ = self->priv->queue_source;
		_tmp45_ = self->priv->context;
		g_source_attach (_tmp44_, _tmp45_);
		result = FALSE;
		return result;
	}
	_tmp46_ = self->priv->channels;
	_tmp47_ = g_queue_pop_head (_tmp46_);
	channel = (DVBChannel*) _tmp47_;
	_tmp48_ = channel;
	_tmp49_ = dvb_channel_get_Schedule (_tmp48_);
	_tmp50_ = _tmp49_;
	dvb_schedule_remove_expired_events (_tmp50_);
	{
		GstElement* _tmp51_;
		_tmp51_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp52_;
			GstElement* _tmp53_;
			GstElement* _tmp54_ = NULL;
			GstElement* dvbsrc;
			DVBChannel* _tmp55_;
			GstElement* _tmp56_;
			GstElement* _tmp57_;
			_tmp52_ = self->priv->pipeline;
			gst_element_set_state (_tmp52_, GST_STATE_READY);
			_tmp53_ = self->priv->pipeline;
			_tmp54_ = gst_bin_get_by_name (GST_BIN (_tmp53_), "dvbsrc");
			dvbsrc = _tmp54_;
			_tmp55_ = channel;
			_tmp56_ = dvbsrc;
			dvb_channel_setup_dvb_source (_tmp55_, _tmp56_);
			_tmp57_ = self->priv->pipeline;
			gst_element_set_state (_tmp57_, GST_STATE_PLAYING);
			_gst_object_unref0 (dvbsrc);
		}
		__finally65:
		{
			GstElement* _tmp58_;
			_tmp58_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (channel);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ELEMENT:
		{
			GstMessage* _tmp2_;
			const GstStructure* _tmp3_ = NULL;
			GstStructure* _tmp4_;
			GstStructure* structure;
			const GstStructure* _tmp5_;
			const gchar* _tmp6_ = NULL;
			_tmp2_ = message;
			_tmp3_ = gst_message_get_structure (_tmp2_);
			_tmp4_ = _gst_structure_copy0 (_tmp3_);
			structure = _tmp4_;
			_tmp5_ = structure;
			_tmp6_ = gst_structure_get_name (_tmp5_);
			if (g_strcmp0 (_tmp6_, "dvb-read-failure") == 0) {
				DVBLoggingLogger* _tmp7_;
				_tmp7_ = dvb_epg_scanner_log;
				dvb_logging_logger_error (_tmp7_, "EPGScanner.vala:232: Could not read from DVB device");
				dvb_epg_scanner_stop (self);
			} else {
				const GstStructure* _tmp8_;
				const gchar* _tmp9_ = NULL;
				_tmp8_ = structure;
				_tmp9_ = gst_structure_get_name (_tmp8_);
				if (g_strcmp0 (_tmp9_, "eit") == 0) {
					const GstStructure* _tmp10_;
					_tmp10_ = structure;
					dvb_epg_scanner_on_eit_structure (self, _tmp10_);
				}
			}
			_gst_structure_free0 (structure);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp11_;
			GError* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			DVBLoggingLogger* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp11_ = message;
			gst_message_parse_error (_tmp11_, &_tmp12_, &_tmp13_);
			_g_error_free0 (gerror);
			gerror = _tmp12_;
			_g_free0 (debug);
			debug = _tmp13_;
			_tmp14_ = dvb_epg_scanner_log;
			_tmp15_ = gerror;
			_tmp16_ = _tmp15_->message;
			_tmp17_ = debug;
			dvb_logging_logger_error (_tmp14_, "EPGScanner.vala:243: %s %s", _tmp16_, _tmp17_);
			dvb_epg_scanner_stop (self);
			result = FALSE;
			_g_free0 (debug);
			_g_error_free0 (gerror);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static guint _dvb_event_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_event_hash (key);
	return result;
}


static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_event_equal (a, b);
	return result;
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure) {
	const GstStructure* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue events;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_ = 0U;
	guint size;
	GValue val = {0};
	const GstStructure* event = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	_tmp1_ = gst_structure_get_value (_tmp0_, "events");
	events = *_tmp1_;
	_tmp2_ = gst_value_list_get_type ();
	_tmp3_ = G_VALUE_HOLDS (&events, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = gst_value_list_get_size (&events);
	size = _tmp4_;
	{
		GeeHashMap* _tmp5_;
		_tmp5_ = self->priv->channel_events;
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			{
				guint i;
				i = (guint) 0;
				{
					gboolean _tmp6_;
					_tmp6_ = TRUE;
					while (TRUE) {
						gboolean _tmp7_;
						guint _tmp9_;
						guint _tmp10_;
						guint _tmp11_;
						GValue* _tmp12_ = NULL;
						const GstStructure* _tmp13_ = NULL;
						DVBEvent* _tmp14_;
						DVBEvent* event_class;
						DVBEvent* _tmp15_;
						const GstStructure* _tmp16_;
						guint _tmp17_ = 0U;
						DVBEvent* _tmp18_;
						const GstStructure* _tmp19_;
						guint _tmp20_ = 0U;
						DVBEvent* _tmp21_;
						const GstStructure* _tmp22_;
						guint _tmp23_ = 0U;
						DVBEvent* _tmp24_;
						const GstStructure* _tmp25_;
						guint _tmp26_ = 0U;
						DVBEvent* _tmp27_;
						const GstStructure* _tmp28_;
						guint _tmp29_ = 0U;
						DVBEvent* _tmp30_;
						const GstStructure* _tmp31_;
						guint _tmp32_ = 0U;
						DVBEvent* _tmp33_;
						const GstStructure* _tmp34_;
						guint _tmp35_ = 0U;
						DVBEvent* _tmp36_;
						const GstStructure* _tmp37_;
						guint _tmp38_ = 0U;
						DVBEvent* _tmp39_;
						gboolean _tmp40_ = FALSE;
						DVBEvent* _tmp41_;
						const GstStructure* _tmp42_;
						guint _tmp43_ = 0U;
						const GstStructure* _tmp44_;
						const gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						gchar* name;
						gboolean _tmp47_ = FALSE;
						const gchar* _tmp48_;
						gboolean _tmp51_;
						const GstStructure* _tmp55_;
						const gchar* _tmp56_ = NULL;
						gchar* _tmp57_;
						gchar* desc;
						gboolean _tmp58_ = FALSE;
						const gchar* _tmp59_;
						gboolean _tmp62_;
						const GstStructure* _tmp66_;
						const gchar* _tmp67_ = NULL;
						gchar* _tmp68_;
						gchar* ext_desc;
						gboolean _tmp69_ = FALSE;
						const gchar* _tmp70_;
						gboolean _tmp73_;
						gboolean free_ca = FALSE;
						const GstStructure* _tmp77_;
						gboolean _tmp78_ = FALSE;
						DVBEvent* _tmp79_;
						gboolean _tmp80_;
						const GstStructure* _tmp81_;
						guint _tmp82_ = 0U;
						guint sid;
						GeeHashMap* _tmp83_;
						guint _tmp84_;
						gboolean _tmp85_ = FALSE;
						GeeHashMap* _tmp90_;
						guint _tmp91_;
						gpointer _tmp92_ = NULL;
						GeeHashSet* list;
						GeeHashSet* _tmp93_;
						DVBEvent* _tmp94_;
						_tmp7_ = _tmp6_;
						if (!_tmp7_) {
							guint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp9_ = i;
						_tmp10_ = size;
						if (!(_tmp9_ < _tmp10_)) {
							break;
						}
						_tmp11_ = i;
						_tmp12_ = gst_value_list_get_value (&events, _tmp11_);
						val = *_tmp12_;
						_tmp13_ = gst_value_get_structure (&val);
						event = _tmp13_;
						_tmp14_ = dvb_event_new ();
						event_class = _tmp14_;
						_tmp15_ = event_class;
						_tmp16_ = event;
						_tmp17_ = dvb_epg_scanner_get_uint_val (_tmp16_, "event-id");
						_tmp15_->id = _tmp17_;
						_tmp18_ = event_class;
						_tmp19_ = event;
						_tmp20_ = dvb_epg_scanner_get_uint_val (_tmp19_, "year");
						_tmp18_->year = _tmp20_;
						_tmp21_ = event_class;
						_tmp22_ = event;
						_tmp23_ = dvb_epg_scanner_get_uint_val (_tmp22_, "month");
						_tmp21_->month = _tmp23_;
						_tmp24_ = event_class;
						_tmp25_ = event;
						_tmp26_ = dvb_epg_scanner_get_uint_val (_tmp25_, "day");
						_tmp24_->day = _tmp26_;
						_tmp27_ = event_class;
						_tmp28_ = event;
						_tmp29_ = dvb_epg_scanner_get_uint_val (_tmp28_, "hour");
						_tmp27_->hour = _tmp29_;
						_tmp30_ = event_class;
						_tmp31_ = event;
						_tmp32_ = dvb_epg_scanner_get_uint_val (_tmp31_, "minute");
						_tmp30_->minute = _tmp32_;
						_tmp33_ = event_class;
						_tmp34_ = event;
						_tmp35_ = dvb_epg_scanner_get_uint_val (_tmp34_, "second");
						_tmp33_->second = _tmp35_;
						_tmp36_ = event_class;
						_tmp37_ = event;
						_tmp38_ = dvb_epg_scanner_get_uint_val (_tmp37_, "duration");
						_tmp36_->duration = _tmp38_;
						_tmp39_ = event_class;
						_tmp40_ = dvb_event_has_expired (_tmp39_);
						if (_tmp40_) {
							_dvb_event_unref0 (event_class);
							continue;
						}
						_tmp41_ = event_class;
						_tmp42_ = event;
						_tmp43_ = dvb_epg_scanner_get_uint_val (_tmp42_, "running-status");
						_tmp41_->running_status = _tmp43_;
						_tmp44_ = event;
						_tmp45_ = gst_structure_get_string (_tmp44_, "name");
						_tmp46_ = g_strdup (_tmp45_);
						name = _tmp46_;
						_tmp48_ = name;
						if (_tmp48_ != NULL) {
							const gchar* _tmp49_;
							gboolean _tmp50_ = FALSE;
							_tmp49_ = name;
							_tmp50_ = g_utf8_validate (_tmp49_, (gssize) (-1), NULL);
							_tmp47_ = _tmp50_;
						} else {
							_tmp47_ = FALSE;
						}
						_tmp51_ = _tmp47_;
						if (_tmp51_) {
							DVBEvent* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							_tmp52_ = event_class;
							_tmp53_ = name;
							_tmp54_ = g_strdup (_tmp53_);
							_g_free0 (_tmp52_->name);
							_tmp52_->name = _tmp54_;
						}
						_tmp55_ = event;
						_tmp56_ = gst_structure_get_string (_tmp55_, "description");
						_tmp57_ = g_strdup (_tmp56_);
						desc = _tmp57_;
						_tmp59_ = desc;
						if (_tmp59_ != NULL) {
							const gchar* _tmp60_;
							gboolean _tmp61_ = FALSE;
							_tmp60_ = desc;
							_tmp61_ = g_utf8_validate (_tmp60_, (gssize) (-1), NULL);
							_tmp58_ = _tmp61_;
						} else {
							_tmp58_ = FALSE;
						}
						_tmp62_ = _tmp58_;
						if (_tmp62_) {
							DVBEvent* _tmp63_;
							const gchar* _tmp64_;
							gchar* _tmp65_;
							_tmp63_ = event_class;
							_tmp64_ = desc;
							_tmp65_ = g_strdup (_tmp64_);
							_g_free0 (_tmp63_->description);
							_tmp63_->description = _tmp65_;
						}
						_tmp66_ = event;
						_tmp67_ = gst_structure_get_string (_tmp66_, "extended-text");
						_tmp68_ = g_strdup (_tmp67_);
						ext_desc = _tmp68_;
						_tmp70_ = ext_desc;
						if (_tmp70_ != NULL) {
							const gchar* _tmp71_;
							gboolean _tmp72_ = FALSE;
							_tmp71_ = ext_desc;
							_tmp72_ = g_utf8_validate (_tmp71_, (gssize) (-1), NULL);
							_tmp69_ = _tmp72_;
						} else {
							_tmp69_ = FALSE;
						}
						_tmp73_ = _tmp69_;
						if (_tmp73_) {
							DVBEvent* _tmp74_;
							const gchar* _tmp75_;
							gchar* _tmp76_;
							_tmp74_ = event_class;
							_tmp75_ = ext_desc;
							_tmp76_ = g_strdup (_tmp75_);
							_g_free0 (_tmp74_->extended_description);
							_tmp74_->extended_description = _tmp76_;
						}
						_tmp77_ = event;
						gst_structure_get_boolean (_tmp77_, "free-ca-mode", &_tmp78_);
						free_ca = _tmp78_;
						_tmp79_ = event_class;
						_tmp80_ = free_ca;
						_tmp79_->free_ca_mode = _tmp80_;
						_tmp81_ = structure;
						_tmp82_ = dvb_epg_scanner_get_uint_val (_tmp81_, "service-id");
						sid = _tmp82_;
						_tmp83_ = self->priv->channel_events;
						_tmp84_ = sid;
						_tmp85_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp83_, GUINT_TO_POINTER (_tmp84_));
						if (!_tmp85_) {
							GeeHashMap* _tmp86_;
							guint _tmp87_;
							GeeHashSet* _tmp88_;
							GeeHashSet* _tmp89_;
							_tmp86_ = self->priv->channel_events;
							_tmp87_ = sid;
							_tmp88_ = gee_hash_set_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, _dvb_event_hash_ghash_func, _dvb_event_equal_gequal_func);
							_tmp89_ = _tmp88_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp86_, GUINT_TO_POINTER (_tmp87_), _tmp89_);
							_g_object_unref0 (_tmp89_);
						}
						_tmp90_ = self->priv->channel_events;
						_tmp91_ = sid;
						_tmp92_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp90_, GUINT_TO_POINTER (_tmp91_));
						list = (GeeHashSet*) _tmp92_;
						_tmp93_ = list;
						_tmp94_ = event_class;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp94_);
						_g_object_unref0 (list);
						_g_free0 (ext_desc);
						_g_free0 (desc);
						_g_free0 (name);
						_dvb_event_unref0 (event_class);
					}
				}
			}
		}
		__finally66:
		{
			GeeHashMap* _tmp95_;
			_tmp95_ = self->priv->channel_events;
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name) {
	guint result = 0U;
	guint val = 0U;
	const GstStructure* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (structure != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	_tmp0_ = structure;
	_tmp1_ = name;
	gst_structure_get_uint (_tmp0_, _tmp1_, &_tmp2_);
	val = _tmp2_;
	result = val;
	return result;
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	GQueue* _tmp0_;
	GMainContext* _tmp1_;
	GeeHashMap* _tmp2_;
	parent_class = G_OBJECT_CLASS (dvb_epg_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_EPG_SCANNER (obj);
	_tmp0_ = g_queue_new ();
	_g_queue_free0 (self->priv->channels);
	self->priv->channels = _tmp0_;
	self->priv->stop_counter = 0;
	_tmp1_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->channel_events);
	self->priv->channel_events = _tmp2_;
	return obj;
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_epg_scanner_log = _tmp1_;
	dvb_epg_scanner_CHECK_EIT_INTERVAL = -1;
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_channel_events);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	_g_queue_free0 (self->priv->channels);
	_g_source_unref0 (self->priv->scan_source);
	_g_source_unref0 (self->priv->queue_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	g_static_rec_mutex_free (&self->priv->__lock_channel_events);
	_g_object_unref0 (self->priv->channel_events);
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static volatile gsize dvb_epg_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_epg_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		GType dvb_epg_scanner_type_id;
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
		g_once_init_leave (&dvb_epg_scanner_type_id__volatile, dvb_epg_scanner_type_id);
	}
	return dvb_epg_scanner_type_id__volatile;
}



