/* Schedule.c generated by valac 0.16.0, the Vala compiler
 * generated from Schedule.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_ID_BUS_SCHEDULE_PROXY (dvb_id_bus_schedule_proxy_get_type ())

#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
typedef struct _DVBSchedulePrivate DVBSchedulePrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_TYPE_EVENT_STORAGE (dvb_event_storage_get_type ())
#define DVB_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorage))
#define DVB_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))
#define DVB_IS_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_STORAGE))
#define DVB_IS_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_STORAGE))
#define DVB_EVENT_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))

typedef struct _DVBEventStorage DVBEventStorage;
typedef struct _DVBEventStorageClass DVBEventStorageClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
typedef struct _DvbScheduleRestoreData DvbScheduleRestoreData;

#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	gchar* name;
	guint duration;
	gchar* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};

struct _DVBSchedule {
	GObject parent_instance;
	DVBSchedulePrivate * priv;
};

struct _DVBScheduleClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBSchedulePrivate {
	DVBChannel* _channel;
	DVBdatabaseEPGStore* epgstore;
	DVBEventStorage* events;
	GStaticRecMutex __lock_events;
};

struct _DvbScheduleRestoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DVBSchedule* self;
	GeeList* levents;
	DVBdatabaseEPGStore* _tmp0_;
	DVBChannel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	DVBChannel* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* e1;
	DVBLoggingLogger* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gint newest_expired;
	DVBEvent* event;
	gint i;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeList* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	DVBEvent* _tmp22_;
	gboolean _tmp23_;
	gint _tmp24_;
	DVBEventStorage* _tmp25_;
	DVBEvent* _tmp26_;
	gint _tmp27_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gpointer _tmp30_;
	DVBdatabaseEPGStore* _tmp31_;
	DVBEvent* _tmp32_;
	DVBChannel* _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	DVBChannel* _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	GError* e2;
	DVBLoggingLogger* _tmp39_;
	GError* _tmp40_;
	const gchar* _tmp41_;
	DVBLoggingLogger* _tmp42_;
	DVBEventStorage* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	DVBChannel* _tmp46_;
	guint _tmp47_;
	guint _tmp48_;
	GError * _inner_error_;
};

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_schedule_parent_class = NULL;
static DVBLoggingLogger* dvb_schedule_log;
static DVBLoggingLogger* dvb_schedule_log = NULL;
static GRecMutex dvb_schedule_mutex;
static GRecMutex dvb_schedule_mutex = {0};
static DVBIDBusScheduleIface* dvb_schedule_dvb_id_bus_schedule_parent_iface = NULL;

GType dvb_id_bus_schedule_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_schedule_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_event_info_get_type (void) G_GNUC_CONST;
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void) G_GNUC_CONST;
GType dvb_schedule_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_event_storage_get_type (void) G_GNUC_CONST;
#define DVB_SCHEDULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCHEDULE, DVBSchedulePrivate))
enum  {
	DVB_SCHEDULE_DUMMY_PROPERTY,
	DVB_SCHEDULE_CHANNEL
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SCHEDULE_MATCH_THRESHOLD 100
#define DVB_SCHEDULE_MIN_EVENT_OVERLAP 0.5
static void dvb_schedule_restore_data_free (gpointer _data);
void dvb_schedule_restore (DVBSchedule* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_schedule_restore_finish (DVBSchedule* self, GAsyncResult* _res_);
static gboolean dvb_schedule_restore_co (DvbScheduleRestoreData* _data_);
GeeList* dvb_database_epg_store_get_events (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
DVBChannel* dvb_schedule_get_channel (DVBSchedule* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_channel_get_GroupId (DVBChannel* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_event_has_expired (DVBEvent* self);
void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event);
gboolean dvb_database_epg_store_remove_events_older_than (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gint dvb_event_storage_get_size (DVBEventStorage* self);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
GType dvb_event_element_get_type (void) G_GNUC_CONST;
DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
const gchar* dvb_channel_get_Name (DVBChannel* self);
void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event);
static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event);
static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event);
void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events);
gboolean dvb_database_epg_store_remove_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gboolean dvb_database_epg_store_add_or_update_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id);
GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event);
gdouble dvb_event_get_overlap_percentage (DVBEvent* self, DVBEvent* other);
time_t dvb_event_get_start_timestamp (DVBEvent* self);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);
gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
gboolean dvb_event_is_running (DVBEvent* self);
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error);
static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error);
static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error);
DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id);
DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element);
static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error);
static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error);
static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error);
static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id);
static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error);
static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1);
static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error);
static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error);
static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value);
static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DVBEventStorage* dvb_event_storage_new (void);
DVBEventStorage* dvb_event_storage_construct (GType object_type);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (DVBFactory* self);
static void dvb_schedule_finalize (GObject* obj);
static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void dvb_schedule_restore_data_free (gpointer _data) {
	DvbScheduleRestoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DvbScheduleRestoreData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_schedule_restore (DVBSchedule* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DvbScheduleRestoreData* _data_;
	DVBSchedule* _tmp0_;
	_data_ = g_slice_new0 (DvbScheduleRestoreData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dvb_schedule_restore);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dvb_schedule_restore_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	dvb_schedule_restore_co (_data_);
}


void dvb_schedule_restore_finish (DVBSchedule* self, GAsyncResult* _res_) {
	DvbScheduleRestoreData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean dvb_schedule_restore_co (DvbScheduleRestoreData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->epgstore;
		_data_->_tmp1_ = _data_->self->priv->_channel;
		_data_->_tmp2_ = dvb_channel_get_Sid (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->_channel;
		_data_->_tmp5_ = dvb_channel_get_GroupId (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = dvb_database_epg_store_get_events (_data_->_tmp0_, _data_->_tmp3_, _data_->_tmp6_, &_data_->_inner_error_);
		_data_->_tmp8_ = _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch164_dvb_database_sql_error;
			}
			_g_object_unref0 (_data_->levents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->levents);
		_data_->levents = _data_->_tmp8_;
	}
	goto __finally164;
	__catch164_dvb_database_sql_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = dvb_schedule_log;
		_data_->_tmp10_ = _data_->e1;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		dvb_logging_logger_error (_data_->_tmp9_, "Schedule.vala:56: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e1);
		_g_object_unref0 (_data_->levents);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally164:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->levents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->newest_expired = -1;
	{
		_data_->i = 0;
		{
			_data_->_tmp12_ = TRUE;
			while (TRUE) {
				_data_->_tmp13_ = _data_->_tmp12_;
				if (!_data_->_tmp13_) {
					_data_->_tmp14_ = _data_->i;
					_data_->i = _data_->_tmp14_ + 1;
				}
				_data_->_tmp12_ = FALSE;
				_data_->_tmp15_ = _data_->i;
				_data_->_tmp16_ = _data_->levents;
				_data_->_tmp17_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				if (!(_data_->_tmp15_ < _data_->_tmp18_)) {
					break;
				}
				_data_->_tmp19_ = _data_->levents;
				_data_->_tmp20_ = _data_->i;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = gee_list_get (_data_->_tmp19_, _data_->_tmp20_);
				_dvb_event_unref0 (_data_->event);
				_data_->event = (DVBEvent*) _data_->_tmp21_;
				_data_->_tmp22_ = _data_->event;
				_data_->_tmp23_ = FALSE;
				_data_->_tmp23_ = dvb_event_has_expired (_data_->_tmp22_);
				if (_data_->_tmp23_) {
					_data_->_tmp24_ = _data_->i;
					_data_->newest_expired = _data_->_tmp24_;
				} else {
					_data_->_tmp25_ = _data_->self->priv->events;
					_data_->_tmp26_ = _data_->event;
					dvb_event_storage_insert (_data_->_tmp25_, _data_->_tmp26_);
				}
			}
		}
	}
	_data_->_tmp27_ = _data_->newest_expired;
	if (_data_->_tmp27_ != (-1)) {
		_data_->_tmp28_ = _data_->levents;
		_data_->_tmp29_ = _data_->newest_expired;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = gee_list_get (_data_->_tmp28_, _data_->_tmp29_);
		_dvb_event_unref0 (_data_->event);
		_data_->event = (DVBEvent*) _data_->_tmp30_;
		{
			_data_->_tmp31_ = _data_->self->priv->epgstore;
			_data_->_tmp32_ = _data_->event;
			_data_->_tmp33_ = _data_->self->priv->_channel;
			_data_->_tmp34_ = dvb_channel_get_Sid (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = _data_->self->priv->_channel;
			_data_->_tmp37_ = dvb_channel_get_GroupId (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			dvb_database_epg_store_remove_events_older_than (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp35_, _data_->_tmp38_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch165_dvb_database_sql_error;
				}
				_dvb_event_unref0 (_data_->event);
				_g_object_unref0 (_data_->levents);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally165;
		__catch165_dvb_database_sql_error:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp39_ = dvb_schedule_log;
			_data_->_tmp40_ = _data_->e2;
			_data_->_tmp41_ = _data_->_tmp40_->message;
			dvb_logging_logger_error (_data_->_tmp39_, "Schedule.vala:78: %s", _data_->_tmp41_);
			_g_error_free0 (_data_->e2);
			_dvb_event_unref0 (_data_->event);
			_g_object_unref0 (_data_->levents);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally165:
		if (_data_->_inner_error_ != NULL) {
			_dvb_event_unref0 (_data_->event);
			_g_object_unref0 (_data_->levents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp42_ = dvb_schedule_log;
	_data_->_tmp43_ = _data_->self->priv->events;
	_data_->_tmp44_ = dvb_event_storage_get_size (_data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = _data_->self->priv->_channel;
	_data_->_tmp47_ = dvb_channel_get_Sid (_data_->_tmp46_);
	_data_->_tmp48_ = _data_->_tmp47_;
	dvb_logging_logger_debug (_data_->_tmp42_, "Schedule.vala:83: Finished restoring %d EPG events for channel %u", _data_->_tmp45_, _data_->_tmp48_);
	_dvb_event_unref0 (_data_->event);
	_g_object_unref0 (_data_->levents);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel) {
	DVBSchedule * self = NULL;
	DVBChannel* _tmp0_;
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = channel;
	self = (DVBSchedule*) g_object_new (object_type, "channel", _tmp0_, NULL);
	return self;
}


DVBSchedule* dvb_schedule_new (DVBChannel* channel) {
	return dvb_schedule_construct (DVB_TYPE_SCHEDULE, channel);
}


void dvb_schedule_remove_expired_events (DVBSchedule* self) {
	gint last_expired;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	last_expired = -1;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBLoggingLogger* _tmp20_;
			DVBChannel* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			DVBChannel* _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			gint _tmp51_;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						gboolean _tmp2_;
						gint _tmp4_;
						DVBEventStorage* _tmp5_;
						gint _tmp6_;
						gint _tmp7_;
						DVBEventStorage* _tmp8_;
						gint _tmp9_;
						DVBEventElement* _tmp10_ = NULL;
						DVBEventElement* element;
						DVBEventElement* _tmp11_;
						guint _tmp12_;
						DVBEvent* _tmp13_ = NULL;
						DVBEvent* e;
						gboolean _tmp14_ = FALSE;
						DVBEvent* _tmp15_;
						gboolean _tmp18_;
						_tmp2_ = _tmp1_;
						if (!_tmp2_) {
							gint _tmp3_;
							_tmp3_ = i;
							i = _tmp3_ + 1;
						}
						_tmp1_ = FALSE;
						_tmp4_ = i;
						_tmp5_ = self->priv->events;
						_tmp6_ = dvb_event_storage_get_size (_tmp5_);
						_tmp7_ = _tmp6_;
						if (!(_tmp4_ < _tmp7_)) {
							break;
						}
						_tmp8_ = self->priv->events;
						_tmp9_ = i;
						_tmp10_ = dvb_event_storage_get (_tmp8_, _tmp9_);
						element = _tmp10_;
						_tmp11_ = element;
						_tmp12_ = _tmp11_->id;
						_tmp13_ = dvb_schedule_get_event (self, _tmp12_);
						e = _tmp13_;
						_tmp15_ = e;
						if (_tmp15_ != NULL) {
							DVBEvent* _tmp16_;
							gboolean _tmp17_ = FALSE;
							_tmp16_ = e;
							_tmp17_ = dvb_event_has_expired (_tmp16_);
							_tmp14_ = _tmp17_;
						} else {
							_tmp14_ = FALSE;
						}
						_tmp18_ = _tmp14_;
						if (_tmp18_) {
							gint _tmp19_;
							_tmp19_ = i;
							last_expired = _tmp19_;
						} else {
							_dvb_event_unref0 (e);
							_g_object_unref0 (element);
							break;
						}
						_dvb_event_unref0 (e);
						_g_object_unref0 (element);
					}
				}
			}
			_tmp20_ = dvb_schedule_log;
			_tmp21_ = self->priv->_channel;
			_tmp22_ = dvb_channel_get_Name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->_channel;
			_tmp25_ = dvb_channel_get_Sid (_tmp24_);
			_tmp26_ = _tmp25_;
			dvb_logging_logger_debug (_tmp20_, "Schedule.vala:106: Removing expired events of channel %s (%u)", _tmp23_, _tmp26_);
			{
				gint i;
				i = 0;
				{
					gboolean _tmp27_;
					_tmp27_ = TRUE;
					while (TRUE) {
						gboolean _tmp28_;
						gint _tmp30_;
						gint _tmp31_;
						DVBEventStorage* _tmp32_;
						gint _tmp33_;
						DVBEventElement* _tmp34_ = NULL;
						DVBEventElement* element;
						DVBEventElement* _tmp35_;
						guint _tmp36_;
						DVBEvent* _tmp37_ = NULL;
						DVBEvent* event;
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							gint _tmp29_;
							_tmp29_ = i;
							i = _tmp29_ + 1;
						}
						_tmp27_ = FALSE;
						_tmp30_ = i;
						_tmp31_ = last_expired;
						if (!(_tmp30_ <= _tmp31_)) {
							break;
						}
						_tmp32_ = self->priv->events;
						_tmp33_ = i;
						_tmp34_ = dvb_event_storage_get (_tmp32_, _tmp33_);
						element = _tmp34_;
						_tmp35_ = element;
						_tmp36_ = _tmp35_->id;
						_tmp37_ = dvb_schedule_get_event (self, _tmp36_);
						event = _tmp37_;
						{
							DVBdatabaseEPGStore* _tmp38_;
							DVBEvent* _tmp39_;
							DVBChannel* _tmp40_;
							guint _tmp41_;
							guint _tmp42_;
							DVBChannel* _tmp43_;
							guint _tmp44_;
							guint _tmp45_;
							_tmp38_ = self->priv->epgstore;
							_tmp39_ = event;
							_tmp40_ = self->priv->_channel;
							_tmp41_ = dvb_channel_get_Sid (_tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = self->priv->_channel;
							_tmp44_ = dvb_channel_get_GroupId (_tmp43_);
							_tmp45_ = _tmp44_;
							dvb_database_epg_store_remove_events_older_than (_tmp38_, _tmp39_, _tmp42_, _tmp45_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
									goto __catch167_dvb_database_sql_error;
								}
								_dvb_event_unref0 (event);
								_g_object_unref0 (element);
								{
									DVBEventStorage* _tmp46_;
									_tmp46_ = self->priv->events;
									g_static_rec_mutex_unlock (&self->priv->__lock_events);
								}
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						goto __finally167;
						__catch167_dvb_database_sql_error:
						{
							GError* e = NULL;
							DVBLoggingLogger* _tmp47_;
							GError* _tmp48_;
							const gchar* _tmp49_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp47_ = dvb_schedule_log;
							_tmp48_ = e;
							_tmp49_ = _tmp48_->message;
							dvb_logging_logger_error (_tmp47_, "Schedule.vala:116: %s", _tmp49_);
							_g_error_free0 (e);
						}
						__finally167:
						if (_inner_error_ != NULL) {
							_dvb_event_unref0 (event);
							_g_object_unref0 (element);
							_dvb_event_unref0 (event);
							_g_object_unref0 (element);
							{
								DVBEventStorage* _tmp50_;
								_tmp50_ = self->priv->events;
								g_static_rec_mutex_unlock (&self->priv->__lock_events);
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
					}
				}
			}
			_tmp51_ = last_expired;
			if (_tmp51_ > (-1)) {
				DVBEventStorage* _tmp52_;
				gint _tmp53_;
				_tmp52_ = self->priv->events;
				_tmp53_ = last_expired;
				dvb_event_storage_remove_range (_tmp52_, 0, _tmp53_);
			}
		}
		__finally166:
		{
			DVBEventStorage* _tmp54_;
			_tmp54_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		DVBdatabaseEPGStore* _tmp0_;
		guint _tmp1_;
		DVBChannel* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		DVBChannel* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		DVBEvent* _tmp8_ = NULL;
		DVBEvent* _tmp9_;
		_tmp0_ = self->priv->epgstore;
		_tmp1_ = event_id;
		_tmp2_ = self->priv->_channel;
		_tmp3_ = dvb_channel_get_Sid (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->_channel;
		_tmp6_ = dvb_channel_get_GroupId (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = dvb_database_epg_store_get_event (_tmp0_, _tmp1_, _tmp4_, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch168_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp9_;
		return result;
	}
	goto __finally168;
	__catch168_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_schedule_log;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp10_, "Schedule.vala:131: %s", _tmp12_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally168:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * When an event with the same id already exists, it's replaced
         */
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event) {
	DVBEvent* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = dvb_event_has_expired (_tmp0_);
	if (_tmp1_) {
		return;
	}
	{
		DVBEventStorage* _tmp2_;
		_tmp2_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				DVBEvent* _tmp3_;
				_tmp3_ = event;
				dvb_schedule_store_event (self, _tmp3_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch170_dvb_database_sql_error;
					}
					{
						DVBEventStorage* _tmp4_;
						_tmp4_ = self->priv->events;
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally170;
			__catch170_dvb_database_sql_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp5_;
				GError* _tmp6_;
				const gchar* _tmp7_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp5_ = dvb_schedule_log;
				_tmp6_ = e;
				_tmp7_ = _tmp6_->message;
				dvb_logging_logger_error (_tmp5_, "Schedule.vala:146: %s", _tmp7_);
				_g_error_free0 (e);
			}
			__finally170:
			if (_inner_error_ != NULL) {
				{
					DVBEventStorage* _tmp8_;
					_tmp8_ = self->priv->events;
					g_static_rec_mutex_unlock (&self->priv->__lock_events);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		__finally169:
		{
			DVBEventStorage* _tmp9_;
			_tmp9_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_events != NULL);
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				DVBdatabaseEPGStore* _tmp1_;
				DVBdatabaseEPGStore* _tmp13_;
				g_rec_mutex_lock (&dvb_schedule_mutex);
				_tmp1_ = self->priv->epgstore;
				dvb_database_sqlite_sqlite_database_begin_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (_tmp1_), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch172_dvb_database_sql_error;
					}
					{
						g_rec_mutex_unlock (&dvb_schedule_mutex);
					}
					{
						DVBEventStorage* _tmp2_;
						_tmp2_ = self->priv->events;
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					GeeCollection* _tmp3_;
					GeeIterator* _tmp4_ = NULL;
					GeeIterator* _event_it;
					_tmp3_ = new_events;
					_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
					_event_it = _tmp4_;
					while (TRUE) {
						GeeIterator* _tmp5_;
						gboolean _tmp6_ = FALSE;
						GeeIterator* _tmp7_;
						gpointer _tmp8_ = NULL;
						DVBEvent* event;
						DVBEvent* _tmp9_;
						gboolean _tmp10_ = FALSE;
						_tmp5_ = _event_it;
						_tmp6_ = gee_iterator_next (_tmp5_);
						if (!_tmp6_) {
							break;
						}
						_tmp7_ = _event_it;
						_tmp8_ = gee_iterator_get (_tmp7_);
						event = (DVBEvent*) _tmp8_;
						_tmp9_ = event;
						_tmp10_ = dvb_event_has_expired (_tmp9_);
						if (!_tmp10_) {
							DVBEvent* _tmp11_;
							_tmp11_ = event;
							dvb_schedule_store_event (self, _tmp11_, &_inner_error_);
							if (_inner_error_ != NULL) {
								_dvb_event_unref0 (event);
								_g_object_unref0 (_event_it);
								if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
									goto __catch172_dvb_database_sql_error;
								}
								_dvb_event_unref0 (event);
								_g_object_unref0 (_event_it);
								{
									g_rec_mutex_unlock (&dvb_schedule_mutex);
								}
								{
									DVBEventStorage* _tmp12_;
									_tmp12_ = self->priv->events;
									g_static_rec_mutex_unlock (&self->priv->__lock_events);
								}
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_dvb_event_unref0 (event);
					}
					_g_object_unref0 (_event_it);
				}
				_tmp13_ = self->priv->epgstore;
				dvb_database_sqlite_sqlite_database_end_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (_tmp13_), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch172_dvb_database_sql_error;
					}
					{
						g_rec_mutex_unlock (&dvb_schedule_mutex);
					}
					{
						DVBEventStorage* _tmp14_;
						_tmp14_ = self->priv->events;
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally172;
			__catch172_dvb_database_sql_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp15_;
				GError* _tmp16_;
				const gchar* _tmp17_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp15_ = dvb_schedule_log;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				dvb_logging_logger_error (_tmp15_, "Schedule.vala:164: %s", _tmp17_);
				_g_error_free0 (e);
			}
			__finally172:
			{
				g_rec_mutex_unlock (&dvb_schedule_mutex);
			}
			if (_inner_error_ != NULL) {
				{
					DVBEventStorage* _tmp18_;
					_tmp18_ = self->priv->events;
					g_static_rec_mutex_unlock (&self->priv->__lock_events);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		__finally171:
		{
			DVBEventStorage* _tmp19_;
			_tmp19_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error) {
	DVBEvent* _tmp0_;
	GeeList* _tmp1_ = NULL;
	GeeList* overlap;
	GeeList* _tmp2_;
	DVBEvent* _tmp3_;
	gint _tmp4_ = 0;
	gint s;
	gint _tmp5_;
	DVBdatabaseEPGStore* _tmp28_;
	DVBEvent* _tmp29_;
	DVBChannel* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	DVBChannel* _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	DVBEventStorage* _tmp36_;
	DVBEvent* _tmp37_;
	guint _tmp38_;
	gboolean _tmp39_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = dvb_schedule_get_overlapping_events (self, _tmp0_);
	overlap = _tmp1_;
	_tmp2_ = overlap;
	_tmp3_ = event;
	_tmp4_ = dvb_schedule_match_events (self, _tmp2_, _tmp3_);
	s = _tmp4_;
	_tmp5_ = s;
	if (_tmp5_ > DVB_SCHEDULE_MATCH_THRESHOLD) {
		DVBEventStorage* _tmp6_;
		GeeList* _tmp7_;
		_tmp6_ = self->priv->events;
		_tmp7_ = overlap;
		dvb_event_storage_remove_all (_tmp6_, _tmp7_);
		{
			GeeList* _tmp8_;
			GeeList* _tmp9_;
			GeeList* _overlapping_event_list;
			GeeList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _overlapping_event_size;
			gint _overlapping_event_index;
			_tmp8_ = overlap;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_overlapping_event_list = _tmp9_;
			_tmp10_ = _overlapping_event_list;
			_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_overlapping_event_size = _tmp12_;
			_overlapping_event_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				GeeList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_ = NULL;
				DVBEvent* overlapping_event;
				DVBdatabaseEPGStore* _tmp19_;
				DVBEvent* _tmp20_;
				guint _tmp21_;
				DVBChannel* _tmp22_;
				guint _tmp23_;
				guint _tmp24_;
				DVBChannel* _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				_tmp13_ = _overlapping_event_index;
				_overlapping_event_index = _tmp13_ + 1;
				_tmp14_ = _overlapping_event_index;
				_tmp15_ = _overlapping_event_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _overlapping_event_list;
				_tmp17_ = _overlapping_event_index;
				_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
				overlapping_event = (DVBEvent*) _tmp18_;
				_tmp19_ = self->priv->epgstore;
				_tmp20_ = overlapping_event;
				_tmp21_ = _tmp20_->id;
				_tmp22_ = self->priv->_channel;
				_tmp23_ = dvb_channel_get_Sid (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = self->priv->_channel;
				_tmp26_ = dvb_channel_get_GroupId (_tmp25_);
				_tmp27_ = _tmp26_;
				dvb_database_epg_store_remove_event (_tmp19_, _tmp21_, _tmp24_, _tmp27_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_dvb_event_unref0 (overlapping_event);
						_g_object_unref0 (_overlapping_event_list);
						_g_object_unref0 (overlap);
						return;
					} else {
						_dvb_event_unref0 (overlapping_event);
						_g_object_unref0 (_overlapping_event_list);
						_g_object_unref0 (overlap);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_dvb_event_unref0 (overlapping_event);
			}
			_g_object_unref0 (_overlapping_event_list);
		}
	}
	_tmp28_ = self->priv->epgstore;
	_tmp29_ = event;
	_tmp30_ = self->priv->_channel;
	_tmp31_ = dvb_channel_get_Sid (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->_channel;
	_tmp34_ = dvb_channel_get_GroupId (_tmp33_);
	_tmp35_ = _tmp34_;
	dvb_database_epg_store_add_or_update_event (_tmp28_, _tmp29_, _tmp32_, _tmp35_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (overlap);
			return;
		} else {
			_g_object_unref0 (overlap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp36_ = self->priv->events;
	_tmp37_ = event;
	_tmp38_ = _tmp37_->id;
	_tmp39_ = dvb_event_storage_contains_event_with_id (_tmp36_, _tmp38_);
	if (!_tmp39_) {
		DVBEventStorage* _tmp40_;
		DVBEvent* _tmp41_;
		_tmp40_ = self->priv->events;
		_tmp41_ = event;
		dvb_event_storage_insert (_tmp40_, _tmp41_);
	}
	_g_object_unref0 (overlap);
}


static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event) {
	GeeList* result = NULL;
	DVBEventStorage* _tmp0_;
	DVBEvent* _tmp1_;
	GeeList* _tmp2_ = NULL;
	GeeList* elements;
	GeeArrayList* _tmp3_;
	GeeList* overlap;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = self->priv->events;
	_tmp1_ = event;
	_tmp2_ = dvb_event_storage_get_overlapping_events (_tmp0_, _tmp1_);
	elements = _tmp2_;
	_tmp3_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	overlap = (GeeList*) _tmp3_;
	{
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _data_list;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _data_size;
		gint _data_index;
		_tmp4_ = elements;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_data_list = _tmp5_;
		_tmp6_ = _data_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_data_size = _tmp8_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			DVBEventElement* data;
			DVBEventElement* _tmp15_;
			guint _tmp16_;
			DVBEvent* _tmp17_ = NULL;
			DVBEvent* e;
			gboolean _tmp18_ = FALSE;
			DVBEvent* _tmp19_;
			gboolean _tmp23_;
			_tmp9_ = _data_index;
			_data_index = _tmp9_ + 1;
			_tmp10_ = _data_index;
			_tmp11_ = _data_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _data_list;
			_tmp13_ = _data_index;
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
			data = (DVBEventElement*) _tmp14_;
			_tmp15_ = data;
			_tmp16_ = _tmp15_->id;
			_tmp17_ = dvb_schedule_get_event (self, _tmp16_);
			e = _tmp17_;
			_tmp19_ = e;
			if (_tmp19_ != NULL) {
				DVBEvent* _tmp20_;
				DVBEvent* _tmp21_;
				gdouble _tmp22_ = 0.0;
				_tmp20_ = e;
				_tmp21_ = event;
				_tmp22_ = dvb_event_get_overlap_percentage (_tmp20_, _tmp21_);
				_tmp18_ = _tmp22_ >= DVB_SCHEDULE_MIN_EVENT_OVERLAP;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp23_ = _tmp18_;
			if (_tmp23_) {
				GeeList* _tmp24_;
				DVBEvent* _tmp25_;
				_tmp24_ = overlap;
				_tmp25_ = e;
				gee_collection_add ((GeeCollection*) _tmp24_, _tmp25_);
			}
			_dvb_event_unref0 (e);
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = overlap;
	_g_object_unref0 (elements);
	return result;
}


static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event) {
	gint result = 0;
	DVBEvent* _tmp0_;
	time_t _tmp1_ = 0;
	time_t ref_start;
	DVBEvent* _tmp2_;
	time_t _tmp3_ = 0;
	time_t ref_end;
	gdouble max_score;
	gdouble _tmp51_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (events != NULL, 0);
	g_return_val_if_fail (ref_event != NULL, 0);
	_tmp0_ = ref_event;
	_tmp1_ = dvb_event_get_start_timestamp (_tmp0_);
	ref_start = _tmp1_;
	_tmp2_ = ref_event;
	_tmp3_ = dvb_event_get_end_timestamp (_tmp2_);
	ref_end = _tmp3_;
	max_score = (gdouble) 0;
	{
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _event_list;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _event_size;
		gint _event_index;
		_tmp4_ = events;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_event_list = _tmp5_;
		_tmp6_ = _event_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_event_size = _tmp8_;
		_event_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			DVBEvent* event;
			gdouble score;
			DVBEvent* _tmp15_;
			time_t _tmp16_ = 0;
			time_t e_start;
			DVBEvent* _tmp17_;
			time_t _tmp18_ = 0;
			time_t e_end;
			gdouble _tmp19_;
			time_t _tmp20_;
			time_t _tmp21_;
			gdouble _tmp22_ = 0.0;
			gdouble _tmp23_;
			time_t _tmp24_;
			time_t _tmp25_;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_;
			DVBEvent* _tmp28_;
			guint _tmp29_;
			DVBEvent* _tmp30_;
			guint _tmp31_;
			gdouble _tmp32_ = 0.0;
			gboolean _tmp33_ = FALSE;
			DVBEvent* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp38_;
			gdouble _tmp48_;
			gdouble _tmp49_;
			_tmp9_ = _event_index;
			_event_index = _tmp9_ + 1;
			_tmp10_ = _event_index;
			_tmp11_ = _event_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _event_list;
			_tmp13_ = _event_index;
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
			event = (DVBEvent*) _tmp14_;
			score = (gdouble) 0;
			_tmp15_ = event;
			_tmp16_ = dvb_event_get_start_timestamp (_tmp15_);
			e_start = _tmp16_;
			_tmp17_ = event;
			_tmp18_ = dvb_event_get_end_timestamp (_tmp17_);
			e_end = _tmp18_;
			_tmp19_ = score;
			_tmp20_ = ref_start;
			_tmp21_ = e_start;
			_tmp22_ = fabs ((gdouble) (_tmp20_ - _tmp21_));
			score = _tmp19_ + _tmp22_;
			_tmp23_ = score;
			_tmp24_ = ref_end;
			_tmp25_ = e_end;
			_tmp26_ = fabs ((gdouble) (_tmp24_ - _tmp25_));
			score = _tmp23_ + _tmp26_;
			_tmp27_ = score;
			_tmp28_ = ref_event;
			_tmp29_ = _tmp28_->duration;
			_tmp30_ = event;
			_tmp31_ = _tmp30_->duration;
			_tmp32_ = fabs ((gdouble) (_tmp29_ - _tmp31_));
			score = _tmp27_ + (_tmp32_ / 60.0);
			_tmp34_ = ref_event;
			_tmp35_ = _tmp34_->name;
			if (_tmp35_ != NULL) {
				DVBEvent* _tmp36_;
				const gchar* _tmp37_;
				_tmp36_ = event;
				_tmp37_ = _tmp36_->name;
				_tmp33_ = _tmp37_ != NULL;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp38_ = _tmp33_;
			if (_tmp38_) {
				glong unmatched = 0L;
				DVBEvent* _tmp39_;
				const gchar* _tmp40_;
				DVBEvent* _tmp41_;
				const gchar* _tmp42_;
				glong _tmp43_ = 0L;
				glong _tmp44_ = 0L;
				glong diff;
				gdouble _tmp45_;
				glong _tmp46_;
				glong _tmp47_;
				_tmp39_ = ref_event;
				_tmp40_ = _tmp39_->name;
				_tmp41_ = event;
				_tmp42_ = _tmp41_->name;
				_tmp44_ = dvb_utils_strdiff (_tmp40_, _tmp42_, &_tmp43_);
				unmatched = _tmp43_;
				diff = _tmp44_;
				_tmp45_ = score;
				_tmp46_ = diff;
				_tmp47_ = unmatched;
				score = _tmp45_ + (10 * (_tmp46_ + (5 * _tmp47_)));
			}
			_tmp48_ = score;
			_tmp49_ = max_score;
			if (_tmp48_ > _tmp49_) {
				gdouble _tmp50_;
				_tmp50_ = score;
				max_score = _tmp50_;
			}
			_dvb_event_unref0 (event);
		}
		_g_object_unref0 (_event_list);
	}
	_tmp51_ = max_score;
	result = (gint) _tmp51_;
	return result;
}


gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, _tmp2_);
			val = _tmp3_;
		}
		__finally173:
		{
			DVBEventStorage* _tmp4_;
			_tmp4_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static gpointer _dvb_event_ref0 (gpointer self) {
	return self ? dvb_event_ref (self) : NULL;
}


DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self) {
	DVBEvent* result = NULL;
	DVBEvent* running_event;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	running_event = NULL;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				DVBEventStorage* _tmp1_;
				DVBEventStorage* _tmp2_;
				DVBEventStorage* _element_list;
				DVBEventStorage* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint _element_size;
				gint _element_index;
				_tmp1_ = self->priv->events;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				_element_list = _tmp2_;
				_tmp3_ = _element_list;
				_tmp4_ = dvb_event_storage_get_size (_tmp3_);
				_tmp5_ = _tmp4_;
				_element_size = _tmp5_;
				_element_index = -1;
				while (TRUE) {
					gint _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					DVBEventStorage* _tmp9_;
					gint _tmp10_;
					DVBEventElement* _tmp11_ = NULL;
					DVBEventElement* element;
					DVBEventElement* _tmp12_;
					guint _tmp13_;
					DVBEvent* _tmp14_ = NULL;
					DVBEvent* event;
					gboolean _tmp15_ = FALSE;
					DVBEvent* _tmp16_;
					gboolean _tmp19_;
					_tmp6_ = _element_index;
					_element_index = _tmp6_ + 1;
					_tmp7_ = _element_index;
					_tmp8_ = _element_size;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = _element_list;
					_tmp10_ = _element_index;
					_tmp11_ = dvb_event_storage_get (_tmp9_, _tmp10_);
					element = _tmp11_;
					_tmp12_ = element;
					_tmp13_ = _tmp12_->id;
					_tmp14_ = dvb_schedule_get_event (self, _tmp13_);
					event = _tmp14_;
					_tmp16_ = event;
					if (_tmp16_ != NULL) {
						DVBEvent* _tmp17_;
						gboolean _tmp18_ = FALSE;
						_tmp17_ = event;
						_tmp18_ = dvb_event_is_running (_tmp17_);
						_tmp15_ = _tmp18_;
					} else {
						_tmp15_ = FALSE;
					}
					_tmp19_ = _tmp15_;
					if (_tmp19_) {
						DVBEvent* _tmp20_;
						DVBEvent* _tmp21_;
						_tmp20_ = event;
						_tmp21_ = _dvb_event_ref0 (_tmp20_);
						_dvb_event_unref0 (running_event);
						running_event = _tmp21_;
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						break;
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
				_g_object_unref0 (_element_list);
			}
		}
		__finally174:
		{
			DVBEventStorage* _tmp22_;
			_tmp22_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (running_event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = running_event;
	return result;
}


/**
         * @start: local time of event
         * @duration: how long the event is
         * @returns: the event that starts after @start
         * and spans the given time period
         */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration) {
	DVBEvent* result = NULL;
	DVBEvent* _result_;
	time_t _tmp0_ = 0;
	time_t timer_start;
	time_t _tmp1_;
	guint _tmp2_;
	time_t timer_end;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = mktime (start);
	timer_start = _tmp0_;
	_tmp1_ = timer_start;
	_tmp2_ = duration;
	timer_end = _tmp1_ + (_tmp2_ * 60);
	{
		DVBEventStorage* _tmp3_;
		_tmp3_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			time_t last_diff;
			last_diff = (time_t) 0;
			{
				DVBEventStorage* _tmp4_;
				DVBEventStorage* _tmp5_;
				DVBEventStorage* _element_list;
				DVBEventStorage* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _element_size;
				gint _element_index;
				_tmp4_ = self->priv->events;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_element_list = _tmp5_;
				_tmp6_ = _element_list;
				_tmp7_ = dvb_event_storage_get_size (_tmp6_);
				_tmp8_ = _tmp7_;
				_element_size = _tmp8_;
				_element_index = -1;
				while (TRUE) {
					gint _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					DVBEventStorage* _tmp12_;
					gint _tmp13_;
					DVBEventElement* _tmp14_ = NULL;
					DVBEventElement* element;
					DVBEventElement* _tmp15_;
					time_t _tmp16_;
					struct tm _tmp17_ = {0};
					time_t _tmp18_ = 0;
					time_t event_start;
					DVBEventElement* _tmp19_;
					guint _tmp20_;
					DVBEvent* _tmp21_ = NULL;
					DVBEvent* event;
					DVBEvent* _tmp22_;
					time_t _tmp23_;
					DVBEvent* _tmp24_;
					guint _tmp25_;
					time_t event_end;
					time_t _tmp26_ = 0;
					time_t _tmp27_;
					time_t _tmp28_;
					time_t _tmp31_;
					time_t min_end;
					time_t _tmp32_ = 0;
					time_t _tmp33_;
					time_t _tmp34_;
					time_t _tmp37_;
					time_t max_start;
					time_t _tmp38_;
					time_t _tmp39_;
					time_t overlap;
					time_t _tmp40_;
					time_t _tmp41_;
					time_t _tmp45_;
					time_t _tmp46_;
					_tmp9_ = _element_index;
					_element_index = _tmp9_ + 1;
					_tmp10_ = _element_index;
					_tmp11_ = _element_size;
					if (!(_tmp10_ < _tmp11_)) {
						break;
					}
					_tmp12_ = _element_list;
					_tmp13_ = _element_index;
					_tmp14_ = dvb_event_storage_get (_tmp12_, _tmp13_);
					element = _tmp14_;
					_tmp15_ = element;
					_tmp16_ = _tmp15_->starttime;
					g_time_local (_tmp16_, &_tmp17_);
					_tmp18_ = timegm (&_tmp17_);
					event_start = _tmp18_;
					_tmp19_ = element;
					_tmp20_ = _tmp19_->id;
					_tmp21_ = dvb_schedule_get_event (self, _tmp20_);
					event = _tmp21_;
					_tmp22_ = event;
					if (_tmp22_ == NULL) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						continue;
					}
					_tmp23_ = event_start;
					_tmp24_ = event;
					_tmp25_ = _tmp24_->duration;
					event_end = _tmp23_ + _tmp25_;
					_tmp27_ = timer_end;
					_tmp28_ = event_end;
					if (_tmp27_ < _tmp28_) {
						time_t _tmp29_;
						_tmp29_ = timer_end;
						_tmp26_ = _tmp29_;
					} else {
						time_t _tmp30_;
						_tmp30_ = event_end;
						_tmp26_ = _tmp30_;
					}
					_tmp31_ = _tmp26_;
					min_end = _tmp31_;
					_tmp33_ = timer_start;
					_tmp34_ = event_start;
					if (_tmp33_ > _tmp34_) {
						time_t _tmp35_;
						_tmp35_ = timer_start;
						_tmp32_ = _tmp35_;
					} else {
						time_t _tmp36_;
						_tmp36_ = event_start;
						_tmp32_ = _tmp36_;
					}
					_tmp37_ = _tmp32_;
					max_start = _tmp37_;
					_tmp38_ = min_end;
					_tmp39_ = max_start;
					overlap = _tmp38_ - _tmp39_;
					_tmp40_ = last_diff;
					_tmp41_ = overlap;
					if (_tmp40_ < _tmp41_) {
						time_t _tmp42_;
						DVBEvent* _tmp43_;
						DVBEvent* _tmp44_;
						_tmp42_ = overlap;
						last_diff = _tmp42_;
						_tmp43_ = event;
						_tmp44_ = _dvb_event_ref0 (_tmp43_);
						_dvb_event_unref0 (_result_);
						_result_ = _tmp44_;
					}
					_tmp45_ = event_start;
					_tmp46_ = timer_end;
					if (_tmp45_ > _tmp46_) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						break;
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
				_g_object_unref0 (_element_list);
			}
		}
		__finally175:
		{
			DVBEventStorage* _tmp47_;
			_tmp47_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	guint32* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* events;
	GeeArrayList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	guint32* _tmp28_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	guint32* _tmp40_;
	gint _tmp40__length1;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	events = _tmp0_;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				DVBEventStorage* _tmp2_;
				DVBEventStorage* _tmp3_;
				DVBEventStorage* _element_list;
				DVBEventStorage* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _element_size;
				gint _element_index;
				_tmp2_ = self->priv->events;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				_element_list = _tmp3_;
				_tmp4_ = _element_list;
				_tmp5_ = dvb_event_storage_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				_element_size = _tmp6_;
				_element_index = -1;
				while (TRUE) {
					gint _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					DVBEventStorage* _tmp10_;
					gint _tmp11_;
					DVBEventElement* _tmp12_ = NULL;
					DVBEventElement* element;
					DVBEventElement* _tmp13_;
					guint _tmp14_;
					DVBEvent* _tmp15_ = NULL;
					DVBEvent* event;
					gboolean _tmp16_ = FALSE;
					DVBEvent* _tmp17_;
					gboolean _tmp20_;
					GeeArrayList* _tmp21_;
					DVBEventElement* _tmp22_;
					guint _tmp23_;
					_tmp7_ = _element_index;
					_element_index = _tmp7_ + 1;
					_tmp8_ = _element_index;
					_tmp9_ = _element_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _element_list;
					_tmp11_ = _element_index;
					_tmp12_ = dvb_event_storage_get (_tmp10_, _tmp11_);
					element = _tmp12_;
					_tmp13_ = element;
					_tmp14_ = _tmp13_->id;
					_tmp15_ = dvb_schedule_get_event (self, _tmp14_);
					event = _tmp15_;
					_tmp17_ = event;
					if (_tmp17_ == NULL) {
						_tmp16_ = TRUE;
					} else {
						DVBEvent* _tmp18_;
						gboolean _tmp19_ = FALSE;
						_tmp18_ = event;
						_tmp19_ = dvb_event_has_expired (_tmp18_);
						_tmp16_ = _tmp19_;
					}
					_tmp20_ = _tmp16_;
					if (_tmp20_) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						continue;
					}
					_tmp21_ = events;
					_tmp22_ = element;
					_tmp23_ = _tmp22_->id;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, GUINT_TO_POINTER ((guint32) _tmp23_));
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
				_g_object_unref0 (_element_list);
			}
		}
		__finally176:
		{
			DVBEventStorage* _tmp24_;
			_tmp24_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp25_ = events;
	_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_new0 (guint32, _tmp27_);
	event_ids = _tmp28_;
	event_ids_length1 = _tmp27_;
	_event_ids_size_ = event_ids_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gboolean _tmp30_;
				gint _tmp32_;
				guint32* _tmp33_;
				gint _tmp33__length1;
				guint32* _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_;
				GeeArrayList* _tmp36_;
				gint _tmp37_;
				gpointer _tmp38_ = NULL;
				guint32 _tmp39_;
				_tmp30_ = _tmp29_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = event_ids;
				_tmp33__length1 = event_ids_length1;
				if (!(_tmp32_ < _tmp33__length1)) {
					break;
				}
				_tmp34_ = event_ids;
				_tmp34__length1 = event_ids_length1;
				_tmp35_ = i;
				_tmp36_ = events;
				_tmp37_ = i;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
				_tmp34_[_tmp35_] = GPOINTER_TO_UINT (_tmp38_);
				_tmp39_ = _tmp34_[_tmp35_];
			}
		}
	}
	_tmp40_ = event_ids;
	_tmp40__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	_g_object_unref0 (events);
	return result;
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	DVBEventInfo* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* all_events;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint n_events;
	gint _tmp27_;
	DVBEventInfo* _tmp28_ = NULL;
	DVBEventInfo* event_infos;
	gint event_infos_length1;
	gint _event_infos_size_;
	gint i;
	DVBEvent* event;
	gint _tmp29_;
	gint _tmp30_;
	DVBEventInfo* _tmp52_;
	gint _tmp52__length1;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	all_events = _tmp0_;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				DVBEventStorage* _tmp2_;
				DVBEventStorage* _tmp3_;
				DVBEventStorage* _element_list;
				DVBEventStorage* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _element_size;
				gint _element_index;
				_tmp2_ = self->priv->events;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				_element_list = _tmp3_;
				_tmp4_ = _element_list;
				_tmp5_ = dvb_event_storage_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				_element_size = _tmp6_;
				_element_index = -1;
				while (TRUE) {
					gint _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					DVBEventStorage* _tmp10_;
					gint _tmp11_;
					DVBEventElement* _tmp12_ = NULL;
					DVBEventElement* element;
					DVBEventElement* _tmp13_;
					guint _tmp14_;
					DVBEvent* _tmp15_ = NULL;
					DVBEvent* event;
					gboolean _tmp16_ = FALSE;
					DVBEvent* _tmp17_;
					gboolean _tmp20_;
					_tmp7_ = _element_index;
					_element_index = _tmp7_ + 1;
					_tmp8_ = _element_index;
					_tmp9_ = _element_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _element_list;
					_tmp11_ = _element_index;
					_tmp12_ = dvb_event_storage_get (_tmp10_, _tmp11_);
					element = _tmp12_;
					_tmp13_ = element;
					_tmp14_ = _tmp13_->id;
					_tmp15_ = dvb_schedule_get_event (self, _tmp14_);
					event = _tmp15_;
					_tmp17_ = event;
					if (_tmp17_ != NULL) {
						DVBEvent* _tmp18_;
						gboolean _tmp19_ = FALSE;
						_tmp18_ = event;
						_tmp19_ = dvb_event_has_expired (_tmp18_);
						_tmp16_ = !_tmp19_;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp20_ = _tmp16_;
					if (_tmp20_) {
						GeeArrayList* _tmp21_;
						DVBEvent* _tmp22_;
						_tmp21_ = all_events;
						_tmp22_ = event;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
				_g_object_unref0 (_element_list);
			}
		}
		__finally177:
		{
			DVBEventStorage* _tmp23_;
			_tmp23_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (all_events);
				return NULL;
			} else {
				_g_object_unref0 (all_events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp24_ = all_events;
	_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	n_events = _tmp26_;
	_tmp27_ = n_events;
	_tmp28_ = g_new0 (DVBEventInfo, _tmp27_);
	event_infos = _tmp28_;
	event_infos_length1 = _tmp27_;
	_event_infos_size_ = event_infos_length1;
	i = 0;
	event = NULL;
	_tmp29_ = n_events;
	_tmp30_ = i;
	if (_tmp29_ > _tmp30_) {
		GeeArrayList* _tmp31_;
		gint _tmp32_;
		gpointer _tmp33_ = NULL;
		_tmp31_ = all_events;
		_tmp32_ = i;
		_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
		_dvb_event_unref0 (event);
		event = (DVBEvent*) _tmp33_;
	}
	while (TRUE) {
		DVBEvent* _tmp34_;
		DVBEventInfo* _tmp35_;
		gint _tmp35__length1;
		gint _tmp36_;
		DVBEvent* _tmp37_;
		DVBEventInfo _tmp38_ = {0};
		DVBEventInfo _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp51_;
		_tmp34_ = event;
		if (!(_tmp34_ != NULL)) {
			break;
		}
		_tmp35_ = event_infos;
		_tmp35__length1 = event_infos_length1;
		_tmp36_ = i;
		_tmp37_ = event;
		dvb_schedule_event_to_event_info (_tmp37_, &_tmp38_);
		dvb_event_info_destroy (&_tmp35_[_tmp36_]);
		_tmp35_[_tmp36_] = _tmp38_;
		_tmp39_ = _tmp35_[_tmp36_];
		_tmp40_ = i;
		_tmp41_ = n_events;
		if ((_tmp40_ + 1) == _tmp41_) {
			DVBEventInfo* _tmp42_;
			gint _tmp42__length1;
			gint _tmp43_;
			_tmp42_ = event_infos;
			_tmp42__length1 = event_infos_length1;
			_tmp43_ = i;
			_tmp42_[_tmp43_].next = (guint32) 0;
			_dvb_event_unref0 (event);
			event = NULL;
		} else {
			GeeArrayList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_ = NULL;
			DVBEventInfo* _tmp47_;
			gint _tmp47__length1;
			gint _tmp48_;
			DVBEvent* _tmp49_;
			guint _tmp50_;
			_tmp44_ = all_events;
			_tmp45_ = i;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_ + 1);
			_dvb_event_unref0 (event);
			event = (DVBEvent*) _tmp46_;
			_tmp47_ = event_infos;
			_tmp47__length1 = event_infos_length1;
			_tmp48_ = i;
			_tmp49_ = event;
			_tmp50_ = _tmp49_->id;
			_tmp47_[_tmp48_].next = (guint32) _tmp50_;
		}
		_tmp51_ = i;
		i = _tmp51_ + 1;
	}
	_tmp52_ = event_infos;
	_tmp52__length1 = event_infos_length1;
	if (result_length1) {
		*result_length1 = _tmp52__length1;
	}
	result = _tmp52_;
	_dvb_event_unref0 (event);
	_g_object_unref0 (all_events);
	return result;
}


static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	DVBSchedule * self;
	DVBEventInfo _vala_event_info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	dvb_event_info_destroy (&_vala_event_info);
	memset (&_vala_event_info, 0, sizeof (DVBEventInfo));
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				DVBEventStorage* _tmp4_;
				guint32 _tmp5_;
				DVBEventElement* _tmp6_ = NULL;
				DVBEventElement* element;
				DVBEventElement* _tmp7_;
				guint _tmp8_;
				DVBEvent* _tmp9_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp10_;
				DVBEventInfo _tmp11_ = {0};
				DVBEventStorage* _tmp12_;
				DVBEventElement* _tmp13_;
				DVBEventElement* _tmp14_ = NULL;
				DVBEventElement* next_element;
				DVBEventElement* _tmp15_;
				_tmp4_ = self->priv->events;
				_tmp5_ = event_id;
				_tmp6_ = dvb_event_storage_get_by_id (_tmp4_, (guint) _tmp5_);
				element = _tmp6_;
				_tmp7_ = element;
				_tmp8_ = _tmp7_->id;
				_tmp9_ = dvb_schedule_get_event (self, _tmp8_);
				event = _tmp9_;
				_tmp10_ = event;
				dvb_schedule_event_to_event_info (_tmp10_, &_tmp11_);
				dvb_event_info_destroy (&_vala_event_info);
				_vala_event_info = _tmp11_;
				_tmp12_ = self->priv->events;
				_tmp13_ = element;
				_tmp14_ = dvb_event_storage_next (_tmp12_, _tmp13_);
				next_element = _tmp14_;
				_tmp15_ = next_element;
				if (_tmp15_ == NULL) {
					_vala_event_info.next = (guint32) 0;
				} else {
					DVBEventElement* _tmp16_;
					DVBEventElement* _tmp17_;
					DVBEventElement* _tmp18_;
					guint _tmp19_;
					_tmp16_ = next_element;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (element);
					element = _tmp17_;
					_tmp18_ = element;
					_tmp19_ = _tmp18_->id;
					_vala_event_info.next = (guint32) _tmp19_;
				}
				ret = TRUE;
				_g_object_unref0 (next_element);
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			} else {
				gchar* _tmp20_;
				gchar* _tmp21_;
				_vala_event_info.id = (guint32) 0;
				_tmp20_ = g_strdup ("");
				_g_free0 (_vala_event_info.name);
				_vala_event_info.name = _tmp20_;
				_vala_event_info.duration = (guint) 0;
				_tmp21_ = g_strdup ("");
				_g_free0 (_vala_event_info.short_description);
				_vala_event_info.short_description = _tmp21_;
				_vala_event_info.next = (guint32) 0;
				ret = FALSE;
			}
		}
		__finally178:
		{
			DVBEventStorage* _tmp22_;
			_tmp22_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (event_info) {
		*event_info = _vala_event_info;
	} else {
		dvb_event_info_destroy (&_vala_event_info);
	}
	return result;
}


static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	DVBEvent* _tmp0_ = NULL;
	DVBEvent* event;
	guint _tmp1_ = 0U;
	DVBEvent* _tmp2_;
	guint _tmp5_;
	self = (DVBSchedule*) base;
	_tmp0_ = dvb_schedule_get_running_event (self);
	event = _tmp0_;
	_tmp2_ = event;
	if (_tmp2_ == NULL) {
		_tmp1_ = (guint) 0;
	} else {
		DVBEvent* _tmp3_;
		guint _tmp4_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->id;
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = _tmp1_;
	result = (guint32) _tmp5_;
	_dvb_event_unref0 (event);
	return result;
}


static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	guint32 next_event;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	next_event = (guint32) 0;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				DVBEventStorage* _tmp4_;
				guint32 _tmp5_;
				DVBEventElement* _tmp6_ = NULL;
				DVBEventElement* element;
				DVBEventStorage* _tmp7_;
				DVBEventElement* _tmp8_;
				DVBEventElement* _tmp9_ = NULL;
				DVBEventElement* next;
				DVBEventElement* _tmp10_;
				_tmp4_ = self->priv->events;
				_tmp5_ = event_id;
				_tmp6_ = dvb_event_storage_get_by_id (_tmp4_, (guint) _tmp5_);
				element = _tmp6_;
				_tmp7_ = self->priv->events;
				_tmp8_ = element;
				_tmp9_ = dvb_event_storage_next (_tmp7_, _tmp8_);
				next = _tmp9_;
				_tmp10_ = next;
				if (_tmp10_ != NULL) {
					DVBEventElement* _tmp11_;
					guint _tmp12_;
					_tmp11_ = next;
					_tmp12_ = _tmp11_->id;
					next_event = (guint32) _tmp12_;
				}
				_g_object_unref0 (next);
				_g_object_unref0 (element);
			} else {
				DVBLoggingLogger* _tmp13_;
				guint32 _tmp14_;
				_tmp13_ = dvb_schedule_log;
				_tmp14_ = event_id;
				dvb_logging_logger_debug (_tmp13_, "Schedule.vala:395: No event with id %u", (guint) _tmp14_);
			}
		}
		__finally179:
		{
			DVBEventStorage* _tmp15_;
			_tmp15_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0U;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
	}
	result = next_event;
	return result;
}


static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error) {
	DVBSchedule * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp2_;
			guint32 _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->events;
			_tmp3_ = event_id;
			_tmp4_ = dvb_event_storage_contains_event_with_id (_tmp2_, (guint) _tmp3_);
			if (_tmp4_) {
				guint32 _tmp5_;
				DVBEvent* _tmp6_ = NULL;
				DVBEvent* event;
				gboolean _tmp7_ = FALSE;
				DVBEvent* _tmp8_;
				gboolean _tmp11_;
				_tmp5_ = event_id;
				_tmp6_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp5_);
				event = _tmp6_;
				_tmp8_ = event;
				if (_tmp8_ != NULL) {
					DVBEvent* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = event;
					_tmp10_ = _tmp9_->name;
					_tmp7_ = _tmp10_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp11_ = _tmp7_;
				if (_tmp11_) {
					DVBEvent* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = event;
					_tmp13_ = _tmp12_->name;
					_tmp14_ = g_strdup (_tmp13_);
					_g_free0 (_vala_name);
					_vala_name = _tmp14_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp15_;
				guint32 _tmp16_;
				_tmp15_ = dvb_schedule_log;
				_tmp16_ = event_id;
				dvb_logging_logger_debug (_tmp15_, "Schedule.vala:414: No event with id %u", (guint) _tmp16_);
			}
		}
		__finally180:
		{
			DVBEventStorage* _tmp17_;
			_tmp17_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}


static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _vala_description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_description);
	_vala_description = _tmp0_;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp2_;
			guint32 _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->events;
			_tmp3_ = event_id;
			_tmp4_ = dvb_event_storage_contains_event_with_id (_tmp2_, (guint) _tmp3_);
			if (_tmp4_) {
				guint32 _tmp5_;
				DVBEvent* _tmp6_ = NULL;
				DVBEvent* event;
				gboolean _tmp7_ = FALSE;
				DVBEvent* _tmp8_;
				gboolean _tmp11_;
				_tmp5_ = event_id;
				_tmp6_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp5_);
				event = _tmp6_;
				_tmp8_ = event;
				if (_tmp8_ != NULL) {
					DVBEvent* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = event;
					_tmp10_ = _tmp9_->description;
					_tmp7_ = _tmp10_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp11_ = _tmp7_;
				if (_tmp11_) {
					DVBEvent* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = event;
					_tmp13_ = _tmp12_->description;
					_tmp14_ = g_strdup (_tmp13_);
					_g_free0 (_vala_description);
					_vala_description = _tmp14_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp15_;
				guint32 _tmp16_;
				_tmp15_ = dvb_schedule_log;
				_tmp16_ = event_id;
				dvb_logging_logger_debug (_tmp15_, "Schedule.vala:435: No event with id %u", (guint) _tmp16_);
			}
		}
		__finally181:
		{
			DVBEventStorage* _tmp17_;
			_tmp17_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (description) {
		*description = _vala_description;
	} else {
		_g_free0 (_vala_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _vala_description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_description);
	_vala_description = _tmp0_;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp2_;
			guint32 _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->events;
			_tmp3_ = event_id;
			_tmp4_ = dvb_event_storage_contains_event_with_id (_tmp2_, (guint) _tmp3_);
			if (_tmp4_) {
				guint32 _tmp5_;
				DVBEvent* _tmp6_ = NULL;
				DVBEvent* event;
				gboolean _tmp7_ = FALSE;
				DVBEvent* _tmp8_;
				gboolean _tmp11_;
				_tmp5_ = event_id;
				_tmp6_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp5_);
				event = _tmp6_;
				_tmp8_ = event;
				if (_tmp8_ != NULL) {
					DVBEvent* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = event;
					_tmp10_ = _tmp9_->extended_description;
					_tmp7_ = _tmp10_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp11_ = _tmp7_;
				if (_tmp11_) {
					DVBEvent* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = event;
					_tmp13_ = _tmp12_->extended_description;
					_tmp14_ = g_strdup (_tmp13_);
					_g_free0 (_vala_description);
					_vala_description = _tmp14_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp15_;
				guint32 _tmp16_;
				_tmp15_ = dvb_schedule_log;
				_tmp16_ = event_id;
				dvb_logging_logger_debug (_tmp15_, "Schedule.vala:456: No event with id %u", (guint) _tmp16_);
			}
		}
		__finally182:
		{
			DVBEventStorage* _tmp17_;
			_tmp17_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (description) {
		*description = _vala_description;
	} else {
		_g_free0 (_vala_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error) {
	DVBSchedule * self;
	guint _vala_duration = 0U;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_vala_duration = (guint) 0;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				guint32 _tmp4_;
				DVBEvent* _tmp5_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp6_;
				_tmp4_ = event_id;
				_tmp5_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp4_);
				event = _tmp5_;
				_tmp6_ = event;
				if (_tmp6_ != NULL) {
					DVBEvent* _tmp7_;
					guint _tmp8_;
					_tmp7_ = event;
					_tmp8_ = _tmp7_->duration;
					_vala_duration = _tmp8_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp9_;
				guint32 _tmp10_;
				_tmp9_ = dvb_schedule_log;
				_tmp10_ = event_id;
				dvb_logging_logger_debug (_tmp9_, "Schedule.vala:477: No event with id %u", (guint) _tmp10_);
			}
		}
		__finally183:
		{
			DVBEventStorage* _tmp11_;
			_tmp11_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (duration) {
		*duration = _vala_duration;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBSchedule * self;
	guint* _vala_start_time = NULL;
	int _vala_start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret;
	guint* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_tmp0_ = g_new0 (guint, 0);
	_vala_start_time = (g_free (_vala_start_time), NULL);
	_vala_start_time = _tmp0_;
	_vala_start_time_length1 = 0;
	{
		DVBEventStorage* _tmp1_;
		_tmp1_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp2_;
			guint32 _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->events;
			_tmp3_ = event_id;
			_tmp4_ = dvb_event_storage_contains_event_with_id (_tmp2_, (guint) _tmp3_);
			if (_tmp4_) {
				guint32 _tmp5_;
				DVBEvent* _tmp6_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp7_;
				_tmp5_ = event_id;
				_tmp6_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp5_);
				event = _tmp6_;
				_tmp7_ = event;
				if (_tmp7_ != NULL) {
					DVBEvent* _tmp8_;
					struct tm _tmp9_ = {0};
					struct tm local_time;
					struct tm _tmp10_;
					gint _tmp11_ = 0;
					guint* _tmp12_ = NULL;
					_tmp8_ = event;
					dvb_event_get_local_start_time (_tmp8_, &_tmp9_);
					local_time = _tmp9_;
					_tmp10_ = local_time;
					_tmp12_ = dvb_schedule_to_time_array (&_tmp10_, &_tmp11_);
					_vala_start_time = (g_free (_vala_start_time), NULL);
					_vala_start_time = _tmp12_;
					_vala_start_time_length1 = _tmp11_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp13_;
				guint32 _tmp14_;
				_tmp13_ = dvb_schedule_log;
				_tmp14_ = event_id;
				dvb_logging_logger_debug (_tmp13_, "Schedule.vala:499: No event with id %u", (guint) _tmp14_);
			}
		}
		__finally184:
		{
			DVBEventStorage* _tmp15_;
			_tmp15_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (start_time) {
		*start_time = _vala_start_time;
	} else {
		_vala_start_time = (g_free (_vala_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _vala_start_time_length1;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error) {
	DVBSchedule * self;
	gint64 _vala_timestamp = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_vala_timestamp = (gint64) 0;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				guint32 _tmp4_;
				DVBEvent* _tmp5_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp6_;
				_tmp4_ = event_id;
				_tmp5_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp4_);
				event = _tmp5_;
				_tmp6_ = event;
				if (_tmp6_ != NULL) {
					DVBEvent* _tmp7_;
					struct tm _tmp8_ = {0};
					struct tm local_time;
					time_t _tmp9_ = 0;
					_tmp7_ = event;
					dvb_event_get_local_start_time (_tmp7_, &_tmp8_);
					local_time = _tmp8_;
					_tmp9_ = mktime (&local_time);
					_vala_timestamp = (gint64) _tmp9_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			}
		}
		__finally185:
		{
			DVBEventStorage* _tmp10_;
			_tmp10_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	return result;
}


static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error) {
	DVBSchedule * self;
	gboolean _vala_running = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_vala_running = FALSE;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				guint32 _tmp4_;
				DVBEvent* _tmp5_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp6_;
				_tmp4_ = event_id;
				_tmp5_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp4_);
				event = _tmp5_;
				_tmp6_ = event;
				if (_tmp6_ != NULL) {
					DVBEvent* _tmp7_;
					gboolean _tmp8_ = FALSE;
					_tmp7_ = event;
					_tmp8_ = dvb_event_is_running (_tmp7_);
					_vala_running = _tmp8_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp9_;
				guint32 _tmp10_;
				_tmp9_ = dvb_schedule_log;
				_tmp10_ = event_id;
				dvb_logging_logger_debug (_tmp9_, "Schedule.vala:540: No event with id %u", (guint) _tmp10_);
			}
		}
		__finally186:
		{
			DVBEventStorage* _tmp11_;
			_tmp11_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (running) {
		*running = _vala_running;
	}
	return result;
}


static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error) {
	DVBSchedule * self;
	gboolean _vala_scrambled = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	_vala_scrambled = FALSE;
	{
		DVBEventStorage* _tmp0_;
		_tmp0_ = self->priv->events;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->events;
			_tmp2_ = event_id;
			_tmp3_ = dvb_event_storage_contains_event_with_id (_tmp1_, (guint) _tmp2_);
			if (_tmp3_) {
				guint32 _tmp4_;
				DVBEvent* _tmp5_ = NULL;
				DVBEvent* event;
				DVBEvent* _tmp6_;
				_tmp4_ = event_id;
				_tmp5_ = dvb_schedule_get_extended_event_by_id (self, (guint) _tmp4_);
				event = _tmp5_;
				_tmp6_ = event;
				if (_tmp6_ != NULL) {
					DVBEvent* _tmp7_;
					gboolean _tmp8_;
					_tmp7_ = event;
					_tmp8_ = _tmp7_->free_ca_mode;
					_vala_scrambled = !_tmp8_;
					ret = TRUE;
				}
				_dvb_event_unref0 (event);
			} else {
				DVBLoggingLogger* _tmp9_;
				guint32 _tmp10_;
				_tmp9_ = dvb_schedule_log;
				_tmp10_ = event_id;
				dvb_logging_logger_debug (_tmp9_, "Schedule.vala:561: No event with id %u", (guint) _tmp10_);
			}
		}
		__finally187:
		{
			DVBEventStorage* _tmp11_;
			_tmp11_ = self->priv->events;
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (scrambled) {
		*scrambled = _vala_scrambled;
	}
	return result;
}


static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	DVBEventStorage* _tmp0_;
	guint _tmp1_;
	DVBEventElement* _tmp2_ = NULL;
	DVBEventElement* element;
	guint _tmp3_;
	DVBEvent* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->events;
	_tmp1_ = event_id;
	_tmp2_ = dvb_event_storage_get_by_id (_tmp0_, _tmp1_);
	element = _tmp2_;
	_tmp3_ = element->id;
	_tmp4_ = dvb_schedule_get_event (self, _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (element);
	return result;
}


static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1) {
	guint* result = NULL;
	guint* _tmp0_ = NULL;
	guint* start;
	gint start_length1;
	gint _start_size_;
	struct tm _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	guint _tmp6_;
	struct tm _tmp7_;
	gint _tmp8_;
	guint _tmp9_;
	struct tm _tmp10_;
	gint _tmp11_;
	guint _tmp12_;
	struct tm _tmp13_;
	gint _tmp14_;
	guint _tmp15_;
	struct tm _tmp16_;
	gint _tmp17_;
	guint _tmp18_;
	guint* _tmp19_;
	gint _tmp19__length1;
	g_return_val_if_fail (local_time != NULL, NULL);
	_tmp0_ = g_new0 (guint, 6);
	start = _tmp0_;
	start_length1 = 6;
	_start_size_ = start_length1;
	_tmp1_ = *local_time;
	_tmp2_ = _tmp1_.tm_year;
	start[0] = (guint) (_tmp2_ + 1900);
	_tmp3_ = start[0];
	_tmp4_ = *local_time;
	_tmp5_ = _tmp4_.tm_mon;
	start[1] = (guint) (_tmp5_ + 1);
	_tmp6_ = start[1];
	_tmp7_ = *local_time;
	_tmp8_ = _tmp7_.tm_mday;
	start[2] = (guint) _tmp8_;
	_tmp9_ = start[2];
	_tmp10_ = *local_time;
	_tmp11_ = _tmp10_.tm_hour;
	start[3] = (guint) _tmp11_;
	_tmp12_ = start[3];
	_tmp13_ = *local_time;
	_tmp14_ = _tmp13_.tm_min;
	start[4] = (guint) _tmp14_;
	_tmp15_ = start[4];
	_tmp16_ = *local_time;
	_tmp17_ = _tmp16_.tm_sec;
	start[5] = (guint) _tmp17_;
	_tmp18_ = start[5];
	_tmp19_ = start;
	_tmp19__length1 = start_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}


static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result) {
	DVBEventInfo event_info = {0};
	DVBEvent* _tmp0_;
	guint _tmp1_;
	DVBEvent* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	DVBEvent* _tmp5_;
	guint _tmp6_;
	DVBEvent* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (event != NULL);
	memset (&event_info, 0, sizeof (DVBEventInfo));
	_tmp0_ = event;
	_tmp1_ = _tmp0_->id;
	event_info.id = (guint32) _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (event_info.name);
	event_info.name = _tmp4_;
	_tmp5_ = event;
	_tmp6_ = _tmp5_->duration;
	event_info.duration = _tmp6_;
	_tmp7_ = event;
	_tmp8_ = _tmp7_->description;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (event_info.short_description);
	event_info.short_description = _tmp9_;
	*result = event_info;
	return;
}


DVBChannel* dvb_schedule_get_channel (DVBSchedule* self) {
	DVBChannel* result;
	DVBChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channel;
	result = _tmp0_;
	return result;
}


static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value) {
	DVBChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_channel = _tmp0_;
	g_object_notify ((GObject *) self, "channel");
}


static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSchedule * self;
	DVBEventStorage* _tmp0_;
	DVBFactory* _tmp1_;
	DVBFactory* _tmp2_;
	DVBdatabaseEPGStore* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_schedule_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCHEDULE (obj);
	_tmp0_ = dvb_event_storage_new ();
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp0_;
	_tmp1_ = dvb_factory_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_factory_get_epg_store (_tmp2_);
	_g_object_unref0 (self->priv->epgstore);
	self->priv->epgstore = _tmp3_;
	_g_object_unref0 (_tmp2_);
	return obj;
}


static void dvb_schedule_class_init (DVBScheduleClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GRecMutex _tmp2_ = {0};
	dvb_schedule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSchedulePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_schedule_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_schedule_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_schedule_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_schedule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCHEDULE_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_schedule_log = _tmp1_;
	g_rec_mutex_init (&_tmp2_);
	dvb_schedule_mutex = _tmp2_;
}


static void dvb_schedule_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface * iface) {
	dvb_schedule_dvb_id_bus_schedule_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetAllEvents = (guint32* (*)(DVBIDBusSchedule*, int*, GError**)) dvb_schedule_real_GetAllEvents;
	iface->GetAllEventInfos = (DVBEventInfo* (*)(DVBIDBusSchedule*, int*, GError**)) dvb_schedule_real_GetAllEventInfos;
	iface->GetInformations = (gboolean (*)(DVBIDBusSchedule*, guint32, DVBEventInfo*, GError**)) dvb_schedule_real_GetInformations;
	iface->NowPlaying = (guint32 (*)(DVBIDBusSchedule*, GError**)) dvb_schedule_real_NowPlaying;
	iface->Next = (guint32 (*)(DVBIDBusSchedule*, guint32, GError**)) dvb_schedule_real_Next;
	iface->GetName = (gboolean (*)(DVBIDBusSchedule*, guint32, gchar**, GError**)) dvb_schedule_real_GetName;
	iface->GetShortDescription = (gboolean (*)(DVBIDBusSchedule*, guint32, gchar**, GError**)) dvb_schedule_real_GetShortDescription;
	iface->GetExtendedDescription = (gboolean (*)(DVBIDBusSchedule*, guint32, gchar**, GError**)) dvb_schedule_real_GetExtendedDescription;
	iface->GetDuration = (gboolean (*)(DVBIDBusSchedule*, guint32, guint*, GError**)) dvb_schedule_real_GetDuration;
	iface->GetLocalStartTime = (gboolean (*)(DVBIDBusSchedule*, guint32, guint**, int*, GError**)) dvb_schedule_real_GetLocalStartTime;
	iface->GetLocalStartTimestamp = (gboolean (*)(DVBIDBusSchedule*, guint32, gint64*, GError**)) dvb_schedule_real_GetLocalStartTimestamp;
	iface->IsRunning = (gboolean (*)(DVBIDBusSchedule*, guint32, gboolean*, GError**)) dvb_schedule_real_IsRunning;
	iface->IsScrambled = (gboolean (*)(DVBIDBusSchedule*, guint32, gboolean*, GError**)) dvb_schedule_real_IsScrambled;
}


static void dvb_schedule_instance_init (DVBSchedule * self) {
	self->priv = DVB_SCHEDULE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_events);
}


static void dvb_schedule_finalize (GObject* obj) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (obj);
	_g_object_unref0 (self->priv->epgstore);
	g_static_rec_mutex_free (&self->priv->__lock_events);
	_g_object_unref0 (self->priv->events);
	G_OBJECT_CLASS (dvb_schedule_parent_class)->finalize (obj);
}


/**
     * Represents a series of events of a channel
     */
GType dvb_schedule_get_type (void) {
	static volatile gsize dvb_schedule_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_schedule_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScheduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_schedule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSchedule), 0, (GInstanceInitFunc) dvb_schedule_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_schedule_info = { (GInterfaceInitFunc) dvb_schedule_dvb_id_bus_schedule_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_schedule_type_id;
		dvb_schedule_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSchedule", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_schedule_type_id, DVB_TYPE_ID_BUS_SCHEDULE, &dvb_id_bus_schedule_info);
		g_once_init_leave (&dvb_schedule_type_id__volatile, dvb_schedule_type_id);
	}
	return dvb_schedule_type_id__volatile;
}


static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		g_value_set_object (value, dvb_schedule_get_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		dvb_schedule_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



