/* destination-selector.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <gtk/gtkmenuitem.h>
#include <gtk/gtkmenushell.h>
#include <libgnome/gnome-i18n.h>
#include "destination-selector.h"
#include "file-destination.h"

static void ds_class_init (DestinationSelectorClass *klass);
static void ds_init (DestinationSelector *ds, DestinationSelectorClass *klass);
static void ds_finalize (GObject *object);

static GObjectClass *parent_class = NULL;

static void
ds_class_init (DestinationSelectorClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);

	object_class = G_OBJECT_CLASS (klass);
	object_class->finalize = ds_finalize;
}

static void
add_destination (DestinationSelector *ds, const gchar *label, GenericDestination *dest)
{
	GtkWidget *menu, *item;

	menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (ds));
	if (!menu) {
		menu = gtk_menu_new ();
		gtk_option_menu_set_menu (GTK_OPTION_MENU (ds), menu);
	}

	ds->destinations = g_list_append (ds->destinations, dest);

	item = gtk_menu_item_new_with_label (label);
	gtk_widget_show (item);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);

	gtk_option_menu_set_history (GTK_OPTION_MENU (ds), 0);
}

static void
ds_init (DestinationSelector *ds, DestinationSelectorClass *klass)
{
	ds->destinations = NULL;

	/* initialize destinations */
	add_destination (ds, _("Backup to local file"), file_destination_new ());
}

static void
ds_finalize (GObject *object)
{
	parent_class->finalize (object);
}

GType
destination_selector_get_type (void)
{
	static GType type = 0;
                                                                                                  
        if (type == 0) {
                static GTypeInfo info = {
                        sizeof (DestinationSelectorClass),
                        (GBaseInitFunc) NULL,
                        (GBaseFinalizeFunc) NULL,
                        (GClassInitFunc) ds_class_init,
                        NULL, NULL,
                        sizeof (DestinationSelector),
                        0,
                        (GInstanceInitFunc) ds_init
                };
		type = g_type_register_static (GTK_TYPE_OPTION_MENU, "DestinationSelector", &info, 0);
        }

        return type;
}

GtkWidget *
destination_selector_new (void)
{
	DestinationSelector *ds;

	ds = g_object_new (destination_selector_get_type (), NULL);
	return GTK_WIDGET (ds);
}
