/* main-window.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <gtk/gtkliststore.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktreeview.h>
#include <libgnome/gnome-i18n.h>
#include "configuration.h"
#include "file-list.h"

static void fl_class_init (FileListClass *klass);
static void fl_init (FileList *fl, FileListClass *klass);
static void fl_finalize (GObject *object);

static GObjectClass *parent_class = NULL;

static void
refresh_file_list (FileList *fl)
{
	const GList *list;

	/* clear previous contents */
	gtk_list_store_clear (GTK_LIST_STORE (fl->model));

	for (list = config_get_fileset_list (); list; list = list->next) {
		GtkTreeIter iter;
		FileSetInfo *fsi = list->data;

		if (!fsi)
			continue;

		gtk_list_store_append (GTK_LIST_STORE (fl->model), &iter);
		gtk_list_store_set (GTK_LIST_STORE (fl->model), &iter,
				    0, fsi->backup,
				    1, fsi->name,
				    2, "--",
				    3, "--",
				    -1);
	}
}

static void
treeview_row_activated_cb (GtkTreeView *tree_view, GtkTreePath *path,
			   GtkTreeViewColumn *column, gpointer user_data)
{
	GtkTreeIter iter;
	gchar *fs_name = NULL;
	FileSetInfo *fsi;
	FileList *fl = user_data;

	if (!gtk_tree_model_get_iter (GTK_TREE_MODEL (fl->model), &iter, path))
		return;

	gtk_tree_model_get (GTK_TREE_MODEL (fl->model), &iter, 1, &fs_name, -1);
	if (!fs_name)
		return;

	fsi = config_get_fileset_by_name (fs_name);
	if (!fsi)
		return;

	/* FIXME */
}

static void
fl_class_init (FileListClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);

	object_class = G_OBJECT_CLASS (klass);
	object_class->finalize = fl_finalize;
}

static void
fl_init (FileList *fl, FileListClass *klass)
{
	GtkWidget *sw;
	GtkCellRenderer *cell_renderer;
	GtkTreeViewColumn *column;

	/* create the model */
	fl->model = gtk_list_store_new (4, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

	/* create the widgets */
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (sw), 6);
	gtk_widget_show (sw);
	gtk_box_pack_start (GTK_BOX (fl), sw, TRUE, TRUE, 6);

	fl->list = gtk_tree_view_new_with_model (fl->model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (fl->list), TRUE);

	cell_renderer = gtk_cell_renderer_toggle_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Back up"), cell_renderer, "active", 0, NULL);
	gtk_tree_view_column_set_alignment (column, 0.5);
	gtk_tree_view_column_set_resizable (column, FALSE);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
					 GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 65);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->list), column);

	cell_renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Items"), cell_renderer, "text", 1, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->list), column);

	cell_renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Size"), cell_renderer, "text", 2, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->list), column);

	cell_renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Last backed up"), cell_renderer, "text", 3, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->list), column);

	/* set up the selection signals */
	g_signal_connect (fl->list, "row_activated", G_CALLBACK (treeview_row_activated_cb), fl);

	/* add tree view to scrolled window */
	gtk_widget_show (fl->list);
	gtk_container_add (GTK_CONTAINER (sw), fl->list);
}

static void
fl_finalize (GObject *object)
{
	FileList *fl = (FileList *) object;

	if (fl->model) {
		g_object_unref (fl->model);
		fl->model = NULL;
	}

	parent_class->finalize (object);
}

GType
file_list_get_type (void)
{
	static GType type = 0;
                                                                                                  
        if (type == 0) {
                static GTypeInfo info = {
                        sizeof (FileListClass),
                        (GBaseInitFunc) NULL,
                        (GBaseFinalizeFunc) NULL,
                        (GClassInitFunc) fl_class_init,
                        NULL, NULL,
                        sizeof (FileList),
                        0,
                        (GInstanceInitFunc) fl_init
                };
		type = g_type_register_static (GTK_TYPE_VBOX, "FileList", &info, 0);
        }

        return type;
}

GtkWidget *
file_list_new (void)
{
	FileList *fl;

	fl = g_object_new (file_list_get_type (), NULL);
	refresh_file_list (fl);

	return GTK_WIDGET (fl);
}
