/* gnome-netinfo - A GUI Interface for network utilities
 * Copyright (C) 2003 by German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <sys/types.h>
#include <signal.h>
#include <errno.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>

#include "scan.h"

#ifdef PING_PROGRAM

static GtkTreeModel *scan_create_model (GtkTreeView *widget);

void
scan_stop (Netinfo * netinfo)
{
	g_return_if_fail (netinfo != NULL);

	netinfo_stop_process_command (netinfo);
}

void
scan_do (Netinfo * netinfo)
{
	const gchar *host = NULL;
	gchar *command = NULL;
	GtkTreeModel *model;
	
	struct sockaddr_in addr;
	struct hostent *hp = NULL;
	struct servent *service = NULL;
	scan_data data;
	gint i, sock, start_port = 1, end_port = 7000;
	GIOChannel *channel;
		
	g_return_if_fail (netinfo != NULL);

	host = netinfo_get_host (netinfo);

	/* Clear the current output */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (netinfo->output));
	if (GTK_IS_LIST_STORE (model)) {
		gtk_list_store_clear (GTK_LIST_STORE (model));
	}
	
	if ((hp = gethostbyname (host)) == NULL) {
		g_print ("Error: Nombre de la maquina desconocido\n");
		g_return_if_fail (hp != NULL);
	}
	
	for (i = start_port; i <= end_port; i++) {
		if ((sock = socket (PF_INET, SOCK_STREAM, 0)) == -1) {
			g_print ("Imposible creacion del socket\n");
			continue;
		}
		
		channel = g_io_channel_unix_new (sock);

		addr.sin_family = PF_INET;
		addr.sin_addr.s_addr = htonl (INADDR_ANY);
		addr.sin_port = htons (i);
		bcopy (hp->h_addr, &addr.sin_addr, hp->h_length);
	
		if (connect (sock, (struct sockaddr *) &addr, sizeof (addr)) == 0) {
			service = getservbyport (htons(i), "tcp");

			if (service != NULL) {
				g_sprintf (data.service, "%s", service->s_name);
			} else {
				g_sprintf (data.service, "%s", _("unknown"));
			}
			data.port = i;
			g_sprintf (data.state, _("open"));
			
			g_print ("%d open\n", i);			
			scan_define_model (netinfo, data);
		}
		while (g_main_context_iteration (NULL, FALSE)) {
			g_main_context_pending (NULL);
		}
		//close (sock);
		g_io_channel_shutdown (channel, FALSE, NULL);
	}
	
	g_free (command);
}

void
scan_define_model (Netinfo * netinfo, scan_data data)
{
	GtkTreeIter iter, sibling;
	GList *columns;
	GtkTreePath *path;
	GtkTreeModel *model;
	GtkTreeView *widget;

	g_return_if_fail (netinfo != NULL);

	widget = (GTK_TREE_VIEW (netinfo->output));

	/* Creation of GtkTreeView */
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW
					  (widget), TRUE);
	columns =
		gtk_tree_view_get_columns (GTK_TREE_VIEW
					   (widget));

	if (g_list_length (columns) == 0) {

		model = scan_create_model (widget);
		gtk_tree_view_set_model (GTK_TREE_VIEW
					 (widget), model);
	}
	g_list_free (columns);

	model =
		gtk_tree_view_get_model (GTK_TREE_VIEW
					 (widget));
	
	gtk_tree_view_get_cursor (GTK_TREE_VIEW (widget),
				  &path, NULL);

	if (path != NULL) {
		gtk_tree_model_get_iter (model, &sibling,
					 path);
		gtk_list_store_insert_after (GTK_LIST_STORE
						 (model),
						 &iter,
						 &sibling);
	} else {
		gtk_list_store_append (GTK_LIST_STORE
					   (model), &iter);
	}

	gtk_list_store_set (GTK_LIST_STORE (model), &iter,
				0, data.port,
				1, data.state,
				2, data.service, -1);

	gtk_tree_view_set_model (GTK_TREE_VIEW (widget),
				 model);
	path = gtk_tree_model_get_path (model, &iter);
	gtk_tree_view_set_cursor (GTK_TREE_VIEW (widget),
				  path, NULL, FALSE);
	gtk_widget_grab_focus (GTK_WIDGET (widget));
	gtk_tree_path_free (path);
}



static GtkTreeModel *
scan_create_model (GtkTreeView *widget)
{
	GtkCellRenderer *renderer;
	static GtkTreeViewColumn *column;
	GtkTreeModel *model;

	renderer = gtk_cell_renderer_text_new ();
	/* Number of bytes received in a ping reply */
	column =
	    gtk_tree_view_column_new_with_attributes
	    (_("Port"), renderer, "text", 0, NULL);
	g_object_set (G_OBJECT (renderer), "xalign", 1.0);
	gtk_tree_view_append_column (widget, column);

	renderer = gtk_cell_renderer_text_new ();
	/* IP address that reply a ping */
	column =
	    gtk_tree_view_column_new_with_attributes
	    (_("State"), renderer, "text", 1, NULL);
	gtk_tree_view_column_set_alignment (column, 0.5);
	gtk_tree_view_append_column (widget, column);

	renderer = gtk_cell_renderer_text_new ();
	/* Number of sequence of a ICMP request (ping) */
	column =
	    gtk_tree_view_column_new_with_attributes
	    (_("Service"), renderer, "text", 2, NULL);
	gtk_tree_view_append_column (widget, column);

	model = GTK_TREE_MODEL (gtk_list_store_new
				(3,
				 G_TYPE_INT,
				 G_TYPE_STRING,
				 G_TYPE_STRING));
	return model;
}
#endif	/* PING_PROGRAM */
