/* obgtkLayout.m: Copyright (C) 1998 Free Software Foundation
 * Objective-C wrappings for GNOME UI routines.
 * Written by: Bertrand Guiheneuf <Bertrand.Guiheneuf@inria.fr>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "obgtkLayout.h"

@implementation Gtk_Layout 

- init 
{

  return [self castGtkLayout:GTK_LAYOUT( gtk_type_new (gtk_layout_get_type()) )];

}


- initWithAdjustmentInfo:(Gtk_Adjustment *) hadjustment
	     vadjustment:(Gtk_Adjustment *) vadjustment
{
  return [self castGtkLayout:GTK_LAYOUT(gtk_layout_new(hadjustment->gtkadjustment,
						       vadjustment->gtkadjustment))];
}

- castGtkLayout:(GtkLayout *) castitem;
{
  gtklayout = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- put: (Gtk_Widget *) widget
    x: (gint) x
    y: (gint) y
{
  gtk_layout_put( gtklayout, widget->gtkwidget, x, y );
  return self;
}

- move: (Gtk_Widget *) widget
    x: (gint) x
    y: (gint) y
{
  gtk_layout_move( gtklayout, widget->gtkwidget, x, y );
  return self;
}

- set_size: (gint) width
    height: (gint) height
{
  gtk_layout_set_size ( gtklayout, width, height );
  return self;
}

- freeze
{
  gtk_layout_freeze( gtklayout ); 
}

- thaw
{
  gtk_layout_thaw( gtklayout ); 
}

// those should be automated for the whole gnome-objc

- (Gtk_Adjustment *) get_hadjustment
{
  Gtk_Adjustment *objcAdj;
  GtkAdjustment  *adj;
  
  adj = gtk_layout_get_hadjustment( gtklayout );

  objcAdj = gtk_object_get_data_by_id( GTK_OBJECT(adj), OBJC_ID() );
  if (!objcAdj) 
    {
      objcAdj = [[Gtk_Adjustment alloc] castGtkAdjustment:adj];
    }
  return objcAdj;
}


- (Gtk_Adjustment *) get_vadjustment
{
  Gtk_Adjustment *objcAdj;
  GtkAdjustment  *adj;
  
  adj = gtk_layout_get_vadjustment( gtklayout );

  objcAdj = gtk_object_get_data_by_id( GTK_OBJECT(adj), OBJC_ID() );
  if (!objcAdj) 
    {
      objcAdj = [[Gtk_Adjustment alloc] castGtkAdjustment:adj];
    }
  return objcAdj;
}


- set_hadjustment: (Gtk_Adjustment *) adjustment
{
  gtk_layout_set_hadjustment (gtklayout, adjustment->gtkadjustment);
  return self;
}

- set_vadjustment: (Gtk_Adjustment *) adjustment
{
  gtk_layout_set_vadjustment (gtklayout, adjustment->gtkadjustment);
  return self;
}

 


@end
