#include "obgtkRadioButton.h"

@implementation Gtk_RadioButton
- castGtkRadioButton:(GtkRadioButton *) castitem
{
  gtkradiobutton = castitem;
  return [super castGtkCheckButton:GTK_CHECK_BUTTON(castitem)];
}

- init
{
  [self error:"Gtk_RadioButton: attempt to call \"init\" method on a class requiring parameters for initialization. Use \"initWithRadioGroup\" instead."];
  return self;
}

- initWithRadioGroup :(GSList *) group
{
  return [self castGtkRadioButton:GTK_RADIO_BUTTON(gtk_radio_button_new(group))];
}

- initWithRadioGroupLabel:(GSList *) group
		   label:(const gchar *) label
{
  return [self castGtkRadioButton:GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(group, label))];
}

- (GSList *) group
{
  return gtk_radio_button_group(gtkradiobutton);
}

- set_group:(GSList *) group
{
  gtk_radio_button_set_group(gtkradiobutton, group);
  return self;
}

- initWithRadioWidget:(id) gtk_radio
{
  return [self castGtkRadioButton:GTK_RADIO_BUTTON(gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON([gtk_radio getGtkObject])))];
}

- initWithRadioWidgetLabel:(id) gtk_radio
		     label:(const gchar *) label
{
  return [self castGtkRadioButton:GTK_RADIO_BUTTON(gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON([gtk_radio getGtkObject]), label))];
}
@end
