#!/usr/bin/env python

from re import compile,DOTALL,MULTILINE

icons = compile("static const PkEnumMatch enum_([^\]]+)_icon_name\[\] = {(.*?)};", DOTALL|MULTILINE)
animations = compile("static const PkEnumMatch enum_([^\]]+)_animation\[\] = {(.*?)};", DOTALL|MULTILINE)
values = compile("PK_([A-Z_]+)_ENUM_([A-Z0-9_]+),\s+\"([^\"]+)\"")

present = compile("gpk_([a-z]+?)_enum_to_localised_present \(Pk[A-Za-z]+? [a-z]+?\)(.*?)}", DOTALL|MULTILINE)
past = compile("gpk_([a-z]+?)_enum_to_localised_past \(Pk[A-Za-z]+? [a-z]+?\)(.*?)}", DOTALL|MULTILINE)
descs = compile("gpk_([a-z]+?)_enum_to_localised_message \(Pk[A-Za-z]+? [a-z]+?\)(.*?)}", DOTALL|MULTILINE)
string_values = compile("case PK_([A-Z_]+?)_ENUM_([A-Z0-9_]+?):\n\s+text = (_\(\".+?\"\));\n", MULTILINE|DOTALL)
strings = compile("gpk_([a-z]+?)_enum_to_localised_text \(Pk[A-Za-z]+? [a-z]+?\)(.*?)}", DOTALL|MULTILINE)
string_values = compile("case PK_([A-Z_]+?)_ENUM_([A-Z0-9_]+?):\n\s+text = (_\(\".+?\"\));\n", MULTILINE|DOTALL)
string_sub_values = compile("case PK_([A-Z_]+?)_ENUM_([A-Z0-9_]+?):\n\s+text = g_strdup_printf\([\\t\\s]*?(_\(\".+?\"\)), ([A-Z_]+?)\);\n", MULTILINE|DOTALL)

inp = open("../src/gpk-enum.c").read()

header = '''"""
Provides human readable strings, icon names and animations for internal 
enumerations

This file was autogenerated from src/gpk-enum.c by msg-converter.py
"""

from packagekit.enums import *
import gettext
from gettext import gettext as _

gettext.textdomain("gnome-packagekit")

GPK_BUGZILLA_URL = "https://bugs.freedesktop.org/"
'''
print(header)

# Extract icon names
for (name, data) in icons.findall(inp):
    print("ICONS_%s = {" % name.upper())
    for match in values.findall(data):
        print("    %s_%s:'%s'," % match)
    print("    }\n")
    print("def get_%s_icon_name_from_enum(enum):" % name)
    print("   if ICONS_%s.has_key(enum):" % name.upper())
    print("       return ICONS_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")

# Extract animations
for (name, data) in animations.findall(inp):
    print("ANIMATIONS_%s = {" % name.upper())
    for match in values.findall(data):
        print("    %s_%s:'%s'," % match)
    print("    }\n")
    print("def get_%s_animation_name_from_enum(enum):" % name)
    print("   if ANIMATIONS_%s.has_key(enum):" % name.upper())
    print("       return ANIMATIONS_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")

# Extract past messages
for (name, data) in past.findall(inp):
    print("PAST_%s = {" % name.upper())
    for match in string_sub_values.findall(data):
        print("    %s_%s:%s %% %s," % match)
    for match in string_values.findall(data):
        print("    %s_%s:%s," % match)
    print("    }\n")
    print("def get_%s_localised_past_from_enum(enum):" % name)
    print("   if PAST_%s.has_key(enum):" % name.upper())
    print("       return PAST_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")


# Extract present messages
for (name, data) in present.findall(inp):
    print("PRESENT_%s = {" % name.upper())
    for match in string_sub_values.findall(data):
        print("    %s_%s:%s %% %s," % match)
    for match in string_values.findall(data):
        print("    %s_%s:%s," % match)
    print("    }\n")
    print("def get_%s_localised_present_from_enum(enum):" % name)
    print("   if PRESENT_%s.has_key(enum):" % name.upper())
    print("       return PRESENT_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")

# Extract messages
for (name, data) in descs.findall(inp):
    print("DESCS_%s = {" % name.upper())
    for match in string_sub_values.findall(data):
        print("    %s_%s:%s %% %s," % match)
    for match in string_values.findall(data):
        print("    %s_%s:%s," % match)
    print("    }\n")
    print("def get_%s_description_from_enum(enum):" % name)
    print("   if DESCS_%s.has_key(enum):" % name.upper())
    print("       return DESCS_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")

for (name, data) in strings.findall(inp):
    print("STRINGS_%s = {" % name.upper())
    for match in string_values.findall(data):
        print("    %s_%s:%s," % match)
    print("    }\n")
    print("def get_%s_string_from_enum(enum):" % name)
    print("   if STRINGS_%s.has_key(enum):" % name.upper())
    print("       return STRINGS_%s[enum]" % name.upper())
    print("   else:")
    print("       return None\n")
