/* $Id: gdict-pref.c,v 1.14 2001/12/14 00:51:44 kevinv Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict preferences
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define GTK_ENABLE_BROKEN
#include <gnome.h>
#include <gconf/gconf-client.h>
#include "dict.h"
#include "gdict-pref.h"
#include "gdict-app.h"

GConfClient *client;

GDictPref gdict_pref = { 
    NULL, 0, TRUE, NULL, NULL,
    TRUE,
    { { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL },
      { NULL, NULL, NULL } }
};


static void
database_changed_cb (GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
    GConfValue *value = gconf_entry_get_value (entry);
    
    gdict_pref.database = g_strdup (gconf_value_get_string (value));
}

static void
strat_changed_cb (GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
    GConfValue *value = gconf_entry_get_value (entry);
    
    gdict_pref.dfl_strat = g_strdup (gconf_value_get_string (value));
}

static void
smart_changed_cb (GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
    GConfValue *value = gconf_entry_get_value (entry);
    
    gdict_pref.smart = gconf_value_get_bool (value);
}

/* gdict_pref_load
 *
 * Loads configuration from config file
 */

void 
gdict_pref_load (void) {
    gchar *prefix, *server_key, *port_key;
    gint i;

    client = gconf_client_get_default ();
    
    gconf_client_add_dir(client, "/apps/gdict", GCONF_CLIENT_PRELOAD_NONE, NULL);
    
    if (gdict_pref.server != NULL)
        g_free(gdict_pref.server);
    
    /* FIXME: notification for the server stuff is really tricky
    ** Leaving it out for now */
    gdict_pref.server = gconf_client_get_string (client, "/apps/gdict/server", NULL);
    
    gdict_pref.port = gconf_client_get_int (client, "/apps/gdict/port", NULL);
    
    gdict_pref.smart = gconf_client_get_bool(client, "/apps/gdict/smart", NULL);
    gconf_client_notify_add (client, "/apps/gdict/smart", smart_changed_cb, NULL, NULL, NULL);
    
    gdict_pref.database = gconf_client_get_string (client, "/apps/gdict/database", NULL);
    gconf_client_notify_add (client, "/apps/gdict/database", database_changed_cb, NULL, NULL, NULL);
    
    gdict_pref.dfl_strat = gconf_client_get_string (client, "/apps/gdict/stratagy", NULL);
    gconf_client_notify_add (client, "/apps/gdict/stratagy", strat_changed_cb, NULL, NULL, NULL);

}


