/* $Id: gdict-applet.c,v 1.26 2002/02/11 11:40:54 mmclouglin Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict panel applet
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>
#include <libbonoboui.h>
#include <panel-applet.h>

#include "gdict-app.h"
#include "gdict-about.h"
#include "gdict-pref.h"
#include "gdict-applet.h"
#include "gdict-pref-dialog.h"



#define DOCKED_APPLET_WIDTH 74
#define FLOATING_APPLET_WIDTH 14
#define SHORT_APPLET_HEIGHT 22
#define TALL_APPLET_HEIGHT 44


static void
redraw_pixbuf (GDictApplet *applet)
{
	GdkPixbuf *tmp;
	gint width, height;
	float ratio;
	gint nwidth, nheight;
	
	width = gdk_pixbuf_get_width (applet->pixbuf);
	height = gdk_pixbuf_get_height (applet->pixbuf);
	
	switch (applet->orient) {
	case PANEL_APPLET_ORIENT_LEFT:
	case PANEL_APPLET_ORIENT_RIGHT:	
		ratio = (float)height / (float)width;
		nwidth = applet->panel_size - 10;
		nheight = ratio * applet->panel_size - 10;
		break;
	case PANEL_APPLET_ORIENT_UP:
	case PANEL_APPLET_ORIENT_DOWN:
		ratio = (float)width / (float)height;
		nheight = applet->panel_size - 10;
		nwidth = ratio * applet->panel_size - 10;
		break;
	}

	nwidth = CLAMP (nwidth, 10, width);
	nheight = CLAMP (nheight, 10, height);
	
	tmp = gdk_pixbuf_scale_simple (applet->pixbuf, nwidth, nheight, GDK_INTERP_HYPER);
	
	if (applet->image) {
		gtk_widget_destroy (applet->image);
	}
		
	applet->image = gtk_image_new_from_pixbuf (tmp);
	gtk_widget_show (applet->image);
	gtk_container_add (GTK_CONTAINER (applet->button_widget), applet->image);
	gdk_pixbuf_unref (tmp);
}

static void
change_size_cb (PanelApplet *widget, gint size, GDictApplet *applet)
{

	applet->panel_size = size;
	redraw_pixbuf (applet);	

}

static void
change_orient_cb (PanelApplet *widget, PanelAppletOrient orient, GDictApplet *applet)
{

	applet->orient = orient;
	redraw_pixbuf (applet);
	
}

#if 0
static void
entry_activate_cb (GtkEntry *entry, gpointer data)
{
    gchar *text = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
    
    if (!context)
		gdict_init_context ();
    if (!GTK_WIDGET_VISIBLE (gdict_app))
        gtk_widget_show (gdict_app);
    
    if (*text == 0)
        return;
    g_strdown (text);
    gdict_app_do_lookup (text);
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    g_free (text);
 
 if 0   
    gtk_entry_set_text (GTK_ENTRY (applet->entry_widget), "");
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    gtk_editable_select_region (GTK_EDITABLE (word_entry), 0, strlen (text));
    gdict_app_do_lookup (text);
 endif
}
#endif

static void
text_received (GtkClipboard *clipboard, const gchar *text, gpointer data)
{
	gchar *lookup_text;
	
	if (!GTK_WIDGET_VISIBLE (gdict_app))
        	gtk_widget_show (gdict_app);
        	
        gtk_window_present (GTK_WINDOW (gdict_app));
        
    	if (!text)
    		return;
    	
    	lookup_text = g_strdup (text);	
	g_print ("text = %s \n", lookup_text);
			
	if (!context)
		gdict_init_context ();
    	
    	if (*lookup_text == 0)
        	return;
    	g_strdown (lookup_text);
    	gdict_app_do_lookup (lookup_text);
    	gtk_entry_set_text (GTK_ENTRY (word_entry), lookup_text);
    	g_free (lookup_text);
 
	
}

static void
button_press_cb (GtkButton *button, gpointer data)
{
	GDictApplet *applet = data;
	GtkClipboard *clipboard;
	
	clipboard = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
 	gtk_clipboard_request_text (clipboard, text_received, NULL);
	
	
}

static void
about_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	gdict_about();
}

static void
help_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{

}

static void
prefs_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	if (!context)
		gdict_init_context ();
	gdict_app_show_preferences ();
}

static void
show_hide_defbox_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	if (!context)
		gdict_init_context ();
	if (!GTK_WIDGET_VISIBLE (gdict_app)) 
        	gtk_widget_show (gdict_app);
    	else
        	gtk_widget_hide (gdict_app);
}

static void
spell_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	GDictApplet *applet = user_data;
	gchar *text;
	
	if (!context)
		gdict_init_context ();
#ifdef FIXME
	text = gtk_editable_get_chars (GTK_EDITABLE (applet->entry_widget), 0, -1);
    	gdict_spell (text, FALSE);
        g_free (text);
#endif
}

static const BonoboUIVerb gdict_applet_menu_verbs [] = {
        BONOBO_UI_VERB ("about", about_cb),
        BONOBO_UI_VERB ("help", help_cb),
        BONOBO_UI_VERB ("prefs", prefs_cb),
	BONOBO_UI_VERB ("def win", show_hide_defbox_cb),
       
        BONOBO_UI_VERB_END
};

static const char gdict_applet_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Item 1\" verb=\"about\" _label=\"About...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "   <menuitem name=\"Item 2\" verb=\"help\" _label=\"Help\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-help\"/>\n"
        "   <menuitem name=\"Item 3\" verb=\"prefs\" _label=\"Preferences...\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
        "   <menuitem name=\"Item 4\" verb=\"def win\" _label=\"Show/Hide Definition Window...\"/>\n"
        "</popup>\n";

static gboolean
gdict_applet_new (PanelApplet *parent_applet)
{
	GDictApplet *applet;
 	GtkWidget *hbox;
 	GtkTooltips *tooltips;
 	
 	applet = g_new0 (GDictApplet, 1);
 	
	hbox = gtk_hbox_new (FALSE, 0);
	
	applet->pixbuf = gdk_pixbuf_new_from_file (GNOME_ICONDIR"/gdict.png", NULL);
	
	applet->button_widget = gtk_button_new ();
	
	gtk_box_pack_start (GTK_BOX (hbox), applet->button_widget, FALSE, FALSE, 2);

	gtk_widget_show_all (hbox);

#if 0	  	
 	/*applet->entry_widget = gtk_entry_new ();
 	gtk_box_pack_start (GTK_BOX (hbox), applet->entry_widget, TRUE, TRUE, 0);*/
#endif 	

 	tooltips = gtk_tooltips_new ();
 	gtk_tooltips_set_tip (tooltips, applet->button_widget,
 			      _("Press button to look up any highlighted text in a dictionary"),
 			      NULL);
 	
 	applet->applet_widget = GTK_WIDGET(parent_applet);
 	gtk_container_add(GTK_CONTAINER(parent_applet), hbox);
 	applet->panel_size = panel_applet_get_size (PANEL_APPLET (applet->applet_widget));
 	applet->orient = panel_applet_get_orient (PANEL_APPLET (applet->applet_widget));
 	
 	gdict_app_create (TRUE);
 	
 	panel_applet_setup_menu (PANEL_APPLET (applet->applet_widget),
                                 gdict_applet_menu_xml,
                                 gdict_applet_menu_verbs,
                                 applet);                               

 	gtk_widget_show (applet->applet_widget);
 	gdict_pref_load ();
 	
 	redraw_pixbuf (applet);	
 	
 	/* server will be contacted when an action is performed */
 	context = NULL;
#if 0 	
 	/*g_signal_connect (G_OBJECT (applet->entry_widget), "activate",
 			  G_CALLBACK (entry_activate_cb), applet);*/
#endif
 	g_signal_connect (G_OBJECT (applet->button_widget), "clicked",
 			  G_CALLBACK (button_press_cb), applet);

 	g_signal_connect (G_OBJECT (applet->applet_widget), "change_size",
 			  G_CALLBACK (change_size_cb), applet);
 	g_signal_connect (G_OBJECT (applet->applet_widget), "change_orient",
 			  G_CALLBACK (change_orient_cb), applet);
 	
	return TRUE;
}

static gboolean
gdict_applet_factory (PanelApplet *applet,
                     const gchar          *iid,
                     gpointer              data)
{
        gboolean retval = FALSE;

        if (!strcmp (iid, "OAFIID:GNOME_GDictApplet"))
                retval = gdict_applet_new (applet);

        return retval;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_GDictApplet_Factory",
			     PANEL_TYPE_APPLET,
                             "Dictionary",
                             "0",
                             gdict_applet_factory,
                             NULL)
 	
